/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

public class BinDetails {
    private String bin;
    private String issuingBank;
    private String binCountryCode;
    private List<String> products;

    public BinDetails() {
    }

    public BinDetails(String bin, String issuingBank, String binCountryCode, List<String> products) {
        this.bin = bin;
        this.issuingBank = issuingBank;
        this.binCountryCode = binCountryCode;
        this.products = products;
    }

    @JsonGetter(value="bin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBin() {
        return this.bin;
    }

    @JsonSetter(value="bin")
    public void setBin(String bin) {
        this.bin = bin;
    }

    @JsonGetter(value="issuing_bank")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIssuingBank() {
        return this.issuingBank;
    }

    @JsonSetter(value="issuing_bank")
    public void setIssuingBank(String issuingBank) {
        this.issuingBank = issuingBank;
    }

    @JsonGetter(value="bin_country_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBinCountryCode() {
        return this.binCountryCode;
    }

    @JsonSetter(value="bin_country_code")
    public void setBinCountryCode(String binCountryCode) {
        this.binCountryCode = binCountryCode;
    }

    @JsonGetter(value="products")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getProducts() {
        return this.products;
    }

    @JsonSetter(value="products")
    public void setProducts(List<String> products) {
        this.products = products;
    }

    public String toString() {
        return "BinDetails [bin=" + this.bin + ", issuingBank=" + this.issuingBank + ", binCountryCode=" + this.binCountryCode + ", products=" + this.products + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().bin(this.getBin()).issuingBank(this.getIssuingBank()).binCountryCode(this.getBinCountryCode()).products(this.getProducts());
        return builder;
    }

    public static class Builder {
        private String bin;
        private String issuingBank;
        private String binCountryCode;
        private List<String> products;

        public Builder bin(String bin) {
            this.bin = bin;
            return this;
        }

        public Builder issuingBank(String issuingBank) {
            this.issuingBank = issuingBank;
            return this;
        }

        public Builder binCountryCode(String binCountryCode) {
            this.binCountryCode = binCountryCode;
            return this;
        }

        public Builder products(List<String> products) {
            this.products = products;
            return this;
        }

        public BinDetails build() {
            return new BinDetails(this.bin, this.issuingBank, this.binCountryCode, this.products);
        }
    }
}

