/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.http.response;

import com.paypal.sdk.http.Headers;
import io.apimatic.coreinterfaces.http.response.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

public class HttpResponse
implements Response {
    private int statusCode;
    private Headers headers;
    private InputStream rawBody;
    private String body;

    public HttpResponse(int code, Headers headers, InputStream rawBody) {
        this.statusCode = code;
        this.headers = headers;
        this.rawBody = rawBody;
    }

    public HttpResponse(int code, Headers headers, InputStream rawBody, String body) {
        this(code, headers, rawBody);
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getRawBody() {
        return this.rawBody;
    }

    public String getRawBodyString() {
        try {
            if (this.rawBody == null || this.rawBody.available() == 0 || !this.rawBody.markSupported()) {
                return null;
            }
            this.rawBody.mark(0);
            String result = new BufferedReader(new InputStreamReader(this.rawBody)).lines().collect(Collectors.joining("\n"));
            this.rawBody.reset();
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getBody() {
        return this.body;
    }
}

