/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.Server;
import com.paypal.sdk.controllers.BaseController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.exceptions.ErrorException;
import com.paypal.sdk.http.request.HttpMethod;
import com.paypal.sdk.http.response.ApiResponse;
import com.paypal.sdk.models.CaptureAuthorizedPaymentInput;
import com.paypal.sdk.models.CapturedPayment;
import com.paypal.sdk.models.GetAuthorizedPaymentInput;
import com.paypal.sdk.models.GetCapturedPaymentInput;
import com.paypal.sdk.models.GetRefundInput;
import com.paypal.sdk.models.PaymentAuthorization;
import com.paypal.sdk.models.ReauthorizePaymentInput;
import com.paypal.sdk.models.Refund;
import com.paypal.sdk.models.RefundCapturedPaymentInput;
import com.paypal.sdk.models.VoidPaymentInput;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class PaymentsController
extends BaseController {
    public PaymentsController(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    public ApiResponse<CapturedPayment> captureAuthorizedPayment(CaptureAuthorizedPaymentInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareCaptureAuthorizedPaymentRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<CapturedPayment>> captureAuthorizedPaymentAsync(CaptureAuthorizedPaymentInput input) {
        try {
            return this.prepareCaptureAuthorizedPaymentRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<CapturedPayment>, ApiException> prepareCaptureAuthorizedPaymentRequest(CaptureAuthorizedPaymentInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}/capture").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("authorization_id").value((Object)input.getAuthorizationId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (CapturedPayment)ApiHelper.deserialize((String)response, CapturedPayment.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"The request failed because it is not well-formed or is syntactically incorrect or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("409", ErrorCase.setReason((String)"The server has detected a conflict while processing this request.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<CapturedPayment> getCapturedPayment(GetCapturedPaymentInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareGetCapturedPaymentRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<CapturedPayment>> getCapturedPaymentAsync(GetCapturedPaymentInput input) {
        try {
            return this.prepareGetCapturedPaymentRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<CapturedPayment>, ApiException> prepareGetCapturedPaymentRequest(GetCapturedPaymentInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/captures/{capture_id}").templateParam(param -> param.key("capture_id").value((Object)input.getCaptureId()).shouldEncode(true)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (CapturedPayment)ApiHelper.deserialize((String)response, CapturedPayment.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<PaymentAuthorization> reauthorizePayment(ReauthorizePaymentInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareReauthorizePaymentRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<PaymentAuthorization>> reauthorizePaymentAsync(ReauthorizePaymentInput input) {
        try {
            return this.prepareReauthorizePaymentRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareReauthorizePaymentRequest(ReauthorizePaymentInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}/reauthorize").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("authorization_id").value((Object)input.getAuthorizationId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentAuthorization)ApiHelper.deserialize((String)response, PaymentAuthorization.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"The request failed because it is not well-formed or is syntactically incorrect or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it either is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<PaymentAuthorization> voidPayment(VoidPaymentInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareVoidPaymentRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<PaymentAuthorization>> voidPaymentAsync(VoidPaymentInput input) {
        try {
            return this.prepareVoidPaymentRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareVoidPaymentRequest(VoidPaymentInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}/void").templateParam(param -> param.key("authorization_id").value((Object)input.getAuthorizationId()).shouldEncode(true)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentAuthorization)ApiHelper.deserialize((String)response, PaymentAuthorization.class)).nullableResponseType(true).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("409", ErrorCase.setReason((String)"The request failed because a previous call for the given resource is in progress.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it either is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Refund> refundCapturedPayment(RefundCapturedPaymentInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareRefundCapturedPaymentRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Refund>> refundCapturedPaymentAsync(RefundCapturedPaymentInput input) {
        try {
            return this.prepareRefundCapturedPaymentRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Refund>, ApiException> prepareRefundCapturedPaymentRequest(RefundCapturedPaymentInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/captures/{capture_id}/refund").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("capture_id").value((Object)input.getCaptureId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Refund)ApiHelper.deserialize((String)response, Refund.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"The request failed because it is not well-formed or is syntactically incorrect or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("409", ErrorCase.setReason((String)"The request failed because a previous call for the given resource is in progress.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it either is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<PaymentAuthorization> getAuthorizedPayment(GetAuthorizedPaymentInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareGetAuthorizedPaymentRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<PaymentAuthorization>> getAuthorizedPaymentAsync(GetAuthorizedPaymentInput input) {
        try {
            return this.prepareGetAuthorizedPaymentRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareGetAuthorizedPaymentRequest(GetAuthorizedPaymentInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}").templateParam(param -> param.key("authorization_id").value((Object)input.getAuthorizationId()).shouldEncode(true)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentAuthorization)ApiHelper.deserialize((String)response, PaymentAuthorization.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Refund> getRefund(GetRefundInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareGetRefundRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Refund>> getRefundAsync(GetRefundInput input) {
        try {
            return this.prepareGetRefundRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Refund>, ApiException> prepareGetRefundRequest(GetRefundInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/refunds/{refund_id}").templateParam(param -> param.key("refund_id").value((Object)input.getRefundId()).shouldEncode(true)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Refund)ApiHelper.deserialize((String)response, Refund.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

