/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.authentication;

import com.paypal.sdk.ClientCredentialsAuth;
import com.paypal.sdk.models.OAuthToken;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class ClientCredentialsAuthModel {
    private String oAuthClientId;
    private String oAuthClientSecret;
    private OAuthToken oAuthToken;
    private BiFunction<OAuthToken, ClientCredentialsAuth, OAuthToken> oAuthTokenProvider;
    private Consumer<OAuthToken> oAuthOnTokenUpdate;
    private long oAuthClockSkew;

    private ClientCredentialsAuthModel(String oAuthClientId, String oAuthClientSecret, OAuthToken oAuthToken, BiFunction<OAuthToken, ClientCredentialsAuth, OAuthToken> oAuthTokenProvider, Consumer<OAuthToken> oAuthOnTokenUpdate, long oAuthClockSkew) {
        this.oAuthClientId = oAuthClientId;
        this.oAuthClientSecret = oAuthClientSecret;
        this.oAuthToken = oAuthToken;
        this.oAuthTokenProvider = oAuthTokenProvider;
        this.oAuthOnTokenUpdate = oAuthOnTokenUpdate;
        this.oAuthClockSkew = oAuthClockSkew;
    }

    public String getOAuthClientId() {
        return this.oAuthClientId;
    }

    public String getOAuthClientSecret() {
        return this.oAuthClientSecret;
    }

    public OAuthToken getOAuthToken() {
        return this.oAuthToken;
    }

    public BiFunction<OAuthToken, ClientCredentialsAuth, OAuthToken> getOAuthTokenProvider() {
        return this.oAuthTokenProvider;
    }

    public Consumer<OAuthToken> getOAuthOnTokenUpdate() {
        return this.oAuthOnTokenUpdate;
    }

    public long getOAuthClockSkew() {
        return this.oAuthClockSkew;
    }

    public Builder toBuilder() {
        return new Builder(this.getOAuthClientId(), this.getOAuthClientSecret()).oAuthToken(this.getOAuthToken()).oAuthTokenProvider(this.getOAuthTokenProvider()).oAuthOnTokenUpdate(this.getOAuthOnTokenUpdate()).oAuthClockSkew(this.getOAuthClockSkew());
    }

    public static class Builder {
        private String oAuthClientId;
        private String oAuthClientSecret;
        private OAuthToken oAuthToken;
        private BiFunction<OAuthToken, ClientCredentialsAuth, OAuthToken> oAuthTokenProvider;
        private Consumer<OAuthToken> oAuthOnTokenUpdate;
        private long oAuthClockSkew;

        public Builder(String oAuthClientId, String oAuthClientSecret) {
            if (oAuthClientId == null) {
                throw new NullPointerException("OAuthClientId cannot be null.");
            }
            if (oAuthClientSecret == null) {
                throw new NullPointerException("OAuthClientSecret cannot be null.");
            }
            this.oAuthClientId = oAuthClientId;
            this.oAuthClientSecret = oAuthClientSecret;
        }

        public Builder oAuthClientId(String oAuthClientId) {
            if (oAuthClientId == null) {
                throw new NullPointerException("OAuthClientId cannot be null.");
            }
            this.oAuthClientId = oAuthClientId;
            return this;
        }

        public Builder oAuthClientSecret(String oAuthClientSecret) {
            if (oAuthClientSecret == null) {
                throw new NullPointerException("OAuthClientSecret cannot be null.");
            }
            this.oAuthClientSecret = oAuthClientSecret;
            return this;
        }

        public Builder oAuthToken(OAuthToken oAuthToken) {
            this.oAuthToken = oAuthToken;
            return this;
        }

        public Builder oAuthTokenProvider(BiFunction<OAuthToken, ClientCredentialsAuth, OAuthToken> oAuthTokenProvider) {
            this.oAuthTokenProvider = oAuthTokenProvider;
            return this;
        }

        public Builder oAuthOnTokenUpdate(Consumer<OAuthToken> oAuthOnTokenUpdate) {
            this.oAuthOnTokenUpdate = oAuthOnTokenUpdate;
            return this;
        }

        public Builder oAuthClockSkew(long oAuthClockSkew) {
            this.oAuthClockSkew = oAuthClockSkew;
            return this;
        }

        public ClientCredentialsAuthModel build() {
            return new ClientCredentialsAuthModel(this.oAuthClientId, this.oAuthClientSecret, this.oAuthToken, this.oAuthTokenProvider, this.oAuthOnTokenUpdate, this.oAuthClockSkew);
        }
    }
}

