/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.AmountWithBreakdown;
import com.paypal.sdk.models.ShippingOption;
import java.util.List;

public class ShippingOptionsPurchaseUnit {
    private String referenceId;
    private AmountWithBreakdown amount;
    private List<ShippingOption> shippingOptions;

    public ShippingOptionsPurchaseUnit() {
    }

    public ShippingOptionsPurchaseUnit(String referenceId, AmountWithBreakdown amount, List<ShippingOption> shippingOptions) {
        this.referenceId = referenceId;
        this.amount = amount;
        this.shippingOptions = shippingOptions;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonSetter(value="reference_id")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonGetter(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AmountWithBreakdown getAmount() {
        return this.amount;
    }

    @JsonSetter(value="amount")
    public void setAmount(AmountWithBreakdown amount) {
        this.amount = amount;
    }

    @JsonGetter(value="shipping_options")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    @JsonSetter(value="shipping_options")
    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    public String toString() {
        return "ShippingOptionsPurchaseUnit [referenceId=" + this.referenceId + ", amount=" + this.amount + ", shippingOptions=" + this.shippingOptions + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().referenceId(this.getReferenceId()).amount(this.getAmount()).shippingOptions(this.getShippingOptions());
        return builder;
    }

    public static class Builder {
        private String referenceId;
        private AmountWithBreakdown amount;
        private List<ShippingOption> shippingOptions;

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder amount(AmountWithBreakdown amount) {
            this.amount = amount;
            return this;
        }

        public Builder shippingOptions(List<ShippingOption> shippingOptions) {
            this.shippingOptions = shippingOptions;
            return this;
        }

        public ShippingOptionsPurchaseUnit build() {
            return new ShippingOptionsPurchaseUnit(this.referenceId, this.amount, this.shippingOptions);
        }
    }
}

