/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class PayeeBase {
    private String emailAddress;
    private String merchantId;

    public PayeeBase() {
    }

    public PayeeBase(String emailAddress, String merchantId) {
        this.emailAddress = emailAddress;
        this.merchantId = merchantId;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonSetter(value="email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonSetter(value="merchant_id")
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String toString() {
        return "PayeeBase [emailAddress=" + this.emailAddress + ", merchantId=" + this.merchantId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().emailAddress(this.getEmailAddress()).merchantId(this.getMerchantId());
        return builder;
    }

    public static class Builder {
        private String emailAddress;
        private String merchantId;

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public PayeeBase build() {
            return new PayeeBase(this.emailAddress, this.merchantId);
        }
    }
}

