/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum OrderStatus {
    CREATED,
    SAVED,
    APPROVED,
    VOIDED,
    COMPLETED,
    PAYER_ACTION_REQUIRED,
    _UNKNOWN;

    private static TreeMap<String, OrderStatus> valueMap;
    private String value;

    @JsonCreator
    public static OrderStatus constructFromString(String toConvert) throws IOException {
        OrderStatus enumValue = OrderStatus.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static OrderStatus fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<OrderStatus> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (OrderStatus enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        OrderStatus.CREATED.value = "CREATED";
        OrderStatus.SAVED.value = "SAVED";
        OrderStatus.APPROVED.value = "APPROVED";
        OrderStatus.VOIDED.value = "VOIDED";
        OrderStatus.COMPLETED.value = "COMPLETED";
        OrderStatus.PAYER_ACTION_REQUIRED.value = "PAYER_ACTION_REQUIRED";
        OrderStatus._UNKNOWN.value = null;
        valueMap.put("CREATED", CREATED);
        valueMap.put("SAVED", SAVED);
        valueMap.put("APPROVED", APPROVED);
        valueMap.put("VOIDED", VOIDED);
        valueMap.put("COMPLETED", COMPLETED);
        valueMap.put("PAYER_ACTION_REQUIRED", PAYER_ACTION_REQUIRED);
    }
}

