/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class GetAuthorizedPaymentInput {
    private String authorizationId;
    private String paypalMockResponse;
    private String paypalAuthAssertion;

    public GetAuthorizedPaymentInput() {
    }

    public GetAuthorizedPaymentInput(String authorizationId, String paypalMockResponse, String paypalAuthAssertion) {
        this.authorizationId = authorizationId;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="authorization_id")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @JsonSetter(value="authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @JsonGetter(value="PayPal-Mock-Response")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return this.paypalMockResponse;
    }

    @JsonSetter(value="PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    public String toString() {
        return "GetAuthorizedPaymentInput [authorizationId=" + this.authorizationId + ", paypalMockResponse=" + this.paypalMockResponse + ", paypalAuthAssertion=" + this.paypalAuthAssertion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.authorizationId).paypalMockResponse(this.getPaypalMockResponse()).paypalAuthAssertion(this.getPaypalAuthAssertion());
        return builder;
    }

    public static class Builder {
        private String authorizationId;
        private String paypalMockResponse;
        private String paypalAuthAssertion;

        public Builder() {
        }

        public Builder(String authorizationId) {
            this.authorizationId = authorizationId;
        }

        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public GetAuthorizedPaymentInput build() {
            return new GetAuthorizedPaymentInput(this.authorizationId, this.paypalMockResponse, this.paypalAuthAssertion);
        }
    }
}

