/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class Customer {
    private String id;
    private String merchantCustomerId;

    public Customer() {
    }

    public Customer(String id, String merchantCustomerId) {
        this.id = id;
        this.merchantCustomerId = merchantCustomerId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="merchant_customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantCustomerId() {
        return this.merchantCustomerId;
    }

    @JsonSetter(value="merchant_customer_id")
    public void setMerchantCustomerId(String merchantCustomerId) {
        this.merchantCustomerId = merchantCustomerId;
    }

    public String toString() {
        return "Customer [id=" + this.id + ", merchantCustomerId=" + this.merchantCustomerId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).merchantCustomerId(this.getMerchantCustomerId());
        return builder;
    }

    public static class Builder {
        private String id;
        private String merchantCustomerId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder merchantCustomerId(String merchantCustomerId) {
            this.merchantCustomerId = merchantCustomerId;
            return this;
        }

        public Customer build() {
            return new Customer(this.id, this.merchantCustomerId);
        }
    }
}

