/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for VenmoWalletCustomerInformation type.
 */
public class VenmoWalletCustomerInformation {
    private String id;
    private String emailAddress;

    /**
     * Default constructor.
     */
    public VenmoWalletCustomerInformation() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  emailAddress  String value for emailAddress.
     */
    public VenmoWalletCustomerInformation(
            String id,
            String emailAddress) {
        this.id = id;
        this.emailAddress = emailAddress;
    }

    /**
     * Getter for Id.
     * The unique ID for a customer generated by PayPal.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The unique ID for a customer generated by PayPal.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * Setter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param emailAddress Value for String
     */
    @JsonSetter("email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Converts this VenmoWalletCustomerInformation into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VenmoWalletCustomerInformation [" + "id=" + id + ", emailAddress=" + emailAddress
                + "]";
    }

    /**
     * Builds a new {@link VenmoWalletCustomerInformation.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VenmoWalletCustomerInformation.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .id(getId())
                .emailAddress(getEmailAddress());
        return builder;
    }

    /**
     * Class to build instances of {@link VenmoWalletCustomerInformation}.
     */
    public static class Builder {
        private String id;
        private String emailAddress;



        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for emailAddress.
         * @param  emailAddress  String value for emailAddress.
         * @return Builder
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        /**
         * Builds a new {@link VenmoWalletCustomerInformation} object using the set fields.
         * @return {@link VenmoWalletCustomerInformation}
         */
        public VenmoWalletCustomerInformation build() {
            return new VenmoWalletCustomerInformation(id, emailAddress);
        }
    }
}
