/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for ThreeDSecureCardAuthenticationResponse type.
 */
public class ThreeDSecureCardAuthenticationResponse {
    private PaResStatus authenticationStatus;
    private EnrollmentStatus enrollmentStatus;
    private String authenticationId;

    /**
     * Default constructor.
     */
    public ThreeDSecureCardAuthenticationResponse() {
    }

    /**
     * Initialization constructor.
     * @param  authenticationStatus  PaResStatus value for authenticationStatus.
     * @param  enrollmentStatus  EnrollmentStatus value for enrollmentStatus.
     * @param  authenticationId  String value for authenticationId.
     */
    public ThreeDSecureCardAuthenticationResponse(
            PaResStatus authenticationStatus,
            EnrollmentStatus enrollmentStatus,
            String authenticationId) {
        this.authenticationStatus = authenticationStatus;
        this.enrollmentStatus = enrollmentStatus;
        this.authenticationId = authenticationId;
    }

    /**
     * Getter for AuthenticationStatus.
     * Transactions status result identifier. The outcome of the issuer's authentication.
     * @return Returns the PaResStatus
     */
    @JsonGetter("authentication_status")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaResStatus getAuthenticationStatus() {
        return authenticationStatus;
    }

    /**
     * Setter for AuthenticationStatus.
     * Transactions status result identifier. The outcome of the issuer's authentication.
     * @param authenticationStatus Value for PaResStatus
     */
    @JsonSetter("authentication_status")
    public void setAuthenticationStatus(PaResStatus authenticationStatus) {
        this.authenticationStatus = authenticationStatus;
    }

    /**
     * Getter for EnrollmentStatus.
     * Status of Authentication eligibility.
     * @return Returns the EnrollmentStatus
     */
    @JsonGetter("enrollment_status")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public EnrollmentStatus getEnrollmentStatus() {
        return enrollmentStatus;
    }

    /**
     * Setter for EnrollmentStatus.
     * Status of Authentication eligibility.
     * @param enrollmentStatus Value for EnrollmentStatus
     */
    @JsonSetter("enrollment_status")
    public void setEnrollmentStatus(EnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    /**
     * Getter for AuthenticationId.
     * The externally received 3ds authentication id, to be returned in card detokenization
     * response.
     * @return Returns the String
     */
    @JsonGetter("authentication_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAuthenticationId() {
        return authenticationId;
    }

    /**
     * Setter for AuthenticationId.
     * The externally received 3ds authentication id, to be returned in card detokenization
     * response.
     * @param authenticationId Value for String
     */
    @JsonSetter("authentication_id")
    public void setAuthenticationId(String authenticationId) {
        this.authenticationId = authenticationId;
    }

    /**
     * Converts this ThreeDSecureCardAuthenticationResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ThreeDSecureCardAuthenticationResponse [" + "authenticationStatus="
                + authenticationStatus + ", enrollmentStatus=" + enrollmentStatus
                + ", authenticationId=" + authenticationId + "]";
    }

    /**
     * Builds a new {@link ThreeDSecureCardAuthenticationResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link ThreeDSecureCardAuthenticationResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .authenticationStatus(getAuthenticationStatus())
                .enrollmentStatus(getEnrollmentStatus())
                .authenticationId(getAuthenticationId());
        return builder;
    }

    /**
     * Class to build instances of {@link ThreeDSecureCardAuthenticationResponse}.
     */
    public static class Builder {
        private PaResStatus authenticationStatus;
        private EnrollmentStatus enrollmentStatus;
        private String authenticationId;



        /**
         * Setter for authenticationStatus.
         * @param  authenticationStatus  PaResStatus value for authenticationStatus.
         * @return Builder
         */
        public Builder authenticationStatus(PaResStatus authenticationStatus) {
            this.authenticationStatus = authenticationStatus;
            return this;
        }

        /**
         * Setter for enrollmentStatus.
         * @param  enrollmentStatus  EnrollmentStatus value for enrollmentStatus.
         * @return Builder
         */
        public Builder enrollmentStatus(EnrollmentStatus enrollmentStatus) {
            this.enrollmentStatus = enrollmentStatus;
            return this;
        }

        /**
         * Setter for authenticationId.
         * @param  authenticationId  String value for authenticationId.
         * @return Builder
         */
        public Builder authenticationId(String authenticationId) {
            this.authenticationId = authenticationId;
            return this;
        }

        /**
         * Builds a new {@link ThreeDSecureCardAuthenticationResponse} object using the set fields.
         * @return {@link ThreeDSecureCardAuthenticationResponse}
         */
        public ThreeDSecureCardAuthenticationResponse build() {
            return new ThreeDSecureCardAuthenticationResponse(authenticationStatus,
                    enrollmentStatus, authenticationId);
        }
    }
}
