/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * StoredPaymentSourceUsageType to be used.
 */
public enum StoredPaymentSourceUsageType {
    /**
     * Indicates the Initial/First payment with a payment_source that is intended to be stored upon successful processing of the payment.
     */
    FIRST,

    /**
     * Indicates a payment using a stored payment_source which has been successfully used previously for a payment.
     */
    SUBSEQUENT,

    /**
     * Indicates that PayPal will derive the value of `FIRST` or `SUBSEQUENT` based on data available to PayPal.
     */
    DERIVED,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, StoredPaymentSourceUsageType> valueMap = new TreeMap<>();
    private String value;

    static {
        FIRST.value = "FIRST";
        SUBSEQUENT.value = "SUBSEQUENT";
        DERIVED.value = "DERIVED";
        _UNKNOWN.value = null;

        valueMap.put("FIRST", FIRST);
        valueMap.put("SUBSEQUENT", SUBSEQUENT);
        valueMap.put("DERIVED", DERIVED);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static StoredPaymentSourceUsageType constructFromString(String toConvert) throws IOException {
        StoredPaymentSourceUsageType enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static StoredPaymentSourceUsageType fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of StoredPaymentSourceUsageType values to list of string values.
     * @param toConvert The list of StoredPaymentSourceUsageType values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<StoredPaymentSourceUsageType> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (StoredPaymentSourceUsageType enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 