/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for PurchaseUnitRequest type.
 */
public class PurchaseUnitRequest {
    private String referenceId;
    private AmountWithBreakdown amount;
    private PayeeBase payee;
    private PaymentInstruction paymentInstruction;
    private String description;
    private String customId;
    private String invoiceId;
    private String softDescriptor;
    private List<Item> items;
    private ShippingDetails shipping;
    private SupplementaryData supplementaryData;

    /**
     * Default constructor.
     */
    public PurchaseUnitRequest() {
    }

    /**
     * Initialization constructor.
     * @param  amount  AmountWithBreakdown value for amount.
     * @param  referenceId  String value for referenceId.
     * @param  payee  PayeeBase value for payee.
     * @param  paymentInstruction  PaymentInstruction value for paymentInstruction.
     * @param  description  String value for description.
     * @param  customId  String value for customId.
     * @param  invoiceId  String value for invoiceId.
     * @param  softDescriptor  String value for softDescriptor.
     * @param  items  List of Item value for items.
     * @param  shipping  ShippingDetails value for shipping.
     * @param  supplementaryData  SupplementaryData value for supplementaryData.
     */
    public PurchaseUnitRequest(
            AmountWithBreakdown amount,
            String referenceId,
            PayeeBase payee,
            PaymentInstruction paymentInstruction,
            String description,
            String customId,
            String invoiceId,
            String softDescriptor,
            List<Item> items,
            ShippingDetails shipping,
            SupplementaryData supplementaryData) {
        this.referenceId = referenceId;
        this.amount = amount;
        this.payee = payee;
        this.paymentInstruction = paymentInstruction;
        this.description = description;
        this.customId = customId;
        this.invoiceId = invoiceId;
        this.softDescriptor = softDescriptor;
        this.items = items;
        this.shipping = shipping;
        this.supplementaryData = supplementaryData;
    }

    /**
     * Getter for ReferenceId.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase
     * units when you must update the order through `PATCH`. If you omit this value and the order
     * contains only one purchase unit, PayPal sets this value to `default`.
     * @return Returns the String
     */
    @JsonGetter("reference_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return referenceId;
    }

    /**
     * Setter for ReferenceId.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase
     * units when you must update the order through `PATCH`. If you omit this value and the order
     * contains only one purchase unit, PayPal sets this value to `default`.
     * @param referenceId Value for String
     */
    @JsonSetter("reference_id")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    /**
     * Getter for Amount.
     * The total order amount with an optional breakdown that provides details, such as the total
     * item amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you
     * specify `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping`
     * plus `handling` plus `insurance` minus `shipping_discount` minus discount. The amount must be
     * a positive number. For listed of supported currencies and decimal precision, see the PayPal
     * REST APIs Currency Codes.
     * @return Returns the AmountWithBreakdown
     */
    @JsonGetter("amount")
    public AmountWithBreakdown getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The total order amount with an optional breakdown that provides details, such as the total
     * item amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you
     * specify `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping`
     * plus `handling` plus `insurance` minus `shipping_discount` minus discount. The amount must be
     * a positive number. For listed of supported currencies and decimal precision, see the PayPal
     * REST APIs Currency Codes.
     * @param amount Value for AmountWithBreakdown
     */
    @JsonSetter("amount")
    public void setAmount(AmountWithBreakdown amount) {
        this.amount = amount;
    }

    /**
     * Getter for Payee.
     * The merchant who receives the funds and fulfills the order. The merchant is also known as the
     * payee.
     * @return Returns the PayeeBase
     */
    @JsonGetter("payee")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PayeeBase getPayee() {
        return payee;
    }

    /**
     * Setter for Payee.
     * The merchant who receives the funds and fulfills the order. The merchant is also known as the
     * payee.
     * @param payee Value for PayeeBase
     */
    @JsonSetter("payee")
    public void setPayee(PayeeBase payee) {
        this.payee = payee;
    }

    /**
     * Getter for PaymentInstruction.
     * Any additional payment instructions to be consider during payment processing. This processing
     * instruction is applicable for Capturing an order or Authorizing an Order.
     * @return Returns the PaymentInstruction
     */
    @JsonGetter("payment_instruction")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaymentInstruction getPaymentInstruction() {
        return paymentInstruction;
    }

    /**
     * Setter for PaymentInstruction.
     * Any additional payment instructions to be consider during payment processing. This processing
     * instruction is applicable for Capturing an order or Authorizing an Order.
     * @param paymentInstruction Value for PaymentInstruction
     */
    @JsonSetter("payment_instruction")
    public void setPaymentInstruction(PaymentInstruction paymentInstruction) {
        this.paymentInstruction = paymentInstruction;
    }

    /**
     * Getter for Description.
     * The purchase description. The maximum length of the character is dependent on the type of
     * characters used. The character length is specified assuming a US ASCII character. Depending
     * on type of character; (e.g. accented character, Japanese characters) the number of characters
     * that that can be specified as input might not equal the permissible max length.
     * @return Returns the String
     */
    @JsonGetter("description")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return description;
    }

    /**
     * Setter for Description.
     * The purchase description. The maximum length of the character is dependent on the type of
     * characters used. The character length is specified assuming a US ASCII character. Depending
     * on type of character; (e.g. accented character, Japanese characters) the number of characters
     * that that can be specified as input might not equal the permissible max length.
     * @param description Value for String
     */
    @JsonSetter("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Getter for CustomId.
     * The API caller-provided external ID. Used to reconcile client transactions with PayPal
     * transactions. Appears in transaction and settlement reports but is not visible to the payer.
     * @return Returns the String
     */
    @JsonGetter("custom_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCustomId() {
        return customId;
    }

    /**
     * Setter for CustomId.
     * The API caller-provided external ID. Used to reconcile client transactions with PayPal
     * transactions. Appears in transaction and settlement reports but is not visible to the payer.
     * @param customId Value for String
     */
    @JsonSetter("custom_id")
    public void setCustomId(String customId) {
        this.customId = customId;
    }

    /**
     * Getter for InvoiceId.
     * The API caller-provided external invoice number for this order. Appears in both the payer's
     * transaction history and the emails that the payer receives.
     * @return Returns the String
     */
    @JsonGetter("invoice_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return invoiceId;
    }

    /**
     * Setter for InvoiceId.
     * The API caller-provided external invoice number for this order. Appears in both the payer's
     * transaction history and the emails that the payer receives.
     * @param invoiceId Value for String
     */
    @JsonSetter("invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    /**
     * Getter for SoftDescriptor.
     * The soft descriptor is the dynamic text used to construct the statement descriptor that
     * appears on a payer's card statement. If an Order is paid using the "PayPal Wallet", the
     * statement descriptor will appear in following format on the payer's card statement:
     * PAYPAL_prefix+(space)+merchant_descriptor+(space)+ soft_descriptor Note: The merchant
     * descriptor is the descriptor of the merchant’s payment receiving preferences which can be
     * seen by logging into the merchant account
     * https://www.sandbox.paypal.com/businessprofile/settings/info/edit The PAYPAL prefix uses 8
     * characters. Only the first 22 characters will be displayed in the statement. For example, if:
     * The PayPal prefix toggle is PAYPAL *. The merchant descriptor in the profile is Janes Gift.
     * The soft descriptor is 800-123-1234. Then, the statement descriptor on the card is PAYPAL *
     * Janes Gift 80.
     * @return Returns the String
     */
    @JsonGetter("soft_descriptor")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getSoftDescriptor() {
        return softDescriptor;
    }

    /**
     * Setter for SoftDescriptor.
     * The soft descriptor is the dynamic text used to construct the statement descriptor that
     * appears on a payer's card statement. If an Order is paid using the "PayPal Wallet", the
     * statement descriptor will appear in following format on the payer's card statement:
     * PAYPAL_prefix+(space)+merchant_descriptor+(space)+ soft_descriptor Note: The merchant
     * descriptor is the descriptor of the merchant’s payment receiving preferences which can be
     * seen by logging into the merchant account
     * https://www.sandbox.paypal.com/businessprofile/settings/info/edit The PAYPAL prefix uses 8
     * characters. Only the first 22 characters will be displayed in the statement. For example, if:
     * The PayPal prefix toggle is PAYPAL *. The merchant descriptor in the profile is Janes Gift.
     * The soft descriptor is 800-123-1234. Then, the statement descriptor on the card is PAYPAL *
     * Janes Gift 80.
     * @param softDescriptor Value for String
     */
    @JsonSetter("soft_descriptor")
    public void setSoftDescriptor(String softDescriptor) {
        this.softDescriptor = softDescriptor;
    }

    /**
     * Getter for Items.
     * An array of items that the customer purchases from the merchant.
     * @return Returns the List of Item
     */
    @JsonGetter("items")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<Item> getItems() {
        return items;
    }

    /**
     * Setter for Items.
     * An array of items that the customer purchases from the merchant.
     * @param items Value for List of Item
     */
    @JsonSetter("items")
    public void setItems(List<Item> items) {
        this.items = items;
    }

    /**
     * Getter for Shipping.
     * The shipping details.
     * @return Returns the ShippingDetails
     */
    @JsonGetter("shipping")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ShippingDetails getShipping() {
        return shipping;
    }

    /**
     * Setter for Shipping.
     * The shipping details.
     * @param shipping Value for ShippingDetails
     */
    @JsonSetter("shipping")
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    /**
     * Getter for SupplementaryData.
     * Supplementary data about a payment. This object passes information that can be used to
     * improve risk assessments and processing costs, for example, by providing Level 2 and Level 3
     * payment data.
     * @return Returns the SupplementaryData
     */
    @JsonGetter("supplementary_data")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public SupplementaryData getSupplementaryData() {
        return supplementaryData;
    }

    /**
     * Setter for SupplementaryData.
     * Supplementary data about a payment. This object passes information that can be used to
     * improve risk assessments and processing costs, for example, by providing Level 2 and Level 3
     * payment data.
     * @param supplementaryData Value for SupplementaryData
     */
    @JsonSetter("supplementary_data")
    public void setSupplementaryData(SupplementaryData supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    /**
     * Converts this PurchaseUnitRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PurchaseUnitRequest [" + "amount=" + amount + ", referenceId=" + referenceId
                + ", payee=" + payee + ", paymentInstruction=" + paymentInstruction
                + ", description=" + description + ", customId=" + customId + ", invoiceId="
                + invoiceId + ", softDescriptor=" + softDescriptor + ", items=" + items
                + ", shipping=" + shipping + ", supplementaryData=" + supplementaryData + "]";
    }

    /**
     * Builds a new {@link PurchaseUnitRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PurchaseUnitRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(amount)
                .referenceId(getReferenceId())
                .payee(getPayee())
                .paymentInstruction(getPaymentInstruction())
                .description(getDescription())
                .customId(getCustomId())
                .invoiceId(getInvoiceId())
                .softDescriptor(getSoftDescriptor())
                .items(getItems())
                .shipping(getShipping())
                .supplementaryData(getSupplementaryData());
        return builder;
    }

    /**
     * Class to build instances of {@link PurchaseUnitRequest}.
     */
    public static class Builder {
        private AmountWithBreakdown amount;
        private String referenceId;
        private PayeeBase payee;
        private PaymentInstruction paymentInstruction;
        private String description;
        private String customId;
        private String invoiceId;
        private String softDescriptor;
        private List<Item> items;
        private ShippingDetails shipping;
        private SupplementaryData supplementaryData;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  amount  AmountWithBreakdown value for amount.
         */
        public Builder(AmountWithBreakdown amount) {
            this.amount = amount;
        }

        /**
         * Setter for amount.
         * @param  amount  AmountWithBreakdown value for amount.
         * @return Builder
         */
        public Builder amount(AmountWithBreakdown amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Setter for referenceId.
         * @param  referenceId  String value for referenceId.
         * @return Builder
         */
        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        /**
         * Setter for payee.
         * @param  payee  PayeeBase value for payee.
         * @return Builder
         */
        public Builder payee(PayeeBase payee) {
            this.payee = payee;
            return this;
        }

        /**
         * Setter for paymentInstruction.
         * @param  paymentInstruction  PaymentInstruction value for paymentInstruction.
         * @return Builder
         */
        public Builder paymentInstruction(PaymentInstruction paymentInstruction) {
            this.paymentInstruction = paymentInstruction;
            return this;
        }

        /**
         * Setter for description.
         * @param  description  String value for description.
         * @return Builder
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        /**
         * Setter for customId.
         * @param  customId  String value for customId.
         * @return Builder
         */
        public Builder customId(String customId) {
            this.customId = customId;
            return this;
        }

        /**
         * Setter for invoiceId.
         * @param  invoiceId  String value for invoiceId.
         * @return Builder
         */
        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        /**
         * Setter for softDescriptor.
         * @param  softDescriptor  String value for softDescriptor.
         * @return Builder
         */
        public Builder softDescriptor(String softDescriptor) {
            this.softDescriptor = softDescriptor;
            return this;
        }

        /**
         * Setter for items.
         * @param  items  List of Item value for items.
         * @return Builder
         */
        public Builder items(List<Item> items) {
            this.items = items;
            return this;
        }

        /**
         * Setter for shipping.
         * @param  shipping  ShippingDetails value for shipping.
         * @return Builder
         */
        public Builder shipping(ShippingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        /**
         * Setter for supplementaryData.
         * @param  supplementaryData  SupplementaryData value for supplementaryData.
         * @return Builder
         */
        public Builder supplementaryData(SupplementaryData supplementaryData) {
            this.supplementaryData = supplementaryData;
            return this;
        }

        /**
         * Builds a new {@link PurchaseUnitRequest} object using the set fields.
         * @return {@link PurchaseUnitRequest}
         */
        public PurchaseUnitRequest build() {
            return new PurchaseUnitRequest(amount, referenceId, payee, paymentInstruction,
                    description, customId, invoiceId, softDescriptor, items, shipping,
                    supplementaryData);
        }
    }
}
