/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for IdealPaymentRequest type.
 */
public class IdealPaymentRequest {
    private String name;
    private String countryCode;
    private String bic;
    private ExperienceContext experienceContext;

    /**
     * Default constructor.
     */
    public IdealPaymentRequest() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  countryCode  String value for countryCode.
     * @param  bic  String value for bic.
     * @param  experienceContext  ExperienceContext value for experienceContext.
     */
    public IdealPaymentRequest(
            String name,
            String countryCode,
            String bic,
            ExperienceContext experienceContext) {
        this.name = name;
        this.countryCode = countryCode;
        this.bic = bic;
        this.experienceContext = experienceContext;
    }

    /**
     * Getter for Name.
     * The full name representation like Mr J Smith.
     * @return Returns the String
     */
    @JsonGetter("name")
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The full name representation like Mr J Smith.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @return Returns the String
     */
    @JsonGetter("country_code")
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * Setter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @param countryCode Value for String
     */
    @JsonSetter("country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * Getter for Bic.
     * The business identification code (BIC). In payments systems, a BIC is used to identify a
     * specific business, most commonly a bank.
     * @return Returns the String
     */
    @JsonGetter("bic")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getBic() {
        return bic;
    }

    /**
     * Setter for Bic.
     * The business identification code (BIC). In payments systems, a BIC is used to identify a
     * specific business, most commonly a bank.
     * @param bic Value for String
     */
    @JsonSetter("bic")
    public void setBic(String bic) {
        this.bic = bic;
    }

    /**
     * Getter for ExperienceContext.
     * Customizes the payer experience during the approval process for the payment.
     * @return Returns the ExperienceContext
     */
    @JsonGetter("experience_context")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ExperienceContext getExperienceContext() {
        return experienceContext;
    }

    /**
     * Setter for ExperienceContext.
     * Customizes the payer experience during the approval process for the payment.
     * @param experienceContext Value for ExperienceContext
     */
    @JsonSetter("experience_context")
    public void setExperienceContext(ExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    /**
     * Converts this IdealPaymentRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "IdealPaymentRequest [" + "name=" + name + ", countryCode=" + countryCode + ", bic="
                + bic + ", experienceContext=" + experienceContext + "]";
    }

    /**
     * Builds a new {@link IdealPaymentRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link IdealPaymentRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(name, countryCode)
                .bic(getBic())
                .experienceContext(getExperienceContext());
        return builder;
    }

    /**
     * Class to build instances of {@link IdealPaymentRequest}.
     */
    public static class Builder {
        private String name;
        private String countryCode;
        private String bic;
        private ExperienceContext experienceContext;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  name  String value for name.
         * @param  countryCode  String value for countryCode.
         */
        public Builder(String name, String countryCode) {
            this.name = name;
            this.countryCode = countryCode;
        }

        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for countryCode.
         * @param  countryCode  String value for countryCode.
         * @return Builder
         */
        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        /**
         * Setter for bic.
         * @param  bic  String value for bic.
         * @return Builder
         */
        public Builder bic(String bic) {
            this.bic = bic;
            return this;
        }

        /**
         * Setter for experienceContext.
         * @param  experienceContext  ExperienceContext value for experienceContext.
         * @return Builder
         */
        public Builder experienceContext(ExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        /**
         * Builds a new {@link IdealPaymentRequest} object using the set fields.
         * @return {@link IdealPaymentRequest}
         */
        public IdealPaymentRequest build() {
            return new IdealPaymentRequest(name, countryCode, bic, experienceContext);
        }
    }
}
