/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for CobrandedCard type.
 */
public class CobrandedCard {
    private List<String> labels;
    private PayeeBase payee;
    private Money amount;

    /**
     * Default constructor.
     */
    public CobrandedCard() {
    }

    /**
     * Initialization constructor.
     * @param  labels  List of String value for labels.
     * @param  payee  PayeeBase value for payee.
     * @param  amount  Money value for amount.
     */
    public CobrandedCard(
            List<String> labels,
            PayeeBase payee,
            Money amount) {
        this.labels = labels;
        this.payee = payee;
        this.amount = amount;
    }

    /**
     * Getter for Labels.
     * Array of labels for the cobranded card.
     * @return Returns the List of String
     */
    @JsonGetter("labels")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<String> getLabels() {
        return labels;
    }

    /**
     * Setter for Labels.
     * Array of labels for the cobranded card.
     * @param labels Value for List of String
     */
    @JsonSetter("labels")
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    /**
     * Getter for Payee.
     * The details for the merchant who receives the funds and fulfills the order. The merchant is
     * also known as the payee.
     * @return Returns the PayeeBase
     */
    @JsonGetter("payee")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PayeeBase getPayee() {
        return payee;
    }

    /**
     * Setter for Payee.
     * The details for the merchant who receives the funds and fulfills the order. The merchant is
     * also known as the payee.
     * @param payee Value for PayeeBase
     */
    @JsonSetter("payee")
    public void setPayee(PayeeBase payee) {
        this.payee = payee;
    }

    /**
     * Getter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param amount Value for Money
     */
    @JsonSetter("amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    /**
     * Converts this CobrandedCard into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CobrandedCard [" + "labels=" + labels + ", payee=" + payee + ", amount=" + amount
                + "]";
    }

    /**
     * Builds a new {@link CobrandedCard.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CobrandedCard.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .labels(getLabels())
                .payee(getPayee())
                .amount(getAmount());
        return builder;
    }

    /**
     * Class to build instances of {@link CobrandedCard}.
     */
    public static class Builder {
        private List<String> labels;
        private PayeeBase payee;
        private Money amount;



        /**
         * Setter for labels.
         * @param  labels  List of String value for labels.
         * @return Builder
         */
        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Setter for payee.
         * @param  payee  PayeeBase value for payee.
         * @return Builder
         */
        public Builder payee(PayeeBase payee) {
            this.payee = payee;
            return this;
        }

        /**
         * Setter for amount.
         * @param  amount  Money value for amount.
         * @return Builder
         */
        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Builds a new {@link CobrandedCard} object using the set fields.
         * @return {@link CobrandedCard}
         */
        public CobrandedCard build() {
            return new CobrandedCard(labels, payee, amount);
        }
    }
}
