/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * CaptureIncompleteReason to be used.
 */
public enum CaptureIncompleteReason {
    /**
     * The payer initiated a dispute for this captured payment with PayPal.
     */
    BUYER_COMPLAINT,

    /**
     * The captured funds were reversed in response to the payer disputing this captured payment with the issuer of the financial instrument used to pay for this captured payment.
     */
    CHARGEBACK,

    /**
     * The payer paid by an eCheck that has not yet cleared.
     */
    ECHECK,

    /**
     * Visit your online account. In your **Account Overview**, accept and deny this payment.
     */
    INTERNATIONAL_WITHDRAWAL,

    /**
     * No additional specific reason can be provided. For more information about this captured payment, visit your account online or contact PayPal.
     */
    OTHER,

    /**
     * The captured payment is pending manual review.
     */
    PENDING_REVIEW,

    /**
     * The payee has not yet set up appropriate receiving preferences for their account. For more information about how to accept or deny this payment, visit your account online. This reason is typically offered in scenarios such as when the currency of the captured payment is different from the primary holding currency of the payee.
     */
    RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION,

    /**
     * The captured funds were refunded.
     */
    REFUNDED,

    /**
     * The payer must send the funds for this captured payment. This code generally appears for manual EFTs.
     */
    TRANSACTION_APPROVED_AWAITING_FUNDING,

    /**
     * The payee does not have a PayPal account.
     */
    UNILATERAL,

    /**
     * The payee's PayPal account is not verified.
     */
    VERIFICATION_REQUIRED,

    /**
     * Risk Filter set by the payee failed for the transaction.
     */
    DECLINED_BY_RISK_FRAUD_FILTERS,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, CaptureIncompleteReason> valueMap = new TreeMap<>();
    private String value;

    static {
        BUYER_COMPLAINT.value = "BUYER_COMPLAINT";
        CHARGEBACK.value = "CHARGEBACK";
        ECHECK.value = "ECHECK";
        INTERNATIONAL_WITHDRAWAL.value = "INTERNATIONAL_WITHDRAWAL";
        OTHER.value = "OTHER";
        PENDING_REVIEW.value = "PENDING_REVIEW";
        RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION.value = "RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION";
        REFUNDED.value = "REFUNDED";
        TRANSACTION_APPROVED_AWAITING_FUNDING.value = "TRANSACTION_APPROVED_AWAITING_FUNDING";
        UNILATERAL.value = "UNILATERAL";
        VERIFICATION_REQUIRED.value = "VERIFICATION_REQUIRED";
        DECLINED_BY_RISK_FRAUD_FILTERS.value = "DECLINED_BY_RISK_FRAUD_FILTERS";
        _UNKNOWN.value = null;

        valueMap.put("BUYER_COMPLAINT", BUYER_COMPLAINT);
        valueMap.put("CHARGEBACK", CHARGEBACK);
        valueMap.put("ECHECK", ECHECK);
        valueMap.put("INTERNATIONAL_WITHDRAWAL", INTERNATIONAL_WITHDRAWAL);
        valueMap.put("OTHER", OTHER);
        valueMap.put("PENDING_REVIEW", PENDING_REVIEW);
        valueMap.put("RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION", RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION);
        valueMap.put("REFUNDED", REFUNDED);
        valueMap.put("TRANSACTION_APPROVED_AWAITING_FUNDING", TRANSACTION_APPROVED_AWAITING_FUNDING);
        valueMap.put("UNILATERAL", UNILATERAL);
        valueMap.put("VERIFICATION_REQUIRED", VERIFICATION_REQUIRED);
        valueMap.put("DECLINED_BY_RISK_FRAUD_FILTERS", DECLINED_BY_RISK_FRAUD_FILTERS);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static CaptureIncompleteReason constructFromString(String toConvert) throws IOException {
        CaptureIncompleteReason enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static CaptureIncompleteReason fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of CaptureIncompleteReason values to list of string values.
     * @param toConvert The list of CaptureIncompleteReason values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<CaptureIncompleteReason> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (CaptureIncompleteReason enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 