/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.authentication;

import com.paypal.sdk.ClientCredentialsAuth;
import com.paypal.sdk.controllers.OAuthAuthorizationController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.models.OAuthToken;
import com.paypal.sdk.models.RequestTokenInput;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.authentication.HeaderAuth;
import io.apimatic.coreinterfaces.http.request.Request;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * Utility class for OAuth 2 authorization and token management.
 */
public class ClientCredentialsAuthManager extends HeaderAuth implements ClientCredentialsAuth {

    /**
     * Private instance of OAuth 2 API controller.
     */
    private OAuthAuthorizationController oAuthApi;

    /**
     * Private instance of the auth model containing the auth credentials.
     */
    private ClientCredentialsAuthModel authModel;

    /**
     * Private instance of the latest auth token.
     */
    private OAuthToken oAuthToken;
    
    /**
     * Instance to use as mutex lock for auth token.
     */
    private static final Object lockObj = new Object();

    /**
     * Constructor.
     */
    public ClientCredentialsAuthManager(ClientCredentialsAuthModel authModel) {
        super(Collections.emptyMap());
        this.authModel = authModel;
        this.oAuthToken = authModel.getOAuthToken();
    }

    /**
    * Apply GlobalConfiguration for token management.
    * @param config GlobalConfiguration instance
    */
    public void applyGlobalConfiguration(GlobalConfiguration config) {
        this.oAuthApi = new OAuthAuthorizationController(config);
    }


    /**
     * String value for oAuthClientId.
     * @return oAuthClientId
     */
    public String getOAuthClientId() {
        return authModel.getOAuthClientId();
    }

    /**
     * String value for oAuthClientSecret.
     * @return oAuthClientSecret
     */
    public String getOAuthClientSecret() {
        return authModel.getOAuthClientSecret();
    }

    /**
     * OAuthToken value for oAuthToken.
     * @return oAuthToken
     */
    public OAuthToken getOAuthToken() {
        return authModel.getOAuthToken();
    }

    /**
     * Checks if provided credentials matched with existing ones.
     * @param oAuthClientId String value for credentials.
     * @param oAuthClientSecret String value for credentials.
     * @param oAuthToken OAuthToken value for credentials.
     * @return true if credentials matched.
     */
    public boolean equals(String oAuthClientId, String oAuthClientSecret, OAuthToken oAuthToken) {
        return oAuthClientId.equals(getOAuthClientId())
                && oAuthClientSecret.equals(getOAuthClientSecret())
                && ((getOAuthToken() == null && oAuthToken == null)
                        || (getOAuthToken() != null && oAuthToken != null
                                && oAuthToken.toString().equals(getOAuthToken().toString())));
    }

    /**
     * Converts this ClientCredentialsAuthManager into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ClientCredentialsAuthManager [" + "oAuthClientId=" + getOAuthClientId()
                + ", oAuthClientSecret=" + getOAuthClientSecret() + ", oAuthToken="
                + getOAuthToken() + "]";
    }

    /**
     * Fetch the OAuth token asynchronously.
     * @param additionalParameters Additional parameters to send during authorization.
     */
    public CompletableFuture<OAuthToken> fetchTokenAsync(
            final Map<String, Object> additionalParameters) {
        final Map<String, Object> aparams =
                additionalParameters == null ? new HashMap<String, Object>()
                : additionalParameters;

        RequestTokenInput input = new RequestTokenInput.Builder()
                .authorization(getBasicAuthForClient())
                .scope(null)
                .build();
        return oAuthApi.requestTokenAsync(
            input,
            aparams).thenApply(result -> {
                OAuthToken token = result.getResult();
                Long expiresIn = token.getExpiresIn();
                if (expiresIn != null && expiresIn != 0) {
                    token.setExpiry((System.currentTimeMillis() / 1000L) + token.getExpiresIn());
                }
                return token;
            });
    }

    /**
     * Fetch the OAuth token asynchronously.
     */
    public CompletableFuture<OAuthToken> fetchTokenAsync() {
        return fetchTokenAsync(null);
    }

    /**
     * Fetch the OAuth token.
     * @param additionalParameters Additional parameters to send during authorization.
     */
    public OAuthToken fetchToken(Map<String, Object> additionalParameters)
            throws ApiException, IOException {
        final Map<String, Object> aparams =
                additionalParameters == null ? new HashMap<String, Object>()
                : additionalParameters;

        RequestTokenInput input = new RequestTokenInput.Builder()
                .authorization(getBasicAuthForClient())
                .scope(null)
                .build();
        OAuthToken token = oAuthApi.requestToken(
            input,
            aparams).getResult();

        if (token.getExpiresIn() != null && token.getExpiresIn() != 0) {
            token.setExpiry((System.currentTimeMillis() / 1000L) + token.getExpiresIn());
        }

        return token;
    }

    /**
     * Fetch the OAuth token.
     */
    public OAuthToken fetchToken() throws ApiException, IOException {
        return fetchToken(null);
    }

    /**
     * Build authorization header value for basic auth.
     * @return Authorization header value for this client.
     */
    private String getBasicAuthForClient() {
        String val = getOAuthClientId() + ":" + getOAuthClientSecret();
        return "Basic " + new String(Base64.getEncoder().encodeToString(val.getBytes()));
    }


    /**
     * Has the OAuth token expired?.
     * @return True if expired
     */
    public boolean isTokenExpired() {
            return isTokenExpired(getOAuthToken());
    }

    /**
     * A utility to check the expiry of the OAuth Token.
     * @param oAuthToken The OAuth token for whose expiry is to check.
     * @return True if expired
     */
    public boolean isTokenExpired(OAuthToken oAuthToken) {
        if (oAuthToken == null) {
            throw new IllegalStateException("OAuth token is missing.");
        }

        return oAuthToken.getExpiry() != null 
            && oAuthToken.getExpiry() - authModel.getOAuthClockSkew()
                < (System.currentTimeMillis() / 1000L);
    }

    /**
     * This provides the OAuth Token from either the user configured callbacks or from default provider.
     * @return The fetched OAuth token.
     */
    private OAuthToken getTokenFromProvider() {
        if(oAuthToken != null && !isTokenExpired(oAuthToken)) {
            return this.oAuthToken;
        }

        if (authModel.getOAuthTokenProvider() != null) {
            OAuthToken token = authModel.getOAuthTokenProvider().apply(this.oAuthToken, this);
            applyOnTokenUpdateCallback(token);
            return token;
        }

        try {
            OAuthToken token = fetchToken();
            applyOnTokenUpdateCallback(token);
            return token;
        } catch (ApiException | IOException e) {
            return this.oAuthToken;
        }
    }

    /**
     * This applies the OAuth token update callback provided by the user.
     */
    private void applyOnTokenUpdateCallback(OAuthToken token) {
        if (authModel.getOAuthOnTokenUpdate() != null) {
            authModel.getOAuthOnTokenUpdate().accept(token.toBuilder().build());
        }
    }

    /**
    * Create authorization header for API calls.
    * @param token OAuth token
    * @return Authorization header
    */
    private static String getAuthorizationHeader(OAuthToken token) {
        if (token == null) {
            return null;
        }
        return "Bearer " + token.getAccessToken();
    }

    /**
    * Validate the authentication on the httpRequest
    */
    @Override
    public void validate() {
        synchronized (lockObj) {
            oAuthToken = getTokenFromProvider();
            if (oAuthToken == null) {
                setErrorMessage("Client is not authorized."
                    + " An OAuth token is needed to make API calls.");
                setValidity(false);
            } else if (isTokenExpired(oAuthToken)) {
                setErrorMessage("The oAuth token is expired."
                    + " A valid token is needed to make API calls.");
                setValidity(false);
            } else {
                setValidity(true);
            }
        }
    }

    /**
    * Apply the Header authentication.
    * @param httpRequest The HTTP request on which the auth is to be applied.
    * @return {@link Request} The HTTP request after applying auth.
    */
    @Override
    public Request apply(Request httpRequest) {
        httpRequest.getHeaders().remove("Authorization");
        httpRequest.getHeaders().add("Authorization", getAuthorizationHeader(oAuthToken));
        return httpRequest;
    }

    /**
    * Returns the error message if the auth credentials are not valid.
    * @return the auth specific error message.
    */
    @Override
    public String getErrorMessage() {
        String errorMessage = super.getErrorMessage();
        if (errorMessage == null) {
            return null;
        }

        return "ClientCredentialsAuth - " + errorMessage;
     }

}
