/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.nvp;

import com.paypal.core.APICallPreHandler;
import com.paypal.core.CredentialManager;
import com.paypal.core.credential.CertificateCredential;
import com.paypal.core.credential.ICredential;
import com.paypal.core.credential.SignatureCredential;
import com.paypal.core.credential.TokenAuthorization;
import com.paypal.core.nvp.CertificateHttpHeaderAuthStrategy;
import com.paypal.core.nvp.SignatureHttpHeaderAuthStrategy;
import com.paypal.exception.ClientActionRequiredException;
import com.paypal.exception.InvalidCredentialException;
import com.paypal.exception.MissingCredentialException;
import com.paypal.sdk.exceptions.OAuthException;
import com.paypal.sdk.util.UserAgentHeader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformAPICallPreHandler
implements APICallPreHandler {
    private final String serviceName;
    private final String method;
    private final String rawPayLoad;
    private String apiUserName;
    private ICredential credential;
    private String accessToken;
    private String tokenSecret;
    private String sdkName;
    private String sdkVersion;
    private String portName;
    private Map<String, String> headers;
    private Map<String, String> configurationMap = null;

    private PlatformAPICallPreHandler(String rawPayLoad, String serviceName, String method) {
        this.rawPayLoad = rawPayLoad;
        this.serviceName = serviceName;
        this.method = method;
    }

    private PlatformAPICallPreHandler(String rawPayLoad, String serviceName, String method, Map<String, String> configurationMap) {
        this.rawPayLoad = rawPayLoad;
        this.serviceName = serviceName;
        this.method = method;
        this.configurationMap = configurationMap;
    }

    public PlatformAPICallPreHandler(String rawPayLoad, String serviceName, String method, String apiUserName, String accessToken, String tokenSecret) throws InvalidCredentialException, MissingCredentialException {
        this(rawPayLoad, serviceName, method);
        this.apiUserName = apiUserName;
        this.accessToken = accessToken;
        this.tokenSecret = tokenSecret;
        this.initCredential();
    }

    public PlatformAPICallPreHandler(String rawPayLoad, String serviceName, String method, ICredential credential) {
        this(rawPayLoad, serviceName, method);
        if (credential == null) {
            throw new IllegalArgumentException("Credential is null in PlatformAPICallPreHandler");
        }
        this.credential = credential;
    }

    public PlatformAPICallPreHandler(String rawPayLoad, String serviceName, String method, ICredential credential, String sdkName, String sdkVersion, String portName, Map<String, String> configurationMap) {
        this(rawPayLoad, serviceName, method, configurationMap);
        if (credential == null) {
            throw new IllegalArgumentException("Credential is null in PlatformAPICallPreHandler");
        }
        this.credential = credential;
        this.sdkName = sdkName;
        this.sdkVersion = sdkVersion;
        this.portName = portName;
    }

    public PlatformAPICallPreHandler(String rawPayLoad, String serviceName, String method, String apiUserName, String accessToken, String tokenSecret, String sdkName, String sdkVersion, String portName, Map<String, String> configurationMap) throws InvalidCredentialException, MissingCredentialException {
        this(rawPayLoad, serviceName, method, configurationMap);
        this.apiUserName = apiUserName;
        this.accessToken = accessToken;
        this.tokenSecret = tokenSecret;
        this.sdkName = sdkName;
        this.sdkVersion = sdkVersion;
        this.portName = portName;
        this.initCredential();
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public void setSdkName(String sdkName) {
        this.sdkName = sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Override
    public Map<String, String> getHeaderMap() throws OAuthException {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            if (this.credential instanceof SignatureCredential) {
                SignatureHttpHeaderAuthStrategy signatureHttpHeaderAuthStrategy = new SignatureHttpHeaderAuthStrategy(this.getEndPoint());
                this.headers = signatureHttpHeaderAuthStrategy.generateHeaderStrategy((SignatureCredential)this.credential);
            } else if (this.credential instanceof CertificateCredential) {
                CertificateHttpHeaderAuthStrategy certificateHttpHeaderAuthStrategy = new CertificateHttpHeaderAuthStrategy(this.getEndPoint());
                this.headers = certificateHttpHeaderAuthStrategy.generateHeaderStrategy((CertificateCredential)this.credential);
            }
            this.headers.putAll(this.getDefaultHttpHeadersNVP());
        }
        return this.headers;
    }

    @Override
    public String getPayLoad() {
        return this.rawPayLoad;
    }

    @Override
    public String getEndPoint() {
        String endPoint = this.searchEndpoint();
        if (endPoint != null) {
            endPoint = endPoint.endsWith("/") ? endPoint + this.serviceName + "/" + this.method : endPoint + "/" + this.serviceName + "/" + this.method;
        } else if ("sandbox".equalsIgnoreCase(this.configurationMap.get("mode").trim())) {
            endPoint = "https://svcs.sandbox.paypal.com/" + this.serviceName + "/" + this.method;
        } else if ("live".equalsIgnoreCase(this.configurationMap.get("mode").trim())) {
            endPoint = "https://svcs.paypal.com/" + this.serviceName + "/" + this.method;
        }
        return endPoint;
    }

    @Override
    public ICredential getCredential() {
        return this.credential;
    }

    @Override
    public void validate() throws ClientActionRequiredException {
        String mode = this.configurationMap.get("mode");
        if (mode == null && this.searchEndpoint() == null) {
            throw new ClientActionRequiredException("mode[production/live] OR endpoint not specified");
        }
        if (mode != null && !mode.trim().equalsIgnoreCase("live") && !mode.trim().equalsIgnoreCase("sandbox")) {
            throw new ClientActionRequiredException("mode[production/live] OR endpoint not specified");
        }
    }

    private String searchEndpoint() {
        String endPoint;
        String string = this.configurationMap.get("service.EndPoint." + this.getPortName()) != null ? this.configurationMap.get("service.EndPoint." + this.getPortName()) : (endPoint = this.configurationMap.get("service.EndPoint") != null ? this.configurationMap.get("service.EndPoint") : null);
        if (endPoint != null && endPoint.trim().length() <= 0) {
            endPoint = null;
        }
        return endPoint;
    }

    private ICredential getCredentials() throws InvalidCredentialException, MissingCredentialException {
        ICredential returnCredential = null;
        CredentialManager credentialManager = new CredentialManager(this.configurationMap);
        returnCredential = credentialManager.getCredentialObject(this.apiUserName);
        if (this.accessToken != null && this.accessToken.length() != 0) {
            TokenAuthorization tokenAuth = new TokenAuthorization(this.accessToken, this.tokenSecret);
            if (returnCredential instanceof SignatureCredential) {
                SignatureCredential sigCred = (SignatureCredential)returnCredential;
                sigCred.setThirdPartyAuthorization(tokenAuth);
            } else if (returnCredential instanceof CertificateCredential) {
                CertificateCredential certCred = (CertificateCredential)returnCredential;
                certCred.setThirdPartyAuthorization(tokenAuth);
            }
        }
        return returnCredential;
    }

    private Map<String, String> getDefaultHttpHeadersNVP() {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("X-PAYPAL-APPLICATION-ID", this.getApplicationId());
        returnMap.put("X-PAYPAL-REQUEST-DATA-FORMAT", "NV");
        returnMap.put("X-PAYPAL-RESPONSE-DATA-FORMAT", "NV");
        returnMap.put("X-PAYPAL-REQUEST-SOURCE", this.sdkName + "-" + this.sdkVersion);
        UserAgentHeader uaHeader = new UserAgentHeader(this.sdkName, this.sdkVersion);
        returnMap.putAll(uaHeader.getHeader());
        String sandboxEmailAddress = this.configurationMap.get("sandbox.EmailAddress");
        if (sandboxEmailAddress != null) {
            returnMap.put("X-PAYPAL-SANDBOX-EMAIL-ADDRESS", sandboxEmailAddress);
        }
        return returnMap;
    }

    private String getApplicationId() {
        String applicationId = null;
        if (this.credential instanceof CertificateCredential) {
            applicationId = ((CertificateCredential)this.credential).getApplicationId();
        } else if (this.credential instanceof SignatureCredential) {
            applicationId = ((SignatureCredential)this.credential).getApplicationId();
        }
        return applicationId;
    }

    private void initCredential() throws InvalidCredentialException, MissingCredentialException {
        if (this.credential == null) {
            this.credential = this.getCredentials();
        }
    }
}

