/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.ConfigManager;
import com.paypal.core.LoggingManager;
import com.paypal.core.SDKUtil;
import com.paypal.exception.SSLConfigurationException;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public abstract class SSLUtil {
    private static final KeyManagerFactory KMF;
    private static final Map<String, KeyStore> STOREMAP;
    private static final Map<String, String> CONFIG_MAP;

    public static SSLContext getSSLContext(KeyManager[] keymanagers) throws SSLConfigurationException {
        try {
            SSLContext ctx = null;
            String protocol = CONFIG_MAP.get("sslutil.protocol");
            try {
                ctx = SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException e) {
                LoggingManager.warn(SSLUtil.class, "WARNING: Your system does not support TLSv1.2. Per PCI Security Council mandate (https://github.com/paypal/TLS-update), you MUST update to latest security library.");
                ctx = SSLContext.getInstance(protocol);
            }
            ctx.init(keymanagers, null, null);
            return ctx;
        }
        catch (Exception e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore p12ToKeyStore(String p12Path, String password) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = STOREMAP.get(p12Path);
        if (keyStore == null) {
            keyStore = KeyStore.getInstance("PKCS12", CONFIG_MAP.get("sslutil.jre"));
            FileInputStream in = null;
            try {
                in = new FileInputStream(p12Path);
                keyStore.load(in, password.toCharArray());
                STOREMAP.put(p12Path, keyStore);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return keyStore;
    }

    public static SSLContext setupClientSSL(String certPath, String certPassword) throws SSLConfigurationException {
        SSLContext sslContext = null;
        try {
            KeyStore ks = SSLUtil.p12ToKeyStore(certPath, certPassword);
            KMF.init(ks, certPassword.toCharArray());
            sslContext = SSLUtil.getSSLContext(KMF.getKeyManagers());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        return sslContext;
    }

    static {
        try {
            KMF = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            STOREMAP = new HashMap<String, KeyStore>();
            CONFIG_MAP = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

