/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http;

import com.paypal.http.Headers;
import com.paypal.http.HttpRequest;
import com.paypal.http.serializer.FormEncoded;
import com.paypal.http.serializer.Json;
import com.paypal.http.serializer.Multipart;
import com.paypal.http.serializer.Serializer;
import com.paypal.http.serializer.StreamUtils;
import com.paypal.http.serializer.Text;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class Encoder {
    private List<Serializer> serializers = new ArrayList<Serializer>();

    public void registerSerializer(Serializer serializer) {
        this.serializers.add(serializer);
    }

    public Encoder() {
        this.registerSerializer(new Json());
        this.registerSerializer(new Text());
        this.registerSerializer(new Multipart());
        this.registerSerializer(new FormEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeRequest(HttpRequest request) throws IOException {
        String contentType = request.headers().header("content-type");
        if (contentType != null) {
            Serializer serializer = this.serializer(contentType);
            if (serializer == null) {
                String message = String.format("Unable to encode request with content-type: %s. Supported encodings are: %s", request.headers().header("content-type"), this.supportedEncodings());
                System.out.println(message);
                throw new UnsupportedEncodingException(message);
            }
            byte[] encoded = serializer.encode(request);
            if ("gzip".equals(request.headers().header("content-encoding"))) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(bos);
                try {
                    gzos.write(encoded);
                }
                finally {
                    bos.close();
                    gzos.close();
                }
                return bos.toByteArray();
            }
            return encoded;
        }
        String message = "HttpRequest does not have content-type header set";
        System.out.println(message);
        throw new UnsupportedEncodingException(message);
    }

    public <T> T deserializeResponse(InputStream stream, Class<T> responseClass, Headers headers) throws IOException {
        String contentType = headers.header("content-type");
        String contentEncoding = headers.header("content-encoding");
        String responseBody = StreamUtils.readStream(stream, contentEncoding);
        stream.close();
        if (responseClass.isAssignableFrom(String.class)) {
            return (T)responseBody;
        }
        if (responseBody.isEmpty()) {
            return null;
        }
        if (contentType == null) {
            String message = "HttpResponse does not have content-type header set";
            System.out.println(message);
            throw new UnsupportedEncodingException(message);
        }
        Serializer serializer = this.serializer(contentType = contentType.toLowerCase());
        if (serializer == null) {
            String message = String.format("Unable to decode response with content-type: %s. Supported decodings are: %s", headers.header("content-type"), this.supportedEncodings());
            System.out.println(message);
            throw new UnsupportedEncodingException(message);
        }
        if (responseBody.length() > 0) {
            return serializer.decode(responseBody, responseClass);
        }
        return null;
    }

    private List<String> supportedEncodings() {
        ArrayList<String> supportedEncodings = new ArrayList<String>();
        for (Serializer serializer : this.serializers) {
            supportedEncodings.add(serializer.contentType());
        }
        return supportedEncodings;
    }

    private Serializer serializer(String contentType) {
        if (contentType.contains(";")) {
            contentType = contentType.split(";")[0];
        }
        for (Serializer s : this.serializers) {
            if (!contentType.matches(s.contentType())) continue;
            return s;
        }
        return null;
    }
}

