/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.paypalwebpayments.errors;

import com.paypal.android.corepayments.PayPalSDKError;
import com.paypal.android.paypalwebpayments.errors.PayPalWebCheckoutErrorCode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\u00042\n\u0010\n\u001a\u00060\u000bj\u0002`\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/paypal/android/paypalwebpayments/errors/PayPalWebCheckoutError;", "", "()V", "malformedResultError", "Lcom/paypal/android/corepayments/PayPalSDKError;", "getMalformedResultError", "()Lcom/paypal/android/corepayments/PayPalSDKError;", "unknownError", "getUnknownError", "browserSwitchError", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "PayPalWebPayments_release"})
public final class PayPalWebCheckoutError {
    @NotNull
    public static final PayPalWebCheckoutError INSTANCE = new PayPalWebCheckoutError();
    @NotNull
    private static final PayPalSDKError unknownError = new PayPalSDKError(PayPalWebCheckoutErrorCode.UNKNOWN.ordinal(), "An unknown error occurred. Contact developer.paypal.com/support.", null, null, 12, null);
    @NotNull
    private static final PayPalSDKError malformedResultError = new PayPalSDKError(PayPalWebCheckoutErrorCode.MALFORMED_RESULT.ordinal(), "Result did not contain the expected data. Payer ID or Order ID is null.", null, null, 12, null);

    private PayPalWebCheckoutError() {
    }

    @NotNull
    public final PayPalSDKError getUnknownError() {
        return unknownError;
    }

    @NotNull
    public final PayPalSDKError getMalformedResultError() {
        return malformedResultError;
    }

    @NotNull
    public final PayPalSDKError browserSwitchError(@NotNull Exception cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        int n = PayPalWebCheckoutErrorCode.BROWSER_SWITCH.ordinal();
        String string = cause.getMessage();
        if (string == null) {
            string = "Unable to Browser Switch";
        }
        return new PayPalSDKError(n, string, null, null, 12, null);
    }
}

