/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.paypalwebpayments;

import android.content.Intent;
import android.net.Uri;
import androidx.activity.ComponentActivity;
import com.braintreepayments.api.BrowserSwitchClient;
import com.braintreepayments.api.BrowserSwitchFinalResult;
import com.braintreepayments.api.BrowserSwitchOptions;
import com.braintreepayments.api.BrowserSwitchStartResult;
import com.paypal.android.corepayments.CoreConfig;
import com.paypal.android.corepayments.Environment;
import com.paypal.android.corepayments.PayPalSDKError;
import com.paypal.android.paypalwebpayments.PayPalPresentAuthChallengeResult;
import com.paypal.android.paypalwebpayments.PayPalWebCheckoutFundingSource;
import com.paypal.android.paypalwebpayments.PayPalWebCheckoutRequest;
import com.paypal.android.paypalwebpayments.PayPalWebCheckoutResult;
import com.paypal.android.paypalwebpayments.PayPalWebStatus;
import com.paypal.android.paypalwebpayments.PayPalWebVaultRequest;
import com.paypal.android.paypalwebpayments.PayPalWebVaultResult;
import com.paypal.android.paypalwebpayments.errors.PayPalWebCheckoutError;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020!J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020$H\u0002J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010&\u001a\u00020$H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/paypal/android/paypalwebpayments/PayPalWebLauncher;", "", "urlScheme", "", "coreConfig", "Lcom/paypal/android/corepayments/CoreConfig;", "browserSwitchClient", "Lcom/braintreepayments/api/BrowserSwitchClient;", "(Ljava/lang/String;Lcom/paypal/android/corepayments/CoreConfig;Lcom/braintreepayments/api/BrowserSwitchClient;)V", "redirectUriPayPalCheckout", "buildPayPalCheckoutUri", "Landroid/net/Uri;", "orderId", "config", "funding", "Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutFundingSource;", "buildPayPalVaultUri", "setupTokenId", "completeAuthRequest", "Lcom/paypal/android/paypalwebpayments/PayPalWebStatus;", "intent", "Landroid/content/Intent;", "authState", "launchBrowserSwitch", "Lcom/paypal/android/paypalwebpayments/PayPalPresentAuthChallengeResult;", "activity", "Landroidx/activity/ComponentActivity;", "options", "Lcom/braintreepayments/api/BrowserSwitchOptions;", "launchPayPalWebCheckout", "request", "Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutRequest;", "launchPayPalWebVault", "Lcom/paypal/android/paypalwebpayments/PayPalWebVaultRequest;", "parseBrowserSwitchSuccessResult", "result", "Lcom/braintreepayments/api/BrowserSwitchFinalResult$Success;", "parseVaultSuccessResult", "finalResult", "parseWebCheckoutSuccessResult", "Companion", "PayPalWebPayments_release"})
@SourceDebugExtension(value={"SMAP\nPayPalWebLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayPalWebLauncher.kt\ncom/paypal/android/paypalwebpayments/PayPalWebLauncher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class PayPalWebLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String urlScheme;
    @NotNull
    private final CoreConfig coreConfig;
    @NotNull
    private final BrowserSwitchClient browserSwitchClient;
    @NotNull
    private final String redirectUriPayPalCheckout;
    @NotNull
    private static final String METADATA_KEY_ORDER_ID = "order_id";
    @NotNull
    private static final String METADATA_KEY_SETUP_TOKEN_ID = "setup_token_id";
    @NotNull
    private static final String URL_PARAM_APPROVAL_SESSION_ID = "approval_session_id";

    public PayPalWebLauncher(@NotNull String urlScheme, @NotNull CoreConfig coreConfig, @NotNull BrowserSwitchClient browserSwitchClient) {
        Intrinsics.checkNotNullParameter((Object)urlScheme, (String)"urlScheme");
        Intrinsics.checkNotNullParameter((Object)coreConfig, (String)"coreConfig");
        Intrinsics.checkNotNullParameter((Object)browserSwitchClient, (String)"browserSwitchClient");
        this.urlScheme = urlScheme;
        this.coreConfig = coreConfig;
        this.browserSwitchClient = browserSwitchClient;
        this.redirectUriPayPalCheckout = this.urlScheme + "://x-callback-url/paypal-sdk/paypal-checkout";
    }

    public /* synthetic */ PayPalWebLauncher(String string, CoreConfig coreConfig, BrowserSwitchClient browserSwitchClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            browserSwitchClient = new BrowserSwitchClient();
        }
        this(string, coreConfig, browserSwitchClient);
    }

    @NotNull
    public final PayPalPresentAuthChallengeResult launchPayPalWebCheckout(@NotNull ComponentActivity activity, @NotNull PayPalWebCheckoutRequest request) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JSONObject metadata = new JSONObject().put(METADATA_KEY_ORDER_ID, (Object)request.getOrderId());
        PayPalWebCheckoutRequest $this$launchPayPalWebCheckout_u24lambda_u240 = request;
        boolean bl = false;
        Uri url = this.buildPayPalCheckoutUri($this$launchPayPalWebCheckout_u24lambda_u240.getOrderId(), this.coreConfig, $this$launchPayPalWebCheckout_u24lambda_u240.getFundingSource());
        BrowserSwitchOptions options = new BrowserSwitchOptions().url(url).requestCode(3).returnUrlScheme(this.urlScheme).metadata(metadata);
        Intrinsics.checkNotNull((Object)options);
        return this.launchBrowserSwitch(activity, options);
    }

    @NotNull
    public final PayPalPresentAuthChallengeResult launchPayPalWebVault(@NotNull ComponentActivity activity, @NotNull PayPalWebVaultRequest request) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JSONObject metadata = new JSONObject().put(METADATA_KEY_SETUP_TOKEN_ID, (Object)request.getSetupTokenId());
        PayPalWebVaultRequest $this$launchPayPalWebVault_u24lambda_u241 = request;
        boolean bl = false;
        Uri url = this.buildPayPalVaultUri(request.getSetupTokenId(), this.coreConfig);
        BrowserSwitchOptions options = new BrowserSwitchOptions().url(url).requestCode(4).returnUrlScheme(this.urlScheme).metadata(metadata);
        Intrinsics.checkNotNull((Object)options);
        return this.launchBrowserSwitch(activity, options);
    }

    private final PayPalPresentAuthChallengeResult launchBrowserSwitch(ComponentActivity activity, BrowserSwitchOptions options) {
        PayPalPresentAuthChallengeResult payPalPresentAuthChallengeResult;
        BrowserSwitchStartResult browserSwitchStartResult = this.browserSwitchClient.start(activity, options);
        Intrinsics.checkNotNullExpressionValue((Object)browserSwitchStartResult, (String)"start(...)");
        BrowserSwitchStartResult startResult = browserSwitchStartResult;
        if (startResult instanceof BrowserSwitchStartResult.Started) {
            payPalPresentAuthChallengeResult = new PayPalPresentAuthChallengeResult.Success(((BrowserSwitchStartResult.Started)startResult).getPendingRequest());
        } else if (startResult instanceof BrowserSwitchStartResult.Failure) {
            PayPalSDKError error = PayPalWebCheckoutError.INSTANCE.browserSwitchError(((BrowserSwitchStartResult.Failure)startResult).getError());
            payPalPresentAuthChallengeResult = new PayPalPresentAuthChallengeResult.Failure(error);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return payPalPresentAuthChallengeResult;
    }

    private final Uri buildPayPalCheckoutUri(String orderId, CoreConfig config, PayPalWebCheckoutFundingSource funding) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[config.getEnvironment().ordinal()]) {
            case 1: {
                string = "https://www.paypal.com";
                break;
            }
            case 2: {
                string = "https://www.sandbox.paypal.com";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String baseURL = string;
        Uri uri = Uri.parse((String)baseURL).buildUpon().appendPath("checkoutnow").appendQueryParameter("token", orderId).appendQueryParameter("redirect_uri", this.redirectUriPayPalCheckout).appendQueryParameter("native_xo", "1").appendQueryParameter("fundingSource", funding.getValue()).build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"build(...)");
        return uri;
    }

    private final Uri buildPayPalVaultUri(String setupTokenId, CoreConfig config) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[config.getEnvironment().ordinal()]) {
            case 1: {
                string = "https://paypal.com/agreements/approve";
                break;
            }
            case 2: {
                string = "https://sandbox.paypal.com/agreements/approve";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String baseURL = string;
        Uri uri = Uri.parse((String)baseURL).buildUpon().appendQueryParameter(URL_PARAM_APPROVAL_SESSION_ID, setupTokenId).build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"build(...)");
        return uri;
    }

    @NotNull
    public final PayPalWebStatus completeAuthRequest(@NotNull Intent intent, @NotNull String authState) {
        PayPalWebStatus payPalWebStatus;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)authState, (String)"authState");
        BrowserSwitchFinalResult finalResult = this.browserSwitchClient.completeRequest(intent, authState);
        if (finalResult instanceof BrowserSwitchFinalResult.Success) {
            payPalWebStatus = this.parseBrowserSwitchSuccessResult((BrowserSwitchFinalResult.Success)finalResult);
        } else if (finalResult instanceof BrowserSwitchFinalResult.Failure) {
            payPalWebStatus = new PayPalWebStatus.UnknownError((Throwable)((BrowserSwitchFinalResult.Failure)finalResult).getError());
        } else if (Intrinsics.areEqual((Object)finalResult, (Object)BrowserSwitchFinalResult.NoResult.INSTANCE)) {
            payPalWebStatus = PayPalWebStatus.NoResult.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return payPalWebStatus;
    }

    private final PayPalWebStatus parseBrowserSwitchSuccessResult(BrowserSwitchFinalResult.Success result) {
        PayPalWebStatus payPalWebStatus;
        switch (result.getRequestCode()) {
            case 3: {
                payPalWebStatus = this.parseWebCheckoutSuccessResult(result);
                break;
            }
            case 4: {
                payPalWebStatus = this.parseVaultSuccessResult(result);
                break;
            }
            default: {
                payPalWebStatus = PayPalWebStatus.NoResult.INSTANCE;
            }
        }
        return payPalWebStatus;
    }

    private final PayPalWebStatus parseWebCheckoutSuccessResult(BrowserSwitchFinalResult.Success finalResult) {
        PayPalWebStatus payPalWebStatus;
        Uri deepLinkUrl = finalResult.getReturnUrl();
        JSONObject metadata = finalResult.getRequestMetadata();
        if (metadata == null) {
            payPalWebStatus = new PayPalWebStatus.CheckoutError(PayPalWebCheckoutError.INSTANCE.getUnknownError(), null);
        } else {
            String payerId = deepLinkUrl.getQueryParameter("PayerID");
            String orderId = metadata.optString(METADATA_KEY_ORDER_ID);
            CharSequence charSequence = orderId;
            payPalWebStatus = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)payerId) == null || StringsKt.isBlank((CharSequence)charSequence) ? (PayPalWebStatus)new PayPalWebStatus.CheckoutError(PayPalWebCheckoutError.INSTANCE.getMalformedResultError(), orderId) : (PayPalWebStatus)new PayPalWebStatus.CheckoutSuccess(new PayPalWebCheckoutResult(orderId, payerId));
        }
        return payPalWebStatus;
    }

    private final PayPalWebStatus parseVaultSuccessResult(BrowserSwitchFinalResult.Success finalResult) {
        PayPalWebStatus payPalWebStatus;
        Uri deepLinkUrl = finalResult.getReturnUrl();
        JSONObject requestMetadata = finalResult.getRequestMetadata();
        if (requestMetadata == null) {
            payPalWebStatus = new PayPalWebStatus.VaultError(PayPalWebCheckoutError.INSTANCE.getUnknownError());
        } else {
            String approvalSessionId = deepLinkUrl.getQueryParameter(URL_PARAM_APPROVAL_SESSION_ID);
            CharSequence charSequence = approvalSessionId;
            if (charSequence == null || charSequence.length() == 0) {
                payPalWebStatus = new PayPalWebStatus.VaultError(PayPalWebCheckoutError.INSTANCE.getMalformedResultError());
            } else {
                PayPalWebVaultResult result = new PayPalWebVaultResult(approvalSessionId);
                payPalWebStatus = new PayPalWebStatus.VaultSuccess(result);
            }
        }
        return payPalWebStatus;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/paypal/android/paypalwebpayments/PayPalWebLauncher$Companion;", "", "()V", "METADATA_KEY_ORDER_ID", "", "METADATA_KEY_SETUP_TOKEN_ID", "URL_PARAM_APPROVAL_SESSION_ID", "PayPalWebPayments_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Environment.values().length];
            try {
                nArray[Environment.LIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Environment.SANDBOX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

