/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.paypalwebpayments;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.activity.ComponentActivity;
import com.paypal.android.corepayments.CoreConfig;
import com.paypal.android.corepayments.PayPalSDKError;
import com.paypal.android.corepayments.analytics.AnalyticsService;
import com.paypal.android.paypalwebpayments.PayPalPresentAuthChallengeResult;
import com.paypal.android.paypalwebpayments.PayPalWebCheckoutListener;
import com.paypal.android.paypalwebpayments.PayPalWebCheckoutRequest;
import com.paypal.android.paypalwebpayments.PayPalWebCheckoutResult;
import com.paypal.android.paypalwebpayments.PayPalWebLauncher;
import com.paypal.android.paypalwebpayments.PayPalWebStatus;
import com.paypal.android.paypalwebpayments.PayPalWebVaultListener;
import com.paypal.android.paypalwebpayments.PayPalWebVaultRequest;
import com.paypal.android.paypalwebpayments.PayPalWebVaultResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u00020 2\b\u0010(\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010)\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\b\u0010(\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010%\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020 J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000204R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutClient;", "", "context", "Landroid/content/Context;", "configuration", "Lcom/paypal/android/corepayments/CoreConfig;", "urlScheme", "", "(Landroid/content/Context;Lcom/paypal/android/corepayments/CoreConfig;Ljava/lang/String;)V", "analyticsService", "Lcom/paypal/android/corepayments/analytics/AnalyticsService;", "payPalWebLauncher", "Lcom/paypal/android/paypalwebpayments/PayPalWebLauncher;", "(Lcom/paypal/android/corepayments/analytics/AnalyticsService;Lcom/paypal/android/paypalwebpayments/PayPalWebLauncher;)V", "listener", "Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutListener;", "getListener", "()Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutListener;", "setListener", "(Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutListener;)V", "vaultListener", "Lcom/paypal/android/paypalwebpayments/PayPalWebVaultListener;", "getVaultListener", "()Lcom/paypal/android/paypalwebpayments/PayPalWebVaultListener;", "setVaultListener", "(Lcom/paypal/android/paypalwebpayments/PayPalWebVaultListener;)V", "completeAuthChallenge", "Lcom/paypal/android/paypalwebpayments/PayPalWebStatus;", "intent", "Landroid/content/Intent;", "authState", "notifyVaultCancelation", "", "notifyVaultFailure", "error", "Lcom/paypal/android/corepayments/PayPalSDKError;", "notifyVaultSuccess", "result", "Lcom/paypal/android/paypalwebpayments/PayPalWebVaultResult;", "notifyWebCheckoutCancelation", "orderId", "notifyWebCheckoutFailure", "notifyWebCheckoutSuccess", "Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutResult;", "removeObservers", "start", "Lcom/paypal/android/paypalwebpayments/PayPalPresentAuthChallengeResult;", "activity", "Landroidx/activity/ComponentActivity;", "request", "Lcom/paypal/android/paypalwebpayments/PayPalWebCheckoutRequest;", "vault", "Lcom/paypal/android/paypalwebpayments/PayPalWebVaultRequest;", "PayPalWebPayments_release"})
public final class PayPalWebCheckoutClient {
    @NotNull
    private final AnalyticsService analyticsService;
    @NotNull
    private final PayPalWebLauncher payPalWebLauncher;
    @Nullable
    private PayPalWebCheckoutListener listener;
    @Nullable
    private PayPalWebVaultListener vaultListener;

    public PayPalWebCheckoutClient(@NotNull AnalyticsService analyticsService, @NotNull PayPalWebLauncher payPalWebLauncher) {
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        Intrinsics.checkNotNullParameter((Object)payPalWebLauncher, (String)"payPalWebLauncher");
        this.analyticsService = analyticsService;
        this.payPalWebLauncher = payPalWebLauncher;
    }

    public PayPalWebCheckoutClient(@NotNull Context context, @NotNull CoreConfig configuration, @NotNull String urlScheme) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)urlScheme, (String)"urlScheme");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this(new AnalyticsService(context2, configuration), new PayPalWebLauncher(urlScheme, configuration, null, 4, null));
    }

    @Nullable
    public final PayPalWebCheckoutListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable PayPalWebCheckoutListener payPalWebCheckoutListener) {
        this.listener = payPalWebCheckoutListener;
    }

    @Nullable
    public final PayPalWebVaultListener getVaultListener() {
        return this.vaultListener;
    }

    public final void setVaultListener(@Nullable PayPalWebVaultListener payPalWebVaultListener) {
        this.vaultListener = payPalWebVaultListener;
    }

    @NotNull
    public final PayPalPresentAuthChallengeResult start(@NotNull ComponentActivity activity, @NotNull PayPalWebCheckoutRequest request) {
        PayPalPresentAuthChallengeResult result;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:started", (String)request.getOrderId(), null, (int)4, null);
        PayPalPresentAuthChallengeResult payPalPresentAuthChallengeResult = result = this.payPalWebLauncher.launchPayPalWebCheckout(activity, request);
        if (payPalPresentAuthChallengeResult instanceof PayPalPresentAuthChallengeResult.Failure) {
            this.notifyWebCheckoutFailure(((PayPalPresentAuthChallengeResult.Failure)result).getError(), request.getOrderId());
        } else if (payPalPresentAuthChallengeResult instanceof PayPalPresentAuthChallengeResult.Success) {
            // empty if block
        }
        return result;
    }

    @NotNull
    public final PayPalPresentAuthChallengeResult vault(@NotNull ComponentActivity activity, @NotNull PayPalWebVaultRequest request) {
        PayPalPresentAuthChallengeResult result;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:vault-wo-purchase:started", null, null, (int)6, null);
        PayPalPresentAuthChallengeResult payPalPresentAuthChallengeResult = result = this.payPalWebLauncher.launchPayPalWebVault(activity, request);
        if (payPalPresentAuthChallengeResult instanceof PayPalPresentAuthChallengeResult.Failure) {
            this.notifyVaultFailure(((PayPalPresentAuthChallengeResult.Failure)result).getError());
        } else if (payPalPresentAuthChallengeResult instanceof PayPalPresentAuthChallengeResult.Success) {
            // empty if block
        }
        return result;
    }

    @NotNull
    public final PayPalWebStatus completeAuthChallenge(@NotNull Intent intent, @NotNull String authState) {
        PayPalWebStatus status;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)authState, (String)"authState");
        PayPalWebStatus payPalWebStatus = status = this.payPalWebLauncher.completeAuthRequest(intent, authState);
        if (payPalWebStatus instanceof PayPalWebStatus.CheckoutSuccess) {
            this.notifyWebCheckoutSuccess(((PayPalWebStatus.CheckoutSuccess)status).getResult());
        } else if (payPalWebStatus instanceof PayPalWebStatus.CheckoutError) {
            PayPalWebStatus.CheckoutError $this$completeAuthChallenge_u24lambda_u240 = (PayPalWebStatus.CheckoutError)status;
            boolean bl = false;
            this.notifyWebCheckoutFailure($this$completeAuthChallenge_u24lambda_u240.getError(), $this$completeAuthChallenge_u24lambda_u240.getOrderId());
        } else if (payPalWebStatus instanceof PayPalWebStatus.CheckoutCanceled) {
            this.notifyWebCheckoutCancelation(((PayPalWebStatus.CheckoutCanceled)status).getOrderId());
        } else if (payPalWebStatus instanceof PayPalWebStatus.VaultSuccess) {
            this.notifyVaultSuccess(((PayPalWebStatus.VaultSuccess)status).getResult());
        } else if (payPalWebStatus instanceof PayPalWebStatus.VaultError) {
            this.notifyVaultFailure(((PayPalWebStatus.VaultError)status).getError());
        } else if (Intrinsics.areEqual((Object)payPalWebStatus, (Object)PayPalWebStatus.VaultCanceled.INSTANCE)) {
            this.notifyVaultCancelation();
        } else if (payPalWebStatus instanceof PayPalWebStatus.UnknownError) {
            Log.d((String)"PayPalSDK", (String)("An unknown error occurred: " + ((PayPalWebStatus.UnknownError)status).getError().getMessage()));
        } else if (Intrinsics.areEqual((Object)payPalWebStatus, (Object)PayPalWebStatus.NoResult.INSTANCE)) {
            // empty if block
        }
        return status;
    }

    private final void notifyWebCheckoutSuccess(PayPalWebCheckoutResult result) {
        block0: {
            AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:succeeded", (String)result.getOrderId(), null, (int)4, null);
            PayPalWebCheckoutListener payPalWebCheckoutListener = this.listener;
            if (payPalWebCheckoutListener == null) break block0;
            payPalWebCheckoutListener.onPayPalWebSuccess(result);
        }
    }

    private final void notifyWebCheckoutFailure(PayPalSDKError error, String orderId) {
        block0: {
            AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:failed", (String)orderId, null, (int)4, null);
            PayPalWebCheckoutListener payPalWebCheckoutListener = this.listener;
            if (payPalWebCheckoutListener == null) break block0;
            payPalWebCheckoutListener.onPayPalWebFailure(error);
        }
    }

    private final void notifyWebCheckoutCancelation(String orderId) {
        block0: {
            AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:browser-login:canceled", (String)orderId, null, (int)4, null);
            PayPalWebCheckoutListener payPalWebCheckoutListener = this.listener;
            if (payPalWebCheckoutListener == null) break block0;
            payPalWebCheckoutListener.onPayPalWebCanceled();
        }
    }

    private final void notifyVaultSuccess(PayPalWebVaultResult result) {
        block0: {
            AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:vault-wo-purchase:succeeded", null, null, (int)6, null);
            PayPalWebVaultListener payPalWebVaultListener = this.vaultListener;
            if (payPalWebVaultListener == null) break block0;
            payPalWebVaultListener.onPayPalWebVaultSuccess(result);
        }
    }

    private final void notifyVaultFailure(PayPalSDKError error) {
        block0: {
            AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:vault-wo-purchase:failed", null, null, (int)6, null);
            PayPalWebVaultListener payPalWebVaultListener = this.vaultListener;
            if (payPalWebVaultListener == null) break block0;
            payPalWebVaultListener.onPayPalWebVaultFailure(error);
        }
    }

    private final void notifyVaultCancelation() {
        block0: {
            AnalyticsService.sendAnalyticsEvent$default((AnalyticsService)this.analyticsService, (String)"paypal-web-payments:vault-wo-purchase:canceled", null, null, (int)6, null);
            PayPalWebVaultListener payPalWebVaultListener = this.vaultListener;
            if (payPalWebVaultListener == null) break block0;
            payPalWebVaultListener.onPayPalWebVaultCanceled();
        }
    }

    public final void removeObservers() {
        this.vaultListener = null;
        this.listener = null;
    }
}

