/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.corepayments.analytics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.paypal.android.corepayments.analytics.DeviceData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/paypal/android/corepayments/analytics/DeviceInspector;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "clientSDKVersion", "", "sdkInt", "", "deviceManufacturer", "deviceModel", "deviceProduct", "deviceFingerprint", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/content/Context;)V", "inspect", "Lcom/paypal/android/corepayments/analytics/DeviceData;", "CorePayments_release"})
public final class DeviceInspector {
    @NotNull
    private final String clientSDKVersion;
    private final int sdkInt;
    @NotNull
    private final String deviceManufacturer;
    @NotNull
    private final String deviceModel;
    @NotNull
    private final String deviceProduct;
    @NotNull
    private final String deviceFingerprint;
    @NotNull
    private final Context context;

    @VisibleForTesting
    public DeviceInspector(@NotNull String clientSDKVersion, int sdkInt, @NotNull String deviceManufacturer, @NotNull String deviceModel, @NotNull String deviceProduct, @NotNull String deviceFingerprint, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)clientSDKVersion, (String)"clientSDKVersion");
        Intrinsics.checkNotNullParameter((Object)deviceManufacturer, (String)"deviceManufacturer");
        Intrinsics.checkNotNullParameter((Object)deviceModel, (String)"deviceModel");
        Intrinsics.checkNotNullParameter((Object)deviceProduct, (String)"deviceProduct");
        Intrinsics.checkNotNullParameter((Object)deviceFingerprint, (String)"deviceFingerprint");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.clientSDKVersion = clientSDKVersion;
        this.sdkInt = sdkInt;
        this.deviceManufacturer = deviceManufacturer;
        this.deviceModel = deviceModel;
        this.deviceProduct = deviceProduct;
        this.deviceFingerprint = deviceFingerprint;
        this.context = context;
    }

    public DeviceInspector(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        String string2 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
        String string3 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PRODUCT");
        String string4 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FINGERPRINT");
        this("null", Build.VERSION.SDK_INT, string, string2, string3, string4, context);
    }

    @NotNull
    public final DeviceData inspect() {
        String packageInfo;
        String applicationInfo;
        PackageManager packageManager = this.context.getPackageManager();
        try {
            ApplicationInfo applicationInfo2 = packageManager.getApplicationInfo(this.context.getPackageName(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo2, (String)"getApplicationInfo(...)");
            applicationInfo = applicationInfo2;
            applicationInfo = ((Object)packageManager.getApplicationLabel((ApplicationInfo)applicationInfo)).toString();
        }
        catch (PackageManager.NameNotFoundException ignored) {
            applicationInfo = "N/A";
        }
        String appName = applicationInfo;
        try {
            packageInfo = packageManager.getPackageInfo(this.context.getPackageName(), 0);
            packageInfo = ((PackageInfo)packageInfo).versionName;
        }
        catch (PackageManager.NameNotFoundException ignored) {
            packageInfo = "N/A";
        }
        String merchantAppVersion = packageInfo;
        String appId = this.context.getPackageName();
        String clientOS = "Android API " + this.sdkInt;
        boolean isSimulator = StringsKt.equals((String)"google_sdk", (String)this.deviceProduct, (boolean)true) || StringsKt.equals((String)"sdk", (String)this.deviceProduct, (boolean)true) || StringsKt.equals((String)"Genymotion", (String)this.deviceManufacturer, (boolean)true) || StringsKt.contains$default((CharSequence)this.deviceFingerprint, (CharSequence)"generic", (boolean)false, (int)2, null);
        String string = this.clientSDKVersion;
        String string2 = this.deviceManufacturer;
        String string3 = this.deviceModel;
        String string4 = merchantAppVersion;
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        Intrinsics.checkNotNull((Object)appId);
        return new DeviceData(appId, appName, clientOS, string, string5, string2, string3, isSimulator);
    }
}

