/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.corepayments;

import com.paypal.android.corepayments.APIRequest;
import com.paypal.android.corepayments.CoreConfig;
import com.paypal.android.corepayments.HttpMethod;
import com.paypal.android.corepayments.HttpResponse;
import com.paypal.android.corepayments.RestClient;
import com.paypal.android.corepayments.analytics.AnalyticsEventData;
import com.paypal.android.corepayments.analytics.DeviceData;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/paypal/android/corepayments/TrackingEventsAPI;", "", "coreConfig", "Lcom/paypal/android/corepayments/CoreConfig;", "(Lcom/paypal/android/corepayments/CoreConfig;)V", "restClient", "Lcom/paypal/android/corepayments/RestClient;", "(Lcom/paypal/android/corepayments/CoreConfig;Lcom/paypal/android/corepayments/RestClient;)V", "createAPIRequestForEvent", "Lcom/paypal/android/corepayments/APIRequest;", "event", "Lcom/paypal/android/corepayments/analytics/AnalyticsEventData;", "deviceData", "Lcom/paypal/android/corepayments/analytics/DeviceData;", "sendEvent", "Lcom/paypal/android/corepayments/HttpResponse;", "(Lcom/paypal/android/corepayments/analytics/AnalyticsEventData;Lcom/paypal/android/corepayments/analytics/DeviceData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "CorePayments_release"})
public final class TrackingEventsAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoreConfig coreConfig;
    @NotNull
    private final RestClient restClient;
    @NotNull
    public static final String KEY_APP_ID = "app_id";
    @NotNull
    public static final String KEY_APP_NAME = "app_name";
    @NotNull
    public static final String KEY_CLIENT_ID = "partner_client_id";
    @NotNull
    public static final String KEY_CLIENT_SDK_VERSION = "c_sdk_ver";
    @NotNull
    public static final String KEY_CLIENT_OS = "client_os";
    @NotNull
    public static final String KEY_COMPONENT = "comp";
    @NotNull
    public static final String KEY_DEVICE_MANUFACTURER = "device_manufacturer";
    @NotNull
    public static final String KEY_DEVICE_MODEL = "mobile_device_model";
    @NotNull
    public static final String KEY_ENVIRONMENT = "merchant_sdk_env";
    @NotNull
    public static final String KEY_EVENT_NAME = "event_name";
    @NotNull
    public static final String KEY_EVENT_SOURCE = "event_source";
    @NotNull
    public static final String KEY_IS_SIMULATOR = "is_simulator";
    @NotNull
    public static final String KEY_MERCHANT_APP_VERSION = "mapv";
    @NotNull
    public static final String KEY_ORDER_ID = "order_id";
    @NotNull
    public static final String KEY_BUTTON_TYPE = "button_type";
    @NotNull
    public static final String KEY_PLATFORM = "platform";
    @NotNull
    public static final String KEY_TIMESTAMP = "t";
    @NotNull
    public static final String KEY_TENANT_NAME = "tenant_name";
    @NotNull
    public static final String KEY_EVENT_PARAMETERS = "event_params";
    @NotNull
    public static final String KEY_EVENTS = "events";

    public TrackingEventsAPI(@NotNull CoreConfig coreConfig, @NotNull RestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)coreConfig, (String)"coreConfig");
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this.coreConfig = coreConfig;
        this.restClient = restClient;
    }

    public TrackingEventsAPI(@NotNull CoreConfig coreConfig) {
        Intrinsics.checkNotNullParameter((Object)coreConfig, (String)"coreConfig");
        this(coreConfig, new RestClient(coreConfig));
    }

    @Nullable
    public final Object sendEvent(@NotNull AnalyticsEventData event, @NotNull DeviceData deviceData, @NotNull Continuation<? super HttpResponse> $completion) {
        APIRequest apiRequest = this.createAPIRequestForEvent(event, deviceData);
        return this.restClient.send(apiRequest, $completion);
    }

    private final APIRequest createAPIRequestForEvent(AnalyticsEventData event, DeviceData deviceData) {
        String appId = deviceData.getAppId();
        String appName = deviceData.getAppName();
        String clientSDKVersion = deviceData.getClientSDKVersion();
        String clientOS = deviceData.getClientOS();
        String deviceManufacturer = deviceData.getDeviceManufacturer();
        String deviceModel = deviceData.getDeviceModel();
        boolean isSimulator = deviceData.isSimulator();
        String merchantAppVersion = deviceData.getMerchantAppVersion();
        JSONObject eventParams = new JSONObject().put(KEY_APP_ID, (Object)appId).put(KEY_APP_NAME, (Object)appName).put(KEY_CLIENT_ID, (Object)this.coreConfig.getClientId()).put(KEY_CLIENT_SDK_VERSION, (Object)clientSDKVersion).put(KEY_CLIENT_OS, (Object)clientOS).put(KEY_COMPONENT, (Object)"ppcpclientsdk").put(KEY_DEVICE_MANUFACTURER, (Object)deviceManufacturer).put(KEY_DEVICE_MODEL, (Object)deviceModel).put(KEY_ENVIRONMENT, (Object)event.getEnvironment()).put(KEY_EVENT_NAME, (Object)event.getEventName()).put(KEY_EVENT_SOURCE, (Object)"mobile-native").put(KEY_IS_SIMULATOR, isSimulator).put(KEY_MERCHANT_APP_VERSION, (Object)merchantAppVersion).put(KEY_PLATFORM, (Object)"Android").putOpt(KEY_ORDER_ID, (Object)event.getOrderId()).putOpt(KEY_BUTTON_TYPE, (Object)event.getButtonType()).put(KEY_TIMESTAMP, (Object)String.valueOf(event.getTimestamp())).put(KEY_TENANT_NAME, (Object)"PayPal");
        JSONObject events = new JSONObject().put(KEY_EVENT_PARAMETERS, (Object)eventParams);
        JSONObject jsonBody = new JSONObject().put(KEY_EVENTS, (Object)events);
        return new APIRequest("v1/tracking/events", HttpMethod.POST, jsonBody.toString());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/paypal/android/corepayments/TrackingEventsAPI$Companion;", "", "()V", "KEY_APP_ID", "", "KEY_APP_NAME", "KEY_BUTTON_TYPE", "KEY_CLIENT_ID", "KEY_CLIENT_OS", "KEY_CLIENT_SDK_VERSION", "KEY_COMPONENT", "KEY_DEVICE_MANUFACTURER", "KEY_DEVICE_MODEL", "KEY_ENVIRONMENT", "KEY_EVENTS", "KEY_EVENT_NAME", "KEY_EVENT_PARAMETERS", "KEY_EVENT_SOURCE", "KEY_IS_SIMULATOR", "KEY_MERCHANT_APP_VERSION", "KEY_ORDER_ID", "KEY_PLATFORM", "KEY_TENANT_NAME", "KEY_TIMESTAMP", "CorePayments_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

