/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.lib;

import com.paymennt.crypto.lib.Sha256;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;

public class ByteUtils {
    public static final int UINT_32_LENGTH = 4;
    public static final int UINT_64_LENGTH = 8;

    public static byte[] readBytes(byte[] buf, int offset, int length) {
        byte[] b = new byte[length];
        System.arraycopy(buf, offset, b, 0, length);
        return b;
    }

    public static BigInteger readUint64(byte[] buf, int offset) {
        return new BigInteger(ByteUtils.reverseBytes(ByteUtils.readBytes(buf, offset, 8)));
    }

    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        int length;
        assert (b.signum() >= 0);
        assert (numBytes > 0);
        byte[] src = b.toByteArray();
        byte[] dest = new byte[numBytes];
        boolean isFirstByteOnlyForSign = src[0] == 0;
        int n = length = isFirstByteOnlyForSign ? src.length - 1 : src.length;
        assert (length <= numBytes);
        int srcPos = isFirstByteOnlyForSign ? 1 : 0;
        int destPos = numBytes - length;
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static BigInteger bytesToBigInteger(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    public static void uint16ToByteArrayLE(int val, byte[] out, int offset) {
        out[offset] = (byte)(0xFF & val);
        out[offset + 1] = (byte)(0xFF & val >> 8);
    }

    public static void uint32ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
    }

    public static void uint32ToByteArrayBE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val >> 24);
        out[offset + 1] = (byte)(0xFFL & val >> 16);
        out[offset + 2] = (byte)(0xFFL & val >> 8);
        out[offset + 3] = (byte)(0xFFL & val);
    }

    public static void int64ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
        out[offset + 4] = (byte)(0xFFL & val >> 32);
        out[offset + 5] = (byte)(0xFFL & val >> 40);
        out[offset + 6] = (byte)(0xFFL & val >> 48);
        out[offset + 7] = (byte)(0xFFL & val >> 56);
    }

    public static void uint16ToByteStreamLE(int val, OutputStream stream) throws IOException {
        stream.write(0xFF & val);
        stream.write(0xFF & val >> 8);
    }

    public static void uint16ToByteStreamBE(int val, OutputStream stream) throws IOException {
        stream.write(0xFF & val >> 8);
        stream.write(0xFF & val);
    }

    public static void uint32ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
    }

    public static void uint32ToByteStreamBE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val >> 24));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val));
    }

    public static void int64ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
        stream.write((int)(0xFFL & val >> 32));
        stream.write((int)(0xFFL & val >> 40));
        stream.write((int)(0xFFL & val >> 48));
        stream.write((int)(0xFFL & val >> 56));
    }

    public static void uint64ToByteStreamLE(BigInteger val, OutputStream stream) throws IOException {
        byte[] bytes = val.toByteArray();
        if (bytes.length > 8) {
            throw new RuntimeException("Input too large to encode into a uint64");
        }
        bytes = ByteUtils.reverseBytes(bytes);
        stream.write(bytes);
        if (bytes.length < 8) {
            for (int i = 0; i < 8 - bytes.length; ++i) {
                stream.write(0);
            }
        }
    }

    public static int readUint16(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    public static long readUint32(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24;
    }

    public static long readInt64(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56;
    }

    public static long readUint32BE(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static int readUint16BE(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    public static int readUint16FromStream(InputStream is) {
        try {
            return is.read() & 0xFF | (is.read() & 0xFF) << 8;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static long readUint32FromStream(InputStream is) {
        try {
            return (long)is.read() & 0xFFL | ((long)is.read() & 0xFFL) << 8 | ((long)is.read() & 0xFFL) << 16 | ((long)is.read() & 0xFFL) << 24;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = bytes[bytes.length - 1 - i];
        }
        return buf;
    }

    public static byte[] sha256hash160(byte[] input) {
        byte[] sha256 = Sha256.hash(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }
}

