/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.lib;

import com.paymennt.crypto.lib.Hash256;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class Base58 {
    private static final String BASE58_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    public static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final int[] INDEXES = new int[128];

    public static String encode(byte[] key) {
        int zeroCount = 0;
        for (byte b : key) {
            if (b != 0) break;
            ++zeroCount;
        }
        BigInteger keyNumber = new BigInteger(1, key);
        String prefix = "1".repeat(zeroCount);
        String result = "";
        while (keyNumber.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] divideAndRemainder = keyNumber.divideAndRemainder(BigInteger.valueOf(58L));
            keyNumber = divideAndRemainder[0];
            int remainder = divideAndRemainder[1].intValueExact();
            result = BASE58_ALPHABET.substring(remainder, remainder + 1).concat(result);
        }
        return prefix.concat(result);
    }

    public static byte[] decode(String input) {
        int zeros;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            int digit;
            char c = input.charAt(i);
            int n = digit = c < '\u0080' ? INDEXES[c] : -1;
            assert (digit >= 0);
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }

    public static String encodeWithChecksum(byte[] key) {
        byte[] checksum = Hash256.hash(key);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.writeBytes(key);
        byteArrayOutputStream.writeBytes(new byte[]{checksum[0], checksum[1], checksum[2], checksum[3]});
        return Base58.encode(byteArrayOutputStream.toByteArray());
    }

    public static byte[] decodeWif(String wif, boolean compressed) {
        BigInteger number = BigInteger.ZERO;
        char[] cArray = wif.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            number = number.multiply(BigInteger.valueOf(58L));
            number = number.add(BigInteger.valueOf(BASE58_ALPHABET.chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toList()).indexOf(c)));
        }
        int length = 37;
        if (compressed) {
            ++length;
        }
        byte[] combined = BigIntegers.asUnsignedByteArray((int)length, (BigInteger)number);
        return Arrays.copyOfRange(combined, 1, 33);
    }

    public static byte[] decodeWithChecksum(String key) {
        byte[] checksum;
        BigInteger number = BigInteger.ZERO;
        char[] cArray = key.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            number = number.multiply(BigInteger.valueOf(58L));
            number = number.add(BigInteger.valueOf(BASE58_ALPHABET.chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toList()).indexOf(c)));
        }
        byte[] combined = BigIntegers.asUnsignedByteArray((int)25, (BigInteger)number);
        if (!Base58.isValidAddress(combined, checksum = Arrays.copyOfRange(combined, 21, 25))) {
            throw new RuntimeException("Bad address");
        }
        return Arrays.copyOfRange(combined, 1, 21);
    }

    public static byte[] decodeExtendedKey(String key) {
        BigInteger number = BigInteger.ZERO;
        char[] cArray = key.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            number = number.multiply(BigInteger.valueOf(58L));
            number = number.add(BigInteger.valueOf(BASE58_ALPHABET.chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toList()).indexOf(c)));
        }
        return BigIntegers.asUnsignedByteArray((BigInteger)number);
    }

    public static String decodeWithChecksumToHex(String key) {
        return Hex.toHexString((byte[])Base58.decodeWithChecksum(key));
    }

    private static boolean isValidAddress(byte[] combined, byte[] checksum) {
        return Arrays.equals(Arrays.copyOfRange(Hash256.hash(Arrays.copyOfRange(combined, 0, 21)), 0, 4), checksum);
    }

    public static String encodeFromHex(String key) {
        return Base58.encode(Hex.decodeStrict((String)key));
    }

    public static String encodeWithChecksumFromHex(String key) {
        return Base58.encodeWithChecksum(Hex.decodeStrict((String)key));
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

