/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.bip32.wallet;

import com.paymennt.crypto.CoinType;
import com.paymennt.crypto.bip32.Network;
import com.paymennt.crypto.bip32.crypto.Hash;
import com.paymennt.crypto.bip32.crypto.HdUtil;
import com.paymennt.crypto.bip32.crypto.HmacSha512;
import com.paymennt.crypto.bip32.crypto.Secp256k1;
import com.paymennt.crypto.bip32.exception.CryptoException;
import com.paymennt.crypto.bip32.wallet.HdAddress;
import com.paymennt.crypto.bip32.wallet.key.Curve;
import com.paymennt.crypto.bip32.wallet.key.HdPrivateKey;
import com.paymennt.crypto.bip32.wallet.key.HdPublicKey;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class HdKeyGenerator {
    private static final EdDSAParameterSpec ED25519SPEC = EdDSANamedCurveTable.getByName((String)"ed25519");
    public static final String MASTER_PATH = "m";

    public static HdAddress getAddressFromSeed(byte[] seed, Network network, CoinType coinType) {
        byte[] I;
        Curve curve = coinType.getCurve();
        HdPublicKey publicKey = new HdPublicKey();
        HdPrivateKey privateKey = new HdPrivateKey();
        HdAddress address = new HdAddress(privateKey, publicKey, coinType, MASTER_PATH);
        try {
            I = HmacSha512.hmac512(seed, curve.getSeed().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoException("Unable to decode seed.");
        }
        byte[] IL = Arrays.copyOfRange(I, 0, 32);
        byte[] IR = Arrays.copyOfRange(I, 32, 64);
        BigInteger masterSecretKey = HdUtil.parse256(IL);
        if (curve != Curve.ED25519 && masterSecretKey.compareTo(BigInteger.ZERO) == 0 || masterSecretKey.compareTo(Secp256k1.getN()) > 0) {
            throw new CryptoException("The master key is invalid");
        }
        privateKey.setVersion(network.getPrivateKeyVersion());
        privateKey.setDepth(0);
        privateKey.setFingerprint(new byte[]{0, 0, 0, 0});
        privateKey.setChildNumber(new byte[]{0, 0, 0, 0});
        privateKey.setChainCode(IR);
        privateKey.setKeyData(HdUtil.append(new byte[]{0}, IL));
        ECPoint point = Secp256k1.point(masterSecretKey);
        publicKey.setVersion(network.getPublicKeyVersion());
        publicKey.setDepth(0);
        publicKey.setFingerprint(new byte[]{0, 0, 0, 0});
        publicKey.setChildNumber(new byte[]{0, 0, 0, 0});
        publicKey.setChainCode(IR);
        publicKey.setKeyData(Secp256k1.serP(point));
        switch (curve) {
            case BITCOIN: {
                privateKey.setPrivateKey(privateKey.getKeyData());
                publicKey.setPublicKey(publicKey.getKeyData());
                break;
            }
            case ED25519: {
                privateKey.setPrivateKey(IL);
                EdDSAPrivateKey sk = new EdDSAPrivateKey(new EdDSAPrivateKeySpec(IL, ED25519SPEC));
                EdDSAPublicKey pk = new EdDSAPublicKey(new EdDSAPublicKeySpec(sk.getA(), sk.getParams()));
                publicKey.setPublicKey(pk.getAbyte());
            }
        }
        return address;
    }

    public static HdPublicKey getPublicKey(HdPublicKey parent, long child, boolean isHardened, Curve curve) {
        if (isHardened) {
            throw new CryptoException("Cannot derive child public keys from hardened keys");
        }
        if (curve == Curve.ED25519) {
            throw new UnsupportedOperationException("Unable to derive ed25519 public key chaining");
        }
        byte[] key = parent.getKeyData();
        byte[] data = HdUtil.append(key, HdUtil.ser32(child));
        byte[] I = HmacSha512.hmac512(data, parent.getChainCode());
        byte[] IL = Arrays.copyOfRange(I, 0, 32);
        byte[] IR = Arrays.copyOfRange(I, 32, 64);
        HdPublicKey publicKey = new HdPublicKey();
        publicKey.setVersion(parent.getVersion());
        publicKey.setDepth(parent.getDepth() + 1);
        byte[] pKd = parent.getKeyData();
        byte[] h160 = Hash.h160(pKd);
        byte[] childFingerprint = new byte[]{h160[0], h160[1], h160[2], h160[3]};
        BigInteger ILBigInt = HdUtil.parse256(IL);
        ECPoint point = Secp256k1.point(ILBigInt);
        point = point.add(Secp256k1.deserP(parent.getKeyData()));
        if (ILBigInt.compareTo(Secp256k1.getN()) > 0 || point.isInfinity()) {
            throw new CryptoException("This key is invalid, should proceed to next key");
        }
        byte[] childKey = Secp256k1.serP(point);
        publicKey.setFingerprint(childFingerprint);
        publicKey.setChildNumber(HdUtil.ser32(child));
        publicKey.setChainCode(IR);
        publicKey.setKeyData(childKey);
        return publicKey;
    }

    public static HdAddress getAddress(HdAddress parent, long child, boolean isHardened) {
        byte[] I;
        HdPrivateKey privateKey = new HdPrivateKey();
        HdPublicKey publicKey = new HdPublicKey();
        HdAddress address = new HdAddress(privateKey, publicKey, parent.getCoinType(), HdKeyGenerator.getPath(parent.getPath(), child, isHardened));
        if (isHardened) {
            child += Integer.MIN_VALUE;
        } else if (parent.getCoinType().getCurve() == Curve.ED25519) {
            throw new CryptoException("ed25519 only supports hardened keys");
        }
        byte[] xChain = parent.getPrivateKey().getChainCode();
        if (isHardened) {
            BigInteger kpar = HdUtil.parse256(parent.getPrivateKey().getKeyData());
            byte[] data = HdUtil.append(new byte[]{0}, HdUtil.ser256(kpar));
            data = HdUtil.append(data, HdUtil.ser32(child));
            I = HmacSha512.hmac512(data, xChain);
        } else {
            byte[] key = parent.getPublicKey().getKeyData();
            byte[] xPubKey = HdUtil.append(key, HdUtil.ser32(child));
            I = HmacSha512.hmac512(xPubKey, xChain);
        }
        byte[] IL = Arrays.copyOfRange(I, 0, 32);
        byte[] IR = Arrays.copyOfRange(I, 32, 64);
        BigInteger parse256 = HdUtil.parse256(IL);
        BigInteger kpar = HdUtil.parse256(parent.getPrivateKey().getKeyData());
        BigInteger childSecretKey = parse256.add(kpar).mod(Secp256k1.getN());
        byte[] childNumber = HdUtil.ser32(child);
        byte[] fingerprint = HdUtil.getFingerprint(parent.getPrivateKey().getKeyData());
        privateKey.setVersion(parent.getPrivateKey().getVersion());
        privateKey.setDepth(parent.getPrivateKey().getDepth() + 1);
        privateKey.setFingerprint(fingerprint);
        privateKey.setChildNumber(childNumber);
        privateKey.setChainCode(IR);
        privateKey.setKeyData(HdUtil.append(new byte[]{0}, HdUtil.ser256(childSecretKey)));
        ECPoint point = Secp256k1.point(childSecretKey);
        publicKey.setVersion(parent.getPublicKey().getVersion());
        publicKey.setDepth(parent.getPublicKey().getDepth() + 1);
        byte[] pKd = parent.getPublicKey().getKeyData();
        byte[] h160 = Hash.h160(pKd);
        byte[] childFingerprint = new byte[]{h160[0], h160[1], h160[2], h160[3]};
        publicKey.setFingerprint(childFingerprint);
        publicKey.setChildNumber(childNumber);
        publicKey.setChainCode(IR);
        publicKey.setKeyData(Secp256k1.serP(point));
        switch (parent.getCoinType().getCurve()) {
            case BITCOIN: {
                privateKey.setPrivateKey(privateKey.getKeyData());
                publicKey.setPublicKey(publicKey.getKeyData());
                break;
            }
            case ED25519: {
                privateKey.setPrivateKey(IL);
                h160 = Hash.h160(parent.getPublicKey().getPublicKey());
                childFingerprint = new byte[]{h160[0], h160[1], h160[2], h160[3]};
                publicKey.setFingerprint(childFingerprint);
                privateKey.setFingerprint(childFingerprint);
                privateKey.setKeyData(HdUtil.append(new byte[]{0}, IL));
                EdDSAPrivateKey sk = new EdDSAPrivateKey(new EdDSAPrivateKeySpec(IL, ED25519SPEC));
                EdDSAPublicKey pk = new EdDSAPublicKey(new EdDSAPublicKeySpec(sk.getA(), sk.getParams()));
                publicKey.setPublicKey(pk.getAbyte());
            }
        }
        return address;
    }

    private static String getPath(String parentPath, long child, boolean isHardened) {
        if (parentPath == null) {
            parentPath = MASTER_PATH;
        }
        return parentPath + "/" + child + (isHardened ? "'" : "");
    }
}

