/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.bip32.crypto;

import com.paymennt.crypto.bip32.crypto.Hash;
import com.paymennt.crypto.bip32.crypto.Secp256k1;
import java.math.BigInteger;
import java.util.Arrays;

public class HdUtil {
    public static byte[] ser32(long i) {
        byte[] ser = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return ser;
    }

    public static byte[] ser256(BigInteger p) {
        byte[] byteArray = p.toByteArray();
        byte[] ret = new byte[32];
        Arrays.fill(ret, (byte)0);
        if (byteArray.length <= ret.length) {
            System.arraycopy(byteArray, 0, ret, ret.length - byteArray.length, byteArray.length);
        } else {
            System.arraycopy(byteArray, byteArray.length - ret.length, ret, 0, ret.length);
        }
        return ret;
    }

    public static byte[] ser256LE(BigInteger p) {
        byte[] byteArray = p.toByteArray();
        HdUtil.reverse(byteArray);
        byte[] ret = new byte[32];
        Arrays.fill(ret, (byte)0);
        if (byteArray.length <= ret.length) {
            System.arraycopy(byteArray, 0, ret, ret.length - byteArray.length, byteArray.length);
        } else {
            System.arraycopy(byteArray, byteArray.length - ret.length, ret, 0, ret.length);
        }
        return ret;
    }

    public static BigInteger parse256(byte[] p) {
        return new BigInteger(1, p);
    }

    public static BigInteger parse256LE(byte[] p) {
        byte[] copy = HdUtil.clone(p);
        HdUtil.reverse(copy);
        return new BigInteger(1, copy);
    }

    public static byte[] append(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] getFingerprint(byte[] keyData) {
        byte[] point = Secp256k1.serP(Secp256k1.point(HdUtil.parse256(keyData)));
        byte[] h160 = Hash.h160(point);
        return new byte[]{h160[0], h160[1], h160[2], h160[3]};
    }

    public static byte[] ser32LE(long i) {
        byte[] ser = new byte[4];
        ser[3] = (byte)(i >> 24);
        ser[2] = (byte)(i >> 16);
        ser[1] = (byte)(i >> 8);
        ser[0] = (byte)i;
        return ser;
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        HdUtil.reverse(array, 0, array.length);
    }

    public static void reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }
}

