/*
 * Decompiled with CFR 0.152.
 */
package com.payline.ws.wrapper;

import com.payline.kit.utils.ConnectParams;
import com.payline.kit.utils.PaylineProperties;
import com.payline.kit.utils.Utils;
import com.payline.ws.model.Authentication3DSecure;
import com.payline.ws.model.BillingRecordForUpdate;
import com.payline.ws.model.Buyer;
import com.payline.ws.model.ContractNumberWalletList;
import com.payline.ws.model.CreateWalletRequest;
import com.payline.ws.model.CreateWalletResponse;
import com.payline.ws.model.CreateWebWalletRequest;
import com.payline.ws.model.CreateWebWalletResponse;
import com.payline.ws.model.DirectPaymentAPI;
import com.payline.ws.model.DisablePaymentRecordRequest;
import com.payline.ws.model.DisablePaymentRecordResponse;
import com.payline.ws.model.DisableWalletRequest;
import com.payline.ws.model.DisableWalletResponse;
import com.payline.ws.model.DoImmediateWalletPaymentRequest;
import com.payline.ws.model.DoImmediateWalletPaymentResponse;
import com.payline.ws.model.DoRecurrentWalletPaymentRequest;
import com.payline.ws.model.DoRecurrentWalletPaymentResponse;
import com.payline.ws.model.DoScheduledWalletPaymentRequest;
import com.payline.ws.model.DoScheduledWalletPaymentResponse;
import com.payline.ws.model.EnableWalletRequest;
import com.payline.ws.model.EnableWalletResponse;
import com.payline.ws.model.GetBillingRecordRequest;
import com.payline.ws.model.GetBillingRecordResponse;
import com.payline.ws.model.GetCardsRequest;
import com.payline.ws.model.GetCardsResponse;
import com.payline.ws.model.GetPaymentRecordRequest;
import com.payline.ws.model.GetPaymentRecordResponse;
import com.payline.ws.model.GetWalletRequest;
import com.payline.ws.model.GetWalletResponse;
import com.payline.ws.model.GetWebWalletRequest;
import com.payline.ws.model.GetWebWalletResponse;
import com.payline.ws.model.ManageWebWalletRequest;
import com.payline.ws.model.ManageWebWalletResponse;
import com.payline.ws.model.Order;
import com.payline.ws.model.Owner;
import com.payline.ws.model.Payment;
import com.payline.ws.model.PrivateDataList;
import com.payline.ws.model.Recurring;
import com.payline.ws.model.RecurringForUpdate;
import com.payline.ws.model.Result;
import com.payline.ws.model.SelectedContractList;
import com.payline.ws.model.SubMerchant;
import com.payline.ws.model.ThreeDSInfo;
import com.payline.ws.model.UpdateBillingRecordRequest;
import com.payline.ws.model.UpdateBillingRecordResponse;
import com.payline.ws.model.UpdatePaymentRecordRequest;
import com.payline.ws.model.UpdatePaymentRecordResponse;
import com.payline.ws.model.UpdateWalletRequest;
import com.payline.ws.model.UpdateWalletResponse;
import com.payline.ws.model.UpdateWebWalletRequest;
import com.payline.ws.model.UpdateWebWalletResponse;
import com.payline.ws.model.Wallet;
import com.payline.ws.model.WalletIdList;
import com.payline.ws.model.WebPaymentAPI;
import com.payline.ws.wrapper.ExtendedAPI;
import com.payline.ws.wrapper.WebServiceWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public class WalletPayment
extends WebServiceWrapper {
    private static final Logger logger = Logger.getLogger(ExtendedAPI.class.getName());
    private boolean initFromFile = true;
    private ConnectParams connectParams;

    public WalletPayment() {
    }

    public WalletPayment(ConnectParams connectParams) {
        this.initFromFile = false;
        this.connectParams = connectParams;
    }

    public final CreateWalletResponse createWallet(Wallet wallet, String contractNumber, PrivateDataList privateDataList, Authentication3DSecure authentication3DSecure, String version) {
        return this.createWallet(wallet, contractNumber, privateDataList, authentication3DSecure, version, null, null, null, null, null);
    }

    public final CreateWalletResponse createWallet(Wallet wallet, String contractNumber, PrivateDataList privateDataList, Authentication3DSecure authentication3DSecure, String version, Buyer buyer, Owner owner, String media, ContractNumberWalletList contractNumberWalletList, String transationID) {
        this.setException(null);
        CreateWalletResponse result = new CreateWalletResponse();
        CreateWalletRequest parameters = new CreateWalletRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setWallet(wallet);
        parameters.setPrivateDataList(privateDataList);
        parameters.setAuthentication3DSecure(authentication3DSecure);
        parameters.setVersion(version);
        parameters.setBuyer(buyer);
        parameters.setOwner(owner);
        parameters.setMedia(media);
        parameters.setContractNumberWalletList(contractNumberWalletList);
        parameters.setTransactionID(transationID);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.createWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during createWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetWalletResponse getWallet(String walletId, String contractNumber, String Cardind, String version) {
        return this.getWallet(walletId, contractNumber, Cardind, version, null);
    }

    public final GetWalletResponse getWallet(String walletId, String contractNumber, String Cardind, String version, String media) {
        this.setException(null);
        GetWalletResponse result = new GetWalletResponse();
        GetWalletRequest parameters = new GetWalletRequest();
        parameters.setWalletId(walletId);
        parameters.setContractNumber(contractNumber);
        parameters.setVersion(version);
        parameters.setCardInd(Cardind);
        parameters.setMedia(media);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final UpdateWalletResponse updateWallet(Wallet wallet, String contractNumber, PrivateDataList privateDataList, Authentication3DSecure authentication3DSecure, String Cardind, String version) {
        return this.updateWallet(wallet, contractNumber, privateDataList, authentication3DSecure, Cardind, version, null, null, null, null, null);
    }

    public final UpdateWalletResponse updateWallet(Wallet wallet, String contractNumber, PrivateDataList privateDataList, Authentication3DSecure authentication3DSecure, String Cardind, String version, Buyer buyer, Owner owner, String media, ContractNumberWalletList contractNumberWalletList, String transationID) {
        this.setException(null);
        UpdateWalletResponse result = new UpdateWalletResponse();
        UpdateWalletRequest parameters = new UpdateWalletRequest();
        parameters.setWallet(wallet);
        parameters.setContractNumber(contractNumber);
        parameters.setPrivateDataList(privateDataList);
        parameters.setAuthentication3DSecure(authentication3DSecure);
        parameters.setCardInd(Cardind);
        parameters.setVersion(version);
        parameters.setBuyer(buyer);
        parameters.setOwner(owner);
        parameters.setMedia(media);
        parameters.setContractNumberWalletList(contractNumberWalletList);
        parameters.setTransactionID(transationID);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.updateWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during updateWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DisableWalletResponse disableWallet(WalletIdList walletIdList, String contractNumber, String Cardind) {
        this.setException(null);
        DisableWalletResponse result = new DisableWalletResponse();
        DisableWalletRequest parameters = new DisableWalletRequest();
        parameters.setWalletIdList(walletIdList);
        parameters.setContractNumber(contractNumber);
        parameters.setCardInd(Cardind);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.disableWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during disableWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final EnableWalletResponse enableWallet(String walletId, String contractNumber, String Cardind) {
        this.setException(null);
        EnableWalletResponse result = new EnableWalletResponse();
        EnableWalletRequest parameters = new EnableWalletRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setWalletId(walletId);
        parameters.setCardInd(Cardind);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.enableWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during enableWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoImmediateWalletPaymentResponse doImmediateWalletPayment(Payment payment, Order order, Buyer buyer, PrivateDataList privateDataList, String walletId, String Cardind, String cvx, String version) {
        return this.doImmediateWalletPayment(payment, order, buyer, privateDataList, walletId, Cardind, cvx, null, version, null, null, null, null);
    }

    public final DoImmediateWalletPaymentResponse doImmediateWalletPayment(Payment payment, Order order, Buyer buyer, PrivateDataList privateDataList, String walletId, String Cardind, String cvx, Authentication3DSecure auth3ds, String version, SubMerchant subMerchant, Recurring recurring, String linkedTransactionId) {
        return this.doImmediateWalletPayment(payment, order, buyer, privateDataList, walletId, Cardind, cvx, auth3ds, version, subMerchant, recurring, linkedTransactionId, null);
    }

    public final DoImmediateWalletPaymentResponse doImmediateWalletPayment(Payment payment, Order order, Buyer buyer, PrivateDataList privateDataList, String walletId, String Cardind, String cvx, Authentication3DSecure auth3ds, String version, SubMerchant subMerchant, Recurring recurring, String linkedTransactionId, String media) {
        this.setException(null);
        DoImmediateWalletPaymentResponse result = new DoImmediateWalletPaymentResponse();
        DoImmediateWalletPaymentRequest parameters = new DoImmediateWalletPaymentRequest();
        parameters.setOrder(order);
        parameters.setPayment(payment);
        parameters.setBuyer(buyer);
        parameters.setPrivateDataList(privateDataList);
        parameters.setWalletId(walletId);
        parameters.setCardInd(Cardind);
        parameters.setCvx(cvx);
        parameters.setAuthentication3DSecure(auth3ds);
        parameters.setVersion(version);
        parameters.setSubMerchant(subMerchant);
        parameters.setRecurring(recurring);
        parameters.setLinkedTransactionId(linkedTransactionId);
        parameters.setMedia(media);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doImmediateWalletPayment(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doImmediateWalletPayment call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoScheduledWalletPaymentResponse doScheduledWalletPayment(Payment payment, String date, String ref, String scheduledDate, String walletId, Order order, PrivateDataList privateDataList, String Cardind, String version, SubMerchant subMerchant, Recurring recurring, Authentication3DSecure authentication3dSecure, String linkedTransactionId) {
        this.setException(null);
        DoScheduledWalletPaymentResponse result = new DoScheduledWalletPaymentResponse();
        DoScheduledWalletPaymentRequest parameters = new DoScheduledWalletPaymentRequest();
        parameters.setOrderDate(date);
        parameters.setOrderRef(ref);
        parameters.setPayment(payment);
        parameters.setScheduledDate(scheduledDate);
        parameters.setWalletId(walletId);
        parameters.setOrder(order);
        parameters.setPrivateDataList(privateDataList);
        parameters.setCardInd(Cardind);
        parameters.setVersion(version);
        parameters.setSubMerchant(subMerchant);
        parameters.setRecurring(recurring);
        parameters.setAuthentication3DSecure(authentication3dSecure);
        parameters.setLinkedTransactionId(linkedTransactionId);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doScheduledWalletPayment(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doScheduledWalletPayment call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoRecurrentWalletPaymentResponse doRecurrentWalletPayment(Payment payment, Recurring recurring, String date, String ref, String walletId, Order order, PrivateDataList privateDataList, String Cardind, String version, String cvx, String linkedTransactionId, Authentication3DSecure authentication3DSecure) {
        return this.doRecurrentWalletPayment(payment, recurring, date, ref, walletId, order, privateDataList, Cardind, version, cvx, linkedTransactionId, authentication3DSecure, null);
    }

    public final DoRecurrentWalletPaymentResponse doRecurrentWalletPayment(Payment payment, Recurring recurring, String date, String ref, String walletId, Order order, PrivateDataList privateDataList, String Cardind, String version, String cvx, String linkedTransactionId, Authentication3DSecure authentication3DSecure, String media) {
        this.setException(null);
        DoRecurrentWalletPaymentResponse result = new DoRecurrentWalletPaymentResponse();
        DoRecurrentWalletPaymentRequest parameters = new DoRecurrentWalletPaymentRequest();
        parameters.setOrderDate(date);
        parameters.setOrderRef(ref);
        parameters.setPayment(payment);
        parameters.setRecurring(recurring);
        parameters.setOrder(order);
        parameters.setPrivateDataList(privateDataList);
        parameters.setCardInd(Cardind);
        parameters.setWalletId(walletId);
        parameters.setVersion(version);
        parameters.setCvx(cvx);
        parameters.setLinkedTransactionId(linkedTransactionId);
        parameters.setAuthentication3DSecure(authentication3DSecure);
        parameters.setMedia(media);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doRecurrentWalletPayment(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doRecurrentWalletPayment call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetPaymentRecordResponse getPaymentRecord(String contractNumber, String paymentRecordId, String version) {
        this.setException(null);
        GetPaymentRecordResponse result = new GetPaymentRecordResponse();
        GetPaymentRecordRequest parameters = new GetPaymentRecordRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setPaymentRecordId(paymentRecordId);
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getPaymentRecord(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getPaymentRecord call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final UpdatePaymentRecordResponse updatePaymentRecord(String version, String contractNumber, String paymentRecordId, RecurringForUpdate recurring) {
        UpdatePaymentRecordResponse result = new UpdatePaymentRecordResponse();
        UpdatePaymentRecordRequest parameters = new UpdatePaymentRecordRequest();
        parameters.setVersion(version);
        parameters.setContractNumber(contractNumber);
        parameters.setPaymentRecordId(paymentRecordId);
        parameters.setRecurring(recurring);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.updatePaymentRecord(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during updatePaymentRecord call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DisablePaymentRecordResponse disablePaymentRecord(String contractNumber, String recordId) {
        this.setException(null);
        DisablePaymentRecordResponse result = new DisablePaymentRecordResponse();
        DisablePaymentRecordRequest parameters = new DisablePaymentRecordRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setPaymentRecordId(recordId);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.disablePaymentRecord(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during disablePaymentRecord call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetBillingRecordResponse getBillingRecord(String contractNumber, String paymentRecordId, String billingRecordId) {
        GetBillingRecordResponse result = new GetBillingRecordResponse();
        GetBillingRecordRequest parameters = new GetBillingRecordRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setPaymentRecordId(paymentRecordId);
        parameters.setBillingRecordId(billingRecordId);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getBillingRecord(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getBillingRecord call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final UpdateBillingRecordResponse updateBillingRecord(String contractNumber, String paymentRecordId, String billingRecordId, BillingRecordForUpdate billingRecord) {
        UpdateBillingRecordResponse result = new UpdateBillingRecordResponse();
        UpdateBillingRecordRequest parameters = new UpdateBillingRecordRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setPaymentRecordId(paymentRecordId);
        parameters.setBillingRecordId(billingRecordId);
        parameters.setBillingRecordForUpdate(billingRecord);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.updateBillingRecord(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during updateBillingRecord call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final CreateWebWalletResponse createWebWallet(Buyer buyer, PrivateDataList privateDataList, String notificationURL, String returnURL, String cancelURL, String languageCode, String securityMode, String customPaymentPageCode, String customPaymentTemplateURL, SelectedContractList selectedContractList, String updatePersonalDetails, String version) {
        return this.createWebWallet(buyer, privateDataList, notificationURL, returnURL, cancelURL, languageCode, securityMode, customPaymentPageCode, customPaymentTemplateURL, selectedContractList, updatePersonalDetails, version, null, null, null);
    }

    public final CreateWebWalletResponse createWebWallet(Buyer buyer, PrivateDataList privateDataList, String notificationURL, String returnURL, String cancelURL, String languageCode, String securityMode, String customPaymentPageCode, String customPaymentTemplateURL, SelectedContractList selectedContractList, String updatePersonalDetails, String version, String contractNumber, Owner owner, ContractNumberWalletList contractNumberWalletList) {
        this.setException(null);
        CreateWebWalletResponse result = new CreateWebWalletResponse();
        if (returnURL.length() <= 0) {
            returnURL = PaylineProperties.getString("RETURN_URL");
        }
        if (cancelURL.length() <= 0) {
            cancelURL = PaylineProperties.getString("CANCEL_URL");
        }
        if (notificationURL.length() <= 0) {
            notificationURL = PaylineProperties.getString("NOTIFICATION_URL");
        }
        CreateWebWalletRequest parameters = new CreateWebWalletRequest();
        parameters.setBuyer(buyer);
        parameters.setCancelURL(cancelURL);
        if (contractNumber != null) {
            parameters.setContractNumber(contractNumber);
        } else if (parameters.getContractNumber() == null || parameters.getContractNumber().length() == 0) {
            parameters.setContractNumber(PaylineProperties.getString("CONTRACT_NUMBER"));
        }
        parameters.setCustomPaymentPageCode(customPaymentPageCode);
        parameters.setCustomPaymentTemplateURL(customPaymentTemplateURL);
        parameters.setLanguageCode(languageCode);
        parameters.setNotificationURL(notificationURL);
        parameters.setPrivateDataList(privateDataList);
        parameters.setReturnURL(returnURL);
        parameters.setSecurityMode(securityMode);
        parameters.setSelectedContractList(selectedContractList);
        parameters.setUpdatePersonalDetails(updatePersonalDetails);
        parameters.setVersion(version);
        parameters.setContractNumber(contractNumber);
        parameters.setOwner(owner);
        parameters.setContractNumberWalletList(contractNumberWalletList);
        try {
            WebPaymentAPI port = this.initFromFile ? Utils.initServiceWeb() : Utils.initServiceWeb(this.connectParams);
            result = port.createWebWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during createWebWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final UpdateWebWalletResponse updateWebWallet(String walletId, PrivateDataList privateDataList, String notificationURL, String returnURL, String cancelURL, String languageCode, String securityMode, String customPaymentPageCode, String customPaymentTemplateURL, SelectedContractList selectedContractList, String updatePersonalDetails, String updatePaymentDetails, Buyer buyer, String Cardind, String version) {
        return this.updateWebWallet(walletId, privateDataList, notificationURL, returnURL, cancelURL, languageCode, securityMode, customPaymentPageCode, customPaymentTemplateURL, selectedContractList, updatePersonalDetails, updatePaymentDetails, buyer, Cardind, version, null, null, null);
    }

    public final UpdateWebWalletResponse updateWebWallet(String walletId, PrivateDataList privateDataList, String notificationURL, String returnURL, String cancelURL, String languageCode, String securityMode, String customPaymentPageCode, String customPaymentTemplateURL, SelectedContractList selectedContractList, String updatePersonalDetails, String updatePaymentDetails, Buyer buyer, String Cardind, String version, String updateOwnerDetails, ContractNumberWalletList contractNumberWalletList, String contractNumber) {
        this.setException(null);
        UpdateWebWalletResponse result = new UpdateWebWalletResponse();
        UpdateWebWalletRequest parameters = new UpdateWebWalletRequest();
        parameters.setWalletId(walletId);
        parameters.setCancelURL(cancelURL);
        if (contractNumber != null) {
            parameters.setContractNumber(contractNumber);
        } else if (parameters.getContractNumber() == null || parameters.getContractNumber().length() == 0) {
            parameters.setContractNumber(PaylineProperties.getString("CONTRACT_NUMBER"));
        }
        parameters.setCustomPaymentPageCode(customPaymentPageCode);
        parameters.setCustomPaymentTemplateURL(customPaymentTemplateURL);
        parameters.setLanguageCode(languageCode);
        parameters.setNotificationURL(notificationURL);
        parameters.setPrivateDataList(privateDataList);
        parameters.setReturnURL(returnURL);
        parameters.setSecurityMode(securityMode);
        parameters.setUpdatePersonalDetails(updatePersonalDetails);
        parameters.setUpdatePaymentDetails(updatePaymentDetails);
        parameters.setCardInd(Cardind);
        parameters.setBuyer(buyer);
        parameters.setVersion(version);
        parameters.setUpdateOwnerDetails(updateOwnerDetails);
        parameters.setContractNumberWalletList(contractNumberWalletList);
        try {
            WebPaymentAPI port = this.initFromFile ? Utils.initServiceWeb() : Utils.initServiceWeb(this.connectParams);
            result = port.updateWebWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during updateWebWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final ManageWebWalletResponse manageWebWallet(String version, String contractNumber, SelectedContractList selectedContractList, String updatePersonalDetails, Buyer buyer, Owner owner, String languageCode, String customPaymentPageCode, String securityMode, String returnURL, String cancelURL, String notificationURL, PrivateDataList privateDataList, String customPaymentTemplateURL, ContractNumberWalletList contractNumberWalletList, String merchantName) {
        return this.manageWebWallet(version, contractNumber, selectedContractList, updatePersonalDetails, buyer, owner, languageCode, customPaymentPageCode, securityMode, returnURL, cancelURL, notificationURL, privateDataList, customPaymentTemplateURL, contractNumberWalletList, merchantName, null);
    }

    public final ManageWebWalletResponse manageWebWallet(String version, String contractNumber, SelectedContractList selectedContractList, String updatePersonalDetails, Buyer buyer, Owner owner, String languageCode, String customPaymentPageCode, String securityMode, String returnURL, String cancelURL, String notificationURL, PrivateDataList privateDataList, String customPaymentTemplateURL, ContractNumberWalletList contractNumberWalletList, String merchantName, ThreeDSInfo threeDSInfo) {
        this.setException(null);
        ManageWebWalletResponse result = new ManageWebWalletResponse();
        ManageWebWalletRequest parameters = new ManageWebWalletRequest();
        parameters.setVersion(version);
        parameters.setContractNumber(contractNumber);
        parameters.setSelectedContractList(selectedContractList);
        parameters.setUpdatePersonalDetails(updatePersonalDetails);
        parameters.setBuyer(buyer);
        parameters.setOwner(owner);
        parameters.setLanguageCode(languageCode);
        parameters.setCustomPaymentPageCode(customPaymentPageCode);
        parameters.setSecurityMode(securityMode);
        parameters.setReturnURL(returnURL);
        parameters.setCancelURL(cancelURL);
        parameters.setNotificationURL(notificationURL);
        parameters.setPrivateDataList(privateDataList);
        parameters.setCustomPaymentTemplateURL(customPaymentTemplateURL);
        parameters.setContractNumberWalletList(contractNumberWalletList);
        parameters.setMerchantName(merchantName);
        parameters.setThreeDSInfo(threeDSInfo);
        try {
            WebPaymentAPI port = this.initFromFile ? Utils.initServiceWeb() : Utils.initServiceWeb(this.connectParams);
            result = port.manageWebWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during manageWebWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetWebWalletResponse getWebWallet(String token, String version) {
        this.setException(null);
        GetWebWalletResponse result = new GetWebWalletResponse();
        GetWebWalletRequest parameters = new GetWebWalletRequest();
        parameters.setToken(token);
        parameters.setVersion(version);
        try {
            WebPaymentAPI port = this.initFromFile ? Utils.initServiceWeb() : Utils.initServiceWeb(this.connectParams);
            result = port.getWebWallet(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getWebWallet call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetCardsResponse getCards(String contractNumber, String walletId, String cardInd, String version) {
        this.setException(null);
        GetCardsResponse result = new GetCardsResponse();
        GetCardsRequest parameters = new GetCardsRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setWalletId(walletId);
        parameters.setCardInd(cardInd);
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getCards(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getCards call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }
}

