/*
 * Decompiled with CFR 0.152.
 */
package com.payline.kit.utils;

import com.payline.kit.utils.ConnectParams;
import com.payline.kit.utils.PaylineProperties;
import com.payline.ws.model.DirectPaymentAPI;
import com.payline.ws.model.DirectPaymentAPI_Service;
import com.payline.ws.model.ExtendedAPI;
import com.payline.ws.model.ExtendedAPI_Service;
import com.payline.ws.model.WebPaymentAPI;
import com.payline.ws.model.WebPaymentAPI_Service;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.commons.codec.binary.Base64;

public final class Utils {
    public static final String HOMO_ENDPOINT = "https://homologation.payline.com/V4/services/";
    public static final String HOMO_ENDPOINT_CC = "https://homologation-cc.payline.com/V4/services/";
    public static final String PROD_ENDPOINT = "https://services.payline.com/V4/services/";
    public static final String PROD_ENDPOINT_CC = "https://services-cc.payline.com/V4/services/";
    public static final String HOMO_GETTOKEN_SERVLET_URL = "https://homologation-webpayment.payline.com/webpayment/getToken";
    public static final String PROD_GETTOKEN_SERVLET_URL = "https://webpayment.payline.com/webpayment/getToken";
    public static final String WEB_PAYMENT_API = "WebPaymentAPI";
    public static final String DIRECT_PAYMENT_API = "DirectPaymentAPI";
    public static final String EXTENDED_API = "ExtendedAPI";
    public static final String WSDL = "v4.44.1.wsdl";
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final Level LOG_LEVEL = Level.ALL;
    public static final String EXCEPTION_CODE = "XXXXX";
    public static final String kitVersion = "kit JAVA v4.44.1";
    static final String RETURN_LINE = "\n";
    static final String SEP_LINE = " - ";
    static final String SEP_PARAGRAPH = "----------";

    private Utils() {
    }

    private static String maskAccessKey(String accessKey) {
        String maskedAccessKey = new String("");
        if (accessKey != null && accessKey != "" && accessKey.length() > 0) {
            int keyLengh = accessKey.length();
            maskedAccessKey = accessKey.substring(0, 2);
            maskedAccessKey = maskedAccessKey + "********************".substring(0, keyLengh - 4);
            maskedAccessKey = maskedAccessKey + accessKey.substring(keyLengh - 2, keyLengh);
        }
        return maskedAccessKey;
    }

    public static void setHTTPBasicCredentialAndEndPointFromBundle(Object proxy, String api) {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "setting HTTPBasic Credentials And EndPoint from payline.properties file");
        }
        if (PaylineProperties.getString("USE_PROXY") != null && PaylineProperties.getString("USE_PROXY").equals("1")) {
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", PaylineProperties.getString("PROXY_HOST"));
            System.setProperty("http.proxyPort", PaylineProperties.getString("PROXY_PORT"));
            System.setProperty("https.proxySet", "true");
            System.setProperty("https.proxyHost", PaylineProperties.getString("PROXY_HOST"));
            System.setProperty("https.proxyPort", PaylineProperties.getString("PROXY_PORT"));
            if (PaylineProperties.getString("PROXY_LOGIN") != null && PaylineProperties.getString("PROXY_LOGIN").length() != 0) {
                System.setProperty("https.proxyLogin", PaylineProperties.getString("PROXY_LOGIN"));
                System.setProperty("http.proxyLogin", PaylineProperties.getString("PROXY_LOGIN"));
            }
            if (PaylineProperties.getString("PROXY_PWD") != null && PaylineProperties.getString("PROXY_PWD").length() != 0) {
                System.setProperty("https.proxyPassword", PaylineProperties.getString("PROXY_PWD"));
                System.setProperty("http.proxyPassword", PaylineProperties.getString("PROXY_PWD"));
            }
        } else {
            System.setProperty("http.proxySet", "false");
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("http.proxyLogin");
            System.clearProperty("http.proxyPassword");
            System.setProperty("https.proxySet", "false");
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            System.clearProperty("https.proxyLogin");
            System.clearProperty("https.proxyPassword");
        }
        ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.security.auth.username", PaylineProperties.getString("MERCHANT_ID"));
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "user name is : " + PaylineProperties.getString("MERCHANT_ID"));
        }
        ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.security.auth.password", PaylineProperties.getString("ACCES_KEY"));
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "password is : " + Utils.maskAccessKey(PaylineProperties.getString("ACCES_KEY")));
        }
        String endpoint = null;
        String prod = PaylineProperties.getString("PRODUCTION");
        endpoint = prod.equalsIgnoreCase("true") ? PROD_ENDPOINT : HOMO_ENDPOINT;
        endpoint = endpoint + api;
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "endpoint is : " + endpoint);
        }
        if (endpoint != null) {
            ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        }
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("version", Collections.singletonList(kitVersion));
        Map reqContext = ((BindingProvider)proxy).getRequestContext();
        reqContext.put("javax.xml.ws.http.request.headers", httpHeaders);
    }

    public static void setHTTPBasicCredentialAndEndPointFromParams(Object proxy, String api, ConnectParams params) {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "setting HTTPBasic Credentials And EndPoint from function parameters");
        }
        if (params.getProxyHost() != null) {
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", params.getProxyHost());
            System.setProperty("http.proxyPort", params.getProxyPort());
            System.setProperty("https.proxySet", "true");
            System.setProperty("https.proxyHost", params.getProxyHost());
            System.setProperty("https.proxyPort", params.getProxyPort());
            if (params.getProxyLogin() != null) {
                System.setProperty("https.proxyLogin", params.getProxyLogin());
                System.setProperty("http.proxyLogin", params.getProxyLogin());
            }
            if (params.getProxyPassword() != null) {
                System.setProperty("https.proxyPassword", params.getProxyPassword());
                System.setProperty("http.proxyPassword", params.getProxyPassword());
            }
        } else {
            System.setProperty("http.proxySet", "false");
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("http.proxyLogin");
            System.clearProperty("http.proxyPassword");
            System.setProperty("https.proxySet", "false");
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            System.clearProperty("https.proxyLogin");
            System.clearProperty("https.proxyPassword");
        }
        String endpoint = null;
        if (params.isClientAuthentication()) {
            endpoint = params.isProduction() ? PROD_ENDPOINT_CC : HOMO_ENDPOINT_CC;
        } else {
            ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.security.auth.username", params.getMerchantId());
            if (LOG_LEVEL != Level.OFF) {
                logger.log(LOG_LEVEL, "user name is : " + params.getMerchantId());
            }
            ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.security.auth.password", params.getAccessKey());
            if (LOG_LEVEL != Level.OFF) {
                logger.log(LOG_LEVEL, "password is : " + Utils.maskAccessKey(params.getAccessKey()));
            }
            endpoint = params.isProduction() ? PROD_ENDPOINT : HOMO_ENDPOINT;
        }
        endpoint = endpoint + api;
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "endpoint is : " + endpoint);
        }
        ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        String headerVersion = null;
        headerVersion = params.getModule() != null ? params.getModule() : kitVersion;
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("version", Collections.singletonList(headerVersion));
        Map reqContext = ((BindingProvider)proxy).getRequestContext();
        reqContext.put("javax.xml.ws.http.request.headers", httpHeaders);
    }

    public static WebPaymentAPI initServiceWeb() {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "Initiating WebPayment Services from payline.properties file");
        }
        URL url = Utils.class.getClassLoader().getResource(WSDL);
        WebPaymentAPI_Service service = new WebPaymentAPI_Service(url, new QName("http://impl.ws.payline.experian.com", WEB_PAYMENT_API));
        WebPaymentAPI port = service.getWebPaymentAPI();
        Utils.setHTTPBasicCredentialAndEndPointFromBundle(port, WEB_PAYMENT_API);
        return port;
    }

    public static WebPaymentAPI initServiceWeb(ConnectParams params) {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "Initiating WebPayment Services from function parameters");
        }
        URL url = Utils.class.getClassLoader().getResource(WSDL);
        WebPaymentAPI_Service service = new WebPaymentAPI_Service(url, new QName("http://impl.ws.payline.experian.com", WEB_PAYMENT_API));
        WebPaymentAPI port = service.getWebPaymentAPI();
        Utils.setHTTPBasicCredentialAndEndPointFromParams(port, WEB_PAYMENT_API, params);
        return port;
    }

    public static DirectPaymentAPI initServiceDirect() {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "Initiating Direct Services from payline.properties file");
        }
        URL url = Utils.class.getClassLoader().getResource(WSDL);
        DirectPaymentAPI_Service service = new DirectPaymentAPI_Service(url, new QName("http://impl.ws.payline.experian.com", DIRECT_PAYMENT_API));
        DirectPaymentAPI port = service.getDirectPaymentAPI();
        Utils.setHTTPBasicCredentialAndEndPointFromBundle(port, DIRECT_PAYMENT_API);
        return port;
    }

    public static DirectPaymentAPI initServiceDirect(ConnectParams params) {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "Initiating Direct Services from function parameters");
        }
        URL url = Utils.class.getClassLoader().getResource(WSDL);
        DirectPaymentAPI_Service service = new DirectPaymentAPI_Service(url, new QName("http://impl.ws.payline.experian.com", DIRECT_PAYMENT_API));
        DirectPaymentAPI port = service.getDirectPaymentAPI();
        Utils.setHTTPBasicCredentialAndEndPointFromParams(port, DIRECT_PAYMENT_API, params);
        return port;
    }

    public static ExtendedAPI initServiceExtended() {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "Initiating Extended Services from payline.properties file");
        }
        URL url = Utils.class.getClassLoader().getResource(WSDL);
        ExtendedAPI_Service service = new ExtendedAPI_Service(url, new QName("http://impl.ws.payline.experian.com", EXTENDED_API));
        ExtendedAPI port = service.getExtendedAPI();
        Utils.setHTTPBasicCredentialAndEndPointFromBundle(port, EXTENDED_API);
        return port;
    }

    public static ExtendedAPI initServiceExtended(ConnectParams params) {
        if (LOG_LEVEL != Level.OFF) {
            logger.log(LOG_LEVEL, "Initiating Extended Services from function parameters");
        }
        URL url = Utils.class.getClassLoader().getResource(WSDL);
        ExtendedAPI_Service service = new ExtendedAPI_Service(url, new QName("http://impl.ws.payline.experian.com", EXTENDED_API));
        ExtendedAPI port = service.getExtendedAPI();
        Utils.setHTTPBasicCredentialAndEndPointFromParams(port, EXTENDED_API, params);
        return port;
    }

    public static String encrypt(String merchantId, String orderRef, String contractNumber, String accessKey) {
        String crypted;
        String sep = ";";
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            byte[] aes256Key = sha.digest(accessKey.getBytes("UTF-8"));
            byte[] msgUtf8 = merchantId.concat(sep).concat(orderRef).concat(sep).concat(contractNumber).getBytes("UTF-8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(aes256Key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            byte[] ciphered = cipher.doFinal(msgUtf8);
            crypted = new String(Base64.encodeBase64URLSafeString((byte[])ciphered));
        }
        catch (Exception e) {
            crypted = e.toString();
            e.printStackTrace();
        }
        return crypted;
    }

    public static final byte[] decrypt(String accessKey, String encrypt) {
        byte[] finalDecrypt = new byte[]{};
        try {
            byte[] accessKeyBytes = accessKey.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            accessKeyBytes = sha.digest(accessKeyBytes);
            SecretKeySpec secretKeySpec = new SecretKeySpec(accessKeyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            finalDecrypt = cipher.doFinal(Base64.decodeBase64((byte[])encrypt.getBytes("UTF-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalDecrypt;
    }

    public static String gzipDecompress(byte[] decrypt) {
        String outStr = "";
        try {
            String line;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(decrypt));
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
            while ((line = bf.readLine()) != null) {
                outStr = outStr + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(LOG_LEVEL, "Erreur lors de la d\u00e9compression");
        }
        return outStr;
    }
}

