/*
 * Decompiled with CFR 0.152.
 */
package com.pavelsikun.seekbarpreference;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.pavelsikun.seekbarpreference.PersistValueListener;
import com.pavelsikun.seekbarpreference.R;

class CustomValueDialog {
    private final String TAG = this.getClass().getSimpleName();
    private Dialog dialog;
    private EditText customValueView;
    private int minValue;
    private int maxValue;
    private int currentValue;
    private PersistValueListener persistValueListener;

    CustomValueDialog(Context context, int theme, int minValue, int maxValue, int currentValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.currentValue = currentValue;
        this.init(new AlertDialog.Builder(context, theme));
    }

    private void init(AlertDialog.Builder dialogBuilder) {
        View dialogView = LayoutInflater.from((Context)dialogBuilder.getContext()).inflate(R.layout.value_selector_dialog, null);
        this.dialog = dialogBuilder.setView(dialogView).create();
        TextView minValueView = (TextView)dialogView.findViewById(R.id.minValue);
        TextView maxValueView = (TextView)dialogView.findViewById(R.id.maxValue);
        this.customValueView = (EditText)dialogView.findViewById(R.id.customValue);
        minValueView.setText((CharSequence)String.valueOf(this.minValue));
        maxValueView.setText((CharSequence)String.valueOf(this.maxValue));
        this.customValueView.setHint((CharSequence)String.valueOf(this.currentValue));
        LinearLayout colorView = (LinearLayout)dialogView.findViewById(R.id.dialog_color_area);
        colorView.setBackgroundColor(this.fetchAccentColor(dialogBuilder.getContext()));
        Button applyButton = (Button)dialogView.findViewById(R.id.btn_apply);
        Button cancelButton = (Button)dialogView.findViewById(R.id.btn_cancel);
        applyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomValueDialog.this.tryApply();
            }
        });
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomValueDialog.this.dialog.dismiss();
            }
        });
    }

    private int fetchAccentColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorAccent});
        int color = a.getColor(0, 0);
        a.recycle();
        return color;
    }

    CustomValueDialog setPersistValueListener(PersistValueListener listener) {
        this.persistValueListener = listener;
        return this;
    }

    void show() {
        this.dialog.show();
    }

    private void tryApply() {
        int value;
        try {
            value = Integer.parseInt(this.customValueView.getText().toString());
            if (value > this.maxValue) {
                Log.e((String)this.TAG, (String)("wrong input( > than required): " + this.customValueView.getText().toString()));
                this.notifyWrongInput();
                return;
            }
            if (value < this.minValue) {
                Log.e((String)this.TAG, (String)("wrong input( < then required): " + this.customValueView.getText().toString()));
                this.notifyWrongInput();
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("worng input(non-integer): " + this.customValueView.getText().toString()));
            this.notifyWrongInput();
            return;
        }
        if (this.persistValueListener != null) {
            this.persistValueListener.persistInt(value);
            this.dialog.dismiss();
        }
    }

    private void notifyWrongInput() {
        this.customValueView.setText((CharSequence)"");
        this.customValueView.setHint((CharSequence)"Wrong Input!");
    }
}

