/*
 * Decompiled with CFR 0.152.
 */
package com.pavelsikun.seekbarpreference;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.preference.Preference;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.TextView;
import com.pavelsikun.seekbarpreference.R;

public class SeekBarPreference
extends Preference
implements SeekBar.OnSeekBarChangeListener,
TextWatcher {
    private final String TAG = ((Object)((Object)this)).getClass().getName();
    private static final int DEFAULT_CURRENT_VALUE = 50;
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final int DEFAULT_INTERVAL = 1;
    private static final String DEFAULT_MEASUREMENT_UNIT = "";
    private int mMaxValue = 100;
    private int mMinValue = 0;
    private int mInterval = 1;
    private int mCurrentValue;
    private String mMeasurementUnitValue;
    private SeekBar mSeekBar;
    private EditText mSeekBarValue;

    public SeekBarPreference(Context context) {
        super(context);
        this.setValuesFromXml(null);
        this.setLayoutResource(R.layout.seekbar_preference);
    }

    public SeekBarPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setValuesFromXml(attrs);
        this.setLayoutResource(R.layout.seekbar_preference);
    }

    public SeekBarPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setValuesFromXml(attrs);
        this.setLayoutResource(R.layout.seekbar_preference);
    }

    @TargetApi(value=21)
    public SeekBarPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setValuesFromXml(attrs);
        this.setLayoutResource(R.layout.seekbar_preference);
    }

    private void setValuesFromXml(AttributeSet attrs) {
        if (attrs == null) {
            this.mCurrentValue = 50;
            this.mMinValue = 0;
            this.mMaxValue = 100;
            this.mInterval = 1;
            this.mMeasurementUnitValue = DEFAULT_MEASUREMENT_UNIT;
        } else {
            this.mCurrentValue = attrs.getAttributeIntValue(16843245, 50);
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SeekBarPreference);
            try {
                this.mMinValue = a.getInt(R.styleable.SeekBarPreference_minValue, 0);
                this.mMaxValue = a.getInt(R.styleable.SeekBarPreference_maxValue, 100);
                this.mInterval = a.getInt(R.styleable.SeekBarPreference_interval, 1);
                this.mMeasurementUnitValue = a.getString(R.styleable.SeekBarPreference_measurementUnit);
                if (this.mMeasurementUnitValue == null) {
                    this.mMeasurementUnitValue = DEFAULT_MEASUREMENT_UNIT;
                }
            }
            finally {
                a.recycle();
            }
        }
    }

    public void onBindView(@NonNull View view) {
        super.onBindView(view);
        this.mSeekBar = (SeekBar)view.findViewById(R.id.seekbar);
        this.mSeekBar.setMax(this.mMaxValue - this.mMinValue);
        this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mSeekBarValue = (EditText)view.findViewById(R.id.seekbar_value);
        this.mSeekBarValue.setText((CharSequence)String.valueOf(this.mCurrentValue));
        this.mSeekBarValue.addTextChangedListener((TextWatcher)this);
        TextView mMeasurementUnit = (TextView)view.findViewById(R.id.measurement_unit);
        mMeasurementUnit.setText((CharSequence)this.mMeasurementUnitValue);
        this.mSeekBar.setProgress(this.mCurrentValue - this.mMinValue);
        this.setSeekBarTintOnPreLollipop();
        if (!view.isEnabled()) {
            this.mSeekBar.setEnabled(false);
            this.mSeekBarValue.setEnabled(false);
        }
    }

    static int pxFromDp(int dp, Context context) {
        return (int)((float)dp * context.getResources().getDisplayMetrics().density);
    }

    void setSeekBarTintOnPreLollipop() {
        if (Build.VERSION.SDK_INT < 21) {
            Resources.Theme theme = this.getContext().getTheme();
            int attr2 = R.attr.colorAccent;
            int fallbackColor = Color.parseColor((String)"#009688");
            int accent = theme.obtainStyledAttributes(new int[]{attr2}).getColor(0, fallbackColor);
            ShapeDrawable thumb = new ShapeDrawable((Shape)new OvalShape());
            thumb.setIntrinsicHeight(SeekBarPreference.pxFromDp(15, this.getContext()));
            thumb.setIntrinsicWidth(SeekBarPreference.pxFromDp(15, this.getContext()));
            thumb.setColorFilter((ColorFilter)new PorterDuffColorFilter(accent, PorterDuff.Mode.SRC_ATOP));
            this.mSeekBar.setThumb((Drawable)thumb);
            Drawable progress = this.mSeekBar.getProgressDrawable();
            progress.setColorFilter((ColorFilter)new PorterDuffColorFilter(accent, PorterDuff.Mode.MULTIPLY));
            this.mSeekBar.setProgressDrawable(progress);
        }
    }

    protected Object onGetDefaultValue(@NonNull TypedArray ta, int index) {
        return ta.getInt(index, this.mCurrentValue);
    }

    protected void onSetInitialValue(boolean restoreValue, @NonNull Object defaultValue) {
        if (restoreValue) {
            this.mCurrentValue = this.getPersistedInt(this.mCurrentValue);
        } else {
            int temp = 0;
            try {
                temp = (Integer)defaultValue;
            }
            catch (Exception ex) {
                Log.e((String)this.TAG, (String)("Invalid default value: " + defaultValue.toString()));
            }
            this.persistInt(temp);
            this.mCurrentValue = temp;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mSeekBar != null) {
            this.mSeekBar.setEnabled(enabled);
        }
        if (this.mSeekBarValue != null) {
            this.mSeekBarValue.setEnabled(enabled);
        }
    }

    public boolean setValue(int value) {
        boolean isSuccess = super.persistInt(value);
        this.notifyChanged();
        return isSuccess;
    }

    public int getValue() {
        return this.mCurrentValue;
    }

    public void onDependencyChanged(Preference dependency, boolean disableDependent) {
        super.onDependencyChanged(dependency, disableDependent);
        if (this.mSeekBar != null) {
            this.mSeekBar.setEnabled(!disableDependent);
        }
        if (this.mSeekBarValue != null) {
            this.mSeekBarValue.setEnabled(!disableDependent);
        }
    }

    public void onProgressChanged(@NonNull SeekBar seekBar, int progress, boolean fromUser) {
        int newValue = progress + this.mMinValue;
        if (newValue > this.mMaxValue) {
            newValue = this.mMaxValue;
        } else if (newValue < this.mMinValue) {
            newValue = this.mMinValue;
        } else if (this.mInterval != 1 && newValue % this.mInterval != 0) {
            newValue = Math.round((float)newValue / (float)this.mInterval) * this.mInterval;
        }
        if (!this.callChangeListener(newValue)) {
            seekBar.setProgress(this.mCurrentValue - this.mMinValue);
            return;
        }
        this.mCurrentValue = newValue;
        this.mSeekBarValue.setText((CharSequence)String.valueOf(newValue));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.mSeekBarValue.removeTextChangedListener((TextWatcher)this);
    }

    public void onStopTrackingTouch(@NonNull SeekBar seekBar) {
        this.notifyChanged();
        this.persistInt(this.mCurrentValue);
        this.mSeekBarValue.addTextChangedListener((TextWatcher)this);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.mSeekBar.setOnSeekBarChangeListener(null);
    }

    public void onTextChanged(@NonNull CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        int value = this.mMinValue;
        try {
            value = Integer.parseInt(s.toString());
            if (value > this.mMaxValue) {
                value = this.mMaxValue;
            } else if (value < this.mMinValue) {
                value = this.mMinValue;
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("non-integer data: " + s.toString()));
        }
        this.mCurrentValue = value;
        this.setValue(this.mCurrentValue);
        this.mSeekBar.setProgress(this.mCurrentValue - this.mMinValue);
        this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
    }
}

