/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.formatter;

import com.patrykandpatrick.vico.core.chart.values.ChartValues;
import com.patrykandpatrick.vico.core.formatter.ValueFormatter;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/patrykandpatrick/vico/core/formatter/PercentageFormatValueFormatter;", "Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;", "()V", "pattern", "", "(Ljava/lang/String;)V", "decimalFormat", "Ljava/text/DecimalFormat;", "formatValue", "value", "", "chartValues", "Lcom/patrykandpatrick/vico/core/chart/values/ChartValues;", "Companion", "core_release"})
public class PercentageFormatValueFormatter
implements ValueFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DecimalFormat decimalFormat;
    @NotNull
    public static final String DEF_PATTERN = "#.##%;\u2212#.##%";

    public PercentageFormatValueFormatter(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.decimalFormat = new DecimalFormat(pattern);
    }

    public PercentageFormatValueFormatter() {
        this(DEF_PATTERN);
    }

    @Override
    @NotNull
    public String formatValue(float value, @NotNull ChartValues chartValues) {
        Intrinsics.checkNotNullParameter((Object)chartValues, (String)"chartValues");
        float percentage = value / chartValues.getMaxY();
        String string = this.decimalFormat.format(Float.valueOf(percentage));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/patrykandpatrick/vico/core/formatter/PercentageFormatValueFormatter$Companion;", "", "()V", "DEF_PATTERN", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

