/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.extension;

import android.graphics.RectF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u000b\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0005\u001a*\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r\u001a2\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005\u001a\u001a\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005\u001a2\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u001a2\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u00a8\u0006\u0018"}, d2={"clear", "", "Landroid/graphics/RectF;", "copy", "getEnd", "", "isLtr", "", "getStart", "rotate", "degrees", "set", "left", "", "top", "right", "bottom", "setAndRotate", "rotationDegrees", "translate", "x", "y", "updateBounds", "updateBy", "core_release"})
@SourceDebugExtension(value={"SMAP\nRectExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectExtensions.kt\ncom/patrykandpatrick/vico/core/extension/RectExtensionsKt\n+ 2 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n*L\n1#1,146:1\n105#2:147\n63#2:148\n63#2:149\n63#2:150\n63#2:151\n69#2:152\n69#2:153\n69#2:154\n69#2:155\n*S KotlinDebug\n*F\n+ 1 RectExtensions.kt\ncom/patrykandpatrick/vico/core/extension/RectExtensionsKt\n*L\n97#1:147\n100#1:148\n101#1:149\n102#1:150\n103#1:151\n116#1:152\n117#1:153\n118#1:154\n119#1:155\n*E\n"})
public final class RectExtensionsKt {
    public static final void updateBounds(@NotNull RectF $this$updateBounds, float left, float top, float right, float bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$updateBounds, (String)"<this>");
        $this$updateBounds.set(left, top, right, bottom);
    }

    public static /* synthetic */ void updateBounds$default(RectF rectF, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = rectF.left;
        }
        if ((n & 2) != 0) {
            f2 = rectF.top;
        }
        if ((n & 4) != 0) {
            f3 = rectF.right;
        }
        if ((n & 8) != 0) {
            f4 = rectF.bottom;
        }
        RectExtensionsKt.updateBounds(rectF, f, f2, f3, f4);
    }

    public static final void updateBy(@NotNull RectF $this$updateBy, float left, float top, float right, float bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$updateBy, (String)"<this>");
        RectExtensionsKt.set($this$updateBy, Float.valueOf($this$updateBy.left + left), Float.valueOf($this$updateBy.top + top), Float.valueOf($this$updateBy.right + right), Float.valueOf($this$updateBy.bottom + bottom));
    }

    public static /* synthetic */ void updateBy$default(RectF rectF, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        RectExtensionsKt.updateBy(rectF, f, f2, f3, f4);
    }

    public static final void set(@NotNull RectF $this$set, @NotNull Number left, @NotNull Number top, @NotNull Number right, @NotNull Number bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)top, (String)"top");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)bottom, (String)"bottom");
        $this$set.set(left.floatValue(), top.floatValue(), right.floatValue(), bottom.floatValue());
    }

    public static final void clear(@NotNull RectF $this$clear) {
        Intrinsics.checkNotNullParameter((Object)$this$clear, (String)"<this>");
        RectExtensionsKt.set($this$clear, 0, 0, 0, 0);
    }

    @NotNull
    public static final RectF setAndRotate(@NotNull RectF $this$setAndRotate, @NotNull Number left, @NotNull Number top, @NotNull Number right, @NotNull Number bottom, float rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)$this$setAndRotate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)top, (String)"top");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)bottom, (String)"bottom");
        $this$setAndRotate.set(left.floatValue(), top.floatValue(), right.floatValue(), bottom.floatValue());
        return RectExtensionsKt.rotate($this$setAndRotate, rotationDegrees);
    }

    @NotNull
    public static final RectF copy(@NotNull RectF $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        return new RectF($this$copy);
    }

    @NotNull
    public static final RectF rotate(@NotNull RectF $this$rotate, float degrees) {
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        if (!(degrees % 180.0f == 0.0f)) {
            float $this$piRad$iv = 0.5f;
            boolean $i$f$getPiRad = false;
            if (degrees % ($this$piRad$iv * 180.0f) == 0.0f) {
                if (!($this$rotate.width() == $this$rotate.height())) {
                    float $this$half$iv = $this$rotate.height();
                    boolean $i$f$getHalf = false;
                    Number number = Float.valueOf($this$rotate.centerX() - $this$half$iv / (float)2);
                    $this$half$iv = $this$rotate.width();
                    $i$f$getHalf = false;
                    Number number2 = Float.valueOf($this$rotate.centerY() - $this$half$iv / (float)2);
                    $this$half$iv = $this$rotate.height();
                    $i$f$getHalf = false;
                    Number number3 = Float.valueOf($this$rotate.centerX() + $this$half$iv / (float)2);
                    $this$half$iv = $this$rotate.width();
                    $i$f$getHalf = false;
                    RectExtensionsKt.set($this$rotate, number, number2, number3, Float.valueOf($this$rotate.centerY() + $this$half$iv / (float)2));
                }
            } else {
                double alpha = Math.toRadians(degrees);
                double sinAlpha = Math.sin(alpha);
                double cosAlpha = Math.cos(alpha);
                double newWidth = Math.abs((double)$this$rotate.width() * cosAlpha) + Math.abs((double)$this$rotate.height() * sinAlpha);
                double newHeight = Math.abs((double)$this$rotate.width() * sinAlpha) + Math.abs((double)$this$rotate.height() * cosAlpha);
                double $this$half$iv = newWidth;
                boolean $i$f$getHalf = false;
                Number number = (double)$this$rotate.centerX() - $this$half$iv / (double)2;
                $this$half$iv = newHeight;
                $i$f$getHalf = false;
                Number number4 = (double)$this$rotate.centerY() - $this$half$iv / (double)2;
                $this$half$iv = newWidth;
                $i$f$getHalf = false;
                Number number5 = (double)$this$rotate.centerX() + $this$half$iv / (double)2;
                $this$half$iv = newHeight;
                $i$f$getHalf = false;
                RectExtensionsKt.set($this$rotate, number, number4, number5, (double)$this$rotate.centerY() + $this$half$iv / (double)2);
            }
        }
        return $this$rotate;
    }

    @NotNull
    public static final RectF translate(@NotNull RectF $this$translate, float x, float y) {
        RectF rectF;
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        RectF $this$translate_u24lambda_u240 = rectF = $this$translate;
        boolean bl = false;
        $this$translate_u24lambda_u240.left += x;
        $this$translate_u24lambda_u240.top += y;
        $this$translate_u24lambda_u240.right += x;
        $this$translate_u24lambda_u240.bottom += y;
        return rectF;
    }

    public static final float getStart(@NotNull RectF $this$getStart, boolean isLtr) {
        Intrinsics.checkNotNullParameter((Object)$this$getStart, (String)"<this>");
        return isLtr ? $this$getStart.left : $this$getStart.right;
    }

    public static final float getEnd(@NotNull RectF $this$getEnd, boolean isLtr) {
        Intrinsics.checkNotNullParameter((Object)$this$getEnd, (String)"<this>");
        return isLtr ? $this$getEnd.right : $this$getEnd.left;
    }
}

