/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.entry;

import com.patrykandpatrick.vico.core.entry.ChartEntry;
import com.patrykandpatrick.vico.core.entry.FloatEntry;
import com.patrykandpatrick.vico.core.extension.NumberExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u001a=\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2*\u0010\u0010\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00110\r\"\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0011\u00a2\u0006\u0002\u0010\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u0002*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003H\u0000\"+\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00038\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"+\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00038\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0018"}, d2={"xRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "", "Lcom/patrykandpatrick/vico/core/entry/ChartEntry;", "getXRange", "(Ljava/lang/Iterable;)Lkotlin/ranges/ClosedFloatingPointRange;", "yRange", "getYRange", "entriesOf", "", "Lcom/patrykandpatrick/vico/core/entry/FloatEntry;", "yValues", "", "", "([Ljava/lang/Number;)Ljava/util/List;", "pairs", "Lkotlin/Pair;", "([Lkotlin/Pair;)Ljava/util/List;", "entryOf", "x", "y", "calculateStackedYRange", "calculateXGcd", "core_release"})
@SourceDebugExtension(value={"SMAP\nChartEntryExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartEntryExtensions.kt\ncom/patrykandpatrick/vico/core/entry/ChartEntryExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 IterableExtensions.kt\ncom/patrykandpatrick/vico/core/extension/IterableExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n11065#2:117\n11400#2,3:118\n11155#2:121\n11266#2,4:122\n23#3,10:126\n23#3,10:136\n41#3,9:152\n1855#4,2:146\n1789#4,2:148\n1791#4:151\n1#5:150\n*S KotlinDebug\n*F\n+ 1 ChartEntryExtensions.kt\ncom/patrykandpatrick/vico/core/entry/ChartEntryExtensionsKt\n*L\n60#1:117\n60#1:118,3\n83#1:121\n83#1:122,4\n86#1:126,10\n89#1:136,10\n115#1:152,9\n93#1:146,2\n111#1:148,2\n111#1:151\n*E\n"})
public final class ChartEntryExtensionsKt {
    @NotNull
    public static final FloatEntry entryOf(float x, float y) {
        return new FloatEntry(x, y);
    }

    @NotNull
    public static final FloatEntry entryOf(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return ChartEntryExtensionsKt.entryOf(x.floatValue(), y.floatValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FloatEntry> entriesOf(Pair<? extends Number, ? extends Number> ... pairs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        Pair<? extends Number, ? extends Number>[] $this$map$iv = pairs;
        boolean $i$f$map = false;
        Pair<? extends Number, ? extends Number>[] pairArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Number x = (Number)var9_9.component1();
            Number y = (Number)var9_9.component2();
            collection.add(ChartEntryExtensionsKt.entryOf(x, y));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FloatEntry> entriesOf(Number ... yValues) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)yValues, (String)"yValues");
        Number[] $this$mapIndexed$iv = yValues;
        boolean $i$f$mapIndexed = false;
        Number[] numberArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void y;
            void index;
            int n = index$iv$iv++;
            void var10_10 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChartEntryExtensionsKt.entryOf((Number)((int)index), (Number)y));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ClosedFloatingPointRange<Float> getYRange(@NotNull Iterable<? extends Iterable<? extends ChartEntry>> $this$yRange) {
        ClosedFloatingPointRange closedFloatingPointRange;
        ClosedFloatingPointRange closedFloatingPointRange2;
        Intrinsics.checkNotNullParameter($this$yRange, (String)"<this>");
        boolean $i$f$getYRange = false;
        Iterable $this$rangeOfOrNull$iv = CollectionsKt.flatten($this$yRange);
        boolean $i$f$rangeOfOrNull = false;
        Iterator iterator$iv = $this$rangeOfOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            closedFloatingPointRange2 = null;
        } else {
            float minValue$iv;
            ChartEntry it = (ChartEntry)iterator$iv.next();
            boolean bl = false;
            float maxValue$iv = minValue$iv = it.getY();
            while (iterator$iv.hasNext()) {
                ChartEntry it2 = (ChartEntry)iterator$iv.next();
                $i$a$-rangeOfOrNull-ChartEntryExtensionsKt$yRange$1 = false;
                float v$iv = it2.getY();
                minValue$iv = Math.min(minValue$iv, v$iv);
                maxValue$iv = Math.max(maxValue$iv, v$iv);
            }
            closedFloatingPointRange2 = closedFloatingPointRange = RangesKt.rangeTo((float)minValue$iv, (float)maxValue$iv);
        }
        if (closedFloatingPointRange2 == null) {
            closedFloatingPointRange = RangesKt.rangeTo((float)0.0f, (float)0.0f);
        }
        return closedFloatingPointRange;
    }

    @NotNull
    public static final ClosedFloatingPointRange<Float> getXRange(@NotNull Iterable<? extends Iterable<? extends ChartEntry>> $this$xRange) {
        ClosedFloatingPointRange closedFloatingPointRange;
        ClosedFloatingPointRange closedFloatingPointRange2;
        Intrinsics.checkNotNullParameter($this$xRange, (String)"<this>");
        boolean $i$f$getXRange = false;
        Iterable $this$rangeOfOrNull$iv = CollectionsKt.flatten($this$xRange);
        boolean $i$f$rangeOfOrNull = false;
        Iterator iterator$iv = $this$rangeOfOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            closedFloatingPointRange2 = null;
        } else {
            float minValue$iv;
            ChartEntry it = (ChartEntry)iterator$iv.next();
            boolean bl = false;
            float maxValue$iv = minValue$iv = it.getX();
            while (iterator$iv.hasNext()) {
                ChartEntry it2 = (ChartEntry)iterator$iv.next();
                $i$a$-rangeOfOrNull-ChartEntryExtensionsKt$xRange$1 = false;
                float v$iv = it2.getX();
                minValue$iv = Math.min(minValue$iv, v$iv);
                maxValue$iv = Math.max(maxValue$iv, v$iv);
            }
            closedFloatingPointRange2 = closedFloatingPointRange = RangesKt.rangeTo((float)minValue$iv, (float)maxValue$iv);
        }
        if (closedFloatingPointRange2 == null) {
            closedFloatingPointRange = RangesKt.rangeTo((float)0.0f, (float)0.0f);
        }
        return closedFloatingPointRange;
    }

    public static final float calculateXGcd(@NotNull Iterable<? extends Iterable<? extends ChartEntry>> $this$calculateXGcd) {
        Intrinsics.checkNotNullParameter($this$calculateXGcd, (String)"<this>");
        Float gcd = null;
        Iterable<? extends Iterable<? extends ChartEntry>> $this$forEach$iv = $this$calculateXGcd;
        boolean $i$f$forEach = false;
        Iterator<? extends Iterable<? extends ChartEntry>> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Iterable<? extends ChartEntry> element$iv;
            Iterable<? extends ChartEntry> entryCollection = element$iv = iterator.next();
            boolean bl = false;
            Iterator<? extends ChartEntry> iterator2 = entryCollection.iterator();
            ChartEntry currentEntry = null;
            ChartEntry previousEntry = null;
            while (iterator2.hasNext()) {
                currentEntry = iterator2.next();
                if (previousEntry != null) {
                    ChartEntry prevEntry;
                    boolean bl2 = false;
                    float difference = Math.abs(currentEntry.getX() - prevEntry.getX());
                    Float f = gcd;
                    gcd = f != null ? Float.valueOf(NumberExtensionsKt.gcdWith(f.floatValue(), difference)) : Float.valueOf(difference);
                }
                previousEntry = currentEntry;
            }
            if (!Intrinsics.areEqual((Float)gcd, (float)-1.0f)) continue;
            gcd = Float.valueOf(1.0f);
        }
        Float f = gcd;
        return f != null ? f.floatValue() : 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ClosedFloatingPointRange<Float> calculateStackedYRange(@NotNull Iterable<? extends Iterable<? extends ChartEntry>> $this$calculateStackedYRange) {
        ClosedFloatingPointRange closedFloatingPointRange;
        ClosedFloatingPointRange closedFloatingPointRange2;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$calculateStackedYRange, (String)"<this>");
        Iterable iterable = CollectionsKt.flatten($this$calculateStackedYRange);
        HashMap initial$iv = new HashMap();
        boolean $i$f$fold = false;
        HashMap accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            ChartEntry chartEntry = (ChartEntry)element$iv;
            HashMap map = accumulator$iv;
            boolean bl = false;
            Map map2 = map;
            Object object = map2.get(Float.valueOf(entry.getX()));
            if (object == null) {
                boolean bl2 = false;
                object = TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            }
            Pair pair = (Pair)object;
            float negY = ((Number)pair.component1()).floatValue();
            float posY = ((Number)pair.component2()).floatValue();
            ((Map)map).put(Float.valueOf(entry.getX()), entry.getY() < 0.0f ? TuplesKt.to((Object)Float.valueOf(negY + entry.getY()), (Object)Float.valueOf(posY)) : TuplesKt.to((Object)Float.valueOf(negY), (Object)Float.valueOf(posY + entry.getY())));
            accumulator$iv = map;
        }
        Collection collection = accumulator$iv.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$rangeOfPairOrNull$iv = collection;
        boolean $i$f$rangeOfPairOrNull = false;
        Iterator iterator$iv = $this$rangeOfPairOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            closedFloatingPointRange2 = null;
        } else {
            Pair it = (Pair)iterator$iv.next();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Pair pair = it;
            float minValue$iv = ((Number)pair.component1()).floatValue();
            float maxValue$iv = ((Number)pair.component2()).floatValue();
            while (iterator$iv.hasNext()) {
                Pair it2 = (Pair)iterator$iv.next();
                $i$a$-rangeOfPairOrNull-ChartEntryExtensionsKt$calculateStackedYRange$2 = false;
                Intrinsics.checkNotNull((Object)it2);
                Pair pair2 = it2;
                float negValue$iv = ((Number)pair2.component1()).floatValue();
                float posValue$iv = ((Number)pair2.component2()).floatValue();
                minValue$iv = Math.min(minValue$iv, negValue$iv);
                maxValue$iv = Math.max(maxValue$iv, posValue$iv);
            }
            closedFloatingPointRange2 = closedFloatingPointRange = RangesKt.rangeTo((float)minValue$iv, (float)maxValue$iv);
        }
        if (closedFloatingPointRange2 == null) {
            closedFloatingPointRange = RangesKt.rangeTo((float)0.0f, (float)0.0f);
        }
        return closedFloatingPointRange;
    }
}

