/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.component.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import com.patrykandpatrick.vico.core.component.Component;
import com.patrykandpatrick.vico.core.component.dimension.Margins;
import com.patrykandpatrick.vico.core.component.dimension.Padding;
import com.patrykandpatrick.vico.core.component.text.HorizontalPosition;
import com.patrykandpatrick.vico.core.component.text.VerticalPosition;
import com.patrykandpatrick.vico.core.context.DrawContext;
import com.patrykandpatrick.vico.core.context.ExtrasExtensionsKt;
import com.patrykandpatrick.vico.core.context.MeasureContext;
import com.patrykandpatrick.vico.core.dimensions.MutableDimensions;
import com.patrykandpatrick.vico.core.dimensions.MutableDimensionsKt;
import com.patrykandpatrick.vico.core.extension.PaintExtensionsKt;
import com.patrykandpatrick.vico.core.extension.RectExtensionsKt;
import com.patrykandpatrick.vico.core.text.StaticLayoutExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001cB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003JX\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u0002042\u0006\u0010G\u001a\u0002042\b\b\u0002\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020\u000b2\b\b\u0002\u0010M\u001a\u00020\u000b2\b\b\u0002\u0010N\u001a\u000204J6\u0010O\u001a\u0002042\u0006\u0010B\u001a\u00020P2\b\b\u0002\u0010D\u001a\u00020E2\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\u000b2\b\b\u0002\u0010N\u001a\u000204JJ\u0010S\u001a\u00020(2\u0006\u0010B\u001a\u00020P2\b\b\u0002\u0010D\u001a\u00020E2\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\u000b2\b\b\u0002\u0010T\u001a\u00020(2\b\b\u0002\u0010U\u001a\u00020V2\b\b\u0002\u0010N\u001a\u000204J4\u0010W\u001a\u0002042\u0006\u0010B\u001a\u00020P2\u0006\u0010D\u001a\u00020E2\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\u000b2\b\b\u0002\u0010N\u001a\u000204J:\u0010X\u001a\u00020Y*\u00020P2\u0006\u0010D\u001a\u00020E2\u0006\u0010Z\u001a\u0002042\b\b\u0002\u0010Q\u001a\u00020\u000b2\b\b\u0002\u0010R\u001a\u00020\u000b2\b\b\u0002\u0010N\u001a\u000204H\u0002J\u0014\u0010[\u001a\u000204*\u00020P2\u0006\u0010\\\u001a\u000204H\u0002J\u001c\u0010]\u001a\u000204*\u00020P2\u0006\u0010\\\u001a\u0002042\u0006\u0010Q\u001a\u000204H\u0002J$\u0010^\u001a\u000204*\u00020I2\u0006\u0010B\u001a\u00020P2\u0006\u0010\\\u001a\u0002042\u0006\u0010Q\u001a\u000204H\u0002J)\u0010_\u001a\u000204*\u00020K2\u0006\u0010B\u001a\u00020P2\u0006\u0010G\u001a\u0002042\u0006\u0010`\u001a\u000204H\u0003\u00a2\u0006\u0002\baJ\u0014\u0010b\u001a\u000204*\u00020)2\u0006\u0010Q\u001a\u000204H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR+\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012*\u0004\b\r\u0010\u000eR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0012R\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010*\u001a\u00020)2\u0006\u0010\n\u001a\u00020)8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R/\u0010:\u001a\u0004\u0018\u0001092\b\u0010\n\u001a\u0004\u0018\u0001098F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?*\u0004\b;\u0010\u000e\u00a8\u0006d"}, d2={"Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "Lcom/patrykandpatrick/vico/core/component/dimension/Padding;", "Lcom/patrykandpatrick/vico/core/component/dimension/Margins;", "()V", "background", "Lcom/patrykandpatrick/vico/core/component/Component;", "getBackground", "()Lcom/patrykandpatrick/vico/core/component/Component;", "setBackground", "(Lcom/patrykandpatrick/vico/core/component/Component;)V", "<set-?>", "", "color", "getColor$delegate", "(Lcom/patrykandpatrick/vico/core/component/text/TextComponent;)Ljava/lang/Object;", "getColor", "()I", "setColor", "(I)V", "ellipsize", "Landroid/text/TextUtils$TruncateAt;", "getEllipsize", "()Landroid/text/TextUtils$TruncateAt;", "setEllipsize", "(Landroid/text/TextUtils$TruncateAt;)V", "layout", "Landroid/text/Layout;", "lineCount", "getLineCount", "setLineCount", "margins", "Lcom/patrykandpatrick/vico/core/dimensions/MutableDimensions;", "getMargins", "()Lcom/patrykandpatrick/vico/core/dimensions/MutableDimensions;", "setMargins", "(Lcom/patrykandpatrick/vico/core/dimensions/MutableDimensions;)V", "padding", "getPadding", "setPadding", "tempMeasureBounds", "Landroid/graphics/RectF;", "Landroid/graphics/Paint$Align;", "textAlign", "getTextAlign", "()Landroid/graphics/Paint$Align;", "setTextAlign", "(Landroid/graphics/Paint$Align;)V", "textAlign$delegate", "Lkotlin/reflect/KMutableProperty0;", "textPaint", "Landroid/text/TextPaint;", "textSizeSp", "", "getTextSizeSp", "()F", "setTextSizeSp", "(F)V", "Landroid/graphics/Typeface;", "typeface", "getTypeface$delegate", "getTypeface", "()Landroid/graphics/Typeface;", "setTypeface", "(Landroid/graphics/Typeface;)V", "drawText", "", "context", "Lcom/patrykandpatrick/vico/core/context/DrawContext;", "text", "", "textX", "textY", "horizontalPosition", "Lcom/patrykandpatrick/vico/core/component/text/HorizontalPosition;", "verticalPosition", "Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;", "maxTextWidth", "maxTextHeight", "rotationDegrees", "getHeight", "Lcom/patrykandpatrick/vico/core/context/MeasureContext;", "width", "height", "getTextBounds", "outRect", "includePaddingAndMargins", "", "getWidth", "getLayout", "Landroid/text/StaticLayout;", "fontScale", "getTextLeftPosition", "baseXPosition", "getTextRightPosition", "getTextStartPosition", "getTextTopPosition", "layoutHeight", "getTextTopPositionExt", "getXCorrection", "Builder", "core_release"})
@SourceDebugExtension(value={"SMAP\nTextComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextComponent.kt\ncom/patrykandpatrick/vico/core/component/text/TextComponent\n+ 2 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n+ 3 DrawContextExtensions.kt\ncom/patrykandpatrick/vico/core/draw/DrawContextExtensionsKt\n*L\n1#1,455:1\n105#2:456\n63#2:458\n63#2:459\n63#2:460\n63#2:461\n63#2:463\n63#2:464\n63#2:465\n105#2:466\n105#2:467\n32#3:457\n33#3:462\n*S KotlinDebug\n*F\n+ 1 TextComponent.kt\ncom/patrykandpatrick/vico/core/component/text/TextComponent\n*L\n162#1:456\n188#1:458\n189#1:459\n194#1:460\n195#1:461\n236#1:463\n252#1:464\n264#1:465\n346#1:466\n347#1:467\n166#1:457\n166#1:462\n*E\n"})
public class TextComponent
implements Padding,
Margins {
    @NotNull
    private final TextPaint textPaint = new TextPaint(1);
    @NotNull
    private final RectF tempMeasureBounds = new RectF();
    private float textSizeSp;
    @Nullable
    private TextUtils.TruncateAt ellipsize = TextUtils.TruncateAt.END;
    private int lineCount = 1;
    @Nullable
    private Component background;
    @NotNull
    private final KMutableProperty0 textAlign$delegate = (KMutableProperty0)new MutablePropertyReference0Impl(this.textPaint){

        @Nullable
        public Object get() {
            return ((TextPaint)this.receiver).getTextAlign();
        }

        public void set(@Nullable Object value) {
            ((TextPaint)this.receiver).setTextAlign((Paint.Align)value);
        }
    };
    @NotNull
    private MutableDimensions padding = MutableDimensionsKt.emptyDimensions();
    @NotNull
    private MutableDimensions margins = MutableDimensionsKt.emptyDimensions();
    @NotNull
    private Layout layout = (Layout)StaticLayoutExtensionsKt.staticLayout$default("", this.textPaint, 0, 0, 0, 0, 0.0f, 0.0f, false, null, 0, null, 4088, null);

    protected TextComponent() {
    }

    public final int getColor() {
        return this.textPaint.getColor();
    }

    public final void setColor(int n) {
        this.textPaint.setColor(n);
    }

    private static Object getColor$delegate(TextComponent textComponent2) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)textComponent2.textPaint, TextPaint.class, "color", "getColor()I", 2)));
    }

    @Nullable
    public final Typeface getTypeface() {
        return this.textPaint.getTypeface();
    }

    public final void setTypeface(@Nullable Typeface typeface) {
        this.textPaint.setTypeface(typeface);
    }

    private static Object getTypeface$delegate(TextComponent textComponent2) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)textComponent2.textPaint, TextPaint.class, "typeface", "getTypeface()Landroid/graphics/Typeface;", 2)));
    }

    public final float getTextSizeSp() {
        return this.textSizeSp;
    }

    public final void setTextSizeSp(float f) {
        this.textSizeSp = f;
    }

    @Nullable
    public final TextUtils.TruncateAt getEllipsize() {
        return this.ellipsize;
    }

    public final void setEllipsize(@Nullable TextUtils.TruncateAt truncateAt) {
        this.ellipsize = truncateAt;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public final void setLineCount(int n) {
        this.lineCount = n;
    }

    @Nullable
    public final Component getBackground() {
        return this.background;
    }

    public final void setBackground(@Nullable Component component) {
        this.background = component;
    }

    @NotNull
    public final Paint.Align getTextAlign() {
        KProperty0 kProperty0 = (KProperty0)this.textAlign$delegate;
        Object object = kProperty0.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Paint.Align)object;
    }

    public final void setTextAlign(@NotNull Paint.Align align) {
        Intrinsics.checkNotNullParameter((Object)align, (String)"<set-?>");
        KMutableProperty0 kMutableProperty0 = this.textAlign$delegate;
        kMutableProperty0.set((Object)align);
    }

    @Override
    @NotNull
    public MutableDimensions getPadding() {
        return this.padding;
    }

    public void setPadding(@NotNull MutableDimensions mutableDimensions) {
        Intrinsics.checkNotNullParameter((Object)mutableDimensions, (String)"<set-?>");
        this.padding = mutableDimensions;
    }

    @Override
    @NotNull
    public MutableDimensions getMargins() {
        return this.margins;
    }

    public void setMargins(@NotNull MutableDimensions mutableDimensions) {
        Intrinsics.checkNotNullParameter((Object)mutableDimensions, (String)"<set-?>");
        this.margins = mutableDimensions;
    }

    public final void drawText(@NotNull DrawContext context, @NotNull CharSequence text, float textX, float textY, @NotNull HorizontalPosition horizontalPosition, @NotNull VerticalPosition verticalPosition, int maxTextWidth, int maxTextHeight, float rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalPosition), (String)"horizontalPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalPosition), (String)"verticalPosition");
        DrawContext $this$drawText_u24lambda_u242 = context;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        this.layout = (Layout)this.getLayout($this$drawText_u24lambda_u242, text, $this$drawText_u24lambda_u242.getFontScale(), maxTextWidth, maxTextHeight, rotationDegrees);
        float $this$piRad$iv = 2.0f;
        boolean $i$f$getPiRad = false;
        boolean shouldRotate = !(rotationDegrees % ($this$piRad$iv * 180.0f) == 0.0f);
        float textStartPosition = this.getTextStartPosition(horizontalPosition, context, textX, StaticLayoutExtensionsKt.getWidestLineWidth(this.layout));
        float textTopPosition = this.getTextTopPositionExt(verticalPosition, context, textY, this.layout.getHeight());
        DrawContext $this$withCanvas$iv = context;
        boolean $i$f$withCanvas = false;
        Canvas $this$drawText_u24lambda_u242_u24lambda_u241 = $this$withCanvas$iv.getCanvas();
        boolean bl2 = false;
        $this$drawText_u24lambda_u242_u24lambda_u241.save();
        RectF bounds = StaticLayoutExtensionsKt.getBounds(this.layout, this.tempMeasureBounds);
        float textAlignCorrection = this.getXCorrection(this.getTextAlign(), bounds.width());
        RectF $this$drawText_u24lambda_u242_u24lambda_u241_u24lambda_u240 = bounds;
        boolean bl3 = false;
        $this$drawText_u24lambda_u242_u24lambda_u241_u24lambda_u240.left -= $this$drawText_u24lambda_u242.getPixels(this.getPadding().getLeftDp($this$drawText_u24lambda_u242.isLtr()));
        $this$drawText_u24lambda_u242_u24lambda_u241_u24lambda_u240.top -= $this$drawText_u24lambda_u242.getPixels(this.getPadding().getTopDp());
        $this$drawText_u24lambda_u242_u24lambda_u241_u24lambda_u240.right += $this$drawText_u24lambda_u242.getPixels(this.getPadding().getRightDp($this$drawText_u24lambda_u242.isLtr()));
        $this$drawText_u24lambda_u242_u24lambda_u241_u24lambda_u240.bottom += $this$drawText_u24lambda_u242.getPixels(this.getPadding().getBottomDp());
        float xCorrection = 0.0f;
        float yCorrection = 0.0f;
        if (shouldRotate) {
            float f;
            float f2;
            boolean $i$f$getHalf;
            float $this$half$iv;
            RectF boundsPostRotation = RectExtensionsKt.rotate(RectExtensionsKt.copy(bounds), rotationDegrees);
            float heightDelta = bounds.height() - boundsPostRotation.height();
            float widthDelta = bounds.width() - boundsPostRotation.width();
            switch (WhenMappings.$EnumSwitchMapping$0[horizontalPosition.ordinal()]) {
                case 1: {
                    $this$half$iv = widthDelta;
                    $i$f$getHalf = false;
                    f2 = $this$half$iv / (float)2;
                    break;
                }
                case 2: {
                    $this$half$iv = widthDelta;
                    $i$f$getHalf = false;
                    f2 = -($this$half$iv / (float)2);
                    break;
                }
                default: {
                    f2 = 0.0f;
                }
            }
            xCorrection = f2 * context.getLayoutDirectionMultiplier();
            switch (WhenMappings.$EnumSwitchMapping$1[verticalPosition.ordinal()]) {
                case 1: {
                    $this$half$iv = heightDelta;
                    $i$f$getHalf = false;
                    f = $this$half$iv / (float)2;
                    break;
                }
                case 2: {
                    $this$half$iv = heightDelta;
                    $i$f$getHalf = false;
                    f = -($this$half$iv / (float)2);
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            yCorrection = f;
        }
        RectExtensionsKt.translate(bounds, textStartPosition + xCorrection, textTopPosition + yCorrection);
        if (shouldRotate) {
            $this$drawText_u24lambda_u242_u24lambda_u241.rotate(rotationDegrees, bounds.centerX(), bounds.centerY());
        }
        Component component = this.background;
        if (component != null) {
            component.draw(context, bounds.left, bounds.top, bounds.right, bounds.bottom);
        }
        $this$drawText_u24lambda_u242_u24lambda_u241.translate(bounds.left + $this$drawText_u24lambda_u242.getPixels(this.getPadding().getLeftDp($this$drawText_u24lambda_u242.isLtr())) + textAlignCorrection, bounds.top + $this$drawText_u24lambda_u242.getPixels(this.getPadding().getTopDp()));
        this.layout.draw($this$drawText_u24lambda_u242_u24lambda_u241);
        $this$drawText_u24lambda_u242_u24lambda_u241.restore();
    }

    public static /* synthetic */ void drawText$default(TextComponent textComponent2, DrawContext drawContext2, CharSequence charSequence, float f, float f2, HorizontalPosition horizontalPosition, VerticalPosition verticalPosition, int n, int n2, float f3, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawText");
        }
        if ((n3 & 0x10) != 0) {
            horizontalPosition = HorizontalPosition.Center;
        }
        if ((n3 & 0x20) != 0) {
            verticalPosition = VerticalPosition.Center;
        }
        if ((n3 & 0x40) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 0x80) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x100) != 0) {
            f3 = 0.0f;
        }
        textComponent2.drawText(drawContext2, charSequence, f, f2, horizontalPosition, verticalPosition, n, n2, f3);
    }

    private final float getTextStartPosition(HorizontalPosition $this$getTextStartPosition, MeasureContext context, float baseXPosition, float width) {
        float f;
        MeasureContext $this$getTextStartPosition_u24lambda_u243 = context;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getTextStartPosition.ordinal()]) {
            case 1: {
                if ($this$getTextStartPosition_u24lambda_u243.isLtr()) {
                    f = this.getTextRightPosition($this$getTextStartPosition_u24lambda_u243, baseXPosition, width);
                    break;
                }
                f = this.getTextLeftPosition($this$getTextStartPosition_u24lambda_u243, baseXPosition);
                break;
            }
            case 3: {
                float $this$half$iv = width;
                boolean $i$f$getHalf = false;
                f = baseXPosition - $this$half$iv / (float)2;
                break;
            }
            case 2: {
                if ($this$getTextStartPosition_u24lambda_u243.isLtr()) {
                    f = this.getTextLeftPosition($this$getTextStartPosition_u24lambda_u243, baseXPosition);
                    break;
                }
                f = this.getTextRightPosition($this$getTextStartPosition_u24lambda_u243, baseXPosition, width);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private final float getTextLeftPosition(MeasureContext $this$getTextLeftPosition, float baseXPosition) {
        return baseXPosition + $this$getTextLeftPosition.getPixels(this.getPadding().getLeftDp($this$getTextLeftPosition.isLtr())) + $this$getTextLeftPosition.getPixels(this.getMargins().getLeftDp($this$getTextLeftPosition.isLtr()));
    }

    private final float getTextRightPosition(MeasureContext $this$getTextRightPosition, float baseXPosition, float width) {
        return baseXPosition - $this$getTextRightPosition.getPixels(this.getPadding().getRightDp($this$getTextRightPosition.isLtr())) - $this$getTextRightPosition.getPixels(this.getMargins().getRightDp($this$getTextRightPosition.isLtr())) - width;
    }

    private final float getXCorrection(Paint.Align $this$getXCorrection, float width) {
        float f;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$getXCorrection.ordinal()]) {
            case 1: {
                f = 0.0f;
                break;
            }
            case 2: {
                float $this$half$iv = width;
                boolean $i$f$getHalf = false;
                f = $this$half$iv / (float)2;
                break;
            }
            case 3: {
                f = width;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    @JvmName(name="getTextTopPositionExt")
    private final float getTextTopPositionExt(VerticalPosition $this$getTextTopPosition, MeasureContext context, float textY, float layoutHeight) {
        float f;
        MeasureContext $this$getTextTopPosition_u24lambda_u244 = context;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getTextTopPosition.ordinal()]) {
            case 1: {
                f = -layoutHeight - $this$getTextTopPosition_u24lambda_u244.getPixels(this.getPadding().getBottomDp()) - $this$getTextTopPosition_u24lambda_u244.getPixels(this.getMargins().getBottomDp());
                break;
            }
            case 3: {
                float $this$half$iv = layoutHeight;
                boolean $i$f$getHalf = false;
                f = -($this$half$iv / (float)2);
                break;
            }
            case 2: {
                f = $this$getTextTopPosition_u24lambda_u244.getPixels(this.getPadding().getTopDp()) + $this$getTextTopPosition_u24lambda_u244.getPixels(this.getMargins().getTopDp());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return textY + f;
    }

    public final float getWidth(@NotNull MeasureContext context, @NotNull CharSequence text, int width, int height, float rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return TextComponent.getTextBounds$default(this, context, text, width, height, null, false, rotationDegrees, 48, null).width();
    }

    public static /* synthetic */ float getWidth$default(TextComponent textComponent2, MeasureContext measureContext, CharSequence charSequence, int n, int n2, float f, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getWidth");
        }
        if ((n3 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x10) != 0) {
            f = 0.0f;
        }
        return textComponent2.getWidth(measureContext, charSequence, n, n2, f);
    }

    public final float getHeight(@NotNull MeasureContext context, @NotNull CharSequence text, int width, int height, float rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return TextComponent.getTextBounds$default(this, context, text, width, height, null, false, rotationDegrees, 48, null).height();
    }

    public static /* synthetic */ float getHeight$default(TextComponent textComponent2, MeasureContext measureContext, CharSequence charSequence, int n, int n2, float f, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getHeight");
        }
        if ((n3 & 2) != 0) {
            charSequence = "";
        }
        if ((n3 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x10) != 0) {
            f = 0.0f;
        }
        return textComponent2.getHeight(measureContext, charSequence, n, n2, f);
    }

    @NotNull
    public final RectF getTextBounds(@NotNull MeasureContext context, @NotNull CharSequence text, int width, int height, @NotNull RectF outRect, boolean includePaddingAndMargins, float rotationDegrees) {
        RectF rectF;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        MeasureContext $this$getTextBounds_u24lambda_u247 = context;
        boolean bl = false;
        RectF $this$getTextBounds_u24lambda_u247_u24lambda_u245 = rectF = StaticLayoutExtensionsKt.getBounds((Layout)this.getLayout($this$getTextBounds_u24lambda_u247, text, $this$getTextBounds_u24lambda_u247.getFontScale(), width, height, rotationDegrees), outRect);
        boolean bl2 = false;
        if (includePaddingAndMargins) {
            $this$getTextBounds_u24lambda_u247_u24lambda_u245.right += $this$getTextBounds_u24lambda_u247.getPixels(this.getPadding().getHorizontalDp());
            $this$getTextBounds_u24lambda_u247_u24lambda_u245.bottom += $this$getTextBounds_u24lambda_u247.getPixels(this.getPadding().getVerticalDp());
        }
        RectF $this$getTextBounds_u24lambda_u247_u24lambda_u246 = rectF = RectExtensionsKt.rotate(rectF, rotationDegrees);
        boolean bl3 = false;
        if (includePaddingAndMargins) {
            $this$getTextBounds_u24lambda_u247_u24lambda_u246.right += $this$getTextBounds_u24lambda_u247.getPixels(this.getMargins().getHorizontalDp());
            $this$getTextBounds_u24lambda_u247_u24lambda_u246.bottom += $this$getTextBounds_u24lambda_u247.getPixels(this.getMargins().getVerticalDp());
        }
        return rectF;
    }

    public static /* synthetic */ RectF getTextBounds$default(TextComponent textComponent2, MeasureContext measureContext, CharSequence charSequence, int n, int n2, RectF rectF, boolean bl, float f, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTextBounds");
        }
        if ((n3 & 2) != 0) {
            charSequence = "";
        }
        if ((n3 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x10) != 0) {
            rectF = textComponent2.tempMeasureBounds;
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        if ((n3 & 0x40) != 0) {
            f = 0.0f;
        }
        return textComponent2.getTextBounds(measureContext, charSequence, n, n2, rectF, bl, f);
    }

    private final StaticLayout getLayout(MeasureContext $this$getLayout, CharSequence text, float fontScale, int width, int height, float rotationDegrees) {
        int n;
        int widthWithoutMargins = width - $this$getLayout.getWholePixels(this.getMargins().getHorizontalDp());
        int heightWithoutMargins = height - $this$getLayout.getWholePixels(this.getMargins().getVerticalDp());
        float $this$piRad$iv = 1.0f;
        boolean $i$f$getPiRad = false;
        if (rotationDegrees % ($this$piRad$iv * 180.0f) == 0.0f) {
            n = widthWithoutMargins;
        } else {
            $this$piRad$iv = 0.5f;
            $i$f$getPiRad = false;
            if (rotationDegrees % ($this$piRad$iv * 180.0f) == 0.0f) {
                n = heightWithoutMargins;
            } else {
                float cumulatedHeight = (float)this.lineCount * PaintExtensionsKt.getLineHeight((Paint)this.textPaint) + (float)$this$getLayout.getWholePixels(this.getPadding().getVerticalDp());
                double alpha = Math.toRadians(rotationDegrees);
                double absSinAlpha = Math.abs(Math.sin(alpha));
                double absCosAlpha = Math.abs(Math.cos(alpha));
                double basedOnWidth = ((double)widthWithoutMargins - (double)cumulatedHeight * absSinAlpha) / absCosAlpha;
                double basedOnHeight = ((double)heightWithoutMargins - (double)cumulatedHeight * absCosAlpha) / absSinAlpha;
                n = (int)Math.min(basedOnWidth, basedOnHeight);
            }
        }
        int correctedWidth = RangesKt.coerceAtLeast((int)(n - $this$getLayout.getWholePixels(this.getPadding().getHorizontalDp())), (int)0);
        String key = "layout_" + text + correctedWidth + rotationDegrees + this.textPaint.hashCode();
        return (StaticLayout)ExtrasExtensionsKt.getOrPutExtra($this$getLayout, key, (Function0)new Function0<StaticLayout>(this, fontScale, text, correctedWidth){
            final /* synthetic */ TextComponent this$0;
            final /* synthetic */ float $fontScale;
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ int $correctedWidth;
            {
                this.this$0 = $receiver;
                this.$fontScale = $fontScale;
                this.$text = $text;
                this.$correctedWidth = $correctedWidth;
                super(0);
            }

            @NotNull
            public final StaticLayout invoke() {
                TextComponent.access$getTextPaint$p(this.this$0).setTextSize(this.this$0.getTextSizeSp() * this.$fontScale);
                return StaticLayoutExtensionsKt.staticLayout$default(this.$text, TextComponent.access$getTextPaint$p(this.this$0), this.$correctedWidth, this.this$0.getLineCount(), 0, 0, 0.0f, 0.0f, false, this.this$0.getEllipsize(), 0, null, 3568, null);
            }
        });
    }

    static /* synthetic */ StaticLayout getLayout$default(TextComponent textComponent2, MeasureContext measureContext, CharSequence charSequence, float f, int n, int n2, float f2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLayout");
        }
        if ((n3 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x10) != 0) {
            f2 = 0.0f;
        }
        return textComponent2.getLayout(measureContext, charSequence, f, n, n2, f2);
    }

    @Override
    public void setPadding(float start, float top, float end, float bottom) {
        Padding.DefaultImpls.setPadding(this, start, top, end, bottom);
    }

    @Override
    public void setPadding(float horizontal, float vertical) {
        Padding.DefaultImpls.setPadding(this, horizontal, vertical);
    }

    @Override
    public void setPadding(float all) {
        Padding.DefaultImpls.setPadding(this, all);
    }

    @Override
    public void setMargins(float start, float top, float end, float bottom) {
        Margins.DefaultImpls.setMargins(this, start, top, end, bottom);
    }

    @Override
    public void setMargins(float all) {
        Margins.DefaultImpls.setMargins(this, all);
    }

    public static final /* synthetic */ TextPaint access$getTextPaint$p(TextComponent $this) {
        return $this.textPaint;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u00103\u001a\u000204R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u00065"}, d2={"Lcom/patrykandpatrick/vico/core/component/text/TextComponent$Builder;", "", "()V", "background", "Lcom/patrykandpatrick/vico/core/component/Component;", "getBackground", "()Lcom/patrykandpatrick/vico/core/component/Component;", "setBackground", "(Lcom/patrykandpatrick/vico/core/component/Component;)V", "color", "", "getColor", "()I", "setColor", "(I)V", "ellipsize", "Landroid/text/TextUtils$TruncateAt;", "getEllipsize", "()Landroid/text/TextUtils$TruncateAt;", "setEllipsize", "(Landroid/text/TextUtils$TruncateAt;)V", "lineCount", "getLineCount", "setLineCount", "margins", "Lcom/patrykandpatrick/vico/core/dimensions/MutableDimensions;", "getMargins", "()Lcom/patrykandpatrick/vico/core/dimensions/MutableDimensions;", "setMargins", "(Lcom/patrykandpatrick/vico/core/dimensions/MutableDimensions;)V", "padding", "getPadding", "setPadding", "textAlign", "Landroid/graphics/Paint$Align;", "getTextAlign", "()Landroid/graphics/Paint$Align;", "setTextAlign", "(Landroid/graphics/Paint$Align;)V", "textSizeSp", "", "getTextSizeSp", "()F", "setTextSizeSp", "(F)V", "typeface", "Landroid/graphics/Typeface;", "getTypeface", "()Landroid/graphics/Typeface;", "setTypeface", "(Landroid/graphics/Typeface;)V", "build", "Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "core_release"})
    public static final class Builder {
        private int color = -16777216;
        private float textSizeSp = 12.0f;
        @Nullable
        private Typeface typeface;
        @NotNull
        private TextUtils.TruncateAt ellipsize = TextUtils.TruncateAt.END;
        private int lineCount = 1;
        @Nullable
        private Component background;
        @NotNull
        private Paint.Align textAlign = Paint.Align.LEFT;
        @NotNull
        private MutableDimensions padding = MutableDimensionsKt.emptyDimensions();
        @NotNull
        private MutableDimensions margins = MutableDimensionsKt.emptyDimensions();

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final float getTextSizeSp() {
            return this.textSizeSp;
        }

        public final void setTextSizeSp(float f) {
            this.textSizeSp = f;
        }

        @Nullable
        public final Typeface getTypeface() {
            return this.typeface;
        }

        public final void setTypeface(@Nullable Typeface typeface) {
            this.typeface = typeface;
        }

        @NotNull
        public final TextUtils.TruncateAt getEllipsize() {
            return this.ellipsize;
        }

        public final void setEllipsize(@NotNull TextUtils.TruncateAt truncateAt) {
            Intrinsics.checkNotNullParameter((Object)truncateAt, (String)"<set-?>");
            this.ellipsize = truncateAt;
        }

        public final int getLineCount() {
            return this.lineCount;
        }

        public final void setLineCount(int n) {
            this.lineCount = n;
        }

        @Nullable
        public final Component getBackground() {
            return this.background;
        }

        public final void setBackground(@Nullable Component component) {
            this.background = component;
        }

        @NotNull
        public final Paint.Align getTextAlign() {
            return this.textAlign;
        }

        public final void setTextAlign(@NotNull Paint.Align align) {
            Intrinsics.checkNotNullParameter((Object)align, (String)"<set-?>");
            this.textAlign = align;
        }

        @NotNull
        public final MutableDimensions getPadding() {
            return this.padding;
        }

        public final void setPadding(@NotNull MutableDimensions mutableDimensions) {
            Intrinsics.checkNotNullParameter((Object)mutableDimensions, (String)"<set-?>");
            this.padding = mutableDimensions;
        }

        @NotNull
        public final MutableDimensions getMargins() {
            return this.margins;
        }

        public final void setMargins(@NotNull MutableDimensions mutableDimensions) {
            Intrinsics.checkNotNullParameter((Object)mutableDimensions, (String)"<set-?>");
            this.margins = mutableDimensions;
        }

        @NotNull
        public final TextComponent build() {
            TextComponent textComponent2;
            TextComponent $this$build_u24lambda_u240 = textComponent2 = new TextComponent();
            boolean bl = false;
            $this$build_u24lambda_u240.setColor(this.color);
            $this$build_u24lambda_u240.setTextSizeSp(this.textSizeSp);
            $this$build_u24lambda_u240.setTypeface(this.typeface);
            $this$build_u24lambda_u240.setEllipsize(this.ellipsize);
            $this$build_u24lambda_u240.setLineCount(this.lineCount);
            $this$build_u24lambda_u240.setBackground(this.background);
            $this$build_u24lambda_u240.setTextAlign(this.textAlign);
            $this$build_u24lambda_u240.getPadding().set(this.padding);
            $this$build_u24lambda_u240.getMargins().set(this.margins);
            return textComponent2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[HorizontalPosition.values().length];
            try {
                nArray[HorizontalPosition.Start.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalPosition.End.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalPosition.Center.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VerticalPosition.values().length];
            try {
                nArray[VerticalPosition.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalPosition.Bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalPosition.Center.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Paint.Align.values().length];
            try {
                nArray[Paint.Align.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Paint.Align.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Paint.Align.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

