/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.component.shape.cornered;

import android.graphics.Paint;
import android.graphics.Path;
import com.patrykandpatrick.vico.core.component.shape.Shape;
import com.patrykandpatrick.vico.core.component.shape.cornered.Corner;
import com.patrykandpatrick.vico.core.component.shape.cornered.CornerLocation;
import com.patrykandpatrick.vico.core.context.DrawContext;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0014J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J@\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/cornered/CorneredShape;", "Lcom/patrykandpatrick/vico/core/component/shape/Shape;", "topLeft", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;", "topRight", "bottomRight", "bottomLeft", "(Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;)V", "getBottomLeft", "()Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;", "getBottomRight", "getTopLeft", "getTopRight", "nonZero", "", "getNonZero", "(F)F", "createPath", "", "context", "Lcom/patrykandpatrick/vico/core/context/DrawContext;", "path", "Landroid/graphics/Path;", "left", "top", "right", "bottom", "density", "drawShape", "paint", "Landroid/graphics/Paint;", "getCornerScale", "width", "height", "core_release"})
public class CorneredShape
implements Shape {
    @NotNull
    private final Corner topLeft;
    @NotNull
    private final Corner topRight;
    @NotNull
    private final Corner bottomRight;
    @NotNull
    private final Corner bottomLeft;

    public CorneredShape(@NotNull Corner topLeft, @NotNull Corner topRight, @NotNull Corner bottomRight, @NotNull Corner bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    public /* synthetic */ CorneredShape(Corner corner, Corner corner2, Corner corner3, Corner corner4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            corner = Corner.Companion.getSharp();
        }
        if ((n & 2) != 0) {
            corner2 = Corner.Companion.getSharp();
        }
        if ((n & 4) != 0) {
            corner3 = Corner.Companion.getSharp();
        }
        if ((n & 8) != 0) {
            corner4 = Corner.Companion.getSharp();
        }
        this(corner, corner2, corner3, corner4);
    }

    @NotNull
    public final Corner getTopLeft() {
        return this.topLeft;
    }

    @NotNull
    public final Corner getTopRight() {
        return this.topRight;
    }

    @NotNull
    public final Corner getBottomRight() {
        return this.bottomRight;
    }

    @NotNull
    public final Corner getBottomLeft() {
        return this.bottomLeft;
    }

    private final float getNonZero(float $this$nonZero) {
        return $this$nonZero == 0.0f ? 1.0f : $this$nonZero;
    }

    public final float getCornerScale(float width, float height, float density) {
        float availableSize = Math.min(width, height);
        float tL = this.topLeft.getCornerSize(availableSize, density);
        float tR = this.topRight.getCornerSize(availableSize, density);
        float bR = this.bottomRight.getCornerSize(availableSize, density);
        float bL = this.bottomLeft.getCornerSize(availableSize, density);
        float[] fArray = new float[]{width / this.getNonZero(bL + bR), height / this.getNonZero(tL + bL), height / this.getNonZero(tR + bR)};
        return ComparisonsKt.minOf((float)(width / this.getNonZero(tL + tR)), (float[])fArray);
    }

    @Override
    public void drawShape(@NotNull DrawContext context, @NotNull Paint paint, @NotNull Path path, float left, float top, float right, float bottom) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.createPath(context, path, left, top, right, bottom);
        context.getCanvas().drawPath(path, paint);
    }

    protected void createPath(@NotNull DrawContext context, @NotNull Path path, float left, float top, float right, float bottom) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.createPath(context.getDensity(), path, left, top, right, bottom);
    }

    public void createPath(float density, @NotNull Path path, float left, float top, float right, float bottom) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        float width = right - left;
        float height = bottom - top;
        if (width == 0.0f || height == 0.0f) {
            return;
        }
        float size = Math.abs(Math.min(width, height));
        float scale = RangesKt.coerceAtMost((float)this.getCornerScale(width, height, density), (float)1.0f);
        float tL = this.topLeft.getCornerSize(size, density) * scale;
        float tR = this.topRight.getCornerSize(size, density) * scale;
        float bR = this.bottomRight.getCornerSize(size, density) * scale;
        float bL = this.bottomLeft.getCornerSize(size, density) * scale;
        path.moveTo(left, top + tL);
        this.topLeft.getCornerTreatment().createCorner(left, top + tL, left + tL, top, CornerLocation.TopLeft, path);
        path.lineTo(right - tR, top);
        this.topRight.getCornerTreatment().createCorner(right - tR, top, right, top + tR, CornerLocation.TopRight, path);
        path.lineTo(right, bottom - bR);
        this.bottomRight.getCornerTreatment().createCorner(right, bottom - bR, right - bR, bottom, CornerLocation.BottomRight, path);
        path.lineTo(left + bL, bottom);
        this.bottomLeft.getCornerTreatment().createCorner(left + bL, bottom, left, bottom - bL, CornerLocation.BottomLeft, path);
        path.close();
    }

    public CorneredShape() {
        this(null, null, null, null, 15, null);
    }
}

