/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.component.shape.cornered;

import com.patrykandpatrick.vico.core.component.shape.cornered.CornerTreatment;
import com.patrykandpatrick.vico.core.component.shape.cornered.RoundedCornerTreatment;
import com.patrykandpatrick.vico.core.component.shape.cornered.SharpCornerTreatment;
import com.patrykandpatrick.vico.core.throwable.IllegalPercentageException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \f2\u00020\u0001:\u0003\u000b\f\rB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;", "", "cornerTreatment", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/CornerTreatment;", "(Lcom/patrykandpatrick/vico/core/component/shape/cornered/CornerTreatment;)V", "getCornerTreatment", "()Lcom/patrykandpatrick/vico/core/component/shape/cornered/CornerTreatment;", "getCornerSize", "", "availableCornerSize", "density", "Absolute", "Companion", "Relative", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner$Absolute;", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner$Relative;", "core_release"})
public abstract class Corner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CornerTreatment cornerTreatment;
    private static final int MAX_PERCENTAGE = 100;
    @NotNull
    private static final Corner FullyRounded = new Relative(100, RoundedCornerTreatment.INSTANCE);
    @NotNull
    private static final Corner Sharp = new Relative(0, SharpCornerTreatment.INSTANCE);

    private Corner(CornerTreatment cornerTreatment) {
        this.cornerTreatment = cornerTreatment;
    }

    @NotNull
    public final CornerTreatment getCornerTreatment() {
        return this.cornerTreatment;
    }

    public abstract float getCornerSize(float var1, float var2);

    public /* synthetic */ Corner(CornerTreatment cornerTreatment, DefaultConstructorMarker $constructor_marker) {
        this(cornerTreatment);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner$Absolute;", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;", "sizeDp", "", "cornerTreatment", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/CornerTreatment;", "(FLcom/patrykandpatrick/vico/core/component/shape/cornered/CornerTreatment;)V", "getSizeDp", "()F", "getCornerSize", "availableCornerSize", "density", "core_release"})
    public static final class Absolute
    extends Corner {
        private final float sizeDp;

        public Absolute(float sizeDp, @NotNull CornerTreatment cornerTreatment) {
            Intrinsics.checkNotNullParameter((Object)cornerTreatment, (String)"cornerTreatment");
            super(cornerTreatment, null);
            this.sizeDp = sizeDp;
        }

        public final float getSizeDp() {
            return this.sizeDp;
        }

        @Override
        public float getCornerSize(float availableCornerSize, float density) {
            return this.sizeDp * density;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner$Companion;", "", "()V", "FullyRounded", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;", "getFullyRounded", "()Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;", "MAX_PERCENTAGE", "", "Sharp", "getSharp", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Corner getFullyRounded() {
            return FullyRounded;
        }

        @NotNull
        public final Corner getSharp() {
            return Sharp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner$Relative;", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/Corner;", "percentage", "", "cornerTreatment", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/CornerTreatment;", "(ILcom/patrykandpatrick/vico/core/component/shape/cornered/CornerTreatment;)V", "getPercentage", "()I", "getCornerSize", "", "availableCornerSize", "density", "core_release"})
    public static final class Relative
    extends Corner {
        private final int percentage;

        public Relative(int percentage, @NotNull CornerTreatment cornerTreatment) {
            Intrinsics.checkNotNullParameter((Object)cornerTreatment, (String)"cornerTreatment");
            super(cornerTreatment, null);
            this.percentage = percentage;
            int n = this.percentage;
            if (!(0 <= n ? n < 101 : false)) {
                throw new IllegalPercentageException(this.percentage);
            }
        }

        public final int getPercentage() {
            return this.percentage;
        }

        @Override
        public float getCornerSize(float availableCornerSize, float density) {
            return availableCornerSize / (float)100 * (float)this.percentage;
        }
    }
}

