/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.component.shape;

import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import com.patrykandpatrick.vico.core.component.shape.Shape;
import com.patrykandpatrick.vico.core.component.shape.ShapesKt;
import com.patrykandpatrick.vico.core.component.shape.cornered.Corner;
import com.patrykandpatrick.vico.core.component.shape.cornered.CorneredShape;
import com.patrykandpatrick.vico.core.component.shape.cornered.CutCornerTreatment;
import com.patrykandpatrick.vico.core.component.shape.cornered.RoundedCornerTreatment;
import com.patrykandpatrick.vico.core.context.DrawContext;
import com.patrykandpatrick.vico.core.extension.DrawableExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ.\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\rJ.\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ.\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/Shapes;", "", "()V", "pillShape", "Lcom/patrykandpatrick/vico/core/component/shape/cornered/CorneredShape;", "getPillShape", "()Lcom/patrykandpatrick/vico/core/component/shape/cornered/CorneredShape;", "rectShape", "Lcom/patrykandpatrick/vico/core/component/shape/Shape;", "getRectShape", "()Lcom/patrykandpatrick/vico/core/component/shape/Shape;", "cutCornerShape", "allPercent", "", "topLeftPercent", "topRightPercent", "bottomRightPercent", "bottomLeftPercent", "drawableShape", "drawable", "Landroid/graphics/drawable/Drawable;", "tintDrawable", "", "keepAspectRatio", "otherShape", "roundedCornerShape", "core_release"})
public final class Shapes {
    @NotNull
    public static final Shapes INSTANCE = new Shapes();
    @NotNull
    private static final CorneredShape pillShape = INSTANCE.roundedCornerShape(50);
    @NotNull
    private static final Shape rectShape = new Shape(){

        public void drawShape(@NotNull DrawContext context, @NotNull Paint paint, @NotNull Path path, float left, float top, float right, float bottom) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            path.moveTo(left, top);
            path.lineTo(right, top);
            path.lineTo(right, bottom);
            path.lineTo(left, bottom);
            path.close();
            context.getCanvas().drawPath(path, paint);
        }
    };

    private Shapes() {
    }

    @NotNull
    public final CorneredShape getPillShape() {
        return pillShape;
    }

    @NotNull
    public final Shape getRectShape() {
        return rectShape;
    }

    @NotNull
    public final CorneredShape roundedCornerShape(int allPercent) {
        return this.roundedCornerShape(allPercent, allPercent, allPercent, allPercent);
    }

    @NotNull
    public final CorneredShape roundedCornerShape(int topLeftPercent, int topRightPercent, int bottomRightPercent, int bottomLeftPercent) {
        return new CorneredShape(new Corner.Relative(topLeftPercent, RoundedCornerTreatment.INSTANCE), new Corner.Relative(topRightPercent, RoundedCornerTreatment.INSTANCE), new Corner.Relative(bottomRightPercent, RoundedCornerTreatment.INSTANCE), new Corner.Relative(bottomLeftPercent, RoundedCornerTreatment.INSTANCE));
    }

    public static /* synthetic */ CorneredShape roundedCornerShape$default(Shapes shapes, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return shapes.roundedCornerShape(n, n2, n3, n4);
    }

    @NotNull
    public final CorneredShape cutCornerShape(int allPercent) {
        return this.cutCornerShape(allPercent, allPercent, allPercent, allPercent);
    }

    @NotNull
    public final CorneredShape cutCornerShape(int topLeftPercent, int topRightPercent, int bottomRightPercent, int bottomLeftPercent) {
        return new CorneredShape(new Corner.Relative(topLeftPercent, CutCornerTreatment.INSTANCE), new Corner.Relative(topRightPercent, CutCornerTreatment.INSTANCE), new Corner.Relative(bottomRightPercent, CutCornerTreatment.INSTANCE), new Corner.Relative(bottomLeftPercent, CutCornerTreatment.INSTANCE));
    }

    public static /* synthetic */ CorneredShape cutCornerShape$default(Shapes shapes, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return shapes.cutCornerShape(n, n2, n3, n4);
    }

    @NotNull
    public final Shape drawableShape(@NotNull Drawable drawable, boolean tintDrawable, boolean keepAspectRatio, @Nullable Shape otherShape) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        return new Shape(drawable, tintDrawable, keepAspectRatio, otherShape){
            private final float ratio;
            final /* synthetic */ Drawable $drawable;
            final /* synthetic */ boolean $tintDrawable;
            final /* synthetic */ boolean $keepAspectRatio;
            final /* synthetic */ Shape $otherShape;
            {
                this.$drawable = $drawable;
                this.$tintDrawable = $tintDrawable;
                this.$keepAspectRatio = $keepAspectRatio;
                this.$otherShape = $otherShape;
                this.ratio = (float)RangesKt.coerceAtLeast((int)$drawable.getIntrinsicWidth(), (int)1) / (float)RangesKt.coerceAtLeast((int)$drawable.getIntrinsicHeight(), (int)1);
            }

            public void drawShape(@NotNull DrawContext context, @NotNull Paint paint, @NotNull Path path, float left, float top, float right, float bottom) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (bottom - top == 0.0f || left - right == 0.0f) {
                    return;
                }
                float width = right - left;
                float height = bottom - top;
                float otherComponentLeft = left;
                float otherComponentTop = top;
                if (this.$tintDrawable) {
                    ShapesKt.access$setTintCompat(this.$drawable, paint.getColor());
                }
                if (height > width) {
                    float drawableHeight = this.$keepAspectRatio ? width / this.ratio : height;
                    float topWithoutClipping = Math.min(top, bottom - drawableHeight);
                    DrawableExtensionsKt.setBounds(this.$drawable, left, topWithoutClipping, right, topWithoutClipping + drawableHeight);
                    otherComponentTop = topWithoutClipping + drawableHeight;
                } else {
                    float drawableWidth = this.$keepAspectRatio ? height * this.ratio : width;
                    float leftWithoutClipping = Math.min(left, right - drawableWidth);
                    DrawableExtensionsKt.setBounds(this.$drawable, leftWithoutClipping, top, leftWithoutClipping + drawableWidth, bottom);
                    otherComponentLeft = leftWithoutClipping + drawableWidth;
                }
                this.$drawable.draw(context.getCanvas());
                if (this.$otherShape == null) {
                    return;
                }
                if (bottom - otherComponentTop > 0.0f && right - otherComponentLeft > 0.0f) {
                    this.$otherShape.drawShape(context, paint, path, otherComponentLeft, otherComponentTop, right, bottom);
                }
            }
        };
    }

    public static /* synthetic */ Shape drawableShape$default(Shapes shapes, Drawable drawable, boolean bl, boolean bl2, Shape shape, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            shape = rectShape;
        }
        return shapes.drawableShape(drawable, bl, bl2, shape);
    }
}

