/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.component.shape;

import android.graphics.Paint;
import android.graphics.Path;
import com.patrykandpatrick.vico.core.component.shape.Shape;
import com.patrykandpatrick.vico.core.component.shape.Shapes;
import com.patrykandpatrick.vico.core.context.DrawContext;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001$B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J@\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J@\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0016J@\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/DashedShape;", "Lcom/patrykandpatrick/vico/core/component/shape/Shape;", "shape", "dashLengthDp", "", "gapLengthDp", "fitStrategy", "Lcom/patrykandpatrick/vico/core/component/shape/DashedShape$FitStrategy;", "(Lcom/patrykandpatrick/vico/core/component/shape/Shape;FFLcom/patrykandpatrick/vico/core/component/shape/DashedShape$FitStrategy;)V", "getDashLengthDp", "()F", "drawDashLength", "drawGapLength", "getFitStrategy", "()Lcom/patrykandpatrick/vico/core/component/shape/DashedShape$FitStrategy;", "getGapLengthDp", "getShape", "()Lcom/patrykandpatrick/vico/core/component/shape/Shape;", "calculateDrawLengths", "", "context", "Lcom/patrykandpatrick/vico/core/context/DrawContext;", "length", "dashLength", "gapLength", "drawHorizontalDashes", "paint", "Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "left", "top", "right", "bottom", "drawShape", "drawVerticalDashes", "FitStrategy", "core_release"})
@SourceDebugExtension(value={"SMAP\nDashedShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DashedShape.kt\ncom/patrykandpatrick/vico/core/component/shape/DashedShape\n+ 2 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n*L\n1#1,175:1\n117#2:176\n*S KotlinDebug\n*F\n+ 1 DashedShape.kt\ncom/patrykandpatrick/vico/core/component/shape/DashedShape\n*L\n146#1:176\n*E\n"})
public final class DashedShape
implements Shape {
    @NotNull
    private final Shape shape;
    private final float dashLengthDp;
    private final float gapLengthDp;
    @NotNull
    private final FitStrategy fitStrategy;
    private float drawDashLength;
    private float drawGapLength;

    public DashedShape(@NotNull Shape shape, float dashLengthDp, float gapLengthDp, @NotNull FitStrategy fitStrategy) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)((Object)fitStrategy), (String)"fitStrategy");
        this.shape = shape;
        this.dashLengthDp = dashLengthDp;
        this.gapLengthDp = gapLengthDp;
        this.fitStrategy = fitStrategy;
        this.drawDashLength = this.dashLengthDp;
        this.drawGapLength = this.gapLengthDp;
    }

    public /* synthetic */ DashedShape(Shape shape, float f, float f2, FitStrategy fitStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            shape = Shapes.INSTANCE.getRectShape();
        }
        if ((n & 2) != 0) {
            f = 4.0f;
        }
        if ((n & 4) != 0) {
            f2 = 2.0f;
        }
        if ((n & 8) != 0) {
            fitStrategy = FitStrategy.Resize;
        }
        this(shape, f, f2, fitStrategy);
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    public final float getDashLengthDp() {
        return this.dashLengthDp;
    }

    public final float getGapLengthDp() {
        return this.gapLengthDp;
    }

    @NotNull
    public final FitStrategy getFitStrategy() {
        return this.fitStrategy;
    }

    @Override
    public void drawShape(@NotNull DrawContext context, @NotNull Paint paint, @NotNull Path path, float left, float top, float right, float bottom) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (right - left > bottom - top) {
            this.drawHorizontalDashes(context, paint, path, left, top, right, bottom);
        } else {
            this.drawVerticalDashes(context, paint, path, left, top, right, bottom);
        }
    }

    private final void drawHorizontalDashes(DrawContext context, Paint paint, Path path, float left, float top, float right, float bottom) {
        this.calculateDrawLengths(context, right - left);
        int index = 0;
        float drawnLength = 0.0f;
        while (right - left - drawnLength > 0.0f) {
            float f;
            if (index % 2 == 0) {
                path.reset();
                this.shape.drawShape(context, paint, path, left + drawnLength, top, left + drawnLength + this.drawDashLength, bottom);
                f = this.drawDashLength;
            } else {
                f = this.drawGapLength;
            }
            drawnLength += f;
            ++index;
        }
    }

    private final void drawVerticalDashes(DrawContext context, Paint paint, Path path, float left, float top, float right, float bottom) {
        this.calculateDrawLengths(context, bottom - top);
        int index = 0;
        float drawnLength = 0.0f;
        while (bottom - top - drawnLength > 0.0f) {
            float f;
            if (index % 2 == 0) {
                path.reset();
                this.shape.drawShape(context, paint, path, left, top + drawnLength, right, top + drawnLength + this.drawDashLength);
                f = this.drawDashLength;
            } else {
                f = this.drawGapLength;
            }
            drawnLength += f;
            ++index;
        }
    }

    private final void calculateDrawLengths(DrawContext context, float length) {
        DrawContext $this$calculateDrawLengths_u24lambda_u240 = context;
        boolean bl = false;
        this.calculateDrawLengths($this$calculateDrawLengths_u24lambda_u240.getPixels(this.dashLengthDp), $this$calculateDrawLengths_u24lambda_u240.getPixels(this.gapLengthDp), length);
    }

    private final void calculateDrawLengths(float dashLength, float gapLength, float length) {
        if (dashLength == 0.0f && gapLength == 0.0f) {
            this.drawDashLength = length;
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.fitStrategy.ordinal()]) {
            case 1: {
                if (length < dashLength + gapLength) {
                    this.drawDashLength = length;
                    this.drawGapLength = 0.0f;
                    break;
                }
                float gapAndDashLength = gapLength + dashLength;
                float $this$ceil$iv = length / gapAndDashLength;
                boolean $i$f$getCeil = false;
                float ratio = length / (dashLength + (float)Math.ceil($this$ceil$iv) * gapAndDashLength);
                this.drawDashLength = dashLength * ratio;
                this.drawGapLength = gapLength * ratio;
                break;
            }
            case 2: {
                this.drawDashLength = dashLength;
                this.drawGapLength = gapLength;
            }
        }
    }

    public DashedShape() {
        this(null, 0.0f, 0.0f, null, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/patrykandpatrick/vico/core/component/shape/DashedShape$FitStrategy;", "", "(Ljava/lang/String;I)V", "Resize", "Fixed", "core_release"})
    public static final class FitStrategy
    extends Enum<FitStrategy> {
        public static final /* enum */ FitStrategy Resize = new FitStrategy();
        public static final /* enum */ FitStrategy Fixed = new FitStrategy();
        private static final /* synthetic */ FitStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FitStrategy[] values() {
            return (FitStrategy[])$VALUES.clone();
        }

        public static FitStrategy valueOf(String value) {
            return Enum.valueOf(FitStrategy.class, value);
        }

        @NotNull
        public static EnumEntries<FitStrategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fitStrategyArray = new FitStrategy[]{FitStrategy.Resize, FitStrategy.Fixed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FitStrategy.values().length];
            try {
                nArray[FitStrategy.Resize.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FitStrategy.Fixed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

