/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.component.marker;

import android.graphics.RectF;
import com.patrykandpatrick.vico.core.chart.dimensions.HorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.insets.HorizontalInsets;
import com.patrykandpatrick.vico.core.chart.insets.Insets;
import com.patrykandpatrick.vico.core.chart.values.ChartValues;
import com.patrykandpatrick.vico.core.chart.values.ChartValuesProvider;
import com.patrykandpatrick.vico.core.component.Component;
import com.patrykandpatrick.vico.core.component.marker.MarkerComponent;
import com.patrykandpatrick.vico.core.component.shape.LineComponent;
import com.patrykandpatrick.vico.core.component.shape.Shape;
import com.patrykandpatrick.vico.core.component.shape.ShapeComponent;
import com.patrykandpatrick.vico.core.component.shape.cornered.MarkerCorneredShape;
import com.patrykandpatrick.vico.core.component.text.TextComponent;
import com.patrykandpatrick.vico.core.component.text.VerticalPosition;
import com.patrykandpatrick.vico.core.context.DrawContext;
import com.patrykandpatrick.vico.core.context.MeasureContext;
import com.patrykandpatrick.vico.core.extension.CollectionExtensionsKt;
import com.patrykandpatrick.vico.core.marker.DefaultMarkerLabelFormatter;
import com.patrykandpatrick.vico.core.marker.Marker;
import com.patrykandpatrick.vico.core.marker.MarkerLabelFormatter;
import com.patrykandpatrick.vico.core.model.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0016J&\u00104\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J.\u00105\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00106\u001a\u000207H\u0002J \u00108\u001a\u00020!2\u0006\u0010,\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J \u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020'2\u0006\u0010@\u001a\u00020\u000eH\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR7\u0010\u001b\u001a\u001f\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020!\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\u00020\u000e*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006A"}, d2={"Lcom/patrykandpatrick/vico/core/component/marker/MarkerComponent;", "Lcom/patrykandpatrick/vico/core/marker/Marker;", "label", "Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "indicator", "Lcom/patrykandpatrick/vico/core/component/Component;", "guideline", "Lcom/patrykandpatrick/vico/core/component/shape/LineComponent;", "(Lcom/patrykandpatrick/vico/core/component/text/TextComponent;Lcom/patrykandpatrick/vico/core/component/Component;Lcom/patrykandpatrick/vico/core/component/shape/LineComponent;)V", "getGuideline", "()Lcom/patrykandpatrick/vico/core/component/shape/LineComponent;", "getIndicator", "()Lcom/patrykandpatrick/vico/core/component/Component;", "indicatorSizeDp", "", "getIndicatorSizeDp", "()F", "setIndicatorSizeDp", "(F)V", "getLabel", "()Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "labelFormatter", "Lcom/patrykandpatrick/vico/core/marker/MarkerLabelFormatter;", "getLabelFormatter", "()Lcom/patrykandpatrick/vico/core/marker/MarkerLabelFormatter;", "setLabelFormatter", "(Lcom/patrykandpatrick/vico/core/marker/MarkerLabelFormatter;)V", "onApplyEntryColor", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "entryColor", "", "getOnApplyEntryColor", "()Lkotlin/jvm/functions/Function1;", "setOnApplyEntryColor", "(Lkotlin/jvm/functions/Function1;)V", "tempBounds", "Landroid/graphics/RectF;", "tickSizeDp", "getTickSizeDp", "(Lcom/patrykandpatrick/vico/core/component/text/TextComponent;)F", "draw", "context", "Lcom/patrykandpatrick/vico/core/context/DrawContext;", "bounds", "markedEntries", "", "Lcom/patrykandpatrick/vico/core/marker/Marker$EntryModel;", "chartValuesProvider", "Lcom/patrykandpatrick/vico/core/chart/values/ChartValuesProvider;", "drawGuideline", "drawLabel", "chartValues", "Lcom/patrykandpatrick/vico/core/chart/values/ChartValues;", "getInsets", "Lcom/patrykandpatrick/vico/core/context/MeasureContext;", "outInsets", "Lcom/patrykandpatrick/vico/core/chart/insets/Insets;", "horizontalDimensions", "Lcom/patrykandpatrick/vico/core/chart/dimensions/HorizontalDimensions;", "overrideXPositionToFit", "xPosition", "halfOfTextWidth", "core_release"})
@SourceDebugExtension(value={"SMAP\nMarkerComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerComponent.kt\ncom/patrykandpatrick/vico/core/component/marker/MarkerComponent\n+ 2 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n87#2:154\n63#2:155\n63#2:159\n1864#3,3:156\n1549#3:160\n1620#3,3:161\n1855#3,2:164\n*S KotlinDebug\n*F\n+ 1 MarkerComponent.kt\ncom/patrykandpatrick/vico/core/component/marker/MarkerComponent\n*L\n55#1:154\n80#1:155\n104#1:159\n82#1:156,3\n133#1:160\n133#1:161,3\n135#1:164,2\n*E\n"})
public class MarkerComponent
implements Marker {
    @NotNull
    private final TextComponent label;
    @Nullable
    private final Component indicator;
    @Nullable
    private final LineComponent guideline;
    @NotNull
    private final RectF tempBounds;
    private float indicatorSizeDp;
    @Nullable
    private Function1<? super Integer, Unit> onApplyEntryColor;
    @NotNull
    private MarkerLabelFormatter labelFormatter;

    public MarkerComponent(@NotNull TextComponent label, @Nullable Component indicator, @Nullable LineComponent guideline) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.label = label;
        this.indicator = indicator;
        this.guideline = guideline;
        this.tempBounds = new RectF();
        this.labelFormatter = DefaultMarkerLabelFormatter.INSTANCE;
    }

    @NotNull
    public final TextComponent getLabel() {
        return this.label;
    }

    @Nullable
    public final Component getIndicator() {
        return this.indicator;
    }

    @Nullable
    public final LineComponent getGuideline() {
        return this.guideline;
    }

    private final float getTickSizeDp(TextComponent $this$tickSizeDp) {
        Component component = $this$tickSizeDp.getBackground();
        ShapeComponent shapeComponent = component instanceof ShapeComponent ? (ShapeComponent)component : null;
        Shape shape = shapeComponent != null ? shapeComponent.getShape() : null;
        MarkerCorneredShape markerCorneredShape = shape instanceof MarkerCorneredShape ? (MarkerCorneredShape)shape : null;
        Float $this$orZero$iv = markerCorneredShape != null ? Float.valueOf(markerCorneredShape.getTickSizeDp()) : null;
        boolean $i$f$getOrZero = false;
        Float f = $this$orZero$iv;
        return f != null ? f.floatValue() : 0.0f;
    }

    public final float getIndicatorSizeDp() {
        return this.indicatorSizeDp;
    }

    public final void setIndicatorSizeDp(float f) {
        this.indicatorSizeDp = f;
    }

    @Nullable
    public final Function1<Integer, Unit> getOnApplyEntryColor() {
        return this.onApplyEntryColor;
    }

    public final void setOnApplyEntryColor(@Nullable Function1<? super Integer, Unit> function1) {
        this.onApplyEntryColor = function1;
    }

    @NotNull
    public final MarkerLabelFormatter getLabelFormatter() {
        return this.labelFormatter;
    }

    public final void setLabelFormatter(@NotNull MarkerLabelFormatter markerLabelFormatter) {
        Intrinsics.checkNotNullParameter((Object)markerLabelFormatter, (String)"<set-?>");
        this.labelFormatter = markerLabelFormatter;
    }

    @Override
    public void draw(@NotNull DrawContext context, @NotNull RectF bounds, @NotNull List<Marker.EntryModel> markedEntries, @NotNull ChartValuesProvider chartValuesProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(markedEntries, (String)"markedEntries");
        Intrinsics.checkNotNullParameter((Object)chartValuesProvider, (String)"chartValuesProvider");
        DrawContext $this$draw_u24lambda_u241 = context;
        boolean bl = false;
        this.drawGuideline(context, bounds, markedEntries);
        float $this$half$iv = this.indicatorSizeDp;
        boolean $i$f$getHalf = false;
        float halfIndicatorSize = $this$draw_u24lambda_u241.getPixels($this$half$iv / (float)2);
        Iterable $this$forEachIndexed$iv = markedEntries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Marker.EntryModel model = (Marker.EntryModel)item$iv;
            boolean bl2 = false;
            Function1<? super Integer, Unit> function1 = this.onApplyEntryColor;
            if (function1 != null) {
                function1.invoke((Object)model.getColor());
            }
            Component component = this.indicator;
            if (component == null) continue;
            component.draw(context, Point.getX-impl(model.getLocation-R_cA99Q()) - halfIndicatorSize, Point.getY-impl(model.getLocation-R_cA99Q()) - halfIndicatorSize, Point.getX-impl(model.getLocation-R_cA99Q()) + halfIndicatorSize, Point.getY-impl(model.getLocation-R_cA99Q()) + halfIndicatorSize);
        }
        this.drawLabel(context, bounds, markedEntries, chartValuesProvider.getChartValues());
    }

    private final void drawLabel(DrawContext context, RectF bounds, List<Marker.EntryModel> markedEntries, ChartValues chartValues) {
        DrawContext $this$drawLabel_u24lambda_u242 = context;
        boolean bl = false;
        CharSequence text = this.labelFormatter.getLabel(markedEntries, chartValues);
        float entryX2 = CollectionExtensionsKt.averageOf((Collection)markedEntries, drawLabel.1.entryX.1.INSTANCE);
        RectF labelBounds = TextComponent.getTextBounds$default(this.label, context, text, 0, 0, this.tempBounds, false, 0.0f, 108, null);
        float $this$half$iv = labelBounds.width();
        boolean $i$f$getHalf = false;
        float halfOfTextWidth = $this$half$iv / (float)2;
        float x = this.overrideXPositionToFit(entryX2, bounds, halfOfTextWidth);
        $this$drawLabel_u24lambda_u242.set("tickX", Float.valueOf(entryX2));
        TextComponent.drawText$default(this.label, context, text, x, bounds.top - labelBounds.height() - $this$drawLabel_u24lambda_u242.getPixels(this.getTickSizeDp(this.label)), null, VerticalPosition.Bottom, 0, 0, 0.0f, 464, null);
    }

    private final float overrideXPositionToFit(float xPosition, RectF bounds, float halfOfTextWidth) {
        return xPosition - halfOfTextWidth < bounds.left ? bounds.left + halfOfTextWidth : (xPosition + halfOfTextWidth > bounds.right ? bounds.right - halfOfTextWidth : xPosition);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawGuideline(DrawContext context, RectF bounds, List<Marker.EntryModel> markedEntries) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = markedEntries;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Marker.EntryModel entryModel = (Marker.EntryModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(Point.getX-impl(it.getLocation-R_cA99Q())));
        }
        $this$map$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            float x = ((Number)element$iv).floatValue();
            boolean bl = false;
            LineComponent lineComponent = this.guideline;
            if (lineComponent == null) continue;
            LineComponent.drawVertical$default(lineComponent, context, bounds.top, bounds.bottom, x, 0.0f, 16, null);
        }
    }

    @Override
    public void getInsets(@NotNull MeasureContext context, @NotNull Insets outInsets, @NotNull HorizontalDimensions horizontalDimensions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)outInsets, (String)"outInsets");
        Intrinsics.checkNotNullParameter((Object)horizontalDimensions, (String)"horizontalDimensions");
        MeasureContext $this$getInsets_u24lambda_u245 = context;
        boolean bl = false;
        outInsets.setTop(TextComponent.getHeight$default(this.label, context, null, 0, 0, 0.0f, 30, null) + $this$getInsets_u24lambda_u245.getPixels(this.getTickSizeDp(this.label)));
    }

    @Override
    @Deprecated(message="Use the version of `draw` that takes a `ChartValuesProvider` as an argument.", replaceWith=@ReplaceWith(expression="draw(context, bounds, markedEntries, chartValuesProvider)", imports={}))
    public void draw(@NotNull DrawContext context, @NotNull RectF bounds, @NotNull List<Marker.EntryModel> markedEntries) {
        Marker.DefaultImpls.draw(this, context, bounds, markedEntries);
    }

    @Override
    public void getHorizontalInsets(@NotNull MeasureContext context, float availableHeight, @NotNull HorizontalInsets outInsets) {
        Marker.DefaultImpls.getHorizontalInsets(this, context, availableHeight, outInsets);
    }
}

