/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.chart.line;

import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.patrykandpatrick.vico.core.axis.AxisPosition;
import com.patrykandpatrick.vico.core.chart.BaseChart;
import com.patrykandpatrick.vico.core.chart.ChartExtensionsKt;
import com.patrykandpatrick.vico.core.chart.DefaultPointConnector;
import com.patrykandpatrick.vico.core.chart.dimensions.HorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.dimensions.MutableHorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.draw.ChartDrawContext;
import com.patrykandpatrick.vico.core.chart.insets.Insets;
import com.patrykandpatrick.vico.core.chart.layout.HorizontalLayout;
import com.patrykandpatrick.vico.core.chart.line.LineChart;
import com.patrykandpatrick.vico.core.chart.line.LineChartExtensionsKt;
import com.patrykandpatrick.vico.core.chart.values.AxisValuesOverrider;
import com.patrykandpatrick.vico.core.chart.values.ChartValuesManager;
import com.patrykandpatrick.vico.core.chart.values.MutableChartValues;
import com.patrykandpatrick.vico.core.component.Component;
import com.patrykandpatrick.vico.core.component.shape.shader.DynamicShader;
import com.patrykandpatrick.vico.core.component.text.TextComponent;
import com.patrykandpatrick.vico.core.component.text.VerticalPosition;
import com.patrykandpatrick.vico.core.component.text.VerticalPositionExtensionsKt;
import com.patrykandpatrick.vico.core.context.DrawContext;
import com.patrykandpatrick.vico.core.context.MeasureContext;
import com.patrykandpatrick.vico.core.entry.ChartEntry;
import com.patrykandpatrick.vico.core.entry.ChartEntryModel;
import com.patrykandpatrick.vico.core.extension.CollectionExtensionsKt;
import com.patrykandpatrick.vico.core.extension.NumberExtensionsKt;
import com.patrykandpatrick.vico.core.extension.RectExtensionsKt;
import com.patrykandpatrick.vico.core.formatter.DecimalFormatValueFormatter;
import com.patrykandpatrick.vico.core.formatter.ValueFormatter;
import com.patrykandpatrick.vico.core.marker.Marker;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001MB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB+\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0002H\u0014J\u0018\u0010\u0016\u001a\u00020/2\u0006\u0010,\u001a\u0002002\u0006\u0010.\u001a\u00020\u0002H\u0016J \u00101\u001a\u00020+2\u0006\u0010,\u001a\u0002002\u0006\u00102\u001a\u0002032\u0006\u0010\u0014\u001a\u00020/H\u0016J\b\u00104\u001a\u00020+H\u0004J'\u00105\u001a\u00020+2\u0006\u00106\u001a\u0002072\u0006\u0010.\u001a\u00020\u00022\b\u00108\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u00109J*\u0010:\u001a\u00020+*\u00020-2\u0006\u0010;\u001a\u00020\u00042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u000b2\u0006\u0010>\u001a\u00020\u0006H\u0014J\u00b4\u0001\u0010?\u001a\u00020+*\u00020-2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u000b2\u0006\u0010>\u001a\u00020\u00062\u008f\u0001\u0010@\u001a\u008a\u0001\u0012\u0013\u0012\u00110B\u00a2\u0006\f\bC\u0012\b\bD\u0012\u0004\b\b(E\u0012\u0013\u0012\u00110=\u00a2\u0006\f\bC\u0012\b\bD\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\bC\u0012\b\bD\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\bC\u0012\b\bD\u0012\u0004\b\b(H\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\bC\u0012\b\bD\u0012\u0004\b\b(I\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\bC\u0012\b\bD\u0012\u0004\b\b(J\u0012\u0004\u0012\u00020+0AH\u0014J5\u0010K\u001a\u00020B*\u00020-2\u0006\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020\u00062\b\u0010I\u001a\u0004\u0018\u00010\u00062\b\u0010J\u001a\u0004\u0018\u00010\u0006H\u0004\u00a2\u0006\u0002\u0010LR<\u0010\r\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000ej\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f`\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006N"}, d2={"Lcom/patrykandpatrick/vico/core/chart/line/LineChart;", "Lcom/patrykandpatrick/vico/core/chart/BaseChart;", "Lcom/patrykandpatrick/vico/core/entry/ChartEntryModel;", "line", "Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec;", "spacingDp", "", "targetVerticalAxisPosition", "Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "(Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec;FLcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;)V", "lines", "", "(Ljava/util/List;FLcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;)V", "entryLocationMap", "Ljava/util/HashMap;", "", "Lcom/patrykandpatrick/vico/core/marker/Marker$EntryModel;", "Lkotlin/collections/HashMap;", "getEntryLocationMap", "()Ljava/util/HashMap;", "horizontalDimensions", "Lcom/patrykandpatrick/vico/core/chart/dimensions/MutableHorizontalDimensions;", "getHorizontalDimensions", "()Lcom/patrykandpatrick/vico/core/chart/dimensions/MutableHorizontalDimensions;", "lineBackgroundPath", "Landroid/graphics/Path;", "getLineBackgroundPath", "()Landroid/graphics/Path;", "linePath", "getLinePath", "getLines", "()Ljava/util/List;", "setLines", "(Ljava/util/List;)V", "getSpacingDp", "()F", "setSpacingDp", "(F)V", "getTargetVerticalAxisPosition", "()Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "setTargetVerticalAxisPosition", "(Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;)V", "drawChart", "", "context", "Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;", "model", "Lcom/patrykandpatrick/vico/core/chart/dimensions/HorizontalDimensions;", "Lcom/patrykandpatrick/vico/core/context/MeasureContext;", "getInsets", "outInsets", "Lcom/patrykandpatrick/vico/core/chart/insets/Insets;", "resetTempData", "updateChartValues", "chartValuesManager", "Lcom/patrykandpatrick/vico/core/chart/values/ChartValuesManager;", "xStep", "(Lcom/patrykandpatrick/vico/core/chart/values/ChartValuesManager;Lcom/patrykandpatrick/vico/core/entry/ChartEntryModel;Ljava/lang/Float;)V", "drawPointsAndDataLabels", "lineSpec", "entries", "Lcom/patrykandpatrick/vico/core/entry/ChartEntry;", "drawingStart", "forEachPointWithinBoundsIndexed", "action", "Lkotlin/Function6;", "", "Lkotlin/ParameterName;", "name", "index", "entry", "x", "y", "previousX", "nextX", "getMaxDataLabelWidth", "(Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;Lcom/patrykandpatrick/vico/core/entry/ChartEntry;FLjava/lang/Float;Ljava/lang/Float;)I", "LineSpec", "core_release"})
@SourceDebugExtension(value={"SMAP\nLineChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChart.kt\ncom/patrykandpatrick/vico/core/chart/line/LineChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n+ 4 EntryModelExtensions.kt\ncom/patrykandpatrick/vico/core/chart/EntryModelExtensionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 LineChartExtensions.kt\ncom/patrykandpatrick/vico/core/chart/line/LineChartExtensionsKt\n*L\n1#1,574:1\n1864#2,3:575\n1855#2:587\n1856#2:595\n75#3:578\n63#3:579\n75#3:580\n63#3:581\n75#3:582\n63#3:599\n63#3:600\n65#4,2:583\n37#4,2:585\n39#4:588\n67#4:589\n68#4:592\n40#4,2:593\n42#4:596\n69#4:597\n1#5:590\n1#5:591\n38#6:598\n*S KotlinDebug\n*F\n+ 1 LineChart.kt\ncom/patrykandpatrick/vico/core/chart/line/LineChart\n*L\n286#1:575,3\n502#1:587\n502#1:595\n435#1:578\n439#1:579\n443#1:580\n449#1:581\n453#1:582\n538#1:599\n541#1:600\n502#1:583,2\n502#1:585,2\n502#1:588\n502#1:589\n502#1:592\n502#1:593,2\n502#1:596\n502#1:597\n502#1:590\n534#1:598\n*E\n"})
public class LineChart
extends BaseChart<ChartEntryModel> {
    @NotNull
    private List<? extends LineSpec> lines;
    private float spacingDp;
    @Nullable
    private AxisPosition.Vertical targetVerticalAxisPosition;
    @NotNull
    private final Path linePath;
    @NotNull
    private final Path lineBackgroundPath;
    @NotNull
    private final MutableHorizontalDimensions horizontalDimensions;
    @NotNull
    private final HashMap<Float, List<Marker.EntryModel>> entryLocationMap;

    public LineChart(@NotNull List<? extends LineSpec> lines, float spacingDp, @Nullable AxisPosition.Vertical targetVerticalAxisPosition) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.lines = lines;
        this.spacingDp = spacingDp;
        this.targetVerticalAxisPosition = targetVerticalAxisPosition;
        this.linePath = new Path();
        this.lineBackgroundPath = new Path();
        this.horizontalDimensions = new MutableHorizontalDimensions(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 31, null);
        this.entryLocationMap = new HashMap();
    }

    public /* synthetic */ LineChart(List list, float f, AxisPosition.Vertical vertical, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.listOf((Object)new LineSpec(0, 0.0f, null, null, null, 0.0f, null, null, null, 0.0f, null, 2047, null));
        }
        if ((n & 2) != 0) {
            f = 32.0f;
        }
        if ((n & 4) != 0) {
            vertical = null;
        }
        this(list, f, vertical);
    }

    @NotNull
    public final List<LineSpec> getLines() {
        return this.lines;
    }

    public final void setLines(@NotNull List<? extends LineSpec> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.lines = list;
    }

    public final float getSpacingDp() {
        return this.spacingDp;
    }

    public final void setSpacingDp(float f) {
        this.spacingDp = f;
    }

    @Nullable
    public final AxisPosition.Vertical getTargetVerticalAxisPosition() {
        return this.targetVerticalAxisPosition;
    }

    public final void setTargetVerticalAxisPosition(@Nullable AxisPosition.Vertical vertical) {
        this.targetVerticalAxisPosition = vertical;
    }

    public LineChart(@NotNull LineSpec line, float spacingDp, @Nullable AxisPosition.Vertical targetVerticalAxisPosition) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this(CollectionsKt.listOf((Object)line), spacingDp, targetVerticalAxisPosition);
    }

    public /* synthetic */ LineChart(LineSpec lineSpec, float f, AxisPosition.Vertical vertical, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vertical = null;
        }
        this(lineSpec, f, vertical);
    }

    @NotNull
    protected final Path getLinePath() {
        return this.linePath;
    }

    @NotNull
    protected final Path getLineBackgroundPath() {
        return this.lineBackgroundPath;
    }

    @NotNull
    protected final MutableHorizontalDimensions getHorizontalDimensions() {
        return this.horizontalDimensions;
    }

    @NotNull
    public HashMap<Float, List<Marker.EntryModel>> getEntryLocationMap() {
        return this.entryLocationMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void drawChart(@NotNull ChartDrawContext context, @NotNull ChartEntryModel model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        ChartDrawContext $this$drawChart_u24lambda_u241 = context;
        boolean bl = false;
        this.resetTempData();
        Iterable $this$forEachIndexed$iv = model.getEntries();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entries;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int entryListIndex = n;
            boolean bl2 = false;
            this.linePath.rewind();
            this.lineBackgroundPath.rewind();
            LineSpec component = CollectionExtensionsKt.getRepeating(this.lines, entryListIndex);
            Ref.FloatRef prevX = new Ref.FloatRef();
            prevX.element = RectExtensionsKt.getStart(this.getBounds(), $this$drawChart_u24lambda_u241.isLtr());
            Ref.FloatRef prevY = new Ref.FloatRef();
            prevY.element = this.getBounds().bottom;
            float drawingStartAlignmentCorrection = $this$drawChart_u24lambda_u241.getLayoutDirectionMultiplier() * $this$drawChart_u24lambda_u241.getHorizontalDimensions().getStartPadding();
            float drawingStart = RectExtensionsKt.getStart(this.getBounds(), $this$drawChart_u24lambda_u241.isLtr()) + drawingStartAlignmentCorrection - $this$drawChart_u24lambda_u241.getHorizontalScroll();
            this.forEachPointWithinBoundsIndexed($this$drawChart_u24lambda_u241, (List<? extends ChartEntry>)entries, drawingStart, (Function6<? super Integer, ? super ChartEntry, ? super Float, ? super Float, ? super Float, ? super Float, Unit>)((Function6)new Function6<Integer, ChartEntry, Float, Float, Float, Float, Unit>(this, component, prevX, prevY, $this$drawChart_u24lambda_u241){
                final /* synthetic */ LineChart this$0;
                final /* synthetic */ LineSpec $component;
                final /* synthetic */ Ref.FloatRef $prevX;
                final /* synthetic */ Ref.FloatRef $prevY;
                final /* synthetic */ ChartDrawContext $this_with;
                {
                    this.this$0 = $receiver;
                    this.$component = $component;
                    this.$prevX = $prevX;
                    this.$prevY = $prevY;
                    this.$this_with = $receiver2;
                    super(6);
                }

                public final void invoke(int entryIndex, @NotNull ChartEntry entry, float x, float y, @Nullable Float f, @Nullable Float f2) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    if (this.this$0.getLinePath().isEmpty()) {
                        this.this$0.getLinePath().moveTo(x, y);
                        if (this.$component.getHasLineBackgroundShader()) {
                            this.this$0.getLineBackgroundPath().moveTo(x, this.this$0.getBounds().bottom);
                            this.this$0.getLineBackgroundPath().lineTo(x, y);
                        }
                    } else {
                        this.$component.getPointConnector().connect(this.this$0.getLinePath(), this.$prevX.element, this.$prevY.element, x, y, this.$this_with.getHorizontalDimensions(), this.this$0.getBounds());
                        if (this.$component.getHasLineBackgroundShader()) {
                            this.$component.getPointConnector().connect(this.this$0.getLineBackgroundPath(), this.$prevX.element, this.$prevY.element, x, y, this.$this_with.getHorizontalDimensions(), this.this$0.getBounds());
                        }
                    }
                    this.$prevX.element = x;
                    this.$prevY.element = y;
                    float f3 = this.this$0.getBounds().left;
                    boolean bl = x <= this.this$0.getBounds().right ? f3 <= x : false;
                    if (bl) {
                        ChartExtensionsKt.put((HashMap<Float, List<Marker.EntryModel>>)this.this$0.getEntryLocationMap(), x, RangesKt.coerceIn((float)y, (float)this.this$0.getBounds().top, (float)this.this$0.getBounds().bottom), entry, this.$component.getLineColor(), entryIndex);
                    }
                }
            }));
            if (component.getHasLineBackgroundShader()) {
                this.lineBackgroundPath.lineTo(prevX.element, this.getBounds().bottom);
                this.lineBackgroundPath.close();
                component.drawBackgroundLine(context, this.getBounds(), this.lineBackgroundPath);
            }
            component.drawLine(context, this.linePath);
            this.drawPointsAndDataLabels($this$drawChart_u24lambda_u241, component, (List<? extends ChartEntry>)entries, drawingStart);
        }
    }

    protected void drawPointsAndDataLabels(@NotNull ChartDrawContext $this$drawPointsAndDataLabels, @NotNull LineSpec lineSpec, @NotNull List<? extends ChartEntry> entries, float drawingStart) {
        Intrinsics.checkNotNullParameter((Object)$this$drawPointsAndDataLabels, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lineSpec, (String)"lineSpec");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        if (lineSpec.getPoint() == null && lineSpec.getDataLabel() == null) {
            return;
        }
        MutableChartValues chartValues = $this$drawPointsAndDataLabels.getChartValuesManager().getChartValues(this.targetVerticalAxisPosition);
        this.forEachPointWithinBoundsIndexed($this$drawPointsAndDataLabels, entries, drawingStart, (Function6<? super Integer, ? super ChartEntry, ? super Float, ? super Float, ? super Float, ? super Float, Unit>)((Function6)new Function6<Integer, ChartEntry, Float, Float, Float, Float, Unit>(lineSpec, $this$drawPointsAndDataLabels, chartValues, this){
            final /* synthetic */ LineSpec $lineSpec;
            final /* synthetic */ ChartDrawContext $this_drawPointsAndDataLabels;
            final /* synthetic */ MutableChartValues $chartValues;
            final /* synthetic */ LineChart this$0;
            {
                this.$lineSpec = $lineSpec;
                this.$this_drawPointsAndDataLabels = $receiver;
                this.$chartValues = $chartValues;
                this.this$0 = $receiver2;
                super(6);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(int n, @NotNull ChartEntry chartEntry, float x, float y, @Nullable Float previousX, @Nullable Float nextX) {
                block6: {
                    float f;
                    void $this$half$iv;
                    TextComponent textComponent2;
                    Intrinsics.checkNotNullParameter((Object)chartEntry, (String)"chartEntry");
                    if (this.$lineSpec.getPoint() != null) {
                        this.$lineSpec.drawPoint(this.$this_drawPointsAndDataLabels, x, y);
                    }
                    TextComponent textComponent3 = this.$lineSpec.getDataLabel();
                    ChartDrawContext chartDrawContext2 = this.$this_drawPointsAndDataLabels;
                    Object object = this.$chartValues;
                    TextComponent it = textComponent3;
                    boolean bl = false;
                    TextComponent textComponent4 = textComponent2 = chartDrawContext2.getHorizontalLayout() instanceof HorizontalLayout.Segmented || !(chartEntry.getX() == ((MutableChartValues)object).getMinX()) && !(chartEntry.getX() == ((MutableChartValues)object).getMaxX()) || chartEntry.getX() == ((MutableChartValues)object).getMinX() && chartDrawContext2.getHorizontalDimensions().getStartPadding() > 0.0f || chartEntry.getX() == ((MutableChartValues)object).getMaxX() && chartDrawContext2.getHorizontalDimensions().getEndPadding() > 0.0f ? textComponent3 : null;
                    if (textComponent2 == null) break block6;
                    textComponent3 = textComponent2;
                    chartDrawContext2 = this.$this_drawPointsAndDataLabels;
                    object = this.$lineSpec;
                    MutableChartValues mutableChartValues = this.$chartValues;
                    LineChart lineChart = this.this$0;
                    TextComponent textComponent5 = textComponent3;
                    boolean bl2 = false;
                    float f2 = ((LineSpec)object).getLineThicknessDp();
                    Object $this$pointSizeDpOrZero$iv22 = object;
                    boolean $i$f$getPointSizeDpOrZero = false;
                    float $this$pointSizeDpOrZero$iv22 = ((LineSpec)$this$pointSizeDpOrZero$iv22).getPoint() != null ? ((LineSpec)$this$pointSizeDpOrZero$iv22).getPointSizeDp() : 0.0f;
                    f2 = Math.max(f2, $this$pointSizeDpOrZero$iv22);
                    boolean $i$f$getHalf = false;
                    float distanceFromLine = chartDrawContext2.getPixels((float)($this$half$iv / (float)2));
                    CharSequence text = ((LineSpec)object).getDataLabelValueFormatter().formatValue(chartEntry.getY(), mutableChartValues);
                    int maxWidth = lineChart.getMaxDataLabelWidth(chartDrawContext2, chartEntry, x, previousX, nextX);
                    VerticalPosition verticalPosition = VerticalPositionExtensionsKt.inBounds(((LineSpec)object).getDataLabelVerticalPosition(), lineChart.getBounds(), distanceFromLine, TextComponent.getHeight$default(textComponent5, chartDrawContext2, text, maxWidth, 0, ((LineSpec)object).getDataLabelRotationDegrees(), 8, null), y);
                    switch (drawPointsAndDataLabels.WhenMappings.$EnumSwitchMapping$0[verticalPosition.ordinal()]) {
                        case 1: {
                            f = -distanceFromLine;
                            break;
                        }
                        case 2: {
                            f = 0.0f;
                            break;
                        }
                        case 3: {
                            f = distanceFromLine;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    float dataLabelY = y + f;
                    float f3 = ((LineSpec)object).getDataLabelRotationDegrees();
                    TextComponent.drawText$default(textComponent5, chartDrawContext2, text, x, dataLabelY, null, verticalPosition, maxWidth, 0, f3, 144, null);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    protected final int getMaxDataLabelWidth(@NotNull ChartDrawContext $this$getMaxDataLabelWidth, @NotNull ChartEntry entry, float x, @Nullable Float previousX, @Nullable Float nextX) {
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$getMaxDataLabelWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        MutableChartValues chartValues = $this$getMaxDataLabelWidth.getChartValuesManager().getChartValues(this.targetVerticalAxisPosition);
        if (previousX != null && nextX != null) {
            f = Math.min(x - previousX.floatValue(), nextX.floatValue() - x);
        } else if (previousX == null && nextX == null) {
            void $this$doubled$iv;
            float f2 = Math.min($this$getMaxDataLabelWidth.getHorizontalDimensions().getStartPadding(), $this$getMaxDataLabelWidth.getHorizontalDimensions().getEndPadding());
            boolean $i$f$getDoubled22 = false;
            f = $this$doubled$iv * (float)2;
        } else if (nextX != null) {
            void $this$doubled$iv22;
            float f3;
            HorizontalLayout $i$f$getDoubled22 = $this$getMaxDataLabelWidth.getHorizontalLayout();
            if ($i$f$getDoubled22 instanceof HorizontalLayout.Segmented) {
                float $this$half$iv = $this$getMaxDataLabelWidth.getHorizontalDimensions().getXSpacing();
                boolean $i$f$getHalf = false;
                f3 = $this$half$iv / (float)2;
            } else if ($i$f$getDoubled22 instanceof HorizontalLayout.FullWidth) {
                f3 = $this$getMaxDataLabelWidth.getHorizontalDimensions().getStartPadding();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            float extraSpace = f3;
            float $i$f$getDoubled22 = (entry.getX() - chartValues.getMinX()) / chartValues.getXStep() * $this$getMaxDataLabelWidth.getHorizontalDimensions().getXSpacing() + extraSpace;
            boolean $i$f$getDoubled = false;
            f = RangesKt.coerceAtMost((float)($this$doubled$iv22 * (float)2), (float)(nextX.floatValue() - x));
        } else {
            float f4;
            HorizontalLayout $this$doubled$iv22 = $this$getMaxDataLabelWidth.getHorizontalLayout();
            if ($this$doubled$iv22 instanceof HorizontalLayout.Segmented) {
                float $this$half$iv = $this$getMaxDataLabelWidth.getHorizontalDimensions().getXSpacing();
                boolean $i$f$getHalf = false;
                f4 = $this$half$iv / (float)2;
            } else if ($this$doubled$iv22 instanceof HorizontalLayout.FullWidth) {
                f4 = $this$getMaxDataLabelWidth.getHorizontalDimensions().getEndPadding();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            float extraSpace = f4;
            float $this$doubled$iv22 = (chartValues.getMaxX() - entry.getX()) / chartValues.getXStep() * $this$getMaxDataLabelWidth.getHorizontalDimensions().getXSpacing() + extraSpace;
            boolean $i$f$getDoubled = false;
            float f5 = $this$doubled$iv22 * (float)2;
            Float f6 = previousX;
            Intrinsics.checkNotNull((Object)f6);
            f = RangesKt.coerceAtMost((float)f5, (float)(x - f6.floatValue()));
        }
        return (int)f;
    }

    protected final void resetTempData() {
        ((HashMap)this.getEntryLocationMap()).clear();
        this.linePath.rewind();
        this.lineBackgroundPath.rewind();
    }

    /*
     * WARNING - void declaration
     */
    protected void forEachPointWithinBoundsIndexed(@NotNull ChartDrawContext $this$forEachPointWithinBoundsIndexed, @NotNull List<? extends ChartEntry> entries, float drawingStart, @NotNull Function6<? super Integer, ? super ChartEntry, ? super Float, ? super Float, ? super Float, ? super Float, Unit> action) {
        void $this$forEachInRelativelyIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)$this$forEachPointWithinBoundsIndexed, (String)"<this>");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        MutableChartValues chartValues = $this$forEachPointWithinBoundsIndexed.getChartValuesManager().getChartValues(this.targetVerticalAxisPosition);
        float minX2 = chartValues.getMinX();
        float maxX2 = chartValues.getMaxX();
        float minY2 = chartValues.getMinY();
        float maxY2 = chartValues.getMaxY();
        float xStep = chartValues.getXStep();
        float x = 0.0f;
        x = Float.NEGATIVE_INFINITY;
        Ref.ObjectRef nextX = new Ref.ObjectRef();
        float y = 0.0f;
        Object prevEntry = null;
        Object lastEntry = null;
        float heightMultiplier = this.getBounds().height() / (maxY2 - minY2);
        float boundsStart = RectExtensionsKt.getStart(this.getBounds(), $this$forEachPointWithinBoundsIndexed.isLtr());
        float boundsEnd = boundsStart + $this$forEachPointWithinBoundsIndexed.getLayoutDirectionMultiplier() * this.getBounds().width();
        List<? extends ChartEntry> list = entries;
        ClosedFloatingPointRange range$iv = RangesKt.rangeTo((float)(minX2 - xStep), (float)(maxX2 + xStep));
        boolean $i$f$forEachInRelativelyIndexed = false;
        int relativeIndex$iv = 0;
        void $this$forEachInAbsolutelyIndexed$iv$iv = $this$forEachInRelativelyIndexed$iv;
        boolean $i$f$forEachInAbsolutelyIndexed = false;
        int index$iv$iv = 0;
        Iterable $this$forEach$iv$iv$iv = (Iterable)$this$forEachInAbsolutelyIndexed$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            ChartEntry entry$iv$iv = (ChartEntry)element$iv$iv$iv;
            boolean bl = false;
            if (range$iv.contains((Comparable)Float.valueOf(entry$iv$iv.getX()))) {
                Float f;
                void next;
                void entry;
                ChartEntry chartEntry;
                void entry$iv;
                ChartEntry chartEntry2 = entry$iv$iv;
                int absoluteIndex$iv = index$iv$iv;
                boolean bl2 = false;
                int n = relativeIndex$iv;
                relativeIndex$iv = n + 1;
                int n2 = n;
                void v1 = entry$iv;
                if ((ChartEntry)CollectionsKt.getOrNull((List)$this$forEachInRelativelyIndexed$iv, (int)(absoluteIndex$iv + 1)) != null) {
                    void it$iv;
                    ChartEntry chartEntry3;
                    ChartEntry chartEntry4 = chartEntry3;
                    void var38_38 = v1;
                    int n3 = n2;
                    boolean bl3 = false;
                    boolean bl4 = range$iv.contains((Comparable)Float.valueOf(it$iv.getX()));
                    n2 = n3;
                    v1 = var38_38;
                    chartEntry = bl4 ? chartEntry3 : null;
                } else {
                    chartEntry = null;
                }
                ChartEntry chartEntry5 = chartEntry;
                void var43_43 = v1;
                int index = n2;
                boolean bl5 = false;
                Float f2 = Float.valueOf(x);
                float it = ((Number)f2).floatValue();
                boolean bl6 = false;
                float f3 = it;
                Float previousX = !Float.isInfinite(f3) && !Float.isNaN(f3) ? f2 : null;
                Float f4 = (Float)nextX.element;
                x = f4 != null ? f4.floatValue() : LineChart.forEachPointWithinBoundsIndexed$getDrawX(drawingStart, $this$forEachPointWithinBoundsIndexed, minX2, xStep, (ChartEntry)entry);
                Ref.ObjectRef objectRef = nextX;
                if (next != null) {
                    void p0;
                    Ref.ObjectRef objectRef2 = objectRef;
                    boolean bl7 = false;
                    f = Float.valueOf(LineChart.forEachPointWithinBoundsIndexed$getDrawX(drawingStart, $this$forEachPointWithinBoundsIndexed, minX2, xStep, (ChartEntry)p0));
                    objectRef = objectRef2;
                } else {
                    f = null;
                }
                objectRef.element = f;
                y = LineChart.forEachPointWithinBoundsIndexed$getDrawY(this, minY2, heightMultiplier, (ChartEntry)entry);
                if ($this$forEachPointWithinBoundsIndexed.isLtr() && x < boundsStart || !$this$forEachPointWithinBoundsIndexed.isLtr() && x > boundsStart) {
                    prevEntry = entry;
                } else if (NumberExtensionsKt.rangeWith(boundsStart, boundsEnd).contains((Comparable)Float.valueOf(x))) {
                    if (prevEntry != null) {
                        Object var47_49;
                        Object it2 = var47_49;
                        boolean bl8 = false;
                        action.invoke((Object)index, it2, (Object)Float.valueOf(LineChart.forEachPointWithinBoundsIndexed$getDrawX(drawingStart, $this$forEachPointWithinBoundsIndexed, minX2, xStep, it2)), (Object)Float.valueOf(LineChart.forEachPointWithinBoundsIndexed$getDrawY(this, minY2, heightMultiplier, it2)), (Object)previousX, nextX.element);
                        prevEntry = null;
                    }
                    action.invoke((Object)index, (Object)entry, (Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)previousX, nextX.element);
                } else if (($this$forEachPointWithinBoundsIndexed.isLtr() && x > boundsEnd || !$this$forEachPointWithinBoundsIndexed.isLtr() && x < boundsEnd) && lastEntry == null) {
                    action.invoke((Object)index, (Object)entry, (Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)previousX, nextX.element);
                    lastEntry = entry;
                }
            }
            ++index$iv$iv;
        }
    }

    @Override
    @NotNull
    public HorizontalDimensions getHorizontalDimensions(@NotNull MeasureContext context, @NotNull ChartEntryModel model) {
        boolean $i$f$getHalf;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MeasureContext $this$getHorizontalDimensions_u24lambda_u247 = context;
        boolean bl = false;
        Object object = this.lines;
        MeasureContext measureContext = $this$getHorizontalDimensions_u24lambda_u247;
        Iterator iterator = object.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        LineSpec it22 = (LineSpec)iterator.next();
        boolean bl2 = false;
        LineSpec $this$pointSizeDpOrZero$iv = it22;
        boolean $i$f$getPointSizeDpOrZero = false;
        float it22 = $this$pointSizeDpOrZero$iv.getPoint() != null ? $this$pointSizeDpOrZero$iv.getPointSizeDp() : 0.0f;
        while (iterator.hasNext()) {
            LineSpec it32 = (LineSpec)iterator.next();
            $i$a$-maxOf-LineChart$getHorizontalDimensions$1$maxPointSize$1 = false;
            LineSpec $this$pointSizeDpOrZero$iv2 = it32;
            boolean $i$f$getPointSizeDpOrZero2 = false;
            float it32 = $this$pointSizeDpOrZero$iv2.getPoint() != null ? $this$pointSizeDpOrZero$iv2.getPointSizeDp() : 0.0f;
            it22 = Math.max(it22, it32);
        }
        float f = it22;
        float maxPointSize = measureContext.getPixels(f);
        Object $this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246 = object = this.horizontalDimensions;
        boolean bl3 = false;
        ((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).setXSpacing(maxPointSize + $this$getHorizontalDimensions_u24lambda_u247.getPixels(this.spacingDp));
        HorizontalLayout horizontalLayout = $this$getHorizontalDimensions_u24lambda_u247.getHorizontalLayout();
        if (horizontalLayout instanceof HorizontalLayout.Segmented) {
            float $this$half$iv = ((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).getXSpacing();
            $i$f$getHalf = false;
            ((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).setScalableStartPadding($this$half$iv / (float)2);
        } else if (horizontalLayout instanceof HorizontalLayout.FullWidth) {
            ((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).setScalableStartPadding($this$getHorizontalDimensions_u24lambda_u247.getPixels(((HorizontalLayout.FullWidth)horizontalLayout).getStartPaddingDp()));
            float $this$half$iv = maxPointSize;
            $i$f$getHalf = false;
            ((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).setUnscalableStartPadding($this$half$iv / (float)2);
            ((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).setUnscalableEndPadding(((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).getUnscalableStartPadding());
        }
        ((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).setScalableEndPadding(((MutableHorizontalDimensions)$this$getHorizontalDimensions_u24lambda_u247_u24lambda_u246).getScalableStartPadding());
        return (HorizontalDimensions)object;
    }

    @Override
    public void updateChartValues(@NotNull ChartValuesManager chartValuesManager, @NotNull ChartEntryModel model, @Nullable Float xStep) {
        float f;
        Object object;
        float f2;
        Object object2;
        float f3;
        Object object3;
        float f4;
        Intrinsics.checkNotNullParameter((Object)chartValuesManager, (String)"chartValuesManager");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        AxisValuesOverrider axisValuesOverrider = this.getAxisValuesOverrider();
        if (axisValuesOverrider != null && (axisValuesOverrider = axisValuesOverrider.getMinX(model)) != null) {
            f4 = ((Float)((Object)axisValuesOverrider)).floatValue();
        } else {
            Float f5 = this.getMinX();
            f4 = f5 != null ? f5.floatValue() : model.getMinX();
        }
        if ((object3 = this.getAxisValuesOverrider()) != null && (object3 = object3.getMaxX(model)) != null) {
            f3 = ((Float)object3).floatValue();
        } else {
            Float f6 = this.getMaxX();
            f3 = f6 != null ? f6.floatValue() : model.getMaxX();
        }
        if ((object2 = this.getAxisValuesOverrider()) != null && (object2 = object2.getMinY(model)) != null) {
            f2 = ((Float)object2).floatValue();
        } else {
            Float f7 = this.getMinY();
            f2 = f7 != null ? f7.floatValue() : Math.min(model.getMinY(), 0.0f);
        }
        if ((object = this.getAxisValuesOverrider()) != null && (object = object.getMaxY(model)) != null) {
            f = ((Float)object).floatValue();
        } else {
            Float f8 = this.getMaxY();
            f = f8 != null ? f8.floatValue() : model.getMaxY();
        }
        Float f9 = xStep;
        chartValuesManager.tryUpdate(f4, f3, f2, f, f9 != null ? f9.floatValue() : model.getXGcd(), model, this.targetVerticalAxisPosition);
    }

    @Override
    public void getInsets(@NotNull MeasureContext context, @NotNull Insets outInsets, @NotNull HorizontalDimensions horizontalDimensions) {
        float f;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)outInsets, (String)"outInsets");
        Intrinsics.checkNotNullParameter((Object)horizontalDimensions, (String)"horizontalDimensions");
        MeasureContext $this$getInsets_u24lambda_u249 = context;
        boolean bl = false;
        Iterable iterable = this.lines;
        MeasureContext measureContext = $this$getInsets_u24lambda_u249;
        Insets insets = outInsets;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        LineSpec it = (LineSpec)iterator.next();
        boolean bl2 = false;
        float f2 = f = it.getPoint() != null ? Math.max(it.getLineThicknessDp(), it.getPointSizeDp()) : it.getLineThicknessDp();
        while (iterator.hasNext()) {
            LineSpec it2 = (LineSpec)iterator.next();
            $i$a$-maxOf-LineChart$getInsets$1$1 = false;
            float f3 = it2.getPoint() != null ? Math.max(it2.getLineThicknessDp(), it2.getPointSizeDp()) : it2.getLineThicknessDp();
            f = Math.max(f, f3);
        }
        float f4 = f;
        insets.setVertical(measureContext.getPixels(f4));
    }

    private static final float forEachPointWithinBoundsIndexed$getDrawX(float $drawingStart, ChartDrawContext $this_forEachPointWithinBoundsIndexed, float minX2, float xStep, ChartEntry entry) {
        return $drawingStart + $this_forEachPointWithinBoundsIndexed.getLayoutDirectionMultiplier() * $this_forEachPointWithinBoundsIndexed.getHorizontalDimensions().getXSpacing() * (entry.getX() - minX2) / xStep;
    }

    private static final float forEachPointWithinBoundsIndexed$getDrawY(LineChart this$0, float minY2, float heightMultiplier, ChartEntry entry) {
        return this$0.getBounds().bottom - (entry.getY() - minY2) * heightMultiplier;
    }

    public LineChart() {
        this((List)null, 0.0f, (AxisPosition.Vertical)null, 7, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001_By\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0015By\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZJ\u0016\u0010[\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010Y\u001a\u00020ZJ\u001e\u0010\\\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R+\u0010\u0002\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?*\u0004\b:\u0010;R\u0014\u0010@\u001a\u00020.X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00100R+\u0010B\u001a\u00020\t2\u0006\u00109\u001a\u00020\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bC\u00106\"\u0004\bD\u00108R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u001e\"\u0004\bH\u0010 R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u001e\"\u0004\bR\u0010 \u00a8\u0006`"}, d2={"Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec;", "", "lineColor", "", "lineThicknessDp", "", "lineBackgroundShader", "Lcom/patrykandpatrick/vico/core/component/shape/shader/DynamicShader;", "lineCap", "Landroid/graphics/Paint$Cap;", "cubicStrength", "point", "Lcom/patrykandpatrick/vico/core/component/Component;", "pointSizeDp", "dataLabel", "Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "dataLabelVerticalPosition", "Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;", "dataLabelValueFormatter", "Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;", "dataLabelRotationDegrees", "(IFLcom/patrykandpatrick/vico/core/component/shape/shader/DynamicShader;Landroid/graphics/Paint$Cap;FLcom/patrykandpatrick/vico/core/component/Component;FLcom/patrykandpatrick/vico/core/component/text/TextComponent;Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;F)V", "pointConnector", "Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec$PointConnector;", "(IFLcom/patrykandpatrick/vico/core/component/shape/shader/DynamicShader;Landroid/graphics/Paint$Cap;Lcom/patrykandpatrick/vico/core/component/Component;FLcom/patrykandpatrick/vico/core/component/text/TextComponent;Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;FLcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec$PointConnector;)V", "getDataLabel", "()Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "setDataLabel", "(Lcom/patrykandpatrick/vico/core/component/text/TextComponent;)V", "getDataLabelRotationDegrees", "()F", "setDataLabelRotationDegrees", "(F)V", "getDataLabelValueFormatter", "()Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;", "setDataLabelValueFormatter", "(Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;)V", "getDataLabelVerticalPosition", "()Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;", "setDataLabelVerticalPosition", "(Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;)V", "hasLineBackgroundShader", "", "getHasLineBackgroundShader", "()Z", "lineBackgroundPaint", "Landroid/graphics/Paint;", "getLineBackgroundPaint", "()Landroid/graphics/Paint;", "getLineBackgroundShader", "()Lcom/patrykandpatrick/vico/core/component/shape/shader/DynamicShader;", "setLineBackgroundShader", "(Lcom/patrykandpatrick/vico/core/component/shape/shader/DynamicShader;)V", "getLineCap", "()Landroid/graphics/Paint$Cap;", "setLineCap", "(Landroid/graphics/Paint$Cap;)V", "<set-?>", "getLineColor$delegate", "(Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec;)Ljava/lang/Object;", "getLineColor", "()I", "setLineColor", "(I)V", "linePaint", "getLinePaint", "lineStrokeCap", "getLineStrokeCap", "setLineStrokeCap", "lineStrokeCap$delegate", "Lkotlin/reflect/KMutableProperty0;", "getLineThicknessDp", "setLineThicknessDp", "getPoint", "()Lcom/patrykandpatrick/vico/core/component/Component;", "setPoint", "(Lcom/patrykandpatrick/vico/core/component/Component;)V", "getPointConnector", "()Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec$PointConnector;", "setPointConnector", "(Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec$PointConnector;)V", "getPointSizeDp", "setPointSizeDp", "drawBackgroundLine", "", "context", "Lcom/patrykandpatrick/vico/core/context/DrawContext;", "bounds", "Landroid/graphics/RectF;", "path", "Landroid/graphics/Path;", "drawLine", "drawPoint", "x", "y", "PointConnector", "core_release"})
    @SourceDebugExtension(value={"SMAP\nLineChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChart.kt\ncom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec\n+ 2 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n*L\n1#1,574:1\n63#2:575\n*S KotlinDebug\n*F\n+ 1 LineChart.kt\ncom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec\n*L\n214#1:575\n*E\n"})
    public static class LineSpec {
        private float lineThicknessDp;
        @Nullable
        private DynamicShader lineBackgroundShader;
        @NotNull
        private Paint.Cap lineCap;
        @Nullable
        private Component point;
        private float pointSizeDp;
        @Nullable
        private TextComponent dataLabel;
        @NotNull
        private VerticalPosition dataLabelVerticalPosition;
        @NotNull
        private ValueFormatter dataLabelValueFormatter;
        private float dataLabelRotationDegrees;
        @NotNull
        private PointConnector pointConnector;
        @NotNull
        private final Paint linePaint;
        @NotNull
        private final Paint lineBackgroundPaint;
        @NotNull
        private final KMutableProperty0 lineStrokeCap$delegate;

        /*
         * WARNING - void declaration
         */
        public LineSpec(int lineColor, float lineThicknessDp, @Nullable DynamicShader lineBackgroundShader, @NotNull Paint.Cap lineCap, @Nullable Component point, float pointSizeDp, @Nullable TextComponent dataLabel, @NotNull VerticalPosition dataLabelVerticalPosition, @NotNull ValueFormatter dataLabelValueFormatter, float dataLabelRotationDegrees, @NotNull PointConnector pointConnector) {
            void $this$linePaint_u24lambda_u240;
            Paint paint;
            Intrinsics.checkNotNullParameter((Object)lineCap, (String)"lineCap");
            Intrinsics.checkNotNullParameter((Object)((Object)dataLabelVerticalPosition), (String)"dataLabelVerticalPosition");
            Intrinsics.checkNotNullParameter((Object)dataLabelValueFormatter, (String)"dataLabelValueFormatter");
            Intrinsics.checkNotNullParameter((Object)pointConnector, (String)"pointConnector");
            this.lineThicknessDp = lineThicknessDp;
            this.lineBackgroundShader = lineBackgroundShader;
            this.lineCap = lineCap;
            this.point = point;
            this.pointSizeDp = pointSizeDp;
            this.dataLabel = dataLabel;
            this.dataLabelVerticalPosition = dataLabelVerticalPosition;
            this.dataLabelValueFormatter = dataLabelValueFormatter;
            this.dataLabelRotationDegrees = dataLabelRotationDegrees;
            this.pointConnector = pointConnector;
            Paint paint2 = paint = new Paint(1);
            LineSpec lineSpec = this;
            boolean bl = false;
            $this$linePaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
            $this$linePaint_u24lambda_u240.setColor(lineColor);
            $this$linePaint_u24lambda_u240.setStrokeCap(this.lineCap);
            lineSpec.linePaint = paint;
            this.lineBackgroundPaint = new Paint(1);
            this.lineStrokeCap$delegate = (KMutableProperty0)new MutablePropertyReference0Impl(this.linePaint){

                @Nullable
                public Object get() {
                    return ((Paint)this.receiver).getStrokeCap();
                }

                public void set(@Nullable Object value) {
                    ((Paint)this.receiver).setStrokeCap((Paint.Cap)value);
                }
            };
        }

        public /* synthetic */ LineSpec(int n, float f, DynamicShader dynamicShader, Paint.Cap cap, Component component, float f2, TextComponent textComponent2, VerticalPosition verticalPosition, ValueFormatter valueFormatter, float f3, PointConnector pointConnector, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = -3355444;
            }
            if ((n2 & 2) != 0) {
                f = 2.0f;
            }
            if ((n2 & 4) != 0) {
                dynamicShader = null;
            }
            if ((n2 & 8) != 0) {
                cap = Paint.Cap.ROUND;
            }
            if ((n2 & 0x10) != 0) {
                component = null;
            }
            if ((n2 & 0x20) != 0) {
                f2 = 16.0f;
            }
            if ((n2 & 0x40) != 0) {
                textComponent2 = null;
            }
            if ((n2 & 0x80) != 0) {
                verticalPosition = VerticalPosition.Top;
            }
            if ((n2 & 0x100) != 0) {
                valueFormatter = new DecimalFormatValueFormatter();
            }
            if ((n2 & 0x200) != 0) {
                f3 = 0.0f;
            }
            if ((n2 & 0x400) != 0) {
                pointConnector = new DefaultPointConnector(0.0f, 1, null);
            }
            this(n, f, dynamicShader, cap, component, f2, textComponent2, verticalPosition, valueFormatter, f3, pointConnector);
        }

        public final float getLineThicknessDp() {
            return this.lineThicknessDp;
        }

        public final void setLineThicknessDp(float f) {
            this.lineThicknessDp = f;
        }

        @Nullable
        public final DynamicShader getLineBackgroundShader() {
            return this.lineBackgroundShader;
        }

        public final void setLineBackgroundShader(@Nullable DynamicShader dynamicShader) {
            this.lineBackgroundShader = dynamicShader;
        }

        @NotNull
        public final Paint.Cap getLineCap() {
            return this.lineCap;
        }

        public final void setLineCap(@NotNull Paint.Cap cap) {
            Intrinsics.checkNotNullParameter((Object)cap, (String)"<set-?>");
            this.lineCap = cap;
        }

        @Nullable
        public final Component getPoint() {
            return this.point;
        }

        public final void setPoint(@Nullable Component component) {
            this.point = component;
        }

        public final float getPointSizeDp() {
            return this.pointSizeDp;
        }

        public final void setPointSizeDp(float f) {
            this.pointSizeDp = f;
        }

        @Nullable
        public final TextComponent getDataLabel() {
            return this.dataLabel;
        }

        public final void setDataLabel(@Nullable TextComponent textComponent2) {
            this.dataLabel = textComponent2;
        }

        @NotNull
        public final VerticalPosition getDataLabelVerticalPosition() {
            return this.dataLabelVerticalPosition;
        }

        public final void setDataLabelVerticalPosition(@NotNull VerticalPosition verticalPosition) {
            Intrinsics.checkNotNullParameter((Object)((Object)verticalPosition), (String)"<set-?>");
            this.dataLabelVerticalPosition = verticalPosition;
        }

        @NotNull
        public final ValueFormatter getDataLabelValueFormatter() {
            return this.dataLabelValueFormatter;
        }

        public final void setDataLabelValueFormatter(@NotNull ValueFormatter valueFormatter) {
            Intrinsics.checkNotNullParameter((Object)valueFormatter, (String)"<set-?>");
            this.dataLabelValueFormatter = valueFormatter;
        }

        public final float getDataLabelRotationDegrees() {
            return this.dataLabelRotationDegrees;
        }

        public final void setDataLabelRotationDegrees(float f) {
            this.dataLabelRotationDegrees = f;
        }

        @NotNull
        public final PointConnector getPointConnector() {
            return this.pointConnector;
        }

        public final void setPointConnector(@NotNull PointConnector pointConnector) {
            Intrinsics.checkNotNullParameter((Object)pointConnector, (String)"<set-?>");
            this.pointConnector = pointConnector;
        }

        @Deprecated(message="Rather than using this constructor and its `cubicStrength` parameter, use the primary\n                constructor and provide a `DefaultPointConnector` instance with a custom `cubicStrength` via the\n                `pointConnector` parameter.", replaceWith=@ReplaceWith(expression="LineSpec(\n                        lineColor = lineColor,\n                        lineThicknessDp = lineThicknessDp,\n                        lineBackgroundShader = lineBackgroundShader,\n                        lineCap = lineCap,\n                        point = point,\n                        pointSizeDp = pointSizeDp,\n                        dataLabel = dataLabel,\n                        dataLabelVerticalPosition = dataLabelVerticalPosition,\n                        dataLabelValueFormatter = dataLabelValueFormatter,\n                        dataLabelRotationDegrees = dataLabelRotationDegrees,\n                        pointConnector = DefaultPointConnector(cubicStrength = cubicStrength),\n                    )", imports={"com.patrykandpatrick.vico.core.chart.DefaultPointConnector"}), level=DeprecationLevel.ERROR)
        public LineSpec(int lineColor, float lineThicknessDp, @Nullable DynamicShader lineBackgroundShader, @NotNull Paint.Cap lineCap, float cubicStrength, @Nullable Component point, float pointSizeDp, @Nullable TextComponent dataLabel, @NotNull VerticalPosition dataLabelVerticalPosition, @NotNull ValueFormatter dataLabelValueFormatter, float dataLabelRotationDegrees) {
            Intrinsics.checkNotNullParameter((Object)lineCap, (String)"lineCap");
            Intrinsics.checkNotNullParameter((Object)((Object)dataLabelVerticalPosition), (String)"dataLabelVerticalPosition");
            Intrinsics.checkNotNullParameter((Object)dataLabelValueFormatter, (String)"dataLabelValueFormatter");
            this(lineColor, lineThicknessDp, lineBackgroundShader, lineCap, point, pointSizeDp, dataLabel, dataLabelVerticalPosition, dataLabelValueFormatter, dataLabelRotationDegrees, new DefaultPointConnector(cubicStrength));
        }

        public /* synthetic */ LineSpec(int n, float f, DynamicShader dynamicShader, Paint.Cap cap, float f2, Component component, float f3, TextComponent textComponent2, VerticalPosition verticalPosition, ValueFormatter valueFormatter, float f4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = -3355444;
            }
            if ((n2 & 2) != 0) {
                f = 2.0f;
            }
            if ((n2 & 4) != 0) {
                dynamicShader = null;
            }
            if ((n2 & 8) != 0) {
                cap = Paint.Cap.ROUND;
            }
            if ((n2 & 0x20) != 0) {
                component = null;
            }
            if ((n2 & 0x40) != 0) {
                f3 = 16.0f;
            }
            if ((n2 & 0x80) != 0) {
                textComponent2 = null;
            }
            if ((n2 & 0x100) != 0) {
                verticalPosition = VerticalPosition.Top;
            }
            if ((n2 & 0x200) != 0) {
                valueFormatter = new DecimalFormatValueFormatter();
            }
            if ((n2 & 0x400) != 0) {
                f4 = 0.0f;
            }
            this(n, f, dynamicShader, cap, f2, component, f3, textComponent2, verticalPosition, valueFormatter, f4);
        }

        public final boolean getHasLineBackgroundShader() {
            return this.lineBackgroundShader != null;
        }

        @NotNull
        protected final Paint getLinePaint() {
            return this.linePaint;
        }

        @NotNull
        protected final Paint getLineBackgroundPaint() {
            return this.lineBackgroundPaint;
        }

        public final int getLineColor() {
            return this.linePaint.getColor();
        }

        public final void setLineColor(int n) {
            this.linePaint.setColor(n);
        }

        private static Object getLineColor$delegate(LineSpec lineSpec) {
            return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)lineSpec.linePaint, Paint.class, "color", "getColor()I", 2)));
        }

        @NotNull
        public final Paint.Cap getLineStrokeCap() {
            KProperty0 kProperty0 = (KProperty0)this.lineStrokeCap$delegate;
            Object object = kProperty0.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Paint.Cap)object;
        }

        public final void setLineStrokeCap(@NotNull Paint.Cap cap) {
            Intrinsics.checkNotNullParameter((Object)cap, (String)"<set-?>");
            KMutableProperty0 kMutableProperty0 = this.lineStrokeCap$delegate;
            kMutableProperty0.set((Object)cap);
        }

        public final void drawPoint(@NotNull DrawContext context, float x, float y) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                DrawContext $this$drawPoint_u24lambda_u241 = context;
                boolean bl = false;
                Component component = this.point;
                if (component == null) break block0;
                float $this$half$iv = $this$drawPoint_u24lambda_u241.getPixels(this.pointSizeDp);
                boolean $i$f$getHalf = false;
                LineChartExtensionsKt.drawPoint(component, context, x, y, $this$half$iv / (float)2);
            }
        }

        public final void drawLine(@NotNull DrawContext context, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            DrawContext $this$drawLine_u24lambda_u242 = context;
            boolean bl = false;
            this.linePaint.setStrokeWidth($this$drawLine_u24lambda_u242.getPixels(this.lineThicknessDp));
            $this$drawLine_u24lambda_u242.getCanvas().drawPath(path, this.linePaint);
        }

        public final void drawBackgroundLine(@NotNull DrawContext context, @NotNull RectF bounds, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            DrawContext $this$drawBackgroundLine_u24lambda_u243 = context;
            boolean bl = false;
            DynamicShader dynamicShader = this.lineBackgroundShader;
            this.lineBackgroundPaint.setShader(dynamicShader != null ? dynamicShader.provideShader(context, bounds.left, bounds.top, bounds.right, bounds.bottom) : null);
            $this$drawBackgroundLine_u24lambda_u243.getCanvas().drawPath(path, this.lineBackgroundPaint);
        }

        public LineSpec() {
            this(0, 0.0f, null, null, null, 0.0f, null, null, null, 0.0f, null, 2047, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J@\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/patrykandpatrick/vico/core/chart/line/LineChart$LineSpec$PointConnector;", "", "connect", "", "path", "Landroid/graphics/Path;", "prevX", "", "prevY", "x", "y", "horizontalDimensions", "Lcom/patrykandpatrick/vico/core/chart/dimensions/HorizontalDimensions;", "bounds", "Landroid/graphics/RectF;", "core_release"})
        public static interface PointConnector {
            public void connect(@NotNull Path var1, float var2, float var3, float var4, float var5, @NotNull HorizontalDimensions var6, @NotNull RectF var7);
        }
    }
}

