/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.chart.edges;

import android.animation.TimeInterpolator;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.patrykandpatrick.vico.core.chart.draw.ChartDrawContext;
import com.patrykandpatrick.vico.core.chart.draw.ChartDrawContextKt;
import com.patrykandpatrick.vico.core.extension.ColorExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B-\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012J<\u0010 \u001a\u00020\u001c*\u00020\u001e2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000e\u00a8\u0006("}, d2={"Lcom/patrykandpatrick/vico/core/chart/edges/FadingEdges;", "", "edgeWidthDp", "", "visibilityThresholdDp", "visibilityInterpolator", "Landroid/animation/TimeInterpolator;", "(FFLandroid/animation/TimeInterpolator;)V", "startEdgeWidthDp", "endEdgeWidthDp", "(FFFLandroid/animation/TimeInterpolator;)V", "getEndEdgeWidthDp", "()F", "setEndEdgeWidthDp", "(F)V", "paint", "Landroid/graphics/Paint;", "rect", "Landroid/graphics/RectF;", "getStartEdgeWidthDp", "setStartEdgeWidthDp", "getVisibilityInterpolator", "()Landroid/animation/TimeInterpolator;", "setVisibilityInterpolator", "(Landroid/animation/TimeInterpolator;)V", "getVisibilityThresholdDp", "setVisibilityThresholdDp", "applyFadingEdges", "", "context", "Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;", "bounds", "drawFadingEdge", "left", "top", "right", "bottom", "direction", "", "alpha", "core_release"})
@SourceDebugExtension(value={"SMAP\nFadingEdges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FadingEdges.kt\ncom/patrykandpatrick/vico/core/chart/edges/FadingEdges\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public class FadingEdges {
    private float startEdgeWidthDp;
    private float endEdgeWidthDp;
    private float visibilityThresholdDp;
    @NotNull
    private TimeInterpolator visibilityInterpolator;
    @NotNull
    private final Paint paint;
    @NotNull
    private final RectF rect;

    public FadingEdges(float startEdgeWidthDp, float endEdgeWidthDp, float visibilityThresholdDp, @NotNull TimeInterpolator visibilityInterpolator) {
        Intrinsics.checkNotNullParameter((Object)visibilityInterpolator, (String)"visibilityInterpolator");
        this.startEdgeWidthDp = startEdgeWidthDp;
        this.endEdgeWidthDp = endEdgeWidthDp;
        this.visibilityThresholdDp = visibilityThresholdDp;
        this.visibilityInterpolator = visibilityInterpolator;
        this.paint = new Paint();
        this.rect = new RectF();
        if (!(this.startEdgeWidthDp >= 0.0f)) {
            boolean $i$a$-require-FadingEdges$32 = false;
            String $i$a$-require-FadingEdges$32 = "`startEdgeWidthDp` must be greater than 0.";
            throw new IllegalArgumentException($i$a$-require-FadingEdges$32.toString());
        }
        if (!(this.endEdgeWidthDp >= 0.0f)) {
            boolean bl = false;
            String string = "`endEdgeWidthDp` must be greater than 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
    }

    public /* synthetic */ FadingEdges(float f, float f2, float f3, TimeInterpolator timeInterpolator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 32.0f;
        }
        if ((n & 2) != 0) {
            f2 = f;
        }
        if ((n & 4) != 0) {
            f3 = 16.0f;
        }
        if ((n & 8) != 0) {
            timeInterpolator = (TimeInterpolator)new AccelerateDecelerateInterpolator();
        }
        this(f, f2, f3, timeInterpolator);
    }

    public final float getStartEdgeWidthDp() {
        return this.startEdgeWidthDp;
    }

    public final void setStartEdgeWidthDp(float f) {
        this.startEdgeWidthDp = f;
    }

    public final float getEndEdgeWidthDp() {
        return this.endEdgeWidthDp;
    }

    public final void setEndEdgeWidthDp(float f) {
        this.endEdgeWidthDp = f;
    }

    public final float getVisibilityThresholdDp() {
        return this.visibilityThresholdDp;
    }

    public final void setVisibilityThresholdDp(float f) {
        this.visibilityThresholdDp = f;
    }

    @NotNull
    public final TimeInterpolator getVisibilityInterpolator() {
        return this.visibilityInterpolator;
    }

    public final void setVisibilityInterpolator(@NotNull TimeInterpolator timeInterpolator) {
        Intrinsics.checkNotNullParameter((Object)timeInterpolator, (String)"<set-?>");
        this.visibilityInterpolator = timeInterpolator;
    }

    public FadingEdges(float edgeWidthDp, float visibilityThresholdDp, @NotNull TimeInterpolator visibilityInterpolator) {
        Intrinsics.checkNotNullParameter((Object)visibilityInterpolator, (String)"visibilityInterpolator");
        this(edgeWidthDp, edgeWidthDp, visibilityThresholdDp, visibilityInterpolator);
    }

    public /* synthetic */ FadingEdges(float f, float f2, TimeInterpolator timeInterpolator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 32.0f;
        }
        if ((n & 2) != 0) {
            f2 = 16.0f;
        }
        if ((n & 4) != 0) {
            timeInterpolator = (TimeInterpolator)new AccelerateDecelerateInterpolator();
        }
        this(f, f2, timeInterpolator);
    }

    public final void applyFadingEdges(@NotNull ChartDrawContext context, @NotNull RectF bounds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        ChartDrawContext $this$applyFadingEdges_u24lambda_u242 = context;
        boolean bl = false;
        float maxScroll = ChartDrawContextKt.getMaxScrollDistance($this$applyFadingEdges_u24lambda_u242);
        float fadeAlphaFraction = 0.0f;
        if ($this$applyFadingEdges_u24lambda_u242.isHorizontalScrollEnabled() && this.startEdgeWidthDp > 0.0f && $this$applyFadingEdges_u24lambda_u242.getHorizontalScroll() > 0.0f) {
            fadeAlphaFraction = RangesKt.coerceAtMost((float)($this$applyFadingEdges_u24lambda_u242.getHorizontalScroll() / $this$applyFadingEdges_u24lambda_u242.getPixels(this.visibilityThresholdDp)), (float)1.0f);
            this.drawFadingEdge($this$applyFadingEdges_u24lambda_u242, bounds.left, bounds.top, bounds.left + $this$applyFadingEdges_u24lambda_u242.getPixels(this.startEdgeWidthDp), bounds.bottom, -1, (int)(this.visibilityInterpolator.getInterpolation(fadeAlphaFraction) * (float)255));
        }
        if ($this$applyFadingEdges_u24lambda_u242.isHorizontalScrollEnabled() && this.endEdgeWidthDp > 0.0f && $this$applyFadingEdges_u24lambda_u242.getHorizontalScroll() < maxScroll) {
            fadeAlphaFraction = RangesKt.coerceAtMost((float)((maxScroll - $this$applyFadingEdges_u24lambda_u242.getHorizontalScroll()) / $this$applyFadingEdges_u24lambda_u242.getPixels(this.visibilityThresholdDp)), (float)1.0f);
            this.drawFadingEdge($this$applyFadingEdges_u24lambda_u242, bounds.right - $this$applyFadingEdges_u24lambda_u242.getPixels(this.endEdgeWidthDp), bounds.top, bounds.right, bounds.bottom, 1, (int)(this.visibilityInterpolator.getInterpolation(fadeAlphaFraction) * (float)255));
        }
    }

    private final void drawFadingEdge(ChartDrawContext $this$drawFadingEdge, float left, float top, float right, float bottom, int direction, int alpha) {
        this.rect.set(left, top, right, bottom);
        int faded = ColorExtensionsKt.copyColor$default(-16777216, alpha, 0, 0, 0, 14, null);
        this.paint.setShader((Shader)new LinearGradient(this.rect.left, 0.0f, this.rect.right, 0.0f, direction < 0 ? faded : 0, direction < 0 ? 0 : faded, Shader.TileMode.CLAMP));
        $this$drawFadingEdge.getCanvas().drawRect(this.rect, this.paint);
    }

    public FadingEdges() {
        this(0.0f, 0.0f, 0.0f, null, 15, null);
    }
}

