/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.chart.column;

import android.graphics.RectF;
import com.patrykandpatrick.vico.core.axis.AxisPosition;
import com.patrykandpatrick.vico.core.chart.BaseChart;
import com.patrykandpatrick.vico.core.chart.ChartExtensionsKt;
import com.patrykandpatrick.vico.core.chart.dimensions.HorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.dimensions.MutableHorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.draw.ChartDrawContext;
import com.patrykandpatrick.vico.core.chart.layout.HorizontalLayout;
import com.patrykandpatrick.vico.core.chart.values.AxisValuesOverrider;
import com.patrykandpatrick.vico.core.chart.values.ChartValues;
import com.patrykandpatrick.vico.core.chart.values.ChartValuesManager;
import com.patrykandpatrick.vico.core.component.shape.LineComponent;
import com.patrykandpatrick.vico.core.component.text.TextComponent;
import com.patrykandpatrick.vico.core.component.text.VerticalPosition;
import com.patrykandpatrick.vico.core.component.text.VerticalPositionExtensionsKt;
import com.patrykandpatrick.vico.core.context.MeasureContext;
import com.patrykandpatrick.vico.core.entry.ChartEntry;
import com.patrykandpatrick.vico.core.entry.ChartEntryModel;
import com.patrykandpatrick.vico.core.extension.CollectionExtensionsKt;
import com.patrykandpatrick.vico.core.extension.RectExtensionsKt;
import com.patrykandpatrick.vico.core.formatter.DecimalFormatValueFormatter;
import com.patrykandpatrick.vico.core.formatter.ValueFormatter;
import com.patrykandpatrick.vico.core.marker.Marker;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001rB%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u0007\b\u0016\u00a2\u0006\u0002\u0010\nBg\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0002H\u0014J\u0018\u00108\u001a\u00020K2\u0006\u0010H\u001a\u00020L2\u0006\u0010J\u001a\u00020\u0002H\u0016J'\u0010M\u001a\u00020G2\u0006\u0010N\u001a\u00020O2\u0006\u0010J\u001a\u00020\u00022\b\u0010P\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010QJ0\u0010R\u001a\u00020G2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u00062\u0006\u0010V\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010W\u001a\u00020XH\u0014J\u001c\u0010Y\u001a\u00020G*\u00020I2\u0006\u0010Z\u001a\u00020[2\u0006\u0010J\u001a\u00020\u0002H\u0014JD\u0010\\\u001a\u00020G*\u00020I2\u0006\u0010]\u001a\u00020X2\u0006\u0010^\u001a\u00020\u00062\u0006\u0010_\u001a\u00020\u00062\u0006\u0010`\u001a\u00020\u00062\u0006\u0010a\u001a\u00020\u00062\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020cH\u0014J]\u0010e\u001a\u00020G*\u00020I2\u0006\u0010]\u001a\u00020X2\u0006\u0010^\u001a\u00020\u00062\b\u0010f\u001a\u0004\u0018\u00010\u00062\b\u0010g\u001a\u0004\u0018\u00010\u00062\u0006\u0010`\u001a\u00020\u00062\u0006\u0010h\u001a\u00020\u00062\u0006\u0010i\u001a\u00020\u00062\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020cH\u0014\u00a2\u0006\u0002\u0010jJ\u0014\u0010k\u001a\u00020\u0006*\u00020L2\u0006\u0010l\u001a\u00020XH\u0014J\u0014\u0010m\u001a\u00020\u0006*\u00020L2\u0006\u0010n\u001a\u00020XH\u0014J\u001c\u0010o\u001a\u00020\u0006*\u00020L2\u0006\u0010p\u001a\u00020X2\u0006\u0010q\u001a\u00020XH\u0014R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R<\u0010,\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0-j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.`0X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102RH\u00103\u001a6\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006040-j\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000604`0X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00102R\u0014\u00106\u001a\u000207X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010!\"\u0004\b;\u0010#R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010!\"\u0004\bA\u0010#R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006s"}, d2={"Lcom/patrykandpatrick/vico/core/chart/column/ColumnChart;", "Lcom/patrykandpatrick/vico/core/chart/BaseChart;", "Lcom/patrykandpatrick/vico/core/entry/ChartEntryModel;", "column", "Lcom/patrykandpatrick/vico/core/component/shape/LineComponent;", "spacingDp", "", "targetVerticalAxisPosition", "Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "(Lcom/patrykandpatrick/vico/core/component/shape/LineComponent;FLcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;)V", "()V", "columns", "", "innerSpacingDp", "mergeMode", "Lcom/patrykandpatrick/vico/core/chart/column/ColumnChart$MergeMode;", "dataLabel", "Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "dataLabelVerticalPosition", "Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;", "dataLabelValueFormatter", "Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;", "dataLabelRotationDegrees", "(Ljava/util/List;FFLcom/patrykandpatrick/vico/core/chart/column/ColumnChart$MergeMode;Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;Lcom/patrykandpatrick/vico/core/component/text/TextComponent;Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;F)V", "getColumns", "()Ljava/util/List;", "setColumns", "(Ljava/util/List;)V", "getDataLabel", "()Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "setDataLabel", "(Lcom/patrykandpatrick/vico/core/component/text/TextComponent;)V", "getDataLabelRotationDegrees", "()F", "setDataLabelRotationDegrees", "(F)V", "getDataLabelValueFormatter", "()Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;", "setDataLabelValueFormatter", "(Lcom/patrykandpatrick/vico/core/formatter/ValueFormatter;)V", "getDataLabelVerticalPosition", "()Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;", "setDataLabelVerticalPosition", "(Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;)V", "entryLocationMap", "Ljava/util/HashMap;", "", "Lcom/patrykandpatrick/vico/core/marker/Marker$EntryModel;", "Lkotlin/collections/HashMap;", "getEntryLocationMap", "()Ljava/util/HashMap;", "heightMap", "Lkotlin/Pair;", "getHeightMap", "horizontalDimensions", "Lcom/patrykandpatrick/vico/core/chart/dimensions/MutableHorizontalDimensions;", "getHorizontalDimensions", "()Lcom/patrykandpatrick/vico/core/chart/dimensions/MutableHorizontalDimensions;", "getInnerSpacingDp", "setInnerSpacingDp", "getMergeMode", "()Lcom/patrykandpatrick/vico/core/chart/column/ColumnChart$MergeMode;", "setMergeMode", "(Lcom/patrykandpatrick/vico/core/chart/column/ColumnChart$MergeMode;)V", "getSpacingDp", "setSpacingDp", "getTargetVerticalAxisPosition", "()Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "setTargetVerticalAxisPosition", "(Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;)V", "drawChart", "", "context", "Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;", "model", "Lcom/patrykandpatrick/vico/core/chart/dimensions/HorizontalDimensions;", "Lcom/patrykandpatrick/vico/core/context/MeasureContext;", "updateChartValues", "chartValuesManager", "Lcom/patrykandpatrick/vico/core/chart/values/ChartValuesManager;", "xStep", "(Lcom/patrykandpatrick/vico/core/chart/values/ChartValuesManager;Lcom/patrykandpatrick/vico/core/entry/ChartEntryModel;Ljava/lang/Float;)V", "updateMarkerLocationMap", "entry", "Lcom/patrykandpatrick/vico/core/entry/ChartEntry;", "columnTop", "columnCenterX", "index", "", "drawChartInternal", "chartValues", "Lcom/patrykandpatrick/vico/core/chart/values/ChartValues;", "drawDataLabel", "modelEntriesSize", "columnThicknessDp", "dataLabelValue", "x", "y", "isFirst", "", "isLast", "drawStackedDataLabel", "negativeY", "positiveY", "zeroLinePosition", "heightMultiplier", "(Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;IFLjava/lang/Float;Ljava/lang/Float;FFFZZ)V", "getColumnCollectionWidth", "entryCollectionSize", "getCumulatedThickness", "count", "getDrawingStart", "entryCollectionIndex", "entryCollectionCount", "MergeMode", "core_release"})
@SourceDebugExtension(value={"SMAP\nColumnChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnChart.kt\ncom/patrykandpatrick/vico/core/chart/column/ColumnChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EntryModelExtensions.kt\ncom/patrykandpatrick/vico/core/chart/EntryModelExtensionsKt\n+ 5 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n*L\n1#1,418:1\n1#2:419\n1864#3,2:420\n1855#3:425\n1856#3:427\n1866#3:430\n52#4,2:422\n26#4:424\n27#4:428\n54#4:429\n63#5:426\n63#5:431\n75#5:432\n75#5:433\n63#5:434\n63#5:435\n63#5:436\n63#5:437\n63#5:438\n*S KotlinDebug\n*F\n+ 1 ColumnChart.kt\ncom/patrykandpatrick/vico/core/chart/column/ColumnChart\n*L\n137#1:420,2\n142#1:425\n142#1:427\n137#1:430\n142#1:422,2\n142#1:424\n142#1:428\n142#1:429\n148#1:426\n256#1:431\n261#1:432\n264#1:433\n276#1:434\n343#1:435\n347#1:436\n348#1:437\n372#1:438\n*E\n"})
public class ColumnChart
extends BaseChart<ChartEntryModel> {
    @NotNull
    private List<? extends LineComponent> columns;
    private float spacingDp;
    private float innerSpacingDp;
    @NotNull
    private MergeMode mergeMode;
    @Nullable
    private AxisPosition.Vertical targetVerticalAxisPosition;
    @Nullable
    private TextComponent dataLabel;
    @NotNull
    private VerticalPosition dataLabelVerticalPosition;
    @NotNull
    private ValueFormatter dataLabelValueFormatter;
    private float dataLabelRotationDegrees;
    @NotNull
    private final HashMap<Float, Pair<Float, Float>> heightMap;
    @NotNull
    private final MutableHorizontalDimensions horizontalDimensions;
    @NotNull
    private final HashMap<Float, List<Marker.EntryModel>> entryLocationMap;

    public ColumnChart(@NotNull List<? extends LineComponent> columns, float spacingDp, float innerSpacingDp, @NotNull MergeMode mergeMode, @Nullable AxisPosition.Vertical targetVerticalAxisPosition, @Nullable TextComponent dataLabel, @NotNull VerticalPosition dataLabelVerticalPosition, @NotNull ValueFormatter dataLabelValueFormatter, float dataLabelRotationDegrees) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)((Object)mergeMode), (String)"mergeMode");
        Intrinsics.checkNotNullParameter((Object)((Object)dataLabelVerticalPosition), (String)"dataLabelVerticalPosition");
        Intrinsics.checkNotNullParameter((Object)dataLabelValueFormatter, (String)"dataLabelValueFormatter");
        this.columns = columns;
        this.spacingDp = spacingDp;
        this.innerSpacingDp = innerSpacingDp;
        this.mergeMode = mergeMode;
        this.targetVerticalAxisPosition = targetVerticalAxisPosition;
        this.dataLabel = dataLabel;
        this.dataLabelVerticalPosition = dataLabelVerticalPosition;
        this.dataLabelValueFormatter = dataLabelValueFormatter;
        this.dataLabelRotationDegrees = dataLabelRotationDegrees;
        this.heightMap = new HashMap();
        this.horizontalDimensions = new MutableHorizontalDimensions(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 31, null);
        this.entryLocationMap = new HashMap();
    }

    public /* synthetic */ ColumnChart(List list, float f, float f2, MergeMode mergeMode, AxisPosition.Vertical vertical, TextComponent textComponent2, VerticalPosition verticalPosition, ValueFormatter valueFormatter, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 32.0f;
        }
        if ((n & 4) != 0) {
            f2 = 8.0f;
        }
        if ((n & 8) != 0) {
            mergeMode = MergeMode.Grouped;
        }
        if ((n & 0x10) != 0) {
            vertical = null;
        }
        if ((n & 0x20) != 0) {
            textComponent2 = null;
        }
        if ((n & 0x40) != 0) {
            verticalPosition = VerticalPosition.Top;
        }
        if ((n & 0x80) != 0) {
            valueFormatter = new DecimalFormatValueFormatter();
        }
        if ((n & 0x100) != 0) {
            f3 = 0.0f;
        }
        this(list, f, f2, mergeMode, vertical, textComponent2, verticalPosition, valueFormatter, f3);
    }

    @NotNull
    public final List<LineComponent> getColumns() {
        return this.columns;
    }

    public final void setColumns(@NotNull List<? extends LineComponent> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.columns = list;
    }

    public final float getSpacingDp() {
        return this.spacingDp;
    }

    public final void setSpacingDp(float f) {
        this.spacingDp = f;
    }

    public final float getInnerSpacingDp() {
        return this.innerSpacingDp;
    }

    public final void setInnerSpacingDp(float f) {
        this.innerSpacingDp = f;
    }

    @NotNull
    public final MergeMode getMergeMode() {
        return this.mergeMode;
    }

    public final void setMergeMode(@NotNull MergeMode mergeMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mergeMode), (String)"<set-?>");
        this.mergeMode = mergeMode;
    }

    @Nullable
    public final AxisPosition.Vertical getTargetVerticalAxisPosition() {
        return this.targetVerticalAxisPosition;
    }

    public final void setTargetVerticalAxisPosition(@Nullable AxisPosition.Vertical vertical) {
        this.targetVerticalAxisPosition = vertical;
    }

    @Nullable
    public final TextComponent getDataLabel() {
        return this.dataLabel;
    }

    public final void setDataLabel(@Nullable TextComponent textComponent2) {
        this.dataLabel = textComponent2;
    }

    @NotNull
    public final VerticalPosition getDataLabelVerticalPosition() {
        return this.dataLabelVerticalPosition;
    }

    public final void setDataLabelVerticalPosition(@NotNull VerticalPosition verticalPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticalPosition), (String)"<set-?>");
        this.dataLabelVerticalPosition = verticalPosition;
    }

    @NotNull
    public final ValueFormatter getDataLabelValueFormatter() {
        return this.dataLabelValueFormatter;
    }

    public final void setDataLabelValueFormatter(@NotNull ValueFormatter valueFormatter) {
        Intrinsics.checkNotNullParameter((Object)valueFormatter, (String)"<set-?>");
        this.dataLabelValueFormatter = valueFormatter;
    }

    public final float getDataLabelRotationDegrees() {
        return this.dataLabelRotationDegrees;
    }

    public final void setDataLabelRotationDegrees(float f) {
        this.dataLabelRotationDegrees = f;
    }

    public ColumnChart(@NotNull LineComponent column, float spacingDp, @Nullable AxisPosition.Vertical targetVerticalAxisPosition) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this(CollectionsKt.listOf((Object)column), spacingDp, 0.0f, null, targetVerticalAxisPosition, null, null, null, 0.0f, 492, null);
    }

    public /* synthetic */ ColumnChart(LineComponent lineComponent, float f, AxisPosition.Vertical vertical, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 32.0f;
        }
        if ((n & 4) != 0) {
            vertical = null;
        }
        this(lineComponent, f, vertical);
    }

    public ColumnChart() {
        this(CollectionsKt.emptyList(), 0.0f, 0.0f, null, null, null, null, null, 0.0f, 510, null);
    }

    @NotNull
    protected final HashMap<Float, Pair<Float, Float>> getHeightMap() {
        return this.heightMap;
    }

    @NotNull
    protected final MutableHorizontalDimensions getHorizontalDimensions() {
        return this.horizontalDimensions;
    }

    @NotNull
    public HashMap<Float, List<Marker.EntryModel>> getEntryLocationMap() {
        return this.entryLocationMap;
    }

    @Override
    protected void drawChart(@NotNull ChartDrawContext context, @NotNull ChartEntryModel model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        ChartDrawContext $this$drawChart_u24lambda_u240 = context;
        boolean bl = false;
        ((HashMap)this.getEntryLocationMap()).clear();
        this.drawChartInternal($this$drawChart_u24lambda_u240, $this$drawChart_u24lambda_u240.getChartValuesManager().getChartValues(this.targetVerticalAxisPosition), model);
        this.heightMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    protected void drawChartInternal(@NotNull ChartDrawContext $this$drawChartInternal, @NotNull ChartValues chartValues, @NotNull ChartEntryModel model) {
        Intrinsics.checkNotNullParameter((Object)$this$drawChartInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chartValues, (String)"chartValues");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Float f = Float.valueOf(chartValues.getMaxY() - chartValues.getMinY());
        float it = ((Number)f).floatValue();
        boolean bl = false;
        Float f2 = !(it == 0.0f) ? f : null;
        if (f2 == null) {
            return;
        }
        float yRange = f2.floatValue();
        float heightMultiplier = this.getBounds().height() / yRange;
        float drawingStart = 0.0f;
        float height = 0.0f;
        float columnCenterX = 0.0f;
        LineComponent column = null;
        float columnTop = 0.0f;
        float columnBottom = 0.0f;
        float zeroLinePosition = this.getBounds().bottom + chartValues.getMinY() / yRange * this.getBounds().height();
        Iterable $this$forEachIndexed$iv = model.getEntries();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$forEachInRelativelyIndexed$iv;
            void entryCollection;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl2 = false;
            column = CollectionExtensionsKt.getRepeating(this.columns, index);
            drawingStart = this.getDrawingStart($this$drawChartInternal, index, model.getEntries().size()) - $this$drawChartInternal.getHorizontalScroll();
            void var22_24 = entryCollection;
            ClosedFloatingPointRange range$iv = RangesKt.rangeTo((float)chartValues.getMinX(), (float)chartValues.getMaxX());
            boolean $i$f$forEachInRelativelyIndexed = false;
            int index$iv2 = 0;
            void $this$forEachIn$iv$iv = $this$forEachInRelativelyIndexed$iv;
            boolean $i$f$forEachIn = false;
            Iterable $this$forEach$iv$iv$iv = (Iterable)$this$forEachIn$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                float columnSignificantY;
                void entry;
                ChartEntry it$iv$iv = (ChartEntry)element$iv$iv$iv;
                boolean bl3 = false;
                if (!range$iv.contains((Comparable)Float.valueOf(it$iv$iv.getX()))) continue;
                ChartEntry it$iv = it$iv$iv;
                boolean bl4 = false;
                int n2 = index$iv2;
                index$iv2 = n2 + 1;
                ChartEntry chartEntry = it$iv;
                int entryIndex = n2;
                boolean bl5 = false;
                height = Math.abs(entry.getY()) * heightMultiplier;
                float xSpacingMultiplier = (entry.getX() - chartValues.getMinX()) / chartValues.getXStep();
                if (!(xSpacingMultiplier % 1.0f == 0.0f)) {
                    boolean $i$a$-check-ColumnChart$drawChartInternal$1$1$22 = false;
                    String $i$a$-check-ColumnChart$drawChartInternal$1$1$22 = "Each entry\u2019s x value must be a multiple of the x step.";
                    throw new IllegalStateException($i$a$-check-ColumnChart$drawChartInternal$1$1$22.toString());
                }
                float $this$half$iv = column.getThicknessDp();
                boolean $i$f$getHalf = false;
                columnCenterX = drawingStart + $this$drawChartInternal.getLayoutDirectionMultiplier() * $this$drawChartInternal.getHorizontalDimensions().getXSpacing() * xSpacingMultiplier + $this$drawChartInternal.getPixels($this$half$iv / (float)2) * $this$drawChartInternal.getChartScale();
                switch (WhenMappings.$EnumSwitchMapping$0[this.mergeMode.ordinal()]) {
                    case 1: {
                        Map map = this.heightMap;
                        Object object = map.get(Float.valueOf(entry.getX()));
                        if (object == null) {
                            boolean bl6 = false;
                            object = TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                        }
                        Pair pair = (Pair)object;
                        float stackedNegY = ((Number)pair.component1()).floatValue();
                        float stackedPosY = ((Number)pair.component2()).floatValue();
                        columnBottom = zeroLinePosition + (entry.getY() < 0.0f ? height + Math.abs(stackedNegY) * heightMultiplier : -stackedPosY * heightMultiplier);
                        columnTop = RangesKt.coerceAtMost((float)(columnBottom - height), (float)columnBottom);
                        ((Map)this.heightMap).put(Float.valueOf(entry.getX()), entry.getY() < 0.0f ? TuplesKt.to((Object)Float.valueOf(stackedNegY + entry.getY()), (Object)Float.valueOf(stackedPosY)) : TuplesKt.to((Object)Float.valueOf(stackedNegY), (Object)Float.valueOf(stackedPosY + entry.getY())));
                        break;
                    }
                    case 2: {
                        columnBottom = zeroLinePosition + (entry.getY() < 0.0f ? height : 0.0f);
                        columnTop = columnBottom - height;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                float f3 = columnSignificantY = entry.getY() < 0.0f ? columnBottom : columnTop;
                if (column.intersectsVertical($this$drawChartInternal, columnTop, columnBottom, columnCenterX, this.getBounds(), $this$drawChartInternal.getChartScale())) {
                    this.updateMarkerLocationMap((ChartEntry)entry, columnSignificantY, columnCenterX, column, entryIndex);
                    column.drawVertical($this$drawChartInternal, columnTop, columnBottom, columnCenterX, $this$drawChartInternal.getChartScale());
                }
                if (this.mergeMode == MergeMode.Grouped) {
                    this.drawDataLabel($this$drawChartInternal, model.getEntries().size(), column.getThicknessDp(), entry.getY(), columnCenterX, columnSignificantY, index == 0 && entry.getX() == chartValues.getMinX(), index == CollectionsKt.getLastIndex(model.getEntries()) && entry.getX() == chartValues.getMaxX());
                    continue;
                }
                if (index != CollectionsKt.getLastIndex(model.getEntries())) continue;
                Pair<Float, Float> yValues = this.heightMap.get(Float.valueOf(entry.getX()));
                Pair<Float, Float> pair = yValues;
                Pair<Float, Float> pair2 = yValues;
                this.drawStackedDataLabel($this$drawChartInternal, model.getEntries().size(), column.getThicknessDp(), pair != null ? (Float)pair.getFirst() : null, pair2 != null ? (Float)pair2.getSecond() : null, columnCenterX, zeroLinePosition, heightMultiplier, entry.getX() == chartValues.getMinX(), entry.getX() == chartValues.getMaxX());
            }
        }
    }

    protected void drawStackedDataLabel(@NotNull ChartDrawContext $this$drawStackedDataLabel, int modelEntriesSize, float columnThicknessDp, @Nullable Float negativeY, @Nullable Float positiveY, float x, float zeroLinePosition, float heightMultiplier, boolean isFirst, boolean isLast) {
        float y;
        Intrinsics.checkNotNullParameter((Object)$this$drawStackedDataLabel, (String)"<this>");
        if (positiveY != null && positiveY.floatValue() > 0.0f) {
            y = zeroLinePosition - positiveY.floatValue() * heightMultiplier;
            this.drawDataLabel($this$drawStackedDataLabel, modelEntriesSize, columnThicknessDp, positiveY.floatValue(), x, y, isFirst, isLast);
        }
        if (negativeY != null && negativeY.floatValue() < 0.0f) {
            y = zeroLinePosition + Math.abs(negativeY.floatValue()) * heightMultiplier;
            this.drawDataLabel($this$drawStackedDataLabel, modelEntriesSize, columnThicknessDp, negativeY.floatValue(), x, y, isFirst, isLast);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawDataLabel(@NotNull ChartDrawContext $this$drawDataLabel, int modelEntriesSize, float columnThicknessDp, float dataLabelValue, float x, float y, boolean isFirst, boolean isLast) {
        block9: {
            CharSequence text;
            float maxWidth;
            TextComponent textComponent2;
            block11: {
                block10: {
                    float dataLabelWidth;
                    boolean $i$f$getDoubled;
                    float $this$doubled$iv;
                    float f;
                    Intrinsics.checkNotNullParameter((Object)$this$drawDataLabel, (String)"<this>");
                    TextComponent textComponent3 = this.dataLabel;
                    if (textComponent3 == null) break block9;
                    textComponent2 = textComponent3;
                    boolean bl = false;
                    boolean canUseXSpacing = this.mergeMode == MergeMode.Stack || this.mergeMode == MergeMode.Grouped && modelEntriesSize == 1;
                    if (canUseXSpacing) {
                        f = $this$drawDataLabel.getHorizontalDimensions().getXSpacing();
                    } else if (this.mergeMode == MergeMode.Grouped) {
                        void $this$half$iv;
                        float f2 = Math.min(this.spacingDp, this.innerSpacingDp);
                        boolean $i$f$getHalf = false;
                        f = $this$drawDataLabel.getPixels(columnThicknessDp + $this$half$iv / (float)2) * $this$drawDataLabel.getChartScale();
                    } else {
                        throw new IllegalStateException("Encountered an unexpected `MergeMode`.".toString());
                    }
                    maxWidth = f;
                    if (isFirst && $this$drawDataLabel.getHorizontalLayout() instanceof HorizontalLayout.FullWidth) {
                        $this$doubled$iv = $this$drawDataLabel.getHorizontalDimensions().getStartPadding();
                        $i$f$getDoubled = false;
                        maxWidth = RangesKt.coerceAtMost((float)maxWidth, (float)($this$doubled$iv * (float)2));
                    }
                    if (isLast && $this$drawDataLabel.getHorizontalLayout() instanceof HorizontalLayout.FullWidth) {
                        $this$doubled$iv = $this$drawDataLabel.getHorizontalDimensions().getEndPadding();
                        $i$f$getDoubled = false;
                        maxWidth = RangesKt.coerceAtMost((float)maxWidth, (float)($this$doubled$iv * (float)2));
                    }
                    text = this.dataLabelValueFormatter.formatValue(dataLabelValue, $this$drawDataLabel.getChartValuesManager().getChartValues(this.targetVerticalAxisPosition));
                    float $this$half$iv = dataLabelWidth = RangesKt.coerceAtMost((float)TextComponent.getWidth$default(textComponent2, $this$drawDataLabel, text, 0, 0, this.dataLabelRotationDegrees, 12, null), (float)maxWidth);
                    boolean $i$f$getHalf = false;
                    if (x - $this$half$iv / (float)2 > this.getBounds().right) break block10;
                    $this$half$iv = dataLabelWidth;
                    $i$f$getHalf = false;
                    if (!(x + $this$half$iv / (float)2 < this.getBounds().left)) break block11;
                }
                return;
            }
            VerticalPosition labelVerticalPosition = dataLabelValue < 0.0f ? this.dataLabelVerticalPosition.negative() : this.dataLabelVerticalPosition;
            RectF rectF = this.getBounds();
            float f = TextComponent.getHeight$default(textComponent2, $this$drawDataLabel, text, (int)maxWidth, 0, this.dataLabelRotationDegrees, 8, null);
            VerticalPosition verticalPosition = VerticalPositionExtensionsKt.inBounds$default(labelVerticalPosition, rectF, 0.0f, f, y, 2, null);
            TextComponent.drawText$default(textComponent2, $this$drawDataLabel, text, x, y, null, verticalPosition, (int)maxWidth, 0, this.dataLabelRotationDegrees, 144, null);
        }
    }

    protected void updateMarkerLocationMap(@NotNull ChartEntry entry, float columnTop, float columnCenterX, @NotNull LineComponent column, int index) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        float f = this.getBounds().left;
        boolean bl = columnCenterX <= this.getBounds().right ? f <= columnCenterX : false;
        if (bl) {
            ChartExtensionsKt.put((HashMap<Float, List<Marker.EntryModel>>)this.getEntryLocationMap(), columnCenterX, RangesKt.coerceIn((float)columnTop, (float)this.getBounds().top, (float)this.getBounds().bottom), entry, column.getColor(), index);
        }
    }

    @Override
    public void updateChartValues(@NotNull ChartValuesManager chartValuesManager, @NotNull ChartEntryModel model, @Nullable Float xStep) {
        float f;
        Object object;
        float f2;
        Object object2;
        float f3;
        Object object3;
        float f4;
        Intrinsics.checkNotNullParameter((Object)chartValuesManager, (String)"chartValuesManager");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        AxisValuesOverrider axisValuesOverrider = this.getAxisValuesOverrider();
        if (axisValuesOverrider != null && (axisValuesOverrider = axisValuesOverrider.getMinX(model)) != null) {
            f4 = ((Float)((Object)axisValuesOverrider)).floatValue();
        } else {
            Float f5 = this.getMinX();
            f4 = f5 != null ? f5.floatValue() : model.getMinX();
        }
        if ((object3 = this.getAxisValuesOverrider()) != null && (object3 = object3.getMaxX(model)) != null) {
            f3 = ((Float)object3).floatValue();
        } else {
            Float f6 = this.getMaxX();
            f3 = f6 != null ? f6.floatValue() : model.getMaxX();
        }
        if ((object2 = this.getAxisValuesOverrider()) != null && (object2 = object2.getMinY(model)) != null) {
            f2 = ((Float)object2).floatValue();
        } else {
            Float f7 = this.getMinY();
            f2 = f7 != null ? f7.floatValue() : this.mergeMode.getMinY(model);
        }
        if ((object = this.getAxisValuesOverrider()) != null && (object = object.getMaxY(model)) != null) {
            f = ((Float)object).floatValue();
        } else {
            Float f8 = this.getMaxY();
            f = f8 != null ? f8.floatValue() : this.mergeMode.getMaxY(model);
        }
        Float f9 = xStep;
        chartValuesManager.tryUpdate(f4, f3, f2, f, f9 != null ? f9.floatValue() : model.getXGcd(), model, this.targetVerticalAxisPosition);
    }

    @Override
    @NotNull
    public HorizontalDimensions getHorizontalDimensions(@NotNull MeasureContext context, @NotNull ChartEntryModel model) {
        MutableHorizontalDimensions mutableHorizontalDimensions;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MeasureContext $this$getHorizontalDimensions_u24lambda_u248 = context;
        boolean bl = false;
        float columnCollectionWidth = this.getColumnCollectionWidth($this$getHorizontalDimensions_u24lambda_u248, model.getEntries().size());
        MutableHorizontalDimensions $this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247 = mutableHorizontalDimensions = this.horizontalDimensions;
        boolean bl2 = false;
        $this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247.setXSpacing(columnCollectionWidth + $this$getHorizontalDimensions_u24lambda_u248.getPixels(this.spacingDp));
        HorizontalLayout horizontalLayout = $this$getHorizontalDimensions_u24lambda_u248.getHorizontalLayout();
        if (horizontalLayout instanceof HorizontalLayout.Segmented) {
            float $this$half$iv = $this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247.getXSpacing();
            boolean $i$f$getHalf = false;
            $this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247.setScalableStartPadding($this$half$iv / (float)2);
            $this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247.setScalableEndPadding($this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247.getScalableStartPadding());
        } else if (horizontalLayout instanceof HorizontalLayout.FullWidth) {
            float $this$half$iv = columnCollectionWidth;
            boolean $i$f$getHalf = false;
            $this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247.setScalableStartPadding($this$half$iv / (float)2 + $this$getHorizontalDimensions_u24lambda_u248.getPixels(((HorizontalLayout.FullWidth)horizontalLayout).getStartPaddingDp()));
            $this$half$iv = columnCollectionWidth;
            $i$f$getHalf = false;
            $this$getHorizontalDimensions_u24lambda_u248_u24lambda_u247.setScalableEndPadding($this$half$iv / (float)2 + $this$getHorizontalDimensions_u24lambda_u248.getPixels(((HorizontalLayout.FullWidth)horizontalLayout).getEndPaddingDp()));
        }
        return mutableHorizontalDimensions;
    }

    protected float getColumnCollectionWidth(@NotNull MeasureContext $this$getColumnCollectionWidth, int entryCollectionSize) {
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$getColumnCollectionWidth, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mergeMode.ordinal()]) {
            case 1: {
                Iterator iterator = ((Iterable)this.columns).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                LineComponent it = (LineComponent)iterator.next();
                boolean bl = false;
                float f2 = $this$getColumnCollectionWidth.getPixels(it.getThicknessDp());
                while (iterator.hasNext()) {
                    LineComponent it2 = (LineComponent)iterator.next();
                    $i$a$-maxOf-ColumnChart$getColumnCollectionWidth$1 = false;
                    float f3 = $this$getColumnCollectionWidth.getPixels(it2.getThicknessDp());
                    f2 = Math.max(f2, f3);
                }
                f = f2;
                break;
            }
            case 2: {
                f = this.getCumulatedThickness($this$getColumnCollectionWidth, entryCollectionSize) + $this$getColumnCollectionWidth.getPixels(this.innerSpacingDp) * (float)(entryCollectionSize - 1);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    protected float getDrawingStart(@NotNull MeasureContext $this$getDrawingStart, int entryCollectionIndex, int entryCollectionCount) {
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$getDrawingStart, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mergeMode.ordinal()]) {
            case 2: {
                f = this.getCumulatedThickness($this$getDrawingStart, entryCollectionIndex) + $this$getDrawingStart.getPixels(this.innerSpacingDp) * (float)entryCollectionIndex;
                break;
            }
            case 1: {
                f = 0.0f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        float mergeModeComponent = f;
        float $this$half$iv = this.getColumnCollectionWidth($this$getDrawingStart, entryCollectionCount);
        boolean $i$f$getHalf = false;
        return RectExtensionsKt.getStart(this.getBounds(), $this$getDrawingStart.isLtr()) + this.horizontalDimensions.scaled($this$getDrawingStart.getChartScale()).getStartPadding() + (mergeModeComponent - $this$half$iv / (float)2) * $this$getDrawingStart.getChartScale() * $this$getDrawingStart.getLayoutDirectionMultiplier();
    }

    protected float getCumulatedThickness(@NotNull MeasureContext $this$getCumulatedThickness, int count) {
        Intrinsics.checkNotNullParameter((Object)$this$getCumulatedThickness, (String)"<this>");
        float thickness = 0.0f;
        for (int i = 0; i < count; ++i) {
            thickness += CollectionExtensionsKt.getRepeating(this.columns, i).getThicknessDp() * $this$getCumulatedThickness.getDensity();
        }
        return thickness;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/patrykandpatrick/vico/core/chart/column/ColumnChart$MergeMode;", "", "(Ljava/lang/String;I)V", "getMaxY", "", "model", "Lcom/patrykandpatrick/vico/core/entry/ChartEntryModel;", "getMinY", "Grouped", "Stack", "core_release"})
    public static final class MergeMode
    extends Enum<MergeMode> {
        public static final /* enum */ MergeMode Grouped = new MergeMode();
        public static final /* enum */ MergeMode Stack = new MergeMode();
        private static final /* synthetic */ MergeMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final float getMinY(@NotNull ChartEntryModel model) {
            float f;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    f = RangesKt.coerceAtMost((float)model.getMinY(), (float)0.0f);
                    break;
                }
                case 2: {
                    f = RangesKt.coerceAtMost((float)model.getStackedNegativeY(), (float)0.0f);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return f;
        }

        public final float getMaxY(@NotNull ChartEntryModel model) {
            float f;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    f = model.getMaxY();
                    break;
                }
                case 2: {
                    f = model.getStackedPositiveY();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return f;
        }

        public static MergeMode[] values() {
            return (MergeMode[])$VALUES.clone();
        }

        public static MergeMode valueOf(String value) {
            return Enum.valueOf(MergeMode.class, value);
        }

        @NotNull
        public static EnumEntries<MergeMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mergeModeArray = new MergeMode[]{MergeMode.Grouped, MergeMode.Stack};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MergeMode.values().length];
                try {
                    nArray[MergeMode.Grouped.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MergeMode.Stack.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MergeMode.values().length];
            try {
                nArray[MergeMode.Stack.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeMode.Grouped.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

