/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.chart;

import android.graphics.Canvas;
import android.graphics.RectF;
import com.patrykandpatrick.vico.core.chart.Chart;
import com.patrykandpatrick.vico.core.chart.decoration.Decoration;
import com.patrykandpatrick.vico.core.chart.dimensions.HorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.draw.ChartDrawContext;
import com.patrykandpatrick.vico.core.chart.insets.ChartInsetter;
import com.patrykandpatrick.vico.core.chart.insets.HorizontalInsets;
import com.patrykandpatrick.vico.core.chart.insets.Insets;
import com.patrykandpatrick.vico.core.chart.values.AxisValuesOverrider;
import com.patrykandpatrick.vico.core.context.MeasureContext;
import com.patrykandpatrick.vico.core.dimensions.BoundsAware;
import com.patrykandpatrick.vico.core.entry.ChartEntryModel;
import com.patrykandpatrick.vico.core.extension.CollectionExtensionsKt;
import com.patrykandpatrick.vico.core.extension.MapExtensionsKt;
import com.patrykandpatrick.vico.core.marker.Marker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0017H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u000201H\u0016J\u001d\u0010<\u001a\u0002092\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010@J\u001d\u0010A\u001a\u0002092\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010@J\u0010\u0010B\u001a\u0002092\u0006\u0010=\u001a\u00020>H\u0004J\u0010\u0010C\u001a\u0002092\u0006\u0010=\u001a\u00020>H\u0004J\u001d\u0010D\u001a\u0002092\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010@J\u001d\u0010E\u001a\u0002092\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010@J\u0010\u0010F\u001a\u0002062\u0006\u00107\u001a\u00020\u0017H\u0016J\u0010\u0010G\u001a\u0002092\u0006\u0010:\u001a\u00020\u001cH\u0016J\u0016\u0010H\u001a\u0002092\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170IH\u0016J\u001c\u0010J\u001a\u0002092\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002010LH\u0016R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0016\n\u0002\u0010\"\u0012\u0004\b\u001d\u0010\u0005\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010#\u001a\u0004\u0018\u00010\u001c8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0016\n\u0002\u0010\"\u0012\u0004\b$\u0010\u0005\u001a\u0004\b%\u0010\u001f\"\u0004\b&\u0010!R(\u0010'\u001a\u0004\u0018\u00010\u001c8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0016\n\u0002\u0010\"\u0012\u0004\b(\u0010\u0005\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R(\u0010+\u001a\u0004\u0018\u00010\u001c8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0016\n\u0002\u0010\"\u0012\u0004\b,\u0010\u0005\u001a\u0004\b-\u0010\u001f\"\u0004\b.\u0010!R0\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020100j\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u000201`2X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006M"}, d2={"Lcom/patrykandpatrick/vico/core/chart/BaseChart;", "Model", "Lcom/patrykandpatrick/vico/core/entry/ChartEntryModel;", "Lcom/patrykandpatrick/vico/core/chart/Chart;", "Lcom/patrykandpatrick/vico/core/dimensions/BoundsAware;", "()V", "axisValuesOverrider", "Lcom/patrykandpatrick/vico/core/chart/values/AxisValuesOverrider;", "getAxisValuesOverrider", "()Lcom/patrykandpatrick/vico/core/chart/values/AxisValuesOverrider;", "setAxisValuesOverrider", "(Lcom/patrykandpatrick/vico/core/chart/values/AxisValuesOverrider;)V", "bounds", "Landroid/graphics/RectF;", "getBounds", "()Landroid/graphics/RectF;", "chartInsetters", "", "Lcom/patrykandpatrick/vico/core/chart/insets/ChartInsetter;", "getChartInsetters", "()Ljava/util/Collection;", "decorations", "Ljava/util/ArrayList;", "Lcom/patrykandpatrick/vico/core/chart/decoration/Decoration;", "Lkotlin/collections/ArrayList;", "insets", "Lcom/patrykandpatrick/vico/core/chart/insets/Insets;", "maxX", "", "getMaxX$annotations", "getMaxX", "()Ljava/lang/Float;", "setMaxX", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "maxY", "getMaxY$annotations", "getMaxY", "setMaxY", "minX", "getMinX$annotations", "getMinX", "setMinX", "minY", "getMinY$annotations", "getMinY", "setMinY", "persistentMarkers", "Ljava/util/HashMap;", "Lcom/patrykandpatrick/vico/core/marker/Marker;", "Lkotlin/collections/HashMap;", "getPersistentMarkers", "()Ljava/util/HashMap;", "addDecoration", "", "decoration", "addPersistentMarker", "", "x", "marker", "drawChart", "context", "Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;", "model", "(Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;Lcom/patrykandpatrick/vico/core/entry/ChartEntryModel;)V", "drawChartInternal", "drawDecorationAboveChart", "drawDecorationBehindChart", "drawNonScrollableContent", "drawScrollableContent", "removeDecoration", "removePersistentMarker", "setDecorations", "", "setPersistentMarkers", "markers", "", "core_release"})
@SourceDebugExtension(value={"SMAP\nBaseChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseChart.kt\ncom/patrykandpatrick/vico/core/chart/BaseChart\n+ 2 CanvasExtensions.kt\ncom/patrykandpatrick/vico/core/extension/CanvasExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n47#2,5:153\n47#2,5:160\n215#3,2:158\n1855#4,2:165\n1855#4,2:167\n*S KotlinDebug\n*F\n+ 1 BaseChart.kt\ncom/patrykandpatrick/vico/core/chart/BaseChart\n*L\n99#1:153,5\n126#1:160,5\n107#1:158,2\n145#1:165,2\n149#1:167,2\n*E\n"})
public abstract class BaseChart<Model extends ChartEntryModel>
implements Chart<Model>,
BoundsAware {
    @NotNull
    private final ArrayList<Decoration> decorations = new ArrayList();
    @NotNull
    private final Insets insets = new Insets(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    @NotNull
    private final HashMap<Float, Marker> persistentMarkers = new HashMap();
    @NotNull
    private final RectF bounds = new RectF();
    @NotNull
    private final Collection<ChartInsetter> chartInsetters;
    @Nullable
    private AxisValuesOverrider<Model> axisValuesOverrider;
    @Nullable
    private Float minY;
    @Nullable
    private Float maxY;
    @Nullable
    private Float minX;
    @Nullable
    private Float maxX;

    public BaseChart() {
        Collection<Marker> collection = this.persistentMarkers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        this.chartInsetters = collection;
    }

    @NotNull
    protected final HashMap<Float, Marker> getPersistentMarkers() {
        return this.persistentMarkers;
    }

    @Override
    @NotNull
    public RectF getBounds() {
        return this.bounds;
    }

    @Override
    @NotNull
    public Collection<ChartInsetter> getChartInsetters() {
        return this.chartInsetters;
    }

    @Override
    @Nullable
    public AxisValuesOverrider<Model> getAxisValuesOverrider() {
        return this.axisValuesOverrider;
    }

    @Override
    public void setAxisValuesOverrider(@Nullable AxisValuesOverrider<Model> axisValuesOverrider) {
        this.axisValuesOverrider = axisValuesOverrider;
    }

    @Override
    @Nullable
    public Float getMinY() {
        return this.minY;
    }

    @Override
    public void setMinY(@Nullable Float f) {
        this.minY = f;
    }

    @Deprecated(message="Axis values should be overridden via `Chart#axisValuesOverrider`.", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getMinY$annotations() {
    }

    @Override
    @Nullable
    public Float getMaxY() {
        return this.maxY;
    }

    @Override
    public void setMaxY(@Nullable Float f) {
        this.maxY = f;
    }

    @Deprecated(message="Axis values should be overridden via `Chart#axisValuesOverrider`.", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getMaxY$annotations() {
    }

    @Override
    @Nullable
    public Float getMinX() {
        return this.minX;
    }

    @Override
    public void setMinX(@Nullable Float f) {
        this.minX = f;
    }

    @Deprecated(message="Axis values should be overridden via `Chart#axisValuesOverrider`.", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getMinX$annotations() {
    }

    @Override
    @Nullable
    public Float getMaxX() {
        return this.maxX;
    }

    @Override
    public void setMaxX(@Nullable Float f) {
        this.maxX = f;
    }

    @Deprecated(message="Axis values should be overridden via `Chart#axisValuesOverrider`.", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getMaxX$annotations() {
    }

    @Override
    public boolean addDecoration(@NotNull Decoration decoration) {
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        return this.decorations.add(decoration);
    }

    @Override
    public void setDecorations(@NotNull List<? extends Decoration> decorations) {
        Intrinsics.checkNotNullParameter(decorations, (String)"decorations");
        CollectionExtensionsKt.setAll((List)this.decorations, (Collection)decorations);
    }

    @Override
    public boolean removeDecoration(@NotNull Decoration decoration) {
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        return this.decorations.remove(decoration);
    }

    @Override
    public void addPersistentMarker(float x, @NotNull Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Float f = Float.valueOf(x);
        ((Map)this.persistentMarkers).put(f, marker);
    }

    @Override
    public void setPersistentMarkers(@NotNull Map<Float, ? extends Marker> markers) {
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        CollectionExtensionsKt.setAll(this.persistentMarkers, markers);
    }

    @Override
    public void removePersistentMarker(float x) {
        this.persistentMarkers.remove(Float.valueOf(x));
    }

    @Override
    public void drawScrollableContent(@NotNull ChartDrawContext context, @NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        ChartDrawContext $this$drawScrollableContent_u24lambda_u240 = context;
        boolean bl = false;
        this.insets.clear();
        this.getInsets($this$drawScrollableContent_u24lambda_u240, this.insets, $this$drawScrollableContent_u24lambda_u240.getHorizontalDimensions());
        this.drawChartInternal(context, model);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawNonScrollableContent(@NotNull ChartDrawContext context, @NotNull Model model) {
        void bottom$iv;
        void right$iv;
        void top$iv;
        void left$iv;
        void $this$inClip$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        ChartDrawContext $this$drawNonScrollableContent_u24lambda_u244 = context;
        boolean bl = false;
        Canvas canvas = $this$drawNonScrollableContent_u24lambda_u244.getCanvas();
        float f = this.getBounds().left;
        float f2 = 0.0f;
        float f3 = this.getBounds().right;
        float f4 = context.getCanvas().getHeight();
        boolean $i$f$inClip = false;
        int clipRestoreCount$iv = $this$inClip$iv.save();
        $this$inClip$iv.clipRect((float)left$iv, (float)top$iv, (float)right$iv, (float)bottom$iv);
        boolean bl2 = false;
        this.drawDecorationAboveChart(context);
        $this$inClip$iv.restoreToCount(clipRestoreCount$iv);
        Map $this$forEach$iv = this.persistentMarkers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List<Marker.EntryModel> list;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl3 = false;
            float x = ((Number)entry.getKey()).floatValue();
            Marker marker = (Marker)entry.getValue();
            if (MapExtensionsKt.getEntryModel(this.getEntryLocationMap(), x) == null) continue;
            List<Marker.EntryModel> markerModel = list;
            boolean bl4 = false;
            marker.draw(context, this.getBounds(), markerModel, $this$drawNonScrollableContent_u24lambda_u244.getChartValuesManager());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawChartInternal(@NotNull ChartDrawContext context, @NotNull Model model) {
        void bottom$iv;
        void right$iv;
        void top$iv;
        void left$iv;
        void $this$inClip$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        ChartDrawContext $this$drawChartInternal_u24lambda_u246 = context;
        boolean bl = false;
        Canvas canvas = $this$drawChartInternal_u24lambda_u246.getCanvas();
        float f = this.getBounds().left - this.insets.getLeft($this$drawChartInternal_u24lambda_u246.isLtr());
        float f2 = this.getBounds().top - this.insets.getTop();
        float f3 = this.getBounds().right + this.insets.getRight($this$drawChartInternal_u24lambda_u246.isLtr());
        float f4 = this.getBounds().bottom + this.insets.getBottom();
        boolean $i$f$inClip = false;
        int clipRestoreCount$iv = $this$inClip$iv.save();
        $this$inClip$iv.clipRect((float)left$iv, (float)top$iv, (float)right$iv, (float)bottom$iv);
        boolean bl2 = false;
        this.drawDecorationBehindChart(context);
        if (!((Collection)model.getEntries()).isEmpty()) {
            this.drawChart(context, model);
        }
        $this$inClip$iv.restoreToCount(clipRestoreCount$iv);
    }

    protected abstract void drawChart(@NotNull ChartDrawContext var1, @NotNull Model var2);

    protected final void drawDecorationBehindChart(@NotNull ChartDrawContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$forEach$iv = this.decorations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Decoration line = (Decoration)element$iv;
            boolean bl = false;
            line.onDrawBehindChart(context, this.getBounds());
        }
    }

    protected final void drawDecorationAboveChart(@NotNull ChartDrawContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$forEach$iv = this.decorations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Decoration line = (Decoration)element$iv;
            boolean bl = false;
            line.onDrawAboveChart(context, this.getBounds());
        }
    }

    @Override
    public boolean removeDecorations(@NotNull List<? extends Decoration> decorations) {
        return Chart.DefaultImpls.removeDecorations(this, decorations);
    }

    @Override
    public void setBounds(@NotNull Number left, @NotNull Number top, @NotNull Number right, @NotNull Number bottom) {
        Chart.DefaultImpls.setBounds(this, left, top, right, bottom);
    }

    @Override
    public void getInsets(@NotNull MeasureContext context, @NotNull Insets outInsets, @NotNull HorizontalDimensions horizontalDimensions) {
        Chart.DefaultImpls.getInsets(this, context, outInsets, horizontalDimensions);
    }

    @Override
    public void getHorizontalInsets(@NotNull MeasureContext context, float availableHeight, @NotNull HorizontalInsets outInsets) {
        Chart.DefaultImpls.getHorizontalInsets(this, context, availableHeight, outInsets);
    }
}

