/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.axis.vertical;

import android.graphics.RectF;
import com.patrykandpatrick.vico.core.axis.Axis;
import com.patrykandpatrick.vico.core.axis.AxisKt;
import com.patrykandpatrick.vico.core.axis.AxisPosition;
import com.patrykandpatrick.vico.core.chart.dimensions.HorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.draw.ChartDrawContext;
import com.patrykandpatrick.vico.core.chart.insets.HorizontalInsets;
import com.patrykandpatrick.vico.core.chart.insets.Insets;
import com.patrykandpatrick.vico.core.chart.values.MutableChartValues;
import com.patrykandpatrick.vico.core.component.shape.LineComponent;
import com.patrykandpatrick.vico.core.component.text.HorizontalPosition;
import com.patrykandpatrick.vico.core.component.text.TextComponent;
import com.patrykandpatrick.vico.core.component.text.VerticalPosition;
import com.patrykandpatrick.vico.core.context.ExtrasExtensionsKt;
import com.patrykandpatrick.vico.core.context.MeasureContext;
import com.patrykandpatrick.vico.core.extension.RectExtensionsKt;
import com.patrykandpatrick.vico.core.throwable.UnknownAxisPositionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003EFGB\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u001e\u0010.\u001a\u00020\u00112\u0006\u0010+\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J \u00103\u001a\u00020*2\u0006\u0010+\u001a\u00020/2\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u000206H\u0016J \u00107\u001a\u00020*2\u0006\u0010+\u001a\u00020/2\u0006\u00105\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J,\u0010;\u001a\u00020**\u00020,2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020\u00112\u0006\u0010@\u001a\u00020\u0011H\u0002J\u0014\u0010A\u001a\u00020\u0017*\u00020/2\u0006\u00104\u001a\u00020\u0017H\u0002J\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020201*\u00020/2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010C\u001a\u00020\u0011*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\f\u0010D\u001a\u00020\u0011*\u00020/H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u0004\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006H"}, d2={"Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis;", "Position", "Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "Lcom/patrykandpatrick/vico/core/axis/Axis;", "position", "(Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;)V", "areLabelsOutsideAtStartOrInsideAtEnd", "", "getAreLabelsOutsideAtStartOrInsideAtEnd", "()Z", "horizontalLabelPosition", "Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$HorizontalLabelPosition;", "getHorizontalLabelPosition", "()Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$HorizontalLabelPosition;", "setHorizontalLabelPosition", "(Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$HorizontalLabelPosition;)V", "labelSpacing", "", "getLabelSpacing", "()F", "setLabelSpacing", "(F)V", "maxLabelCount", "", "getMaxLabelCount", "()I", "setMaxLabelCount", "(I)V", "getPosition", "()Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "textHorizontalPosition", "Lcom/patrykandpatrick/vico/core/component/text/HorizontalPosition;", "getTextHorizontalPosition", "()Lcom/patrykandpatrick/vico/core/component/text/HorizontalPosition;", "verticalLabelPosition", "Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$VerticalLabelPosition;", "getVerticalLabelPosition", "()Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$VerticalLabelPosition;", "setVerticalLabelPosition", "(Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$VerticalLabelPosition;)V", "drawAboveChart", "", "context", "Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;", "drawBehindChart", "getDesiredWidth", "Lcom/patrykandpatrick/vico/core/context/MeasureContext;", "labels", "", "", "getHorizontalInsets", "availableHeight", "outInsets", "Lcom/patrykandpatrick/vico/core/chart/insets/HorizontalInsets;", "getInsets", "Lcom/patrykandpatrick/vico/core/chart/insets/Insets;", "horizontalDimensions", "Lcom/patrykandpatrick/vico/core/chart/dimensions/HorizontalDimensions;", "drawLabel", "label", "Lcom/patrykandpatrick/vico/core/component/text/TextComponent;", "labelText", "labelX", "tickCenterY", "getDrawLabelCount", "getLabels", "getMaxLabelWidth", "getTickLeftX", "Builder", "HorizontalLabelPosition", "VerticalLabelPosition", "core_release"})
@SourceDebugExtension(value={"SMAP\nVerticalAxis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalAxis.kt\ncom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis\n+ 2 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n63#2:400\n63#2:401\n63#2:402\n63#2:403\n63#2:405\n63#2:407\n63#2:408\n87#2:409\n87#2:410\n63#2:411\n63#2:412\n63#2:413\n87#2:414\n63#2:415\n87#2:416\n63#2:417\n87#2:419\n1855#3:404\n1856#3:406\n1#4:418\n*S KotlinDebug\n*F\n+ 1 VerticalAxis.kt\ncom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis\n*L\n94#1:400\n99#1:401\n101#1:402\n126#1:403\n133#1:405\n199#1:407\n208#1:408\n227#1:409\n270#1:410\n274#1:411\n275#1:412\n282#1:413\n304#1:414\n305#1:415\n314#1:416\n314#1:417\n321#1:419\n132#1:404\n132#1:406\n*E\n"})
public final class VerticalAxis<Position extends AxisPosition.Vertical>
extends Axis<Position> {
    @NotNull
    private final Position position;
    private int maxLabelCount;
    private float labelSpacing;
    @NotNull
    private HorizontalLabelPosition horizontalLabelPosition;
    @NotNull
    private VerticalLabelPosition verticalLabelPosition;

    public VerticalAxis(@NotNull Position position) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        this.position = position;
        this.maxLabelCount = 100;
        this.labelSpacing = 16.0f;
        this.horizontalLabelPosition = HorizontalLabelPosition.Outside;
        this.verticalLabelPosition = VerticalLabelPosition.Center;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    private final boolean getAreLabelsOutsideAtStartOrInsideAtEnd() {
        return this.horizontalLabelPosition == HorizontalLabelPosition.Outside && this.getPosition() instanceof AxisPosition.Vertical.Start || this.horizontalLabelPosition == HorizontalLabelPosition.Inside && this.getPosition() instanceof AxisPosition.Vertical.End;
    }

    private final HorizontalPosition getTextHorizontalPosition() {
        return this.getAreLabelsOutsideAtStartOrInsideAtEnd() ? HorizontalPosition.Start : HorizontalPosition.End;
    }

    public final int getMaxLabelCount() {
        return this.maxLabelCount;
    }

    public final void setMaxLabelCount(int n) {
        this.maxLabelCount = n;
    }

    public final float getLabelSpacing() {
        return this.labelSpacing;
    }

    public final void setLabelSpacing(float f) {
        this.labelSpacing = f;
    }

    @NotNull
    public final HorizontalLabelPosition getHorizontalLabelPosition() {
        return this.horizontalLabelPosition;
    }

    public final void setHorizontalLabelPosition(@NotNull HorizontalLabelPosition horizontalLabelPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalLabelPosition), (String)"<set-?>");
        this.horizontalLabelPosition = horizontalLabelPosition;
    }

    @NotNull
    public final VerticalLabelPosition getVerticalLabelPosition() {
        return this.verticalLabelPosition;
    }

    public final void setVerticalLabelPosition(@NotNull VerticalLabelPosition verticalLabelPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticalLabelPosition), (String)"<set-?>");
        this.verticalLabelPosition = verticalLabelPosition;
    }

    @Override
    public void drawBehindChart(@NotNull ChartDrawContext context) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ChartDrawContext $this$drawBehindChart_u24lambda_u241 = context;
            boolean bl = false;
            int drawLabelCount = this.getDrawLabelCount($this$drawBehindChart_u24lambda_u241, (int)this.getBounds().height());
            float axisStep = this.getBounds().height() / (float)(drawLabelCount - 1);
            float centerY = 0.0f;
            for (int index = 0; index < drawLabelCount; ++index) {
                LineComponent lineComponent;
                LineComponent lineComponent2;
                float $this$half$iv = this.getGuidelineThickness($this$drawBehindChart_u24lambda_u241);
                boolean $i$f$getHalf = false;
                centerY = this.getBounds().bottom - axisStep * (float)index + $this$half$iv / (float)2;
                LineComponent lineComponent3 = this.getGuideline();
                if (lineComponent3 == null) continue;
                LineComponent it = lineComponent2 = lineComponent3;
                boolean bl2 = false;
                float $this$half$iv2 = this.getGuidelineThickness($this$drawBehindChart_u24lambda_u241);
                boolean $i$f$getHalf2 = false;
                float f = centerY - $this$half$iv2 / (float)2;
                $this$half$iv2 = this.getGuidelineThickness($this$drawBehindChart_u24lambda_u241);
                $i$f$getHalf2 = false;
                LineComponent lineComponent4 = lineComponent = this.isNotInRestrictedBounds($this$drawBehindChart_u24lambda_u241.getChartBounds().left, f, $this$drawBehindChart_u24lambda_u241.getChartBounds().right, centerY - $this$half$iv2 / (float)2) ? lineComponent2 : null;
                if (lineComponent == null) continue;
                LineComponent.drawHorizontal$default(lineComponent, context, $this$drawBehindChart_u24lambda_u241.getChartBounds().left, $this$drawBehindChart_u24lambda_u241.getChartBounds().right, centerY, 0.0f, 16, null);
            }
            LineComponent lineComponent = this.getAxisLine();
            if (lineComponent == null) break block1;
            LineComponent.drawVertical$default(lineComponent, context, this.getBounds().top, this.getBounds().bottom + this.getAxisThickness($this$drawBehindChart_u24lambda_u241), this.getPosition().isLeft($this$drawBehindChart_u24lambda_u241.isLtr()) ? this.getBounds().right : this.getBounds().left, 0.0f, 16, null);
        }
    }

    @Override
    public void drawAboveChart(@NotNull ChartDrawContext context) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ChartDrawContext $this$drawAboveChart_u24lambda_u244 = context;
            boolean bl = false;
            TextComponent label = this.getLabel();
            int labelCount = this.getDrawLabelCount($this$drawAboveChart_u24lambda_u244, (int)this.getBounds().height());
            List<CharSequence> labels = this.getLabels($this$drawAboveChart_u24lambda_u244, labelCount);
            float tickLeftX = this.getTickLeftX($this$drawAboveChart_u24lambda_u244);
            float $this$half$iv = this.getAxisThickness($this$drawAboveChart_u24lambda_u244);
            boolean $i$f$getHalf = false;
            float tickRightX = tickLeftX + $this$half$iv / (float)2 + this.getTickLength($this$drawAboveChart_u24lambda_u244);
            float labelX = this.getAreLabelsOutsideAtStartOrInsideAtEnd() == $this$drawAboveChart_u24lambda_u244.isLtr() ? tickLeftX : tickRightX;
            float tickCenterY = 0.0f;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)labelCount);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                CharSequence labelText;
                int element$iv;
                int index = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                float $this$half$iv2 = this.getTickThickness($this$drawAboveChart_u24lambda_u244);
                boolean $i$f$getHalf2 = false;
                tickCenterY = this.getBounds().bottom - this.getBounds().height() / (float)(labelCount - 1) * (float)index + $this$half$iv2 / (float)2;
                LineComponent lineComponent = this.getTick();
                if (lineComponent != null) {
                    LineComponent.drawHorizontal$default(lineComponent, context, tickLeftX, tickRightX, tickCenterY, 0.0f, 16, null);
                }
                if (label == null || (CharSequence)CollectionsKt.getOrNull(labels, (int)index) == null) continue;
                this.drawLabel($this$drawAboveChart_u24lambda_u244, label, labelText, labelX, tickCenterY);
            }
            CharSequence charSequence = this.getTitle();
            if (charSequence == null) break block3;
            CharSequence title = charSequence;
            boolean bl3 = false;
            TextComponent textComponent2 = this.getTitleComponent();
            if (textComponent2 != null) {
                float f = this.getPosition().isStart() ? RectExtensionsKt.getStart(this.getBounds(), $this$drawAboveChart_u24lambda_u244.isLtr()) : RectExtensionsKt.getEnd(this.getBounds(), $this$drawAboveChart_u24lambda_u244.isLtr());
                float f2 = this.getBounds().centerY();
                HorizontalPosition horizontalPosition = this.getPosition().isStart() ? HorizontalPosition.End : HorizontalPosition.Start;
                VerticalPosition verticalPosition = VerticalPosition.Center;
                float f3 = 90.0f * (this.getPosition().isStart() ? -1.0f : 1.0f);
                int n = (int)this.getBounds().height();
                TextComponent.drawText$default(textComponent2, $this$drawAboveChart_u24lambda_u244, title, f, f2, horizontalPosition, verticalPosition, 0, n, f3, 64, null);
            }
        }
    }

    private final void drawLabel(ChartDrawContext $this$drawLabel, TextComponent label, CharSequence labelText, float labelX, float tickCenterY) {
        Object object;
        RectF $this$drawLabel_u24lambda_u245 = object = TextComponent.getTextBounds$default(label, $this$drawLabel, labelText, 0, 0, null, false, this.getLabelRotationDegrees(), 60, null);
        boolean bl = false;
        RectExtensionsKt.translate($this$drawLabel_u24lambda_u245, labelX, tickCenterY - $this$drawLabel_u24lambda_u245.centerY());
        RectF textBounds = object;
        if (this.horizontalLabelPosition == HorizontalLabelPosition.Outside || this.isNotInRestrictedBounds(textBounds.left, textBounds.top, textBounds.right, textBounds.bottom)) {
            int n;
            object = this.getTextHorizontalPosition();
            VerticalPosition verticalPosition = this.verticalLabelPosition.getTextPosition();
            float f = this.getLabelRotationDegrees();
            if (this.getSizeConstraint() instanceof Axis.SizeConstraint.Auto) {
                n = Integer.MAX_VALUE;
            } else {
                float $this$half$iv = this.getAxisThickness($this$drawLabel);
                boolean $i$f$getHalf = false;
                n = (int)(this.getBounds().width() - this.getTickLength($this$drawLabel) - $this$half$iv / (float)2);
            }
            int n2 = n;
            TextComponent.drawText$default(label, $this$drawLabel, labelText, labelX, tickCenterY, (HorizontalPosition)((Object)object), verticalPosition, n2, 0, f, 128, null);
        }
    }

    private final float getTickLeftX(MeasureContext $this$getTickLeftX) {
        float f;
        boolean onLeft = this.getPosition().isLeft($this$getTickLeftX.isLtr());
        float base = onLeft ? this.getBounds().right : this.getBounds().left;
        if (onLeft == (this.horizontalLabelPosition == HorizontalLabelPosition.Outside)) {
            float $this$half$iv = this.getAxisThickness($this$getTickLeftX);
            boolean $i$f$getHalf = false;
            f = base - $this$half$iv / (float)2 - this.getTickLength($this$getTickLeftX);
        } else {
            f = base;
        }
        return f;
    }

    private final int getDrawLabelCount(MeasureContext $this$getDrawLabelCount, int availableHeight) {
        TextComponent textComponent2 = this.getLabel();
        if (textComponent2 != null) {
            TextComponent label = textComponent2;
            boolean bl = false;
            MutableChartValues chartValues = $this$getDrawLabelCount.getChartValuesManager().getChartValues((AxisPosition.Vertical)this.getPosition());
            Float[] floatArray = new Float[]{Float.valueOf(VerticalAxis.getDrawLabelCount$lambda$6$getLabelHeight(label, $this$getDrawLabelCount, this, chartValues, chartValues.getMinY())), Float.valueOf(VerticalAxis.getDrawLabelCount$lambda$6$getLabelHeight(label, $this$getDrawLabelCount, this, chartValues, (chartValues.getMaxY() + chartValues.getMinY()) / (float)2)), Float.valueOf(VerticalAxis.getDrawLabelCount$lambda$6$getLabelHeight(label, $this$getDrawLabelCount, this, chartValues, chartValues.getMaxY()))};
            Float $this$orZero$iv = ArraysKt.maxOrNull((Float[])floatArray);
            boolean $i$f$getOrZero = false;
            Float f = $this$orZero$iv;
            float avgHeight = f != null ? f.floatValue() : 0.0f;
            return RangesKt.coerceAtMost((int)((int)((float)availableHeight / avgHeight + 1.0f)), (int)this.maxLabelCount);
        }
        return this.maxLabelCount;
    }

    private final List<CharSequence> getLabels(MeasureContext $this$getLabels, int maxLabelCount) {
        MutableChartValues chartValues = $this$getLabels.getChartValuesManager().getChartValues((AxisPosition.Vertical)this.getPosition());
        String cacheKey = "labels" + this.getPosition() + maxLabelCount;
        return (List)ExtrasExtensionsKt.getOrPutExtra($this$getLabels, cacheKey, (Function0)new Function0<ArrayList<CharSequence>>(this, chartValues, maxLabelCount){
            final /* synthetic */ VerticalAxis<Position> this$0;
            final /* synthetic */ MutableChartValues $chartValues;
            final /* synthetic */ int $maxLabelCount;
            {
                this.this$0 = $receiver;
                this.$chartValues = $chartValues;
                this.$maxLabelCount = $maxLabelCount;
                super(0);
            }

            @NotNull
            public final ArrayList<CharSequence> invoke() {
                VerticalAxis.access$getLabels(this.this$0).clear();
                float step = (this.$chartValues.getMaxY() - this.$chartValues.getMinY()) / (float)(this.$maxLabelCount - 1);
                for (int index = 0; index < this.$maxLabelCount; ++index) {
                    float value = this.$chartValues.getMinY() + step * (float)index;
                    ((Collection)VerticalAxis.access$getLabels(this.this$0)).add(this.this$0.getValueFormatter().formatValue(value, this.$chartValues));
                }
                return VerticalAxis.access$getLabels(this.this$0);
            }
        });
    }

    static /* synthetic */ List getLabels$default(VerticalAxis verticalAxis, MeasureContext measureContext, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = verticalAxis.maxLabelCount;
        }
        return verticalAxis.getLabels(measureContext, n);
    }

    @Override
    public void getHorizontalInsets(@NotNull MeasureContext context, float availableHeight, @NotNull HorizontalInsets outInsets) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)outInsets, (String)"outInsets");
        MeasureContext $this$getHorizontalInsets_u24lambda_u247 = context;
        boolean bl = false;
        List<CharSequence> labels = this.getLabels($this$getHorizontalInsets_u24lambda_u247, this.getDrawLabelCount($this$getHorizontalInsets_u24lambda_u247, (int)availableHeight));
        float desiredWidth = this.getDesiredWidth(context, labels);
        outInsets.set(this.getPosition().isStart() ? desiredWidth : 0.0f, this.getPosition().isEnd() ? desiredWidth : 0.0f);
    }

    @Override
    public void getInsets(@NotNull MeasureContext context, @NotNull Insets outInsets, @NotNull HorizontalDimensions horizontalDimensions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)outInsets, (String)"outInsets");
        Intrinsics.checkNotNullParameter((Object)horizontalDimensions, (String)"horizontalDimensions");
        MeasureContext $this$getInsets_u24lambda_u248 = context;
        boolean bl = false;
        TextComponent textComponent2 = this.getLabel();
        Float $this$orZero$iv = textComponent2 != null ? Float.valueOf(TextComponent.getHeight$default(textComponent2, context, null, 0, 0, 0.0f, 30, null)) : null;
        boolean $i$f$getOrZero = false;
        Float f = $this$orZero$iv;
        float labelHeight = f != null ? f.floatValue() : 0.0f;
        float lineThickness = Math.max(this.getAxisThickness($this$getInsets_u24lambda_u248), this.getTickThickness($this$getInsets_u24lambda_u248));
        switch (WhenMappings.$EnumSwitchMapping$0[this.verticalLabelPosition.ordinal()]) {
            case 1: {
                float $this$half$iv = labelHeight;
                boolean $i$f$getHalf = false;
                float f2 = $this$half$iv / (float)2 - lineThickness;
                $this$half$iv = labelHeight;
                $i$f$getHalf = false;
                Insets.set$default(outInsets, 0.0f, f2, 0.0f, $this$half$iv / (float)2, 5, null);
                break;
            }
            case 2: {
                Insets.set$default(outInsets, 0.0f, labelHeight - lineThickness, 0.0f, lineThickness, 5, null);
                break;
            }
            case 3: {
                float $this$half$iv = lineThickness;
                boolean $i$f$getHalf = false;
                Insets.set$default(outInsets, 0.0f, $this$half$iv / (float)2, 0.0f, labelHeight, 5, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final float getDesiredWidth(MeasureContext context, List<? extends CharSequence> labels) {
        float f;
        MeasureContext $this$getDesiredWidth_u24lambda_u2410 = context;
        boolean bl = false;
        Axis.SizeConstraint constraint = this.getSizeConstraint();
        if (constraint instanceof Axis.SizeConstraint.Auto) {
            void $this$orZero$iv;
            Float f2;
            CharSequence charSequence = this.getTitle();
            if (charSequence != null) {
                CharSequence title = charSequence;
                boolean bl2 = false;
                TextComponent textComponent2 = this.getTitleComponent();
                if (textComponent2 != null) {
                    int n = (int)this.getBounds().height();
                    f2 = Float.valueOf(TextComponent.getWidth$default(textComponent2, $this$getDesiredWidth_u24lambda_u2410, title, 0, n, 90.0f, 4, null));
                } else {
                    f2 = null;
                }
            } else {
                f2 = null;
            }
            Float f3 = f2;
            boolean $i$f$getOrZero = false;
            void v2 = $this$orZero$iv;
            float titleComponentWidth = v2 != null ? v2.floatValue() : 0.0f;
            float $this$half$iv = this.getAxisThickness($this$getDesiredWidth_u24lambda_u2410);
            boolean $i$f$getHalf = false;
            f = RangesKt.coerceIn((float)(this.getMaxLabelWidth($this$getDesiredWidth_u24lambda_u2410, labels) + titleComponentWidth + $this$half$iv / (float)2 + this.getTickLength($this$getDesiredWidth_u24lambda_u2410)), (float)$this$getDesiredWidth_u24lambda_u2410.getPixels(((Axis.SizeConstraint.Auto)constraint).getMinSizeDp()), (float)$this$getDesiredWidth_u24lambda_u2410.getPixels(((Axis.SizeConstraint.Auto)constraint).getMaxSizeDp()));
        } else if (constraint instanceof Axis.SizeConstraint.Exact) {
            f = $this$getDesiredWidth_u24lambda_u2410.getPixels(((Axis.SizeConstraint.Exact)constraint).getSizeDp());
        } else if (constraint instanceof Axis.SizeConstraint.Fraction) {
            f = $this$getDesiredWidth_u24lambda_u2410.getCanvasBounds().width() * ((Axis.SizeConstraint.Fraction)constraint).getFraction();
        } else if (constraint instanceof Axis.SizeConstraint.TextWidth) {
            void $this$orZero$iv;
            TextComponent textComponent3 = this.getLabel();
            Float titleComponentWidth = textComponent3 != null ? Float.valueOf(TextComponent.getWidth$default(textComponent3, $this$getDesiredWidth_u24lambda_u2410, ((Axis.SizeConstraint.TextWidth)constraint).getText(), 0, 0, this.getLabelRotationDegrees(), 12, null)) : null;
            boolean $i$f$getOrZero = false;
            void v5 = $this$orZero$iv;
            float $this$half$iv = this.getAxisThickness($this$getDesiredWidth_u24lambda_u2410);
            boolean $i$f$getHalf = false;
            f = (v5 != null ? v5.floatValue() : 0.0f) + this.getTickLength($this$getDesiredWidth_u24lambda_u2410) + $this$half$iv / (float)2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return f;
    }

    private final float getMaxLabelWidth(MeasureContext $this$getMaxLabelWidth, List<? extends CharSequence> labels) {
        float f;
        switch (WhenMappings.$EnumSwitchMapping$1[this.horizontalLabelPosition.ordinal()]) {
            case 1: {
                Float f2;
                TextComponent textComponent2 = this.getLabel();
                if (textComponent2 != null) {
                    TextComponent label = textComponent2;
                    boolean bl = false;
                    Iterator iterator = ((Iterable)labels).iterator();
                    if (!iterator.hasNext()) {
                        f2 = null;
                    } else {
                        CharSequence it = (CharSequence)iterator.next();
                        boolean bl2 = false;
                        float f3 = TextComponent.getWidth$default(label, $this$getMaxLabelWidth, it, 0, 0, this.getLabelRotationDegrees(), 12, null);
                        while (iterator.hasNext()) {
                            CharSequence it2 = (CharSequence)iterator.next();
                            $i$a$-maxOfOrNull-VerticalAxis$getMaxLabelWidth$1$1 = false;
                            float f4 = TextComponent.getWidth$default(label, $this$getMaxLabelWidth, it2, 0, 0, this.getLabelRotationDegrees(), 12, null);
                            f3 = Math.max(f3, f4);
                        }
                        f2 = Float.valueOf(f3);
                    }
                } else {
                    f2 = null;
                }
                Float $this$orZero$iv = f2;
                boolean $i$f$getOrZero = false;
                Float f5 = $this$orZero$iv;
                if (f5 != null) {
                    f = f5.floatValue();
                    break;
                }
                f = 0.0f;
                break;
            }
            case 2: {
                f = 0.0f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private static final <Position extends AxisPosition.Vertical> float getDrawLabelCount$lambda$6$getLabelHeight(TextComponent $label, MeasureContext $this_getDrawLabelCount, VerticalAxis<Position> this$0, MutableChartValues chartValues, float value) {
        return TextComponent.getHeight$default($label, $this_getDrawLabelCount, this$0.getValueFormatter().formatValue(value, chartValues), 0, 0, this$0.getLabelRotationDegrees(), 12, null);
    }

    public static final /* synthetic */ ArrayList access$getLabels(VerticalAxis $this) {
        return $this.getLabels();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\n\b\u0002\u0010 \u0018\u0001*\u00028\u0001H\u0086\bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$Builder;", "Position", "Lcom/patrykandpatrick/vico/core/axis/AxisPosition$Vertical;", "Lcom/patrykandpatrick/vico/core/axis/Axis$Builder;", "builder", "(Lcom/patrykandpatrick/vico/core/axis/Axis$Builder;)V", "horizontalLabelPosition", "Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$HorizontalLabelPosition;", "getHorizontalLabelPosition", "()Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$HorizontalLabelPosition;", "setHorizontalLabelPosition", "(Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$HorizontalLabelPosition;)V", "labelSpacing", "", "getLabelSpacing", "()F", "setLabelSpacing", "(F)V", "maxLabelCount", "", "getMaxLabelCount", "()I", "setMaxLabelCount", "(I)V", "verticalLabelPosition", "Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$VerticalLabelPosition;", "getVerticalLabelPosition", "()Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$VerticalLabelPosition;", "setVerticalLabelPosition", "(Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$VerticalLabelPosition;)V", "build", "Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis;", "T", "core_release"})
    public static final class Builder<Position extends AxisPosition.Vertical>
    extends Axis.Builder<Position> {
        private int maxLabelCount;
        private float labelSpacing;
        @NotNull
        private HorizontalLabelPosition horizontalLabelPosition;
        @NotNull
        private VerticalLabelPosition verticalLabelPosition;

        public Builder(@Nullable Axis.Builder<Position> builder) {
            super(builder);
            this.maxLabelCount = 100;
            this.labelSpacing = 16.0f;
            this.horizontalLabelPosition = HorizontalLabelPosition.Outside;
            this.verticalLabelPosition = VerticalLabelPosition.Center;
        }

        public /* synthetic */ Builder(Axis.Builder builder, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                builder = null;
            }
            this(builder);
        }

        public final int getMaxLabelCount() {
            return this.maxLabelCount;
        }

        public final void setMaxLabelCount(int n) {
            this.maxLabelCount = n;
        }

        public final float getLabelSpacing() {
            return this.labelSpacing;
        }

        public final void setLabelSpacing(float f) {
            this.labelSpacing = f;
        }

        @NotNull
        public final HorizontalLabelPosition getHorizontalLabelPosition() {
            return this.horizontalLabelPosition;
        }

        public final void setHorizontalLabelPosition(@NotNull HorizontalLabelPosition horizontalLabelPosition) {
            Intrinsics.checkNotNullParameter((Object)((Object)horizontalLabelPosition), (String)"<set-?>");
            this.horizontalLabelPosition = horizontalLabelPosition;
        }

        @NotNull
        public final VerticalLabelPosition getVerticalLabelPosition() {
            return this.verticalLabelPosition;
        }

        public final void setVerticalLabelPosition(@NotNull VerticalLabelPosition verticalLabelPosition) {
            Intrinsics.checkNotNullParameter((Object)((Object)verticalLabelPosition), (String)"<set-?>");
            this.verticalLabelPosition = verticalLabelPosition;
        }

        public final /* synthetic */ <T extends Position> VerticalAxis<T> build() {
            AxisPosition.Vertical vertical;
            boolean $i$f$build = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object object = AxisPosition.Vertical.class;
            if (Intrinsics.areEqual(object, AxisPosition.Vertical.Start.class)) {
                vertical = AxisPosition.Vertical.Start.INSTANCE;
            } else if (Intrinsics.areEqual(object, AxisPosition.Vertical.End.class)) {
                vertical = AxisPosition.Vertical.End.INSTANCE;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw new UnknownAxisPositionException(AxisPosition.Vertical.class);
            }
            Intrinsics.checkNotNull((Object)vertical, (String)"null cannot be cast to non-null type Position of com.patrykandpatrick.vico.core.axis.vertical.VerticalAxis.Builder");
            AxisPosition.Vertical position = vertical;
            object = AxisKt.setTo(this, (Axis)new VerticalAxis<AxisPosition.Vertical>(position));
            VerticalAxis axis = (VerticalAxis)object;
            boolean bl = false;
            axis.setMaxLabelCount(this.getMaxLabelCount());
            axis.setLabelSpacing(this.getLabelSpacing());
            axis.setHorizontalLabelPosition(this.getHorizontalLabelPosition());
            axis.setVerticalLabelPosition(this.getVerticalLabelPosition());
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.patrykandpatrick.vico.core.axis.vertical.VerticalAxis<T of com.patrykandpatrick.vico.core.axis.vertical.VerticalAxis.Builder.build>");
            return (VerticalAxis)object2;
        }

        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$HorizontalLabelPosition;", "", "(Ljava/lang/String;I)V", "Outside", "Inside", "core_release"})
    public static final class HorizontalLabelPosition
    extends Enum<HorizontalLabelPosition> {
        public static final /* enum */ HorizontalLabelPosition Outside = new HorizontalLabelPosition();
        public static final /* enum */ HorizontalLabelPosition Inside = new HorizontalLabelPosition();
        private static final /* synthetic */ HorizontalLabelPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HorizontalLabelPosition[] values() {
            return (HorizontalLabelPosition[])$VALUES.clone();
        }

        public static HorizontalLabelPosition valueOf(String value) {
            return Enum.valueOf(HorizontalLabelPosition.class, value);
        }

        @NotNull
        public static EnumEntries<HorizontalLabelPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = horizontalLabelPositionArray = new HorizontalLabelPosition[]{HorizontalLabelPosition.Outside, HorizontalLabelPosition.Inside};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/patrykandpatrick/vico/core/axis/vertical/VerticalAxis$VerticalLabelPosition;", "", "textPosition", "Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;", "(Ljava/lang/String;ILcom/patrykandpatrick/vico/core/component/text/VerticalPosition;)V", "getTextPosition", "()Lcom/patrykandpatrick/vico/core/component/text/VerticalPosition;", "Center", "Top", "Bottom", "core_release"})
    public static final class VerticalLabelPosition
    extends Enum<VerticalLabelPosition> {
        @NotNull
        private final VerticalPosition textPosition;
        public static final /* enum */ VerticalLabelPosition Center = new VerticalLabelPosition(VerticalPosition.Center);
        public static final /* enum */ VerticalLabelPosition Top = new VerticalLabelPosition(VerticalPosition.Top);
        public static final /* enum */ VerticalLabelPosition Bottom = new VerticalLabelPosition(VerticalPosition.Bottom);
        private static final /* synthetic */ VerticalLabelPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VerticalLabelPosition(VerticalPosition textPosition) {
            this.textPosition = textPosition;
        }

        @NotNull
        public final VerticalPosition getTextPosition() {
            return this.textPosition;
        }

        public static VerticalLabelPosition[] values() {
            return (VerticalLabelPosition[])$VALUES.clone();
        }

        public static VerticalLabelPosition valueOf(String value) {
            return Enum.valueOf(VerticalLabelPosition.class, value);
        }

        @NotNull
        public static EnumEntries<VerticalLabelPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = verticalLabelPositionArray = new VerticalLabelPosition[]{VerticalLabelPosition.Center, VerticalLabelPosition.Top, VerticalLabelPosition.Bottom};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VerticalLabelPosition.values().length];
            try {
                nArray[VerticalLabelPosition.Center.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalLabelPosition.Top.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalLabelPosition.Bottom.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HorizontalLabelPosition.values().length];
            try {
                nArray[HorizontalLabelPosition.Outside.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalLabelPosition.Inside.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

