/*
 * Decompiled with CFR 0.152.
 */
package com.patrykandpatrick.vico.core.axis.horizontal;

import com.patrykandpatrick.vico.core.axis.AxisItemPlacer;
import com.patrykandpatrick.vico.core.chart.dimensions.HorizontalDimensions;
import com.patrykandpatrick.vico.core.chart.draw.ChartDrawContext;
import com.patrykandpatrick.vico.core.chart.layout.HorizontalLayout;
import com.patrykandpatrick.vico.core.chart.values.ChartValues;
import com.patrykandpatrick.vico.core.context.MeasureContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\b\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J4\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J&\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/patrykandpatrick/vico/core/axis/horizontal/DefaultHorizontalAxisItemPlacer;", "Lcom/patrykandpatrick/vico/core/axis/AxisItemPlacer$Horizontal;", "spacing", "", "offset", "(II)V", "getEndHorizontalAxisInset", "", "context", "Lcom/patrykandpatrick/vico/core/context/MeasureContext;", "horizontalDimensions", "Lcom/patrykandpatrick/vico/core/chart/dimensions/HorizontalDimensions;", "tickThickness", "getLabelValues", "", "Lcom/patrykandpatrick/vico/core/chart/draw/ChartDrawContext;", "visibleXRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "fullXRange", "getLineValues", "getMeasuredLabelClearance", "getMeasuredLabelValues", "getStartHorizontalAxisInset", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nDefaultHorizontalAxisItemPlacer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHorizontalAxisItemPlacer.kt\ncom/patrykandpatrick/vico/core/axis/horizontal/DefaultHorizontalAxisItemPlacer\n+ 2 NumberExtensions.kt\ncom/patrykandpatrick/vico/core/extension/NumberExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n99#2:120\n63#2:122\n63#2:123\n63#2:124\n63#2:125\n63#2:126\n1#3:121\n*S KotlinDebug\n*F\n+ 1 DefaultHorizontalAxisItemPlacer.kt\ncom/patrykandpatrick/vico/core/axis/horizontal/DefaultHorizontalAxisItemPlacer\n*L\n46#1:120\n61#1:122\n101#1:123\n102#1:124\n110#1:125\n111#1:126\n*E\n"})
public final class DefaultHorizontalAxisItemPlacer
implements AxisItemPlacer.Horizontal {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int spacing;
    private final int offset;
    @Deprecated
    public static final int LABEL_OVERFLOW_SIZE = 2;
    @Deprecated
    public static final int TICK_OVERFLOW_SIZE = 1;

    public DefaultHorizontalAxisItemPlacer(int spacing, int offset) {
        this.spacing = spacing;
        this.offset = offset;
    }

    public /* synthetic */ DefaultHorizontalAxisItemPlacer(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 1;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<Float> getLabelValues(@NotNull ChartDrawContext context, @NotNull ClosedFloatingPointRange<Float> visibleXRange, @NotNull ClosedFloatingPointRange<Float> fullXRange) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(visibleXRange, (String)"visibleXRange");
        Intrinsics.checkNotNullParameter(fullXRange, (String)"fullXRange");
        ChartValues chartValues = context.getChartValuesManager().getChartValues();
        float remainder = ((((Number)((Object)visibleXRange.getStart())).floatValue() - chartValues.getMinX()) / chartValues.getXStep() - (float)this.offset) % (float)this.spacing;
        float firstValue = ((Number)((Object)visibleXRange.getStart())).floatValue() + ((float)this.spacing - remainder) % (float)this.spacing * chartValues.getXStep();
        List values = new ArrayList();
        int multiplier = -2;
        boolean hasEndOverflow = false;
        while (true) {
            boolean bl;
            float potentialValue = firstValue + (float)(multiplier++ * this.spacing) * chartValues.getXStep();
            float $this$round$iv = potentialValue / chartValues.getXStep();
            boolean $i$f$getRound22 = false;
            potentialValue = chartValues.getXStep() * (float)MathKt.roundToInt((float)$this$round$iv);
            if (potentialValue < chartValues.getMinX() || potentialValue == ((Number)((Object)fullXRange.getStart())).floatValue()) continue;
            if (potentialValue > chartValues.getMaxX() || potentialValue == ((Number)((Object)fullXRange.getEndInclusive())).floatValue()) return values;
            Float $i$f$getRound22 = Float.valueOf(potentialValue);
            ((Collection)values).add($i$f$getRound22);
            if (!(potentialValue > ((Number)((Object)visibleXRange.getEndInclusive())).floatValue())) continue;
            boolean it = bl = hasEndOverflow;
            boolean bl2 = false;
            hasEndOverflow = true;
            if (bl) return values;
        }
    }

    @Override
    @NotNull
    public List<Float> getMeasuredLabelValues(@NotNull MeasureContext context, @NotNull HorizontalDimensions horizontalDimensions, @NotNull ClosedFloatingPointRange<Float> fullXRange) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)horizontalDimensions, (String)"horizontalDimensions");
        Intrinsics.checkNotNullParameter(fullXRange, (String)"fullXRange");
        ChartValues chartValues = context.getChartValuesManager().getChartValues();
        Object[] objectArray = new Float[3];
        objectArray[0] = Float.valueOf(chartValues.getMinX());
        float $this$half$iv = chartValues.getMinX() + chartValues.getMaxX();
        boolean $i$f$getHalf = false;
        objectArray[1] = Float.valueOf($this$half$iv / (float)2);
        objectArray[2] = Float.valueOf(chartValues.getMaxX());
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public float getMeasuredLabelClearance(@NotNull MeasureContext context, @NotNull HorizontalDimensions horizontalDimensions, @NotNull ClosedFloatingPointRange<Float> fullXRange) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)horizontalDimensions, (String)"horizontalDimensions");
        Intrinsics.checkNotNullParameter(fullXRange, (String)"fullXRange");
        return this.spacing;
    }

    @Override
    @Nullable
    public List<Float> getLineValues(@NotNull ChartDrawContext context, @NotNull ClosedFloatingPointRange<Float> visibleXRange, @NotNull ClosedFloatingPointRange<Float> fullXRange) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(visibleXRange, (String)"visibleXRange");
        Intrinsics.checkNotNullParameter(fullXRange, (String)"fullXRange");
        ChartValues chartValues = context.getChartValuesManager().getChartValues();
        HorizontalLayout horizontalLayout = context.getHorizontalLayout();
        if (horizontalLayout instanceof HorizontalLayout.Segmented) {
            float remainder = (((Number)((Object)visibleXRange.getStart())).floatValue() - ((Number)((Object)fullXRange.getStart())).floatValue()) % chartValues.getXStep();
            float firstValue = ((Number)((Object)visibleXRange.getStart())).floatValue() + (chartValues.getXStep() - remainder) % chartValues.getXStep();
            int multiplier = -1;
            List values = new ArrayList();
            while (true) {
                float potentialValue;
                if ((potentialValue = firstValue + (float)multiplier++ * chartValues.getXStep()) < ((Number)((Object)fullXRange.getStart())).floatValue()) {
                    continue;
                }
                if (potentialValue > ((Number)((Object)fullXRange.getEndInclusive())).floatValue()) break;
                Float f = Float.valueOf(potentialValue);
                ((Collection)values).add(f);
                if (potentialValue > ((Number)((Object)visibleXRange.getEndInclusive())).floatValue()) break;
            }
            list = values;
        } else if (horizontalLayout instanceof HorizontalLayout.FullWidth) {
            list = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Override
    public float getStartHorizontalAxisInset(@NotNull MeasureContext context, @NotNull HorizontalDimensions horizontalDimensions, float tickThickness) {
        float f;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)horizontalDimensions, (String)"horizontalDimensions");
        HorizontalLayout horizontalLayout = context.getHorizontalLayout();
        if (horizontalLayout instanceof HorizontalLayout.Segmented) {
            float $this$half$iv = tickThickness;
            boolean $i$f$getHalf = false;
            f = $this$half$iv / (float)2;
        } else if (horizontalLayout instanceof HorizontalLayout.FullWidth) {
            float $this$half$iv = tickThickness;
            boolean $i$f$getHalf = false;
            f = RangesKt.coerceAtLeast((float)($this$half$iv / (float)2 - horizontalDimensions.getStartPadding()), (float)0.0f);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return f;
    }

    @Override
    public float getEndHorizontalAxisInset(@NotNull MeasureContext context, @NotNull HorizontalDimensions horizontalDimensions, float tickThickness) {
        float f;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)horizontalDimensions, (String)"horizontalDimensions");
        HorizontalLayout horizontalLayout = context.getHorizontalLayout();
        if (horizontalLayout instanceof HorizontalLayout.Segmented) {
            float $this$half$iv = tickThickness;
            boolean $i$f$getHalf = false;
            f = $this$half$iv / (float)2;
        } else if (horizontalLayout instanceof HorizontalLayout.FullWidth) {
            float $this$half$iv = tickThickness;
            boolean $i$f$getHalf = false;
            f = RangesKt.coerceAtLeast((float)($this$half$iv / (float)2 - horizontalDimensions.getEndPadding()), (float)0.0f);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return f;
    }

    public DefaultHorizontalAxisItemPlacer() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/patrykandpatrick/vico/core/axis/horizontal/DefaultHorizontalAxisItemPlacer$Companion;", "", "()V", "LABEL_OVERFLOW_SIZE", "", "TICK_OVERFLOW_SIZE", "core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

