/*
 * Decompiled with CFR 0.152.
 */
package bolts;

import android.content.Context;
import android.net.Uri;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import bolts.AppLink;
import bolts.AppLinkResolver;
import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebViewAppLinkResolver
implements AppLinkResolver {
    private final Context context;
    private static final String TAG_EXTRACTION_JAVASCRIPT = "javascript:boltsWebViewAppLinkResolverResult.setValue((function() {  var metaTags = document.getElementsByTagName('meta');  var results = [];  for (var i = 0; i < metaTags.length; i++) {    var property = metaTags[i].getAttribute('property');    if (property && property.substring(0, 'al:'.length) === 'al:') {      var tag = { \"property\": metaTags[i].getAttribute('property') };      if (metaTags[i].hasAttribute('content')) {        tag['content'] = metaTags[i].getAttribute('content');      }      results.push(tag);    }  }  return JSON.stringify(results);})())";
    private static final String PREFER_HEADER = "Prefer-Html-Meta-Tags";
    private static final String META_TAG_PREFIX = "al";
    private static final String KEY_AL_VALUE = "value";
    private static final String KEY_APP_NAME = "app_name";
    private static final String KEY_CLASS = "class";
    private static final String KEY_PACKAGE = "package";
    private static final String KEY_URL = "url";
    private static final String KEY_SHOULD_FALLBACK = "should_fallback";
    private static final String KEY_WEB_URL = "url";
    private static final String KEY_WEB = "web";
    private static final String KEY_ANDROID = "android";

    public WebViewAppLinkResolver(Context context) {
        this.context = context;
    }

    @Override
    public Task<AppLink> getAppLinkFromUrlInBackground(final Uri url) {
        final Capture content = new Capture();
        final Capture contentType = new Capture();
        return Task.callInBackground(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                URL currentURL = new URL(url.toString());
                URLConnection connection = null;
                while (currentURL != null) {
                    connection = currentURL.openConnection();
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).setInstanceFollowRedirects(true);
                    }
                    connection.setRequestProperty(WebViewAppLinkResolver.PREFER_HEADER, WebViewAppLinkResolver.META_TAG_PREFIX);
                    connection.connect();
                    if (connection instanceof HttpURLConnection) {
                        HttpURLConnection httpConnection = (HttpURLConnection)connection;
                        if (httpConnection.getResponseCode() >= 300 && httpConnection.getResponseCode() < 400) {
                            currentURL = new URL(httpConnection.getHeaderField("Location"));
                            httpConnection.disconnect();
                            continue;
                        }
                        currentURL = null;
                        continue;
                    }
                    currentURL = null;
                }
                try {
                    content.set(WebViewAppLinkResolver.readFromConnection(connection));
                    contentType.set(connection.getContentType());
                }
                finally {
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).disconnect();
                    }
                }
                return null;
            }
        }).onSuccessTask(new Continuation<Void, Task<JSONArray>>(){

            @Override
            public Task<JSONArray> then(Task<Void> task) throws Exception {
                final Task.TaskCompletionSource tcs = Task.create();
                WebView webView = new WebView(WebViewAppLinkResolver.this.context);
                webView.getSettings().setJavaScriptEnabled(true);
                webView.setNetworkAvailable(false);
                webView.setWebViewClient(new WebViewClient(){
                    private boolean loaded = false;

                    private void runJavaScript(WebView view) {
                        if (!this.loaded) {
                            this.loaded = true;
                            view.loadUrl(WebViewAppLinkResolver.TAG_EXTRACTION_JAVASCRIPT);
                        }
                    }

                    public void onPageFinished(WebView view, String url) {
                        super.onPageFinished(view, url);
                        this.runJavaScript(view);
                    }

                    public void onLoadResource(WebView view, String url) {
                        super.onLoadResource(view, url);
                        this.runJavaScript(view);
                    }
                });
                webView.addJavascriptInterface(new Object(){

                    @JavascriptInterface
                    public void setValue(String value) {
                        try {
                            tcs.trySetResult(new JSONArray(value));
                        }
                        catch (JSONException e) {
                            tcs.trySetError((Exception)((Object)e));
                        }
                    }
                }, "boltsWebViewAppLinkResolverResult");
                String inferredContentType = null;
                if (contentType.get() != null) {
                    inferredContentType = ((String)contentType.get()).split(";")[0];
                }
                webView.loadDataWithBaseURL(url.toString(), (String)content.get(), inferredContentType, null, null);
                return tcs.getTask();
            }
        }, Task.UI_THREAD_EXECUTOR).onSuccess(new Continuation<JSONArray, AppLink>(){

            @Override
            public AppLink then(Task<JSONArray> task) throws Exception {
                Map alData = WebViewAppLinkResolver.parseAlData(task.getResult());
                AppLink appLink = WebViewAppLinkResolver.makeAppLinkFromAlData(alData, url);
                return appLink;
            }
        });
    }

    private static Map<String, Object> parseAlData(JSONArray dataArray) throws JSONException {
        HashMap<String, Object> al = new HashMap<String, Object>();
        for (int i = 0; i < dataArray.length(); ++i) {
            JSONObject tag = dataArray.getJSONObject(i);
            String name = tag.getString("property");
            String[] nameComponents = name.split(":");
            if (!nameComponents[0].equals(META_TAG_PREFIX)) continue;
            HashMap<String, Object> root = al;
            for (int j = 1; j < nameComponents.length; ++j) {
                HashMap child;
                ArrayList children = (ArrayList)root.get(nameComponents[j]);
                if (children == null) {
                    children = new ArrayList();
                    root.put(nameComponents[j], children);
                }
                HashMap hashMap = child = children.size() > 0 ? (HashMap)children.get(children.size() - 1) : null;
                if (child == null || j == nameComponents.length - 1) {
                    child = new HashMap();
                    children.add(child);
                }
                root = child;
            }
            if (!tag.has("content")) continue;
            if (tag.isNull("content")) {
                root.put(KEY_AL_VALUE, null);
                continue;
            }
            root.put(KEY_AL_VALUE, tag.getString("content"));
        }
        return al;
    }

    private static List<Map<String, Object>> getAlList(Map<String, Object> map, String key) {
        List result = (List)map.get(key);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    private static AppLink makeAppLinkFromAlData(Map<String, Object> appLinkDict, Uri destination) {
        ArrayList<AppLink.Target> targets = new ArrayList<AppLink.Target>();
        List<Map> platformMapList = (List<Map>)appLinkDict.get(KEY_ANDROID);
        if (platformMapList == null) {
            platformMapList = Collections.emptyList();
        }
        for (Map platformMap : platformMapList) {
            List<Map<String, Object>> urls = WebViewAppLinkResolver.getAlList(platformMap, "url");
            List<Map<String, Object>> packages = WebViewAppLinkResolver.getAlList(platformMap, KEY_PACKAGE);
            List<Map<String, Object>> classes = WebViewAppLinkResolver.getAlList(platformMap, KEY_CLASS);
            List<Map<String, Object>> appNames = WebViewAppLinkResolver.getAlList(platformMap, KEY_APP_NAME);
            int maxCount = Math.max(urls.size(), Math.max(packages.size(), Math.max(classes.size(), appNames.size())));
            for (int i = 0; i < maxCount; ++i) {
                String urlString = (String)(urls.size() > i ? urls.get(i).get(KEY_AL_VALUE) : null);
                Uri url = WebViewAppLinkResolver.tryCreateUrl(urlString);
                String packageName = (String)(packages.size() > i ? packages.get(i).get(KEY_AL_VALUE) : null);
                String className = (String)(classes.size() > i ? classes.get(i).get(KEY_AL_VALUE) : null);
                String appName = (String)(appNames.size() > i ? appNames.get(i).get(KEY_AL_VALUE) : null);
                AppLink.Target target = new AppLink.Target(packageName, className, url, appName);
                targets.add(target);
            }
        }
        Uri webUrl = destination;
        List webMapList = (List)appLinkDict.get(KEY_WEB);
        if (webMapList != null && webMapList.size() > 0) {
            Map webMap = (Map)webMapList.get(0);
            List urls = (List)webMap.get("url");
            List shouldFallbacks = (List)webMap.get(KEY_SHOULD_FALLBACK);
            if (shouldFallbacks != null && shouldFallbacks.size() > 0) {
                String shouldFallbackString = (String)((Map)shouldFallbacks.get(0)).get(KEY_AL_VALUE);
                if (Arrays.asList("no", "false", "0").contains(shouldFallbackString.toLowerCase())) {
                    webUrl = null;
                }
            }
            if (webUrl != null && urls != null && urls.size() > 0) {
                String webUrlString = (String)((Map)urls.get(0)).get(KEY_AL_VALUE);
                webUrl = WebViewAppLinkResolver.tryCreateUrl(webUrlString);
            }
        }
        return new AppLink(destination, targets, webUrl);
    }

    private static Uri tryCreateUrl(String urlString) {
        if (urlString == null) {
            return null;
        }
        return Uri.parse((String)urlString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromConnection(URLConnection connection) throws IOException {
        InputStream stream;
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            try {
                stream = connection.getInputStream();
            }
            catch (Exception e) {
                stream = httpConnection.getErrorStream();
            }
        } else {
            stream = connection.getInputStream();
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
            String charset = connection.getContentEncoding();
            if (charset == null) {
                String[] parts;
                String mimeType = connection.getContentType();
                for (String part : parts = mimeType.split(";")) {
                    if (!(part = part.trim()).startsWith("charset=")) continue;
                    charset = part.substring("charset=".length());
                    break;
                }
                if (charset == null) {
                    charset = "UTF-8";
                }
            }
            String string = new String(output.toByteArray(), charset);
            return string;
        }
        finally {
            stream.close();
        }
    }
}

