/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.okhttp3.LogInterceptor.formatter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.parkingwang.okhttp3.LogInterceptor.formatter.JSONFormatter;

class GsonFormatter
extends JSONFormatter {
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final JsonParser PARSER = new JsonParser();

    GsonFormatter() {
    }

    @Override
    String format(String source) {
        return this.GSON.toJson(this.PARSER.parse(source));
    }

    static JSONFormatter buildIfSupported() {
        try {
            Class.forName("com.google.gson.Gson");
            return new GsonFormatter();
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }
}

